/*
 * Echo Server API
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.openapitools.client;

import org.junit.jupiter.api.Test;
import org.openapitools.client.api.BodyApi;
import org.openapitools.client.api.EchoServerResponseParser;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.jupiter.api.Assertions.assertTrue;

/**
 * API tests
 */
public class CustomTest {

    private final BodyApi api = new BodyApi();

    /**
     * Test single binary in multipart mime
     *
     * @see
     * <a href="https://github.com/OpenAPITools/openapi-generator/issues/17367">#17367</a>
     */
    @Test
    public void testBodyMultipartFormdataSingleBinaryTest() throws ApiException, IOException {
        File myFile = new File("test.txt");
        if (!myFile.exists()){
            assertTrue(myFile.createNewFile());
        }
        FileWriter fw = new FileWriter(myFile);
        fw.write("testing only");
        fw.close();
        myFile.deleteOnExit();

        String response =
                api.testBodyMultipartFormdataSingleBinary(myFile);

        EchoServerResponseParser parser =
                new org.openapitools.client.api.EchoServerResponseParser(response);

        String contentDisposition = parser.headers.get("Content-Disposition");

        assertThat(contentDisposition).contains(
                "form-data; name=\"my-file\"; filename=\"test.txt\""
        );
    }
}
