/*
Echo Server API

Echo Server API

API version: 0.1.0
Contact: team@openapitools.org
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"time"
)


// QueryAPIService QueryAPI service
type QueryAPIService service

type ApiTestEnumRefStringRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	enumNonrefStringQuery *string
	enumRefStringQuery *StringEnumRef
}

func (r ApiTestEnumRefStringRequest) EnumNonrefStringQuery(enumNonrefStringQuery string) ApiTestEnumRefStringRequest {
	r.enumNonrefStringQuery = &enumNonrefStringQuery
	return r
}

func (r ApiTestEnumRefStringRequest) EnumRefStringQuery(enumRefStringQuery StringEnumRef) ApiTestEnumRefStringRequest {
	r.enumRefStringQuery = &enumRefStringQuery
	return r
}

func (r ApiTestEnumRefStringRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestEnumRefStringExecute(r)
}

/*
TestEnumRefString Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestEnumRefStringRequest
*/
func (a *QueryAPIService) TestEnumRefString(ctx context.Context) ApiTestEnumRefStringRequest {
	return ApiTestEnumRefStringRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestEnumRefStringExecute(r ApiTestEnumRefStringRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestEnumRefString")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/enum_ref_string"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.enumNonrefStringQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "enum_nonref_string_query", r.enumNonrefStringQuery, "form", "")
	}
	if r.enumRefStringQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "enum_ref_string_query", r.enumRefStringQuery, "form", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryDatetimeDateStringRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	datetimeQuery *time.Time
	dateQuery *string
	stringQuery *string
}

func (r ApiTestQueryDatetimeDateStringRequest) DatetimeQuery(datetimeQuery time.Time) ApiTestQueryDatetimeDateStringRequest {
	r.datetimeQuery = &datetimeQuery
	return r
}

func (r ApiTestQueryDatetimeDateStringRequest) DateQuery(dateQuery string) ApiTestQueryDatetimeDateStringRequest {
	r.dateQuery = &dateQuery
	return r
}

func (r ApiTestQueryDatetimeDateStringRequest) StringQuery(stringQuery string) ApiTestQueryDatetimeDateStringRequest {
	r.stringQuery = &stringQuery
	return r
}

func (r ApiTestQueryDatetimeDateStringRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryDatetimeDateStringExecute(r)
}

/*
TestQueryDatetimeDateString Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryDatetimeDateStringRequest
*/
func (a *QueryAPIService) TestQueryDatetimeDateString(ctx context.Context) ApiTestQueryDatetimeDateStringRequest {
	return ApiTestQueryDatetimeDateStringRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryDatetimeDateStringExecute(r ApiTestQueryDatetimeDateStringRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryDatetimeDateString")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/datetime/date/string"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.datetimeQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "datetime_query", r.datetimeQuery, "form", "")
	}
	if r.dateQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "date_query", r.dateQuery, "form", "")
	}
	if r.stringQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "string_query", r.stringQuery, "form", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryIntegerBooleanStringRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	integerQuery *int32
	booleanQuery *bool
	stringQuery *string
}

func (r ApiTestQueryIntegerBooleanStringRequest) IntegerQuery(integerQuery int32) ApiTestQueryIntegerBooleanStringRequest {
	r.integerQuery = &integerQuery
	return r
}

func (r ApiTestQueryIntegerBooleanStringRequest) BooleanQuery(booleanQuery bool) ApiTestQueryIntegerBooleanStringRequest {
	r.booleanQuery = &booleanQuery
	return r
}

func (r ApiTestQueryIntegerBooleanStringRequest) StringQuery(stringQuery string) ApiTestQueryIntegerBooleanStringRequest {
	r.stringQuery = &stringQuery
	return r
}

func (r ApiTestQueryIntegerBooleanStringRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryIntegerBooleanStringExecute(r)
}

/*
TestQueryIntegerBooleanString Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryIntegerBooleanStringRequest
*/
func (a *QueryAPIService) TestQueryIntegerBooleanString(ctx context.Context) ApiTestQueryIntegerBooleanStringRequest {
	return ApiTestQueryIntegerBooleanStringRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryIntegerBooleanStringExecute(r ApiTestQueryIntegerBooleanStringRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryIntegerBooleanString")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/integer/boolean/string"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.integerQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "integer_query", r.integerQuery, "form", "")
	}
	if r.booleanQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "boolean_query", r.booleanQuery, "form", "")
	}
	if r.stringQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "string_query", r.stringQuery, "form", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	queryObject *Pet
}

func (r ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest) QueryObject(queryObject Pet) ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest {
	r.queryObject = &queryObject
	return r
}

func (r ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleDeepObjectExplodeTrueObjectExecute(r)
}

/*
TestQueryStyleDeepObjectExplodeTrueObject Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest
*/
func (a *QueryAPIService) TestQueryStyleDeepObjectExplodeTrueObject(ctx context.Context) ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest {
	return ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleDeepObjectExplodeTrueObjectExecute(r ApiTestQueryStyleDeepObjectExplodeTrueObjectRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleDeepObjectExplodeTrueObject")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_deepObject/explode_true/object"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.queryObject != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "query_object", r.queryObject, "deepObject", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	queryObject *TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter
}

func (r ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest) QueryObject(queryObject TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter) ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest {
	r.queryObject = &queryObject
	return r
}

func (r ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleDeepObjectExplodeTrueObjectAllOfExecute(r)
}

/*
TestQueryStyleDeepObjectExplodeTrueObjectAllOf Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest
*/
func (a *QueryAPIService) TestQueryStyleDeepObjectExplodeTrueObjectAllOf(ctx context.Context) ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest {
	return ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleDeepObjectExplodeTrueObjectAllOfExecute(r ApiTestQueryStyleDeepObjectExplodeTrueObjectAllOfRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleDeepObjectExplodeTrueObjectAllOf")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_deepObject/explode_true/object/allOf"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.queryObject != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "query_object", r.queryObject, "deepObject", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	queryObject *[]int32
}

func (r ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest) QueryObject(queryObject []int32) ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest {
	r.queryObject = &queryObject
	return r
}

func (r ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleFormExplodeFalseArrayIntegerExecute(r)
}

/*
TestQueryStyleFormExplodeFalseArrayInteger Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest
*/
func (a *QueryAPIService) TestQueryStyleFormExplodeFalseArrayInteger(ctx context.Context) ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest {
	return ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleFormExplodeFalseArrayIntegerExecute(r ApiTestQueryStyleFormExplodeFalseArrayIntegerRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleFormExplodeFalseArrayInteger")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_form/explode_false/array_integer"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.queryObject != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "query_object", r.queryObject, "form", "csv")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleFormExplodeFalseArrayStringRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	queryObject *[]string
}

func (r ApiTestQueryStyleFormExplodeFalseArrayStringRequest) QueryObject(queryObject []string) ApiTestQueryStyleFormExplodeFalseArrayStringRequest {
	r.queryObject = &queryObject
	return r
}

func (r ApiTestQueryStyleFormExplodeFalseArrayStringRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleFormExplodeFalseArrayStringExecute(r)
}

/*
TestQueryStyleFormExplodeFalseArrayString Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleFormExplodeFalseArrayStringRequest
*/
func (a *QueryAPIService) TestQueryStyleFormExplodeFalseArrayString(ctx context.Context) ApiTestQueryStyleFormExplodeFalseArrayStringRequest {
	return ApiTestQueryStyleFormExplodeFalseArrayStringRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleFormExplodeFalseArrayStringExecute(r ApiTestQueryStyleFormExplodeFalseArrayStringRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleFormExplodeFalseArrayString")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_form/explode_false/array_string"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.queryObject != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "query_object", r.queryObject, "form", "csv")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleFormExplodeTrueArrayStringRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	queryObject *TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter
}

func (r ApiTestQueryStyleFormExplodeTrueArrayStringRequest) QueryObject(queryObject TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter) ApiTestQueryStyleFormExplodeTrueArrayStringRequest {
	r.queryObject = &queryObject
	return r
}

func (r ApiTestQueryStyleFormExplodeTrueArrayStringRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleFormExplodeTrueArrayStringExecute(r)
}

/*
TestQueryStyleFormExplodeTrueArrayString Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleFormExplodeTrueArrayStringRequest
*/
func (a *QueryAPIService) TestQueryStyleFormExplodeTrueArrayString(ctx context.Context) ApiTestQueryStyleFormExplodeTrueArrayStringRequest {
	return ApiTestQueryStyleFormExplodeTrueArrayStringRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleFormExplodeTrueArrayStringExecute(r ApiTestQueryStyleFormExplodeTrueArrayStringRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleFormExplodeTrueArrayString")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_form/explode_true/array_string"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.queryObject != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "query_object", r.queryObject, "form", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleFormExplodeTrueObjectRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	queryObject *Pet
}

func (r ApiTestQueryStyleFormExplodeTrueObjectRequest) QueryObject(queryObject Pet) ApiTestQueryStyleFormExplodeTrueObjectRequest {
	r.queryObject = &queryObject
	return r
}

func (r ApiTestQueryStyleFormExplodeTrueObjectRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleFormExplodeTrueObjectExecute(r)
}

/*
TestQueryStyleFormExplodeTrueObject Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleFormExplodeTrueObjectRequest
*/
func (a *QueryAPIService) TestQueryStyleFormExplodeTrueObject(ctx context.Context) ApiTestQueryStyleFormExplodeTrueObjectRequest {
	return ApiTestQueryStyleFormExplodeTrueObjectRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleFormExplodeTrueObjectExecute(r ApiTestQueryStyleFormExplodeTrueObjectRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleFormExplodeTrueObject")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_form/explode_true/object"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.queryObject != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "query_object", r.queryObject, "form", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	queryObject *DataQuery
}

func (r ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest) QueryObject(queryObject DataQuery) ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest {
	r.queryObject = &queryObject
	return r
}

func (r ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleFormExplodeTrueObjectAllOfExecute(r)
}

/*
TestQueryStyleFormExplodeTrueObjectAllOf Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest
*/
func (a *QueryAPIService) TestQueryStyleFormExplodeTrueObjectAllOf(ctx context.Context) ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest {
	return ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleFormExplodeTrueObjectAllOfExecute(r ApiTestQueryStyleFormExplodeTrueObjectAllOfRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleFormExplodeTrueObjectAllOf")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_form/explode_true/object/allOf"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.queryObject != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "query_object", r.queryObject, "form", "")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ApiTestQueryStyleJsonSerializationObjectRequest struct {
	ctx context.Context
	ApiService *QueryAPIService
	jsonSerializedObjectRefStringQuery *Pet
	jsonSerializedObjectArrayRefStringQuery *[]Pet
}

func (r ApiTestQueryStyleJsonSerializationObjectRequest) JsonSerializedObjectRefStringQuery(jsonSerializedObjectRefStringQuery Pet) ApiTestQueryStyleJsonSerializationObjectRequest {
	r.jsonSerializedObjectRefStringQuery = &jsonSerializedObjectRefStringQuery
	return r
}

func (r ApiTestQueryStyleJsonSerializationObjectRequest) JsonSerializedObjectArrayRefStringQuery(jsonSerializedObjectArrayRefStringQuery []Pet) ApiTestQueryStyleJsonSerializationObjectRequest {
	r.jsonSerializedObjectArrayRefStringQuery = &jsonSerializedObjectArrayRefStringQuery
	return r
}

func (r ApiTestQueryStyleJsonSerializationObjectRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestQueryStyleJsonSerializationObjectExecute(r)
}

/*
TestQueryStyleJsonSerializationObject Test query parameter(s)

Test query parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestQueryStyleJsonSerializationObjectRequest
*/
func (a *QueryAPIService) TestQueryStyleJsonSerializationObject(ctx context.Context) ApiTestQueryStyleJsonSerializationObjectRequest {
	return ApiTestQueryStyleJsonSerializationObjectRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *QueryAPIService) TestQueryStyleJsonSerializationObjectExecute(r ApiTestQueryStyleJsonSerializationObjectRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "QueryAPIService.TestQueryStyleJsonSerializationObject")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/query/style_jsonSerialization/object"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.jsonSerializedObjectRefStringQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "json_serialized_object_ref_string_query", r.jsonSerializedObjectRefStringQuery, "", "")
	}
	if r.jsonSerializedObjectArrayRefStringQuery != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "json_serialized_object_array_ref_string_query", r.jsonSerializedObjectArrayRefStringQuery, "", "csv")
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
