/*
Echo Server API

Echo Server API

API version: 0.1.0
Contact: team@openapitools.org
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
)


// HeaderAPIService HeaderAPI service
type HeaderAPIService service

type ApiTestHeaderIntegerBooleanStringEnumsRequest struct {
	ctx context.Context
	ApiService *HeaderAPIService
	integerHeader *int32
	booleanHeader *bool
	stringHeader *string
	enumNonrefStringHeader *string
	enumRefStringHeader *StringEnumRef
}

func (r ApiTestHeaderIntegerBooleanStringEnumsRequest) IntegerHeader(integerHeader int32) ApiTestHeaderIntegerBooleanStringEnumsRequest {
	r.integerHeader = &integerHeader
	return r
}

func (r ApiTestHeaderIntegerBooleanStringEnumsRequest) BooleanHeader(booleanHeader bool) ApiTestHeaderIntegerBooleanStringEnumsRequest {
	r.booleanHeader = &booleanHeader
	return r
}

func (r ApiTestHeaderIntegerBooleanStringEnumsRequest) StringHeader(stringHeader string) ApiTestHeaderIntegerBooleanStringEnumsRequest {
	r.stringHeader = &stringHeader
	return r
}

func (r ApiTestHeaderIntegerBooleanStringEnumsRequest) EnumNonrefStringHeader(enumNonrefStringHeader string) ApiTestHeaderIntegerBooleanStringEnumsRequest {
	r.enumNonrefStringHeader = &enumNonrefStringHeader
	return r
}

func (r ApiTestHeaderIntegerBooleanStringEnumsRequest) EnumRefStringHeader(enumRefStringHeader StringEnumRef) ApiTestHeaderIntegerBooleanStringEnumsRequest {
	r.enumRefStringHeader = &enumRefStringHeader
	return r
}

func (r ApiTestHeaderIntegerBooleanStringEnumsRequest) Execute() (string, *http.Response, error) {
	return r.ApiService.TestHeaderIntegerBooleanStringEnumsExecute(r)
}

/*
TestHeaderIntegerBooleanStringEnums Test header parameter(s)

Test header parameter(s)

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ApiTestHeaderIntegerBooleanStringEnumsRequest
*/
func (a *HeaderAPIService) TestHeaderIntegerBooleanStringEnums(ctx context.Context) ApiTestHeaderIntegerBooleanStringEnumsRequest {
	return ApiTestHeaderIntegerBooleanStringEnumsRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return string
func (a *HeaderAPIService) TestHeaderIntegerBooleanStringEnumsExecute(r ApiTestHeaderIntegerBooleanStringEnumsRequest) (string, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  string
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "HeaderAPIService.TestHeaderIntegerBooleanStringEnums")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/header/integer/boolean/string/enums"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"text/plain"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.integerHeader != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "integer_header", r.integerHeader, "form", "")
	}
	if r.booleanHeader != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "boolean_header", r.booleanHeader, "form", "")
	}
	if r.stringHeader != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "string_header", r.stringHeader, "form", "")
	}
	if r.enumNonrefStringHeader != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "enum_nonref_string_header", r.enumNonrefStringHeader, "form", "")
	}
	if r.enumRefStringHeader != nil {
		parameterAddToHeaderOrQuery(localVarHeaderParams, "enum_ref_string_header", r.enumRefStringHeader, "form", "")
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
