# Go API client for openapi

Echo Server API

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 0.1.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```sh
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```go
import openapi "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```go
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `openapi.ContextServerIndex` of type `int`.

```go
ctx := context.WithValue(context.Background(), openapi.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `openapi.ContextServerVariables` of type `map[string]string`.

```go
ctx := context.WithValue(context.Background(), openapi.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `openapi.ContextOperationServerIndices` and `openapi.ContextOperationServerVariables` context maps.

```go
ctx := context.WithValue(context.Background(), openapi.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), openapi.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:3000*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthAPI* | [**TestAuthHttpBasic**](docs/AuthAPI.md#testauthhttpbasic) | **Post** /auth/http/basic | To test HTTP basic authentication
*AuthAPI* | [**TestAuthHttpBearer**](docs/AuthAPI.md#testauthhttpbearer) | **Post** /auth/http/bearer | To test HTTP bearer authentication
*BodyAPI* | [**TestBinaryGif**](docs/BodyAPI.md#testbinarygif) | **Post** /binary/gif | Test binary (gif) response body
*BodyAPI* | [**TestBodyApplicationOctetstreamBinary**](docs/BodyAPI.md#testbodyapplicationoctetstreambinary) | **Post** /body/application/octetstream/binary | Test body parameter(s)
*BodyAPI* | [**TestBodyMultipartFormdataArrayOfBinary**](docs/BodyAPI.md#testbodymultipartformdataarrayofbinary) | **Post** /body/application/octetstream/array_of_binary | Test array of binary in multipart mime
*BodyAPI* | [**TestBodyMultipartFormdataSingleBinary**](docs/BodyAPI.md#testbodymultipartformdatasinglebinary) | **Post** /body/application/octetstream/single_binary | Test single binary in multipart mime
*BodyAPI* | [**TestEchoBodyAllOfPet**](docs/BodyAPI.md#testechobodyallofpet) | **Post** /echo/body/allOf/Pet | Test body parameter(s)
*BodyAPI* | [**TestEchoBodyFreeFormObjectResponseString**](docs/BodyAPI.md#testechobodyfreeformobjectresponsestring) | **Post** /echo/body/FreeFormObject/response_string | Test free form object
*BodyAPI* | [**TestEchoBodyPet**](docs/BodyAPI.md#testechobodypet) | **Post** /echo/body/Pet | Test body parameter(s)
*BodyAPI* | [**TestEchoBodyPetResponseString**](docs/BodyAPI.md#testechobodypetresponsestring) | **Post** /echo/body/Pet/response_string | Test empty response body
*BodyAPI* | [**TestEchoBodyStringEnum**](docs/BodyAPI.md#testechobodystringenum) | **Post** /echo/body/string_enum | Test string enum response body
*BodyAPI* | [**TestEchoBodyTagResponseString**](docs/BodyAPI.md#testechobodytagresponsestring) | **Post** /echo/body/Tag/response_string | Test empty json (request body)
*FormAPI* | [**TestFormIntegerBooleanString**](docs/FormAPI.md#testformintegerbooleanstring) | **Post** /form/integer/boolean/string | Test form parameter(s)
*FormAPI* | [**TestFormObjectMultipart**](docs/FormAPI.md#testformobjectmultipart) | **Post** /form/object/multipart | Test form parameter(s) for multipart schema
*FormAPI* | [**TestFormOneof**](docs/FormAPI.md#testformoneof) | **Post** /form/oneof | Test form parameter(s) for oneOf schema
*HeaderAPI* | [**TestHeaderIntegerBooleanStringEnums**](docs/HeaderAPI.md#testheaderintegerbooleanstringenums) | **Get** /header/integer/boolean/string/enums | Test header parameter(s)
*PathAPI* | [**TestsPathStringPathStringIntegerPathIntegerEnumNonrefStringPathEnumRefStringPath**](docs/PathAPI.md#testspathstringpathstringintegerpathintegerenumnonrefstringpathenumrefstringpath) | **Get** /path/string/{path_string}/integer/{path_integer}/{enum_nonref_string_path}/{enum_ref_string_path} | Test path parameter(s)
*QueryAPI* | [**TestEnumRefString**](docs/QueryAPI.md#testenumrefstring) | **Get** /query/enum_ref_string | Test query parameter(s)
*QueryAPI* | [**TestQueryDatetimeDateString**](docs/QueryAPI.md#testquerydatetimedatestring) | **Get** /query/datetime/date/string | Test query parameter(s)
*QueryAPI* | [**TestQueryIntegerBooleanString**](docs/QueryAPI.md#testqueryintegerbooleanstring) | **Get** /query/integer/boolean/string | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleDeepObjectExplodeTrueObject**](docs/QueryAPI.md#testquerystyledeepobjectexplodetrueobject) | **Get** /query/style_deepObject/explode_true/object | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleDeepObjectExplodeTrueObjectAllOf**](docs/QueryAPI.md#testquerystyledeepobjectexplodetrueobjectallof) | **Get** /query/style_deepObject/explode_true/object/allOf | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleFormExplodeFalseArrayInteger**](docs/QueryAPI.md#testquerystyleformexplodefalsearrayinteger) | **Get** /query/style_form/explode_false/array_integer | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleFormExplodeFalseArrayString**](docs/QueryAPI.md#testquerystyleformexplodefalsearraystring) | **Get** /query/style_form/explode_false/array_string | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleFormExplodeTrueArrayString**](docs/QueryAPI.md#testquerystyleformexplodetruearraystring) | **Get** /query/style_form/explode_true/array_string | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleFormExplodeTrueObject**](docs/QueryAPI.md#testquerystyleformexplodetrueobject) | **Get** /query/style_form/explode_true/object | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleFormExplodeTrueObjectAllOf**](docs/QueryAPI.md#testquerystyleformexplodetrueobjectallof) | **Get** /query/style_form/explode_true/object/allOf | Test query parameter(s)
*QueryAPI* | [**TestQueryStyleJsonSerializationObject**](docs/QueryAPI.md#testquerystylejsonserializationobject) | **Get** /query/style_jsonSerialization/object | Test query parameter(s)


## Documentation For Models

 - [Bird](docs/Bird.md)
 - [Category](docs/Category.md)
 - [DataQuery](docs/DataQuery.md)
 - [DefaultValue](docs/DefaultValue.md)
 - [NumberPropertiesOnly](docs/NumberPropertiesOnly.md)
 - [Pet](docs/Pet.md)
 - [Query](docs/Query.md)
 - [StringEnumRef](docs/StringEnumRef.md)
 - [Tag](docs/Tag.md)
 - [TestFormObjectMultipartRequestMarker](docs/TestFormObjectMultipartRequestMarker.md)
 - [TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter](docs/TestQueryStyleDeepObjectExplodeTrueObjectAllOfQueryObjectParameter.md)
 - [TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter](docs/TestQueryStyleFormExplodeTrueArrayStringQueryObjectParameter.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### http_auth

- **Type**: HTTP basic authentication

Example

```go
auth := context.WithValue(context.Background(), openapi.ContextBasicAuth, openapi.BasicAuth{
	UserName: "username",
	Password: "password",
})
r, err := client.Service.Operation(auth, args)
```

### http_bearer_auth

- **Type**: HTTP Bearer token authentication

Example

```go
auth := context.WithValue(context.Background(), openapi.ContextAccessToken, "BEARER_TOKEN_STRING")
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author

team@openapitools.org

