/*
 * Echo Server API
 *
 * Echo Server API
 *
 * The version of the OpenAPI document: 0.1.0
 * Contact: team@openapitools.org
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Net.Mime;
using Org.OpenAPITools.Client;
using Org.OpenAPITools.Model;

namespace Org.OpenAPITools.Api
{

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IFormApiSync : IApiAccessor
    {
        #region Synchronous Operations
        /// <summary>
        /// Test form parameter(s)
        /// </summary>
        /// <remarks>
        /// Test form parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        string TestFormIntegerBooleanString(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0);

        /// <summary>
        /// Test form parameter(s)
        /// </summary>
        /// <remarks>
        /// Test form parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        ApiResponse<string> TestFormIntegerBooleanStringWithHttpInfo(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0);
        /// <summary>
        /// Test form parameter(s) for multipart schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for multipart schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        string TestFormObjectMultipart(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0);

        /// <summary>
        /// Test form parameter(s) for multipart schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for multipart schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        ApiResponse<string> TestFormObjectMultipartWithHttpInfo(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0);
        /// <summary>
        /// Test form parameter(s) for oneOf schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for oneOf schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        string TestFormOneof(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0);

        /// <summary>
        /// Test form parameter(s) for oneOf schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for oneOf schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        ApiResponse<string> TestFormOneofWithHttpInfo(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0);
        #endregion Synchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IFormApiAsync : IApiAccessor
    {
        #region Asynchronous Operations
        /// <summary>
        /// Test form parameter(s)
        /// </summary>
        /// <remarks>
        /// Test form parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        System.Threading.Tasks.Task<string> TestFormIntegerBooleanStringAsync(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);

        /// <summary>
        /// Test form parameter(s)
        /// </summary>
        /// <remarks>
        /// Test form parameter(s)
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        System.Threading.Tasks.Task<ApiResponse<string>> TestFormIntegerBooleanStringWithHttpInfoAsync(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);
        /// <summary>
        /// Test form parameter(s) for multipart schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for multipart schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        System.Threading.Tasks.Task<string> TestFormObjectMultipartAsync(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);

        /// <summary>
        /// Test form parameter(s) for multipart schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for multipart schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        System.Threading.Tasks.Task<ApiResponse<string>> TestFormObjectMultipartWithHttpInfoAsync(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);
        /// <summary>
        /// Test form parameter(s) for oneOf schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for oneOf schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        System.Threading.Tasks.Task<string> TestFormOneofAsync(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);

        /// <summary>
        /// Test form parameter(s) for oneOf schema
        /// </summary>
        /// <remarks>
        /// Test form parameter(s) for oneOf schema
        /// </remarks>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        System.Threading.Tasks.Task<ApiResponse<string>> TestFormOneofWithHttpInfoAsync(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default);
        #endregion Asynchronous Operations
    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public interface IFormApi : IFormApiSync, IFormApiAsync
    {

    }

    /// <summary>
    /// Represents a collection of functions to interact with the API endpoints
    /// </summary>
    public partial class FormApi : IFormApi
    {
        private Org.OpenAPITools.Client.ExceptionFactory _exceptionFactory = (name, response) => null;

        /// <summary>
        /// Initializes a new instance of the <see cref="FormApi"/> class.
        /// </summary>
        /// <returns></returns>
        public FormApi() : this((string)null)
        {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="FormApi"/> class.
        /// </summary>
        /// <returns></returns>
        public FormApi(string basePath)
        {
            this.Configuration = Org.OpenAPITools.Client.Configuration.MergeConfigurations(
                Org.OpenAPITools.Client.GlobalConfiguration.Instance,
                new Org.OpenAPITools.Client.Configuration { BasePath = basePath }
            );
            this.Client = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            this.ExceptionFactory = Org.OpenAPITools.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="FormApi"/> class
        /// using Configuration object
        /// </summary>
        /// <param name="configuration">An instance of Configuration</param>
        /// <returns></returns>
        public FormApi(Org.OpenAPITools.Client.Configuration configuration)
        {
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Configuration = Org.OpenAPITools.Client.Configuration.MergeConfigurations(
                Org.OpenAPITools.Client.GlobalConfiguration.Instance,
                configuration
            );
            this.Client = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            this.AsynchronousClient = new Org.OpenAPITools.Client.ApiClient(this.Configuration.BasePath);
            ExceptionFactory = Org.OpenAPITools.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="FormApi"/> class
        /// using a Configuration object and client instance.
        /// </summary>
        /// <param name="client">The client interface for synchronous API access.</param>
        /// <param name="asyncClient">The client interface for asynchronous API access.</param>
        /// <param name="configuration">The configuration object.</param>
        public FormApi(Org.OpenAPITools.Client.ISynchronousClient client, Org.OpenAPITools.Client.IAsynchronousClient asyncClient, Org.OpenAPITools.Client.IReadableConfiguration configuration)
        {
            if (client == null) throw new ArgumentNullException("client");
            if (asyncClient == null) throw new ArgumentNullException("asyncClient");
            if (configuration == null) throw new ArgumentNullException("configuration");

            this.Client = client;
            this.AsynchronousClient = asyncClient;
            this.Configuration = configuration;
            this.ExceptionFactory = Org.OpenAPITools.Client.Configuration.DefaultExceptionFactory;
        }

        /// <summary>
        /// The client for accessing this underlying API asynchronously.
        /// </summary>
        public Org.OpenAPITools.Client.IAsynchronousClient AsynchronousClient { get; set; }

        /// <summary>
        /// The client for accessing this underlying API synchronously.
        /// </summary>
        public Org.OpenAPITools.Client.ISynchronousClient Client { get; set; }

        /// <summary>
        /// Gets the base path of the API client.
        /// </summary>
        /// <value>The base path</value>
        public string GetBasePath()
        {
            return this.Configuration.BasePath;
        }

        /// <summary>
        /// Gets or sets the configuration object
        /// </summary>
        /// <value>An instance of the Configuration</value>
        public Org.OpenAPITools.Client.IReadableConfiguration Configuration { get; set; }

        /// <summary>
        /// Provides a factory method hook for the creation of exceptions.
        /// </summary>
        public Org.OpenAPITools.Client.ExceptionFactory ExceptionFactory
        {
            get
            {
                if (_exceptionFactory != null && _exceptionFactory.GetInvocationList().Length > 1)
                {
                    throw new InvalidOperationException("Multicast delegate for ExceptionFactory is unsupported.");
                }
                return _exceptionFactory;
            }
            set { _exceptionFactory = value; }
        }

        /// <summary>
        /// Test form parameter(s) Test form parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        public string TestFormIntegerBooleanString(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = TestFormIntegerBooleanStringWithHttpInfo(integerForm, booleanForm, stringForm);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test form parameter(s) Test form parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        public Org.OpenAPITools.Client.ApiResponse<string> TestFormIntegerBooleanStringWithHttpInfo(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0)
        {
            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            var localVarMultipartFormData = localVarContentType == "multipart/form-data";
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (integerForm != null)
            {
                localVarRequestOptions.FormParameters.Add("integer_form", Org.OpenAPITools.Client.ClientUtils.ParameterToString(integerForm)); // form parameter
            }
            if (booleanForm != null)
            {
                localVarRequestOptions.FormParameters.Add("boolean_form", Org.OpenAPITools.Client.ClientUtils.ParameterToString(booleanForm)); // form parameter
            }
            if (stringForm != null)
            {
                localVarRequestOptions.FormParameters.Add("string_form", Org.OpenAPITools.Client.ClientUtils.ParameterToString(stringForm)); // form parameter
            }

            localVarRequestOptions.Operation = "FormApi.TestFormIntegerBooleanString";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = this.Client.Post<string>("/form/integer/boolean/string", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestFormIntegerBooleanString", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Test form parameter(s) Test form parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        public async System.Threading.Tasks.Task<string> TestFormIntegerBooleanStringAsync(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = await TestFormIntegerBooleanStringWithHttpInfoAsync(integerForm, booleanForm, stringForm, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test form parameter(s) Test form parameter(s)
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="integerForm"> (optional)</param>
        /// <param name="booleanForm"> (optional)</param>
        /// <param name="stringForm"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        public async System.Threading.Tasks.Task<Org.OpenAPITools.Client.ApiResponse<string>> TestFormIntegerBooleanStringWithHttpInfoAsync(int? integerForm = default, bool? booleanForm = default, string? stringForm = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {

            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (integerForm != null)
            {
                localVarRequestOptions.FormParameters.Add("integer_form", Org.OpenAPITools.Client.ClientUtils.ParameterToString(integerForm)); // form parameter
            }
            if (booleanForm != null)
            {
                localVarRequestOptions.FormParameters.Add("boolean_form", Org.OpenAPITools.Client.ClientUtils.ParameterToString(booleanForm)); // form parameter
            }
            if (stringForm != null)
            {
                localVarRequestOptions.FormParameters.Add("string_form", Org.OpenAPITools.Client.ClientUtils.ParameterToString(stringForm)); // form parameter
            }

            localVarRequestOptions.Operation = "FormApi.TestFormIntegerBooleanString";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<string>("/form/integer/boolean/string", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestFormIntegerBooleanString", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Test form parameter(s) for multipart schema Test form parameter(s) for multipart schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        public string TestFormObjectMultipart(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = TestFormObjectMultipartWithHttpInfo(marker);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test form parameter(s) for multipart schema Test form parameter(s) for multipart schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        public Org.OpenAPITools.Client.ApiResponse<string> TestFormObjectMultipartWithHttpInfo(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0)
        {
            // verify the required parameter 'marker' is set
            if (marker == null)
            {
                throw new Org.OpenAPITools.Client.ApiException(400, "Missing required parameter 'marker' when calling FormApi->TestFormObjectMultipart");
            }

            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "multipart/form-data"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            var localVarMultipartFormData = localVarContentType == "multipart/form-data";
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.FormParameters.Add("marker", localVarMultipartFormData ? Org.OpenAPITools.Client.ClientUtils.ParameterToString(marker) : Org.OpenAPITools.Client.ClientUtils.Serialize(marker)); // form parameter

            localVarRequestOptions.Operation = "FormApi.TestFormObjectMultipart";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = this.Client.Post<string>("/form/object/multipart", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestFormObjectMultipart", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Test form parameter(s) for multipart schema Test form parameter(s) for multipart schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        public async System.Threading.Tasks.Task<string> TestFormObjectMultipartAsync(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = await TestFormObjectMultipartWithHttpInfoAsync(marker, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test form parameter(s) for multipart schema Test form parameter(s) for multipart schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="marker"></param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        public async System.Threading.Tasks.Task<Org.OpenAPITools.Client.ApiResponse<string>> TestFormObjectMultipartWithHttpInfoAsync(TestFormObjectMultipartRequestMarker marker, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {
            // verify the required parameter 'marker' is set
            if (marker == null)
            {
                throw new Org.OpenAPITools.Client.ApiException(400, "Missing required parameter 'marker' when calling FormApi->TestFormObjectMultipart");
            }


            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "multipart/form-data"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            localVarRequestOptions.FormParameters.Add("marker", Org.OpenAPITools.Client.ClientUtils.Serialize(marker)); // form parameter

            localVarRequestOptions.Operation = "FormApi.TestFormObjectMultipart";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<string>("/form/object/multipart", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestFormObjectMultipart", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Test form parameter(s) for oneOf schema Test form parameter(s) for oneOf schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>string</returns>
        public string TestFormOneof(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = TestFormOneofWithHttpInfo(form1, form2, form3, form4, id, name);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test form parameter(s) for oneOf schema Test form parameter(s) for oneOf schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <returns>ApiResponse of string</returns>
        public Org.OpenAPITools.Client.ApiResponse<string> TestFormOneofWithHttpInfo(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0)
        {
            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            var localVarMultipartFormData = localVarContentType == "multipart/form-data";
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (form1 != null)
            {
                localVarRequestOptions.FormParameters.Add("form1", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form1)); // form parameter
            }
            if (form2 != null)
            {
                localVarRequestOptions.FormParameters.Add("form2", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form2)); // form parameter
            }
            if (form3 != null)
            {
                localVarRequestOptions.FormParameters.Add("form3", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form3)); // form parameter
            }
            if (form4 != null)
            {
                localVarRequestOptions.FormParameters.Add("form4", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form4)); // form parameter
            }
            if (id != null)
            {
                localVarRequestOptions.FormParameters.Add("id", Org.OpenAPITools.Client.ClientUtils.ParameterToString(id)); // form parameter
            }
            if (name != null)
            {
                localVarRequestOptions.FormParameters.Add("name", Org.OpenAPITools.Client.ClientUtils.ParameterToString(name)); // form parameter
            }

            localVarRequestOptions.Operation = "FormApi.TestFormOneof";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = this.Client.Post<string>("/form/oneof", localVarRequestOptions, this.Configuration);
            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestFormOneof", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

        /// <summary>
        /// Test form parameter(s) for oneOf schema Test form parameter(s) for oneOf schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of string</returns>
        public async System.Threading.Tasks.Task<string> TestFormOneofAsync(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {
            Org.OpenAPITools.Client.ApiResponse<string> localVarResponse = await TestFormOneofWithHttpInfoAsync(form1, form2, form3, form4, id, name, operationIndex, cancellationToken).ConfigureAwait(false);
            return localVarResponse.Data;
        }

        /// <summary>
        /// Test form parameter(s) for oneOf schema Test form parameter(s) for oneOf schema
        /// </summary>
        /// <exception cref="Org.OpenAPITools.Client.ApiException">Thrown when fails to make API call</exception>
        /// <param name="form1"> (optional)</param>
        /// <param name="form2"> (optional)</param>
        /// <param name="form3"> (optional)</param>
        /// <param name="form4"> (optional)</param>
        /// <param name="id"> (optional)</param>
        /// <param name="name"> (optional)</param>
        /// <param name="operationIndex">Index associated with the operation.</param>
        /// <param name="cancellationToken">Cancellation Token to cancel the request.</param>
        /// <returns>Task of ApiResponse (string)</returns>
        public async System.Threading.Tasks.Task<Org.OpenAPITools.Client.ApiResponse<string>> TestFormOneofWithHttpInfoAsync(string? form1 = default, int? form2 = default, string? form3 = default, bool? form4 = default, long? id = default, string? name = default, int operationIndex = 0, System.Threading.CancellationToken cancellationToken = default)
        {

            Org.OpenAPITools.Client.RequestOptions localVarRequestOptions = new Org.OpenAPITools.Client.RequestOptions();

            string[] _contentTypes = new string[] {
                "application/x-www-form-urlencoded"
            };

            // to determine the Accept header
            string[] _accepts = new string[] {
                "text/plain"
            };

            var localVarContentType = Org.OpenAPITools.Client.ClientUtils.SelectHeaderContentType(_contentTypes);
            if (localVarContentType != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Content-Type", localVarContentType);
            }

            var localVarAccept = Org.OpenAPITools.Client.ClientUtils.SelectHeaderAccept(_accepts);
            if (localVarAccept != null)
            {
                localVarRequestOptions.HeaderParameters.Add("Accept", localVarAccept);
            }

            if (form1 != null)
            {
                localVarRequestOptions.FormParameters.Add("form1", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form1)); // form parameter
            }
            if (form2 != null)
            {
                localVarRequestOptions.FormParameters.Add("form2", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form2)); // form parameter
            }
            if (form3 != null)
            {
                localVarRequestOptions.FormParameters.Add("form3", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form3)); // form parameter
            }
            if (form4 != null)
            {
                localVarRequestOptions.FormParameters.Add("form4", Org.OpenAPITools.Client.ClientUtils.ParameterToString(form4)); // form parameter
            }
            if (id != null)
            {
                localVarRequestOptions.FormParameters.Add("id", Org.OpenAPITools.Client.ClientUtils.ParameterToString(id)); // form parameter
            }
            if (name != null)
            {
                localVarRequestOptions.FormParameters.Add("name", Org.OpenAPITools.Client.ClientUtils.ParameterToString(name)); // form parameter
            }

            localVarRequestOptions.Operation = "FormApi.TestFormOneof";
            localVarRequestOptions.OperationIndex = operationIndex;


            // make the HTTP request
            var localVarResponse = await this.AsynchronousClient.PostAsync<string>("/form/oneof", localVarRequestOptions, this.Configuration, cancellationToken).ConfigureAwait(false);

            if (this.ExceptionFactory != null)
            {
                Exception _exception = this.ExceptionFactory("TestFormOneof", localVarResponse);
                if (_exception != null)
                {
                    throw _exception;
                }
            }

            return localVarResponse;
        }

    }
}
