# OpenAPI generated server

A Spring Boot Server application which hosts a client/server generator API.


## Overview  

This server was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.
By using the [OpenAPI-Spec](https://openapis.org), you can easily generate a server stub or one of 100+ client packages.

This is an example of building a OpenAPI-enabled server in Java using the SpringBoot framework.

The underlying library integrating OpenAPI to SpringBoot is [springfox](https://github.com/springfox/springfox)

## Building

Refer to [root README](../../README.md) for build directions.

## Running

### Via command line

Running is as simple as:

```
java -jar ./target/openapi-generator-online.jar
```

This exposes the API on local port 8080.

Springfox supports configuration of the "host" value in the output OpenAPI document by setting the `Host` HTTP header in the request.
To set this explicitly, pass the system property `springfox.documentation.swagger.v2.host` with the desired host. For example:

```
java -Dspringfox.documentation.swagger.v2.host=example.com:8888 -jar ./target/openapi-generator-online.jar
```

### Via Docker

After building from source, change to this module directory (`cd modules/openapi-generator-online`) and build the docker image:

```
docker build -t openapitools/openapi-generator-online:latest .
```

Now, run the docker image:

```
docker run -d -p 8888:8080 openapitools/openapi-generator-online
```

The `GENERATOR_HOST` variable is used here to ensure download links generated by the API refer to the proper API location.

## Environment

`GENERATOR_HOST` can be set to force the scheme/host/port used for download link generation. In most cases, this environment variable is not
necessary to be set and the download link will be generated to match the originating request. The variable is provided simply as a fallback.
