---
title: Documentation for the postgresql-schema Generator
---

## METADATA

| Property | Value | Notes |
| -------- | ----- | ----- |
| generator name | postgresql-schema | pass this to the generate command after -g |
| generator stability | BETA | |
| generator type | SCHEMA | |
| generator language | Postgresql | |
| generator default templating engine | mustache | |
| helpTxt | Generates a PostgreSQL schema based on the schema defined in the OpenAPI specification (v2, v3) | |

## CONFIG OPTIONS
These options may be applied as additional-properties (cli) or configOptions (plugins). Refer to [configuration docs](https://openapi-generator.tech/docs/configuration) for more details.

| Option | Description | Values | Default |
| ------ | ----------- | ------ | ------- |
|defaultDatabaseName|Database name that will be used for all generated PostgreSQL DDL and DML statements.| ||
|idAutoIncEnabled|If `true`, generates autoincrement PostgreSQL types `SERIAL` and `BIGSERIAL` for `int32` and `int64` respectively for integer fields with name 'id'.| |false|
|identifierNamingConvention|Naming convention of PostgreSQL idebntifiers (table names and column names).|<dl><dt>**snake_case**</dt><dd>Transform named to 'snake_case'.</dd><dt>**original**</dt><dd>Leave original names as in `YAML` file.</dd></dl>|snake_case|
|jsonDataType|Use of PostgreSQL data types for complex model properties.|<dl><dt>**json**</dt><dd>Generate `JSON` fields. Value is stored in `JSON` data type field as human-readable text. Value compliance with JSON standard is checked.</dd><dt>**jsonb**</dt><dd>Generate `JSONB` fields. Value is stored in `JSONB` data type field in binary format. `JSONB` data type is generally more efficient than `JSON` but it is not human-readable. Value compliance with JSON standard is checked.</dd><dt>**off**</dt><dd>Generate `TEXT` fields. Just store the value as plain text. Value compliance with JSON standard is not checked.</dd></dl>|json|
|namedParametersEnabled|Generates query examples with named variables in value placeholders (eg.`:name`,`:quantity`) if `true`. Otherwise, generates question marks `?` in value placeholders.| |false|

## IMPORT MAPPING

| Type/Alias | Imports |
| ---------- | ------- |


## INSTANTIATION TYPES

| Type/Alias | Instantiated By |
| ---------- | --------------- |


## LANGUAGE PRIMITIVES

<ul class="column-ul">
<li>BigDecimal</li>
<li>ByteArray</li>
<li>Date</li>
<li>DateTime</li>
<li>URI</li>
<li>UUID</li>
<li>bool</li>
<li>boolean</li>
<li>byte</li>
<li>char</li>
<li>date</li>
<li>double</li>
<li>file</li>
<li>float</li>
<li>int</li>
<li>integer</li>
<li>long</li>
<li>mixed</li>
<li>number</li>
<li>short</li>
<li>string</li>
<li>void</li>
</ul>

## RESERVED WORDS

<ul class="column-ul">
<li>a</li>
<li>abort</li>
<li>abs</li>
<li>absent</li>
<li>absolute</li>
<li>access</li>
<li>according</li>
<li>acos</li>
<li>action</li>
<li>ada</li>
<li>add</li>
<li>admin</li>
<li>after</li>
<li>aggregate</li>
<li>all</li>
<li>allocate</li>
<li>also</li>
<li>alter</li>
<li>always</li>
<li>analyse</li>
<li>analyze</li>
<li>and</li>
<li>any</li>
<li>any_value</li>
<li>are</li>
<li>array</li>
<li>array_agg</li>
<li>array_max_cardinality</li>
<li>as</li>
<li>asc</li>
<li>asensitive</li>
<li>asin</li>
<li>assertion</li>
<li>assignment</li>
<li>asymmetric</li>
<li>at</li>
<li>atan</li>
<li>atomic</li>
<li>attach</li>
<li>attribute</li>
<li>attributes</li>
<li>authorization</li>
<li>avg</li>
<li>backward</li>
<li>base64</li>
<li>before</li>
<li>begin</li>
<li>begin_frame</li>
<li>begin_partition</li>
<li>bernoulli</li>
<li>between</li>
<li>bigint</li>
<li>binary</li>
<li>bit</li>
<li>bit_length</li>
<li>blob</li>
<li>blocked</li>
<li>bom</li>
<li>boolean</li>
<li>both</li>
<li>breadth</li>
<li>btrim</li>
<li>by</li>
<li>c</li>
<li>cache</li>
<li>call</li>
<li>called</li>
<li>cardinality</li>
<li>cascade</li>
<li>cascaded</li>
<li>case</li>
<li>cast</li>
<li>catalog</li>
<li>catalog_name</li>
<li>ceil</li>
<li>ceiling</li>
<li>chain</li>
<li>chaining</li>
<li>char</li>
<li>char_length</li>
<li>character</li>
<li>character_length</li>
<li>character_set_catalog</li>
<li>character_set_name</li>
<li>character_set_schema</li>
<li>characteristics</li>
<li>characters</li>
<li>check</li>
<li>checkpoint</li>
<li>class</li>
<li>class_origin</li>
<li>classifier</li>
<li>clob</li>
<li>close</li>
<li>cluster</li>
<li>coalesce</li>
<li>cobol</li>
<li>collate</li>
<li>collation</li>
<li>collation_catalog</li>
<li>collation_name</li>
<li>collation_schema</li>
<li>collect</li>
<li>column</li>
<li>column_name</li>
<li>columns</li>
<li>command_function</li>
<li>command_function_code</li>
<li>comment</li>
<li>comments</li>
<li>commit</li>
<li>committed</li>
<li>compression</li>
<li>concurrently</li>
<li>condition</li>
<li>condition_number</li>
<li>conditional</li>
<li>configuration</li>
<li>conflict</li>
<li>connect</li>
<li>connection</li>
<li>connection_name</li>
<li>constraint</li>
<li>constraint_catalog</li>
<li>constraint_name</li>
<li>constraint_schema</li>
<li>constraints</li>
<li>constructor</li>
<li>contains</li>
<li>content</li>
<li>continue</li>
<li>control</li>
<li>conversion</li>
<li>convert</li>
<li>copartition</li>
<li>copy</li>
<li>corr</li>
<li>corresponding</li>
<li>cos</li>
<li>cosh</li>
<li>cost</li>
<li>count</li>
<li>covar_pop</li>
<li>covar_samp</li>
<li>create</li>
<li>cross</li>
<li>csv</li>
<li>cube</li>
<li>cume_dist</li>
<li>current</li>
<li>current_catalog</li>
<li>current_date</li>
<li>current_default_transform_group</li>
<li>current_path</li>
<li>current_role</li>
<li>current_row</li>
<li>current_schema</li>
<li>current_time</li>
<li>current_timestamp</li>
<li>current_transform_group_for_type</li>
<li>current_user</li>
<li>cursor</li>
<li>cursor_name</li>
<li>cycle</li>
<li>data</li>
<li>database</li>
<li>datalink</li>
<li>date</li>
<li>datetime_interval_code</li>
<li>datetime_interval_precision</li>
<li>day</li>
<li>db</li>
<li>deallocate</li>
<li>dec</li>
<li>decfloat</li>
<li>decimal</li>
<li>declare</li>
<li>default</li>
<li>defaults</li>
<li>deferrable</li>
<li>deferred</li>
<li>define</li>
<li>defined</li>
<li>definer</li>
<li>degree</li>
<li>delete</li>
<li>delimiter</li>
<li>delimiters</li>
<li>dense_rank</li>
<li>depends</li>
<li>depth</li>
<li>deref</li>
<li>derived</li>
<li>desc</li>
<li>describe</li>
<li>descriptor</li>
<li>detach</li>
<li>deterministic</li>
<li>diagnostics</li>
<li>dictionary</li>
<li>disable</li>
<li>discard</li>
<li>disconnect</li>
<li>dispatch</li>
<li>distinct</li>
<li>dlnewcopy</li>
<li>dlpreviouscopy</li>
<li>dlurlcomplete</li>
<li>dlurlcompleteonly</li>
<li>dlurlcompletewrite</li>
<li>dlurlpath</li>
<li>dlurlpathonly</li>
<li>dlurlpathwrite</li>
<li>dlurlscheme</li>
<li>dlurlserver</li>
<li>dlvalue</li>
<li>do</li>
<li>document</li>
<li>domain</li>
<li>double</li>
<li>drop</li>
<li>dynamic</li>
<li>dynamic_function</li>
<li>dynamic_function_code</li>
<li>each</li>
<li>element</li>
<li>else</li>
<li>empty</li>
<li>enable</li>
<li>encoding</li>
<li>encrypted</li>
<li>end</li>
<li>end-exec</li>
<li>end_frame</li>
<li>end_partition</li>
<li>enforced</li>
<li>enum</li>
<li>equals</li>
<li>error</li>
<li>escape</li>
<li>event</li>
<li>every</li>
<li>except</li>
<li>exception</li>
<li>exclude</li>
<li>excluding</li>
<li>exclusive</li>
<li>exec</li>
<li>execute</li>
<li>exists</li>
<li>exp</li>
<li>explain</li>
<li>expression</li>
<li>extension</li>
<li>external</li>
<li>extract</li>
<li>false</li>
<li>family</li>
<li>fetch</li>
<li>file</li>
<li>filter</li>
<li>final</li>
<li>finalize</li>
<li>finish</li>
<li>first</li>
<li>first_value</li>
<li>flag</li>
<li>float</li>
<li>floor</li>
<li>following</li>
<li>for</li>
<li>force</li>
<li>foreign</li>
<li>format</li>
<li>fortran</li>
<li>forward</li>
<li>found</li>
<li>frame_row</li>
<li>free</li>
<li>freeze</li>
<li>from</li>
<li>fs</li>
<li>fulfill</li>
<li>full</li>
<li>function</li>
<li>functions</li>
<li>fusion</li>
<li>g</li>
<li>general</li>
<li>generated</li>
<li>get</li>
<li>global</li>
<li>go</li>
<li>goto</li>
<li>grant</li>
<li>granted</li>
<li>greatest</li>
<li>group</li>
<li>grouping</li>
<li>groups</li>
<li>handler</li>
<li>having</li>
<li>header</li>
<li>hex</li>
<li>hierarchy</li>
<li>hold</li>
<li>hour</li>
<li>id</li>
<li>identity</li>
<li>if</li>
<li>ignore</li>
<li>ilike</li>
<li>immediate</li>
<li>immediately</li>
<li>immutable</li>
<li>implementation</li>
<li>implicit</li>
<li>import</li>
<li>in</li>
<li>include</li>
<li>including</li>
<li>increment</li>
<li>indent</li>
<li>index</li>
<li>indexes</li>
<li>indicator</li>
<li>inherit</li>
<li>inherits</li>
<li>initial</li>
<li>initially</li>
<li>inline</li>
<li>inner</li>
<li>inout</li>
<li>input</li>
<li>insensitive</li>
<li>insert</li>
<li>instance</li>
<li>instantiable</li>
<li>instead</li>
<li>int</li>
<li>integer</li>
<li>integrity</li>
<li>intersect</li>
<li>intersection</li>
<li>interval</li>
<li>into</li>
<li>invoker</li>
<li>is</li>
<li>isnull</li>
<li>isolation</li>
<li>join</li>
<li>json</li>
<li>json_array</li>
<li>json_arrayagg</li>
<li>json_exists</li>
<li>json_object</li>
<li>json_objectagg</li>
<li>json_query</li>
<li>json_scalar</li>
<li>json_serialize</li>
<li>json_table</li>
<li>json_table_primitive</li>
<li>json_value</li>
<li>k</li>
<li>keep</li>
<li>key</li>
<li>key_member</li>
<li>key_type</li>
<li>keys</li>
<li>label</li>
<li>lag</li>
<li>language</li>
<li>large</li>
<li>last</li>
<li>last_value</li>
<li>lateral</li>
<li>lead</li>
<li>leading</li>
<li>leakproof</li>
<li>least</li>
<li>left</li>
<li>length</li>
<li>level</li>
<li>library</li>
<li>like</li>
<li>like_regex</li>
<li>limit</li>
<li>link</li>
<li>listagg</li>
<li>listen</li>
<li>ln</li>
<li>load</li>
<li>local</li>
<li>localtime</li>
<li>localtimestamp</li>
<li>location</li>
<li>locator</li>
<li>lock</li>
<li>locked</li>
<li>log</li>
<li>log10</li>
<li>logged</li>
<li>lower</li>
<li>lpad</li>
<li>ltrim</li>
<li>m</li>
<li>map</li>
<li>mapping</li>
<li>match</li>
<li>match_number</li>
<li>match_recognize</li>
<li>matched</li>
<li>matches</li>
<li>materialized</li>
<li>max</li>
<li>maxvalue</li>
<li>measures</li>
<li>member</li>
<li>merge</li>
<li>merge_action</li>
<li>message_length</li>
<li>message_octet_length</li>
<li>message_text</li>
<li>method</li>
<li>min</li>
<li>minute</li>
<li>minvalue</li>
<li>mod</li>
<li>mode</li>
<li>modifies</li>
<li>module</li>
<li>month</li>
<li>more</li>
<li>move</li>
<li>multiset</li>
<li>mumps</li>
<li>name</li>
<li>names</li>
<li>namespace</li>
<li>national</li>
<li>natural</li>
<li>nchar</li>
<li>nclob</li>
<li>nested</li>
<li>nesting</li>
<li>new</li>
<li>next</li>
<li>nfc</li>
<li>nfd</li>
<li>nfkc</li>
<li>nfkd</li>
<li>nil</li>
<li>no</li>
<li>none</li>
<li>normalize</li>
<li>normalized</li>
<li>not</li>
<li>nothing</li>
<li>notify</li>
<li>notnull</li>
<li>nowait</li>
<li>nth_value</li>
<li>ntile</li>
<li>null</li>
<li>null_ordering</li>
<li>nullable</li>
<li>nullif</li>
<li>nulls</li>
<li>number</li>
<li>numeric</li>
<li>object</li>
<li>occurrence</li>
<li>occurrences_regex</li>
<li>octet_length</li>
<li>octets</li>
<li>of</li>
<li>off</li>
<li>offset</li>
<li>oids</li>
<li>old</li>
<li>omit</li>
<li>on</li>
<li>one</li>
<li>only</li>
<li>open</li>
<li>operator</li>
<li>option</li>
<li>options</li>
<li>or</li>
<li>order</li>
<li>ordering</li>
<li>ordinality</li>
<li>others</li>
<li>out</li>
<li>outer</li>
<li>output</li>
<li>over</li>
<li>overflow</li>
<li>overlaps</li>
<li>overlay</li>
<li>overriding</li>
<li>owned</li>
<li>owner</li>
<li>p</li>
<li>pad</li>
<li>parallel</li>
<li>parameter</li>
<li>parameter_mode</li>
<li>parameter_name</li>
<li>parameter_ordinal_position</li>
<li>parameter_specific_catalog</li>
<li>parameter_specific_name</li>
<li>parameter_specific_schema</li>
<li>parser</li>
<li>partial</li>
<li>partition</li>
<li>pascal</li>
<li>pass</li>
<li>passing</li>
<li>passthrough</li>
<li>password</li>
<li>past</li>
<li>path</li>
<li>pattern</li>
<li>per</li>
<li>percent</li>
<li>percent_rank</li>
<li>percentile_cont</li>
<li>percentile_disc</li>
<li>period</li>
<li>permission</li>
<li>permute</li>
<li>pipe</li>
<li>placing</li>
<li>plan</li>
<li>plans</li>
<li>pli</li>
<li>policy</li>
<li>portion</li>
<li>position</li>
<li>position_regex</li>
<li>power</li>
<li>precedes</li>
<li>preceding</li>
<li>precision</li>
<li>prepare</li>
<li>prepared</li>
<li>preserve</li>
<li>prev</li>
<li>primary</li>
<li>prior</li>
<li>private</li>
<li>privileges</li>
<li>procedural</li>
<li>procedure</li>
<li>procedures</li>
<li>program</li>
<li>prune</li>
<li>ptf</li>
<li>public</li>
<li>publication</li>
<li>quote</li>
<li>quotes</li>
<li>range</li>
<li>rank</li>
<li>read</li>
<li>reads</li>
<li>real</li>
<li>reassign</li>
<li>recheck</li>
<li>recovery</li>
<li>recursive</li>
<li>ref</li>
<li>references</li>
<li>referencing</li>
<li>refresh</li>
<li>regr_avgx</li>
<li>regr_avgy</li>
<li>regr_count</li>
<li>regr_intercept</li>
<li>regr_r2</li>
<li>regr_slope</li>
<li>regr_sxx</li>
<li>regr_sxy</li>
<li>regr_syy</li>
<li>reindex</li>
<li>relative</li>
<li>release</li>
<li>rename</li>
<li>repeatable</li>
<li>replace</li>
<li>replica</li>
<li>requiring</li>
<li>reset</li>
<li>respect</li>
<li>restart</li>
<li>restore</li>
<li>restrict</li>
<li>result</li>
<li>return</li>
<li>returned_cardinality</li>
<li>returned_length</li>
<li>returned_octet_length</li>
<li>returned_sqlstate</li>
<li>returning</li>
<li>returns</li>
<li>revoke</li>
<li>right</li>
<li>role</li>
<li>rollback</li>
<li>rollup</li>
<li>routine</li>
<li>routine_catalog</li>
<li>routine_name</li>
<li>routine_schema</li>
<li>routines</li>
<li>row</li>
<li>row_count</li>
<li>row_number</li>
<li>rows</li>
<li>rpad</li>
<li>rtrim</li>
<li>rule</li>
<li>running</li>
<li>savepoint</li>
<li>scalar</li>
<li>scale</li>
<li>schema</li>
<li>schema_name</li>
<li>schemas</li>
<li>scope</li>
<li>scope_catalog</li>
<li>scope_name</li>
<li>scope_schema</li>
<li>scroll</li>
<li>search</li>
<li>second</li>
<li>section</li>
<li>security</li>
<li>seek</li>
<li>select</li>
<li>selective</li>
<li>self</li>
<li>semantics</li>
<li>sensitive</li>
<li>sequence</li>
<li>sequences</li>
<li>serializable</li>
<li>server</li>
<li>server_name</li>
<li>session</li>
<li>session_user</li>
<li>set</li>
<li>setof</li>
<li>sets</li>
<li>share</li>
<li>show</li>
<li>similar</li>
<li>simple</li>
<li>sin</li>
<li>sinh</li>
<li>size</li>
<li>skip</li>
<li>smallint</li>
<li>snapshot</li>
<li>some</li>
<li>sort_direction</li>
<li>source</li>
<li>space</li>
<li>specific</li>
<li>specific_name</li>
<li>specifictype</li>
<li>sql</li>
<li>sqlcode</li>
<li>sqlerror</li>
<li>sqlexception</li>
<li>sqlstate</li>
<li>sqlwarning</li>
<li>sqrt</li>
<li>stable</li>
<li>standalone</li>
<li>start</li>
<li>state</li>
<li>statement</li>
<li>static</li>
<li>statistics</li>
<li>stddev_pop</li>
<li>stddev_samp</li>
<li>stdin</li>
<li>stdout</li>
<li>storage</li>
<li>stored</li>
<li>strict</li>
<li>string</li>
<li>strip</li>
<li>structure</li>
<li>style</li>
<li>subclass_origin</li>
<li>submultiset</li>
<li>subscription</li>
<li>subset</li>
<li>substring</li>
<li>substring_regex</li>
<li>succeeds</li>
<li>sum</li>
<li>support</li>
<li>symmetric</li>
<li>sysid</li>
<li>system</li>
<li>system_time</li>
<li>system_user</li>
<li>t</li>
<li>table</li>
<li>table_name</li>
<li>tables</li>
<li>tablesample</li>
<li>tablespace</li>
<li>tan</li>
<li>tanh</li>
<li>target</li>
<li>temp</li>
<li>template</li>
<li>temporary</li>
<li>text</li>
<li>then</li>
<li>through</li>
<li>ties</li>
<li>time</li>
<li>timestamp</li>
<li>timezone_hour</li>
<li>timezone_minute</li>
<li>to</li>
<li>token</li>
<li>top_level_count</li>
<li>trailing</li>
<li>transaction</li>
<li>transaction_active</li>
<li>transactions_committed</li>
<li>transactions_rolled_back</li>
<li>transform</li>
<li>transforms</li>
<li>translate</li>
<li>translate_regex</li>
<li>translation</li>
<li>treat</li>
<li>trigger</li>
<li>trigger_catalog</li>
<li>trigger_name</li>
<li>trigger_schema</li>
<li>trim</li>
<li>trim_array</li>
<li>true</li>
<li>truncate</li>
<li>trusted</li>
<li>type</li>
<li>types</li>
<li>uescape</li>
<li>unbounded</li>
<li>uncommitted</li>
<li>unconditional</li>
<li>under</li>
<li>unencrypted</li>
<li>union</li>
<li>unique</li>
<li>unknown</li>
<li>unlink</li>
<li>unlisten</li>
<li>unlogged</li>
<li>unmatched</li>
<li>unnamed</li>
<li>unnest</li>
<li>until</li>
<li>untyped</li>
<li>update</li>
<li>upper</li>
<li>uri</li>
<li>usage</li>
<li>user</li>
<li>user_defined_type_catalog</li>
<li>user_defined_type_code</li>
<li>user_defined_type_name</li>
<li>user_defined_type_schema</li>
<li>using</li>
<li>utf16</li>
<li>utf32</li>
<li>utf8</li>
<li>vacuum</li>
<li>valid</li>
<li>validate</li>
<li>validator</li>
<li>value</li>
<li>value_of</li>
<li>values</li>
<li>var_pop</li>
<li>var_samp</li>
<li>varbinary</li>
<li>varchar</li>
<li>variadic</li>
<li>varying</li>
<li>verbose</li>
<li>version</li>
<li>versioning</li>
<li>view</li>
<li>views</li>
<li>volatile</li>
<li>when</li>
<li>whenever</li>
<li>where</li>
<li>whitespace</li>
<li>width_bucket</li>
<li>window</li>
<li>with</li>
<li>within</li>
<li>without</li>
<li>work</li>
<li>wrapper</li>
<li>write</li>
<li>xml</li>
<li>xmlagg</li>
<li>xmlattributes</li>
<li>xmlbinary</li>
<li>xmlcast</li>
<li>xmlcomment</li>
<li>xmlconcat</li>
<li>xmldeclaration</li>
<li>xmldocument</li>
<li>xmlelement</li>
<li>xmlexists</li>
<li>xmlforest</li>
<li>xmliterate</li>
<li>xmlnamespaces</li>
<li>xmlparse</li>
<li>xmlpi</li>
<li>xmlquery</li>
<li>xmlroot</li>
<li>xmlschema</li>
<li>xmlserialize</li>
<li>xmltable</li>
<li>xmltext</li>
<li>xmlvalidate</li>
<li>year</li>
<li>yes</li>
<li>zone</li>
</ul>

## FEATURE SET


### Client Modification Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|BasePath|✗|ToolingExtension
|Authorizations|✗|ToolingExtension
|UserAgent|✗|ToolingExtension
|MockServer|✗|ToolingExtension

### Data Type Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Custom|✗|OAS2,OAS3
|Int32|✓|OAS2,OAS3
|Int64|✓|OAS2,OAS3
|Float|✓|OAS2,OAS3
|Double|✓|OAS2,OAS3
|Decimal|✓|ToolingExtension
|String|✓|OAS2,OAS3
|Byte|✓|OAS2,OAS3
|Binary|✓|OAS2,OAS3
|Boolean|✓|OAS2,OAS3
|Date|✓|OAS2,OAS3
|DateTime|✓|OAS2,OAS3
|Password|✓|OAS2,OAS3
|File|✓|OAS2
|Uuid|✗|
|Array|✓|OAS2,OAS3
|Null|✗|OAS3
|AnyType|✗|OAS2,OAS3
|Object|✓|OAS2,OAS3
|Maps|✓|ToolingExtension
|CollectionFormat|✓|OAS2
|CollectionFormatMulti|✓|OAS2
|Enum|✓|OAS2,OAS3
|ArrayOfEnum|✓|ToolingExtension
|ArrayOfModel|✓|ToolingExtension
|ArrayOfCollectionOfPrimitives|✓|ToolingExtension
|ArrayOfCollectionOfModel|✓|ToolingExtension
|ArrayOfCollectionOfEnum|✓|ToolingExtension
|MapOfEnum|✓|ToolingExtension
|MapOfModel|✓|ToolingExtension
|MapOfCollectionOfPrimitives|✓|ToolingExtension
|MapOfCollectionOfModel|✓|ToolingExtension
|MapOfCollectionOfEnum|✓|ToolingExtension

### Documentation Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Readme|✓|ToolingExtension
|Model|✓|ToolingExtension
|Api|✓|ToolingExtension

### Global Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Host|✓|OAS2,OAS3
|BasePath|✓|OAS2,OAS3
|Info|✓|OAS2,OAS3
|Schemes|✗|OAS2,OAS3
|PartialSchemes|✓|OAS2,OAS3
|Consumes|✓|OAS2
|Produces|✓|OAS2
|ExternalDocumentation|✓|OAS2,OAS3
|Examples|✓|OAS2,OAS3
|XMLStructureDefinitions|✗|OAS2,OAS3
|MultiServer|✗|OAS3
|ParameterizedServer|✗|OAS3
|ParameterStyling|✗|OAS3
|Callbacks|✗|OAS3
|LinkObjects|✗|OAS3

### Parameter Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Path|✓|OAS2,OAS3
|Query|✓|OAS2,OAS3
|Header|✓|OAS2,OAS3
|Body|✓|OAS2
|FormUnencoded|✓|OAS2
|FormMultipart|✓|OAS2
|Cookie|✓|OAS3

### Schema Support Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Simple|✓|OAS2,OAS3
|Composite|✓|OAS2,OAS3
|Polymorphism|✗|OAS2,OAS3
|Union|✗|OAS3
|allOf|✗|OAS2,OAS3
|anyOf|✗|OAS3
|oneOf|✗|OAS3
|not|✗|OAS3

### Security Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|BasicAuth|✗|OAS2,OAS3
|ApiKey|✗|OAS2,OAS3
|OpenIDConnect|✗|OAS3
|BearerToken|✗|OAS3
|OAuth2_Implicit|✗|OAS2,OAS3
|OAuth2_Password|✗|OAS2,OAS3
|OAuth2_ClientCredentials|✗|OAS2,OAS3
|OAuth2_AuthorizationCode|✗|OAS2,OAS3
|SignatureAuth|✗|OAS3
|AWSV4Signature|✗|ToolingExtension

### Wire Format Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|JSON|✗|OAS2,OAS3
|XML|✗|OAS2,OAS3
|PROTOBUF|✗|ToolingExtension
|Custom|✗|OAS2,OAS3
