---
title: Documentation for the gdscript Generator
---

## METADATA

| Property | Value | Notes |
| -------- | ----- | ----- |
| generator name | gdscript | pass this to the generate command after -g |
| generator stability | STABLE | |
| generator type | CLIENT | |
| generator language | Java | |
| generator default templating engine | handlebars | |
| helpTxt | Generates a GDScript client (Godot 4+). | |

## CONFIG OPTIONS
These options may be applied as additional-properties (cli) or configOptions (plugins). Refer to [configuration docs](https://openapi-generator.tech/docs/configuration) for more details.

| Option | Description | Values | Default |
| ------ | ----------- | ------ | ------- |
|allowUnicodeIdentifiers|boolean, toggles whether unicode identifiers are allowed in names or not, default is false| |false|
|anticollisionPrefix|Prefix added at the beginning of reserved words| |some_|
|anticollisionSuffix|Suffix added at the ending of reserved words| ||
|coreNamePrefix|PascalCase prefix added to all core classes| ||
|coreNameSuffix|PascalCase suffix added to all core classes| ||
|disallowAdditionalPropertiesIfNotPresent|If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.|<dl><dt>**false**</dt><dd>The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.</dd><dt>**true**</dt><dd>Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.</dd></dl>|true|
|ensureUniqueParams|Whether to ensure parameter names are unique in an operation (rename parameters that are not).| |true|
|enumUnknownDefaultCase|If the server adds new enum cases, that are unknown by an old spec/client, the client will fail to parse the network response.With this option enabled, each enum will have a new case, 'unknown_default_open_api', so that when the server sends an enum case that is not known by the client/spec, they can safely fallback to this case.|<dl><dt>**false**</dt><dd>No changes to the enum's are made, this is the default option.</dd><dt>**true**</dt><dd>With this option enabled, each enum will have a new case, 'unknown_default_open_api', so that when the enum case sent by the server is not known by the client/spec, can safely be decoded to this case.</dd></dl>|false|
|legacyDiscriminatorBehavior|Set to false for generators with better support for discriminators. (Python, Java, Go, PowerShell, C# have this enabled by default).|<dl><dt>**true**</dt><dd>The mapping in the discriminator includes descendent schemas that allOf inherit from self and the discriminator mapping schemas in the OAS document.</dd><dt>**false**</dt><dd>The mapping in the discriminator includes any descendent schemas that allOf inherit from self, any oneOf schemas, any anyOf schemas, any x-discriminator-values, and the discriminator mapping schemas in the OAS document AND Codegen validates that oneOf and anyOf schemas contain the required discriminator and throws an error if the discriminator is missing.</dd></dl>|true|
|prependFormOrBodyParameters|Add form or body parameters to the beginning of the parameter list.| |false|
|sortModelPropertiesByRequiredFlag|Sort model properties to place required parameters before optional parameters.| |true|
|sortParamsByRequiredFlag|Sort method arguments to place required parameters before optional parameters.| |true|

## IMPORT MAPPING

| Type/Alias | Imports |
| ---------- | ------- |


## INSTANTIATION TYPES

| Type/Alias | Instantiated By |
| ---------- | --------------- |


## LANGUAGE PRIMITIVES

<ul class="column-ul">
</ul>

## RESERVED WORDS

<ul class="column-ul">
<li>_bzz_client</li>
<li>_bzz_config</li>
<li>_bzz_connect_client_if_needed</li>
<li>_bzz_convert_http_method</li>
<li>_bzz_do_request_text</li>
<li>_bzz_escape_path_param</li>
<li>_bzz_format_error_response</li>
<li>_bzz_get_content_type</li>
<li>_bzz_name</li>
<li>_bzz_next_loop_iteration</li>
<li>_bzz_request</li>
<li>_bzz_request_text</li>
<li>_bzz_urlize_path_param</li>
<li>aabb</li>
<li>abs</li>
<li>absf</li>
<li>absi</li>
<li>acceptdialog</li>
<li>acos</li>
<li>aescontext</li>
<li>and</li>
<li>animatablebody2d</li>
<li>animatablebody3d</li>
<li>animatedsprite2d</li>
<li>animatedsprite3d</li>
<li>animatedtexture</li>
<li>animation</li>
<li>animationlibrary</li>
<li>animationnode</li>
<li>animationnodeadd2</li>
<li>animationnodeadd3</li>
<li>animationnodeanimation</li>
<li>animationnodeblend2</li>
<li>animationnodeblend3</li>
<li>animationnodeblendspace1d</li>
<li>animationnodeblendspace2d</li>
<li>animationnodeblendtree</li>
<li>animationnodeoneshot</li>
<li>animationnodeoutput</li>
<li>animationnodestatemachine</li>
<li>animationnodestatemachineplayback</li>
<li>animationnodestatemachinetransition</li>
<li>animationnodesync</li>
<li>animationnodetimescale</li>
<li>animationnodetimeseek</li>
<li>animationnodetransition</li>
<li>animationplayer</li>
<li>animationrootnode</li>
<li>animationtrackeditplugin</li>
<li>animationtree</li>
<li>area2d</li>
<li>area3d</li>
<li>arraymesh</li>
<li>arrayoccluder3d</li>
<li>as</li>
<li>asin</li>
<li>aspectratiocontainer</li>
<li>assert</li>
<li>astar2d</li>
<li>astar3d</li>
<li>astargrid2d</li>
<li>atan</li>
<li>atan2</li>
<li>atlastexture</li>
<li>audiobuslayout</li>
<li>audioeffect</li>
<li>audioeffectamplify</li>
<li>audioeffectbandlimitfilter</li>
<li>audioeffectbandpassfilter</li>
<li>audioeffectcapture</li>
<li>audioeffectchorus</li>
<li>audioeffectcompressor</li>
<li>audioeffectdelay</li>
<li>audioeffectdistortion</li>
<li>audioeffecteq</li>
<li>audioeffecteq10</li>
<li>audioeffecteq21</li>
<li>audioeffecteq6</li>
<li>audioeffectfilter</li>
<li>audioeffecthighpassfilter</li>
<li>audioeffecthighshelffilter</li>
<li>audioeffectinstance</li>
<li>audioeffectlimiter</li>
<li>audioeffectlowpassfilter</li>
<li>audioeffectlowshelffilter</li>
<li>audioeffectnotchfilter</li>
<li>audioeffectpanner</li>
<li>audioeffectphaser</li>
<li>audioeffectpitchshift</li>
<li>audioeffectrecord</li>
<li>audioeffectreverb</li>
<li>audioeffectspectrumanalyzer</li>
<li>audioeffectspectrumanalyzerinstance</li>
<li>audioeffectstereoenhance</li>
<li>audiolistener2d</li>
<li>audiolistener3d</li>
<li>audioserver</li>
<li>audiostream</li>
<li>audiostreamgenerator</li>
<li>audiostreamgeneratorplayback</li>
<li>audiostreammicrophone</li>
<li>audiostreamplayback</li>
<li>audiostreamplaybackresampled</li>
<li>audiostreamplayer</li>
<li>audiostreamplayer2d</li>
<li>audiostreamplayer3d</li>
<li>audiostreamrandomizer</li>
<li>audiostreamwav</li>
<li>await</li>
<li>backbuffercopy</li>
<li>basebutton</li>
<li>basematerial3d</li>
<li>basis</li>
<li>bezier_interpolate</li>
<li>bitmap</li>
<li>bone2d</li>
<li>boneattachment3d</li>
<li>bonemap</li>
<li>bool</li>
<li>boxcontainer</li>
<li>boxmesh</li>
<li>boxoccluder3d</li>
<li>boxshape3d</li>
<li>break</li>
<li>breakpoint</li>
<li>button</li>
<li>buttongroup</li>
<li>bytes_to_var</li>
<li>bytes_to_var_with_objects</li>
<li>bzz_code</li>
<li>bzz_error</li>
<li>bzz_headers</li>
<li>bzz_method</li>
<li>bzz_path</li>
<li>bzz_query</li>
<li>bzz_result</li>
<li>callable</li>
<li>callbacktweener</li>
<li>camera2d</li>
<li>camera3d</li>
<li>cameraattributes</li>
<li>cameraattributesphysical</li>
<li>cameraattributespractical</li>
<li>camerafeed</li>
<li>cameraserver</li>
<li>cameratexture</li>
<li>canvasgroup</li>
<li>canvasitem</li>
<li>canvasitemmaterial</li>
<li>canvaslayer</li>
<li>canvasmodulate</li>
<li>canvastexture</li>
<li>capsulemesh</li>
<li>capsuleshape2d</li>
<li>capsuleshape3d</li>
<li>ceil</li>
<li>ceilf</li>
<li>ceili</li>
<li>centercontainer</li>
<li>characterbody2d</li>
<li>characterbody3d</li>
<li>charfxtransform</li>
<li>checkbox</li>
<li>checkbutton</li>
<li>circleshape2d</li>
<li>clamp</li>
<li>clampf</li>
<li>clampi</li>
<li>class</li>
<li>class_name</li>
<li>classdb</li>
<li>clockwise</li>
<li>codeedit</li>
<li>codehighlighter</li>
<li>collisionobject2d</li>
<li>collisionobject3d</li>
<li>collisionpolygon2d</li>
<li>collisionpolygon3d</li>
<li>collisionshape2d</li>
<li>collisionshape3d</li>
<li>color</li>
<li>colorpicker</li>
<li>colorpickerbutton</li>
<li>colorrect</li>
<li>compressedcubemap</li>
<li>compressedcubemaparray</li>
<li>compressedtexture2d</li>
<li>compressedtexture2darray</li>
<li>compressedtexture3d</li>
<li>compressedtexturelayered</li>
<li>concavepolygonshape2d</li>
<li>concavepolygonshape3d</li>
<li>conetwistjoint3d</li>
<li>configfile</li>
<li>confirmationdialog</li>
<li>const</li>
<li>container</li>
<li>continue</li>
<li>control</li>
<li>convexpolygonshape2d</li>
<li>convexpolygonshape3d</li>
<li>corner_bottom_left</li>
<li>corner_bottom_right</li>
<li>corner_top_left</li>
<li>corner_top_right</li>
<li>cos</li>
<li>cosh</li>
<li>counterclockwise</li>
<li>cpuparticles2d</li>
<li>cpuparticles3d</li>
<li>crypto</li>
<li>cryptokey</li>
<li>cubemap</li>
<li>cubemaparray</li>
<li>cubic_interpolate</li>
<li>cubic_interpolate_angle</li>
<li>cubic_interpolate_angle_in_time</li>
<li>cubic_interpolate_in_time</li>
<li>curve</li>
<li>curve2d</li>
<li>curve3d</li>
<li>curvetexture</li>
<li>curvexyztexture</li>
<li>cylindermesh</li>
<li>cylindershape3d</li>
<li>dampedspringjoint2d</li>
<li>db_to_linear</li>
<li>decal</li>
<li>deg_to_rad</li>
<li>dictionary</li>
<li>diraccess</li>
<li>directionallight2d</li>
<li>directionallight3d</li>
<li>displayserver</li>
<li>dtlsserver</li>
<li>ease</li>
<li>editorcommandpalette</li>
<li>editordebuggerplugin</li>
<li>editorexportplatform</li>
<li>editorexportplugin</li>
<li>editorfeatureprofile</li>
<li>editorfiledialog</li>
<li>editorfilesystem</li>
<li>editorfilesystemdirectory</li>
<li>editorfilesystemimportformatsupportquery</li>
<li>editorimportplugin</li>
<li>editorinspector</li>
<li>editorinspectorplugin</li>
<li>editorinterface</li>
<li>editornode3dgizmo</li>
<li>editornode3dgizmoplugin</li>
<li>editorpaths</li>
<li>editorplugin</li>
<li>editorproperty</li>
<li>editorresourceconversionplugin</li>
<li>editorresourcepicker</li>
<li>editorresourcepreview</li>
<li>editorresourcepreviewgenerator</li>
<li>editorsceneformatimporter</li>
<li>editorscenepostimport</li>
<li>editorscenepostimportplugin</li>
<li>editorscript</li>
<li>editorscriptpicker</li>
<li>editorselection</li>
<li>editorsettings</li>
<li>editorspinslider</li>
<li>editorsyntaxhighlighter</li>
<li>editortranslationparserplugin</li>
<li>editorundoredomanager</li>
<li>editorvcsinterface</li>
<li>elif</li>
<li>else</li>
<li>encodedobjectasid</li>
<li>engine</li>
<li>enginedebugger</li>
<li>engineprofiler</li>
<li>enum</li>
<li>environment</li>
<li>err_already_exists</li>
<li>err_already_in_use</li>
<li>err_bug</li>
<li>err_busy</li>
<li>err_cant_acquire_resource</li>
<li>err_cant_connect</li>
<li>err_cant_create</li>
<li>err_cant_fork</li>
<li>err_cant_open</li>
<li>err_cant_resolve</li>
<li>err_compilation_failed</li>
<li>err_connection_error</li>
<li>err_cyclic_link</li>
<li>err_database_cant_read</li>
<li>err_database_cant_write</li>
<li>err_does_not_exist</li>
<li>err_duplicate_symbol</li>
<li>err_file_already_in_use</li>
<li>err_file_bad_drive</li>
<li>err_file_bad_path</li>
<li>err_file_cant_open</li>
<li>err_file_cant_read</li>
<li>err_file_cant_write</li>
<li>err_file_corrupt</li>
<li>err_file_eof</li>
<li>err_file_missing_dependencies</li>
<li>err_file_no_permission</li>
<li>err_file_not_found</li>
<li>err_file_unrecognized</li>
<li>err_help</li>
<li>err_invalid_data</li>
<li>err_invalid_declaration</li>
<li>err_invalid_parameter</li>
<li>err_link_failed</li>
<li>err_locked</li>
<li>err_method_not_found</li>
<li>err_out_of_memory</li>
<li>err_parameter_range_error</li>
<li>err_parse_error</li>
<li>err_printer_on_fire</li>
<li>err_query_failed</li>
<li>err_script_failed</li>
<li>err_skip</li>
<li>err_timeout</li>
<li>err_unauthorized</li>
<li>err_unavailable</li>
<li>err_unconfigured</li>
<li>error_string</li>
<li>exp</li>
<li>expression</li>
<li>extends</li>
<li>failed</li>
<li>fileaccess</li>
<li>filedialog</li>
<li>filesystemdock</li>
<li>float</li>
<li>floor</li>
<li>floorf</li>
<li>floori</li>
<li>flowcontainer</li>
<li>fmod</li>
<li>fogmaterial</li>
<li>fogvolume</li>
<li>font</li>
<li>fontfile</li>
<li>fontvariation</li>
<li>for</li>
<li>fposmod</li>
<li>func</li>
<li>generic6dofjoint3d</li>
<li>geometry2d</li>
<li>geometry3d</li>
<li>geometryinstance3d</li>
<li>godotsharp</li>
<li>gpuparticles2d</li>
<li>gpuparticles3d</li>
<li>gpuparticlesattractor3d</li>
<li>gpuparticlesattractorbox3d</li>
<li>gpuparticlesattractorsphere3d</li>
<li>gpuparticlesattractorvectorfield3d</li>
<li>gpuparticlescollision3d</li>
<li>gpuparticlescollisionbox3d</li>
<li>gpuparticlescollisionheightfield3d</li>
<li>gpuparticlescollisionsdf3d</li>
<li>gpuparticlescollisionsphere3d</li>
<li>gradient</li>
<li>gradienttexture1d</li>
<li>gradienttexture2d</li>
<li>graphedit</li>
<li>graphnode</li>
<li>gridcontainer</li>
<li>groovejoint2d</li>
<li>hash</li>
<li>hashingcontext</li>
<li>hboxcontainer</li>
<li>heightmapshape3d</li>
<li>hflowcontainer</li>
<li>hingejoint3d</li>
<li>hmaccontext</li>
<li>horizontal</li>
<li>horizontal_alignment_center</li>
<li>horizontal_alignment_fill</li>
<li>horizontal_alignment_left</li>
<li>horizontal_alignment_right</li>
<li>hscrollbar</li>
<li>hseparator</li>
<li>hslider</li>
<li>hsplitcontainer</li>
<li>httpclient</li>
<li>httprequest</li>
<li>if</li>
<li>image</li>
<li>imageformatloader</li>
<li>imageformatloaderextension</li>
<li>imagetexture</li>
<li>imagetexture3d</li>
<li>imagetexturelayered</li>
<li>immediatemesh</li>
<li>importermesh</li>
<li>importermeshinstance3d</li>
<li>in</li>
<li>inf</li>
<li>inline_alignment_bottom</li>
<li>inline_alignment_bottom_to</li>
<li>inline_alignment_center</li>
<li>inline_alignment_center_to</li>
<li>inline_alignment_image_mask</li>
<li>inline_alignment_text_mask</li>
<li>inline_alignment_to_baseline</li>
<li>inline_alignment_to_bottom</li>
<li>inline_alignment_to_center</li>
<li>inline_alignment_to_top</li>
<li>inline_alignment_top</li>
<li>inline_alignment_top_to</li>
<li>input</li>
<li>inputevent</li>
<li>inputeventaction</li>
<li>inputeventfromwindow</li>
<li>inputeventgesture</li>
<li>inputeventjoypadbutton</li>
<li>inputeventjoypadmotion</li>
<li>inputeventkey</li>
<li>inputeventmagnifygesture</li>
<li>inputeventmidi</li>
<li>inputeventmouse</li>
<li>inputeventmousebutton</li>
<li>inputeventmousemotion</li>
<li>inputeventpangesture</li>
<li>inputeventscreendrag</li>
<li>inputeventscreentouch</li>
<li>inputeventshortcut</li>
<li>inputeventwithmodifiers</li>
<li>inputmap</li>
<li>instance_from_id</li>
<li>instanceplaceholder</li>
<li>int</li>
<li>intervaltweener</li>
<li>inverse_lerp</li>
<li>ip</li>
<li>is</li>
<li>is_equal_approx</li>
<li>is_finite</li>
<li>is_inf</li>
<li>is_instance_id_valid</li>
<li>is_instance_valid</li>
<li>is_nan</li>
<li>is_zero_approx</li>
<li>itemlist</li>
<li>javaclass</li>
<li>javaclasswrapper</li>
<li>javascriptbridge</li>
<li>javascriptobject</li>
<li>jnisingleton</li>
<li>joint2d</li>
<li>joint3d</li>
<li>joy_axis_invalid</li>
<li>joy_axis_left_x</li>
<li>joy_axis_left_y</li>
<li>joy_axis_max</li>
<li>joy_axis_right_x</li>
<li>joy_axis_right_y</li>
<li>joy_axis_sdl_max</li>
<li>joy_axis_trigger_left</li>
<li>joy_axis_trigger_right</li>
<li>joy_button_a</li>
<li>joy_button_b</li>
<li>joy_button_back</li>
<li>joy_button_dpad_down</li>
<li>joy_button_dpad_left</li>
<li>joy_button_dpad_right</li>
<li>joy_button_dpad_up</li>
<li>joy_button_guide</li>
<li>joy_button_invalid</li>
<li>joy_button_left_shoulder</li>
<li>joy_button_left_stick</li>
<li>joy_button_max</li>
<li>joy_button_misc1</li>
<li>joy_button_paddle1</li>
<li>joy_button_paddle2</li>
<li>joy_button_paddle3</li>
<li>joy_button_paddle4</li>
<li>joy_button_right_shoulder</li>
<li>joy_button_right_stick</li>
<li>joy_button_sdl_max</li>
<li>joy_button_start</li>
<li>joy_button_touchpad</li>
<li>joy_button_x</li>
<li>joy_button_y</li>
<li>json</li>
<li>jsonrpc</li>
<li>key_0</li>
<li>key_1</li>
<li>key_2</li>
<li>key_3</li>
<li>key_4</li>
<li>key_5</li>
<li>key_6</li>
<li>key_7</li>
<li>key_8</li>
<li>key_9</li>
<li>key_a</li>
<li>key_aacute</li>
<li>key_acircumflex</li>
<li>key_acute</li>
<li>key_adiaeresis</li>
<li>key_ae</li>
<li>key_agrave</li>
<li>key_alt</li>
<li>key_ampersand</li>
<li>key_apostrophe</li>
<li>key_aring</li>
<li>key_asciicircum</li>
<li>key_asciitilde</li>
<li>key_asterisk</li>
<li>key_at</li>
<li>key_atilde</li>
<li>key_b</li>
<li>key_back</li>
<li>key_backslash</li>
<li>key_backspace</li>
<li>key_backtab</li>
<li>key_bar</li>
<li>key_bassboost</li>
<li>key_bassdown</li>
<li>key_bassup</li>
<li>key_braceleft</li>
<li>key_braceright</li>
<li>key_bracketleft</li>
<li>key_bracketright</li>
<li>key_brokenbar</li>
<li>key_c</li>
<li>key_capslock</li>
<li>key_ccedilla</li>
<li>key_cedilla</li>
<li>key_cent</li>
<li>key_clear</li>
<li>key_code_mask</li>
<li>key_colon</li>
<li>key_comma</li>
<li>key_copyright</li>
<li>key_ctrl</li>
<li>key_currency</li>
<li>key_d</li>
<li>key_degree</li>
<li>key_delete</li>
<li>key_diaeresis</li>
<li>key_direction_l</li>
<li>key_direction_r</li>
<li>key_division</li>
<li>key_dollar</li>
<li>key_down</li>
<li>key_e</li>
<li>key_eacute</li>
<li>key_ecircumflex</li>
<li>key_ediaeresis</li>
<li>key_egrave</li>
<li>key_end</li>
<li>key_enter</li>
<li>key_equal</li>
<li>key_escape</li>
<li>key_eth</li>
<li>key_exclam</li>
<li>key_exclamdown</li>
<li>key_f</li>
<li>key_f1</li>
<li>key_f10</li>
<li>key_f11</li>
<li>key_f12</li>
<li>key_f13</li>
<li>key_f14</li>
<li>key_f15</li>
<li>key_f16</li>
<li>key_f17</li>
<li>key_f18</li>
<li>key_f19</li>
<li>key_f2</li>
<li>key_f20</li>
<li>key_f21</li>
<li>key_f22</li>
<li>key_f23</li>
<li>key_f24</li>
<li>key_f25</li>
<li>key_f26</li>
<li>key_f27</li>
<li>key_f28</li>
<li>key_f29</li>
<li>key_f3</li>
<li>key_f30</li>
<li>key_f31</li>
<li>key_f32</li>
<li>key_f33</li>
<li>key_f34</li>
<li>key_f35</li>
<li>key_f4</li>
<li>key_f5</li>
<li>key_f6</li>
<li>key_f7</li>
<li>key_f8</li>
<li>key_f9</li>
<li>key_favorites</li>
<li>key_forward</li>
<li>key_g</li>
<li>key_greater</li>
<li>key_guillemotleft</li>
<li>key_guillemotright</li>
<li>key_h</li>
<li>key_help</li>
<li>key_home</li>
<li>key_homepage</li>
<li>key_hyper_l</li>
<li>key_hyper_r</li>
<li>key_hyphen</li>
<li>key_i</li>
<li>key_iacute</li>
<li>key_icircumflex</li>
<li>key_idiaeresis</li>
<li>key_igrave</li>
<li>key_insert</li>
<li>key_j</li>
<li>key_k</li>
<li>key_kp_0</li>
<li>key_kp_1</li>
<li>key_kp_2</li>
<li>key_kp_3</li>
<li>key_kp_4</li>
<li>key_kp_5</li>
<li>key_kp_6</li>
<li>key_kp_7</li>
<li>key_kp_8</li>
<li>key_kp_9</li>
<li>key_kp_add</li>
<li>key_kp_divide</li>
<li>key_kp_enter</li>
<li>key_kp_multiply</li>
<li>key_kp_period</li>
<li>key_kp_subtract</li>
<li>key_l</li>
<li>key_launch0</li>
<li>key_launch1</li>
<li>key_launch2</li>
<li>key_launch3</li>
<li>key_launch4</li>
<li>key_launch5</li>
<li>key_launch6</li>
<li>key_launch7</li>
<li>key_launch8</li>
<li>key_launch9</li>
<li>key_launcha</li>
<li>key_launchb</li>
<li>key_launchc</li>
<li>key_launchd</li>
<li>key_launche</li>
<li>key_launchf</li>
<li>key_launchmail</li>
<li>key_launchmedia</li>
<li>key_left</li>
<li>key_less</li>
<li>key_m</li>
<li>key_macron</li>
<li>key_masculine</li>
<li>key_mask_alt</li>
<li>key_mask_cmd_or_ctrl</li>
<li>key_mask_ctrl</li>
<li>key_mask_group_switch</li>
<li>key_mask_kpad</li>
<li>key_mask_meta</li>
<li>key_mask_shift</li>
<li>key_medianext</li>
<li>key_mediaplay</li>
<li>key_mediaprevious</li>
<li>key_mediarecord</li>
<li>key_mediastop</li>
<li>key_menu</li>
<li>key_meta</li>
<li>key_minus</li>
<li>key_modifier_mask</li>
<li>key_mu</li>
<li>key_multiply</li>
<li>key_n</li>
<li>key_nobreakspace</li>
<li>key_none</li>
<li>key_notsign</li>
<li>key_ntilde</li>
<li>key_numbersign</li>
<li>key_numlock</li>
<li>key_o</li>
<li>key_oacute</li>
<li>key_ocircumflex</li>
<li>key_odiaeresis</li>
<li>key_ograve</li>
<li>key_onehalf</li>
<li>key_onequarter</li>
<li>key_onesuperior</li>
<li>key_ooblique</li>
<li>key_openurl</li>
<li>key_ordfeminine</li>
<li>key_otilde</li>
<li>key_p</li>
<li>key_pagedown</li>
<li>key_pageup</li>
<li>key_paragraph</li>
<li>key_parenleft</li>
<li>key_parenright</li>
<li>key_pause</li>
<li>key_percent</li>
<li>key_period</li>
<li>key_periodcentered</li>
<li>key_plus</li>
<li>key_plusminus</li>
<li>key_print</li>
<li>key_q</li>
<li>key_question</li>
<li>key_questiondown</li>
<li>key_quotedbl</li>
<li>key_quoteleft</li>
<li>key_r</li>
<li>key_refresh</li>
<li>key_registered</li>
<li>key_right</li>
<li>key_s</li>
<li>key_scrolllock</li>
<li>key_search</li>
<li>key_section</li>
<li>key_semicolon</li>
<li>key_shift</li>
<li>key_slash</li>
<li>key_space</li>
<li>key_special</li>
<li>key_ssharp</li>
<li>key_standby</li>
<li>key_sterling</li>
<li>key_stop</li>
<li>key_super_l</li>
<li>key_super_r</li>
<li>key_sysreq</li>
<li>key_t</li>
<li>key_tab</li>
<li>key_thorn</li>
<li>key_threequarters</li>
<li>key_threesuperior</li>
<li>key_trebledown</li>
<li>key_trebleup</li>
<li>key_twosuperior</li>
<li>key_u</li>
<li>key_uacute</li>
<li>key_ucircumflex</li>
<li>key_udiaeresis</li>
<li>key_ugrave</li>
<li>key_underscore</li>
<li>key_unknown</li>
<li>key_up</li>
<li>key_v</li>
<li>key_volumedown</li>
<li>key_volumemute</li>
<li>key_volumeup</li>
<li>key_w</li>
<li>key_x</li>
<li>key_y</li>
<li>key_yacute</li>
<li>key_ydiaeresis</li>
<li>key_yen</li>
<li>key_z</li>
<li>kinematiccollision2d</li>
<li>kinematiccollision3d</li>
<li>label</li>
<li>label3d</li>
<li>labelsettings</li>
<li>lerp</li>
<li>lerp_angle</li>
<li>lerpf</li>
<li>light2d</li>
<li>light3d</li>
<li>lightmapgi</li>
<li>lightmapgidata</li>
<li>lightmapper</li>
<li>lightmapperrd</li>
<li>lightmapprobe</li>
<li>lightoccluder2d</li>
<li>line2d</li>
<li>linear_to_db</li>
<li>lineedit</li>
<li>linkbutton</li>
<li>log</li>
<li>mainloop</li>
<li>margincontainer</li>
<li>marker2d</li>
<li>marker3d</li>
<li>marshalls</li>
<li>match</li>
<li>material</li>
<li>max</li>
<li>maxf</li>
<li>maxi</li>
<li>menubar</li>
<li>menubutton</li>
<li>mesh</li>
<li>meshdatatool</li>
<li>meshinstance2d</li>
<li>meshinstance3d</li>
<li>meshlibrary</li>
<li>meshtexture</li>
<li>method_flag_const</li>
<li>method_flag_editor</li>
<li>method_flag_normal</li>
<li>method_flag_object_core</li>
<li>method_flag_static</li>
<li>method_flag_vararg</li>
<li>method_flag_virtual</li>
<li>method_flags_default</li>
<li>methodtweener</li>
<li>midi_message_active_sensing</li>
<li>midi_message_aftertouch</li>
<li>midi_message_channel_pressure</li>
<li>midi_message_continue</li>
<li>midi_message_control_change</li>
<li>midi_message_none</li>
<li>midi_message_note_off</li>
<li>midi_message_note_on</li>
<li>midi_message_pitch_bend</li>
<li>midi_message_program_change</li>
<li>midi_message_quarter_frame</li>
<li>midi_message_song_position_pointer</li>
<li>midi_message_song_select</li>
<li>midi_message_start</li>
<li>midi_message_stop</li>
<li>midi_message_system_exclusive</li>
<li>midi_message_system_reset</li>
<li>midi_message_timing_clock</li>
<li>midi_message_tune_request</li>
<li>min</li>
<li>minf</li>
<li>mini</li>
<li>missingnode</li>
<li>missingresource</li>
<li>mouse_button_left</li>
<li>mouse_button_mask_left</li>
<li>mouse_button_mask_middle</li>
<li>mouse_button_mask_right</li>
<li>mouse_button_mask_xbutton1</li>
<li>mouse_button_mask_xbutton2</li>
<li>mouse_button_middle</li>
<li>mouse_button_none</li>
<li>mouse_button_right</li>
<li>mouse_button_wheel_down</li>
<li>mouse_button_wheel_left</li>
<li>mouse_button_wheel_right</li>
<li>mouse_button_wheel_up</li>
<li>mouse_button_xbutton1</li>
<li>mouse_button_xbutton2</li>
<li>move_toward</li>
<li>moviewriter</li>
<li>multimesh</li>
<li>multimeshinstance2d</li>
<li>multimeshinstance3d</li>
<li>multiplayerapi</li>
<li>multiplayerapiextension</li>
<li>multiplayerpeer</li>
<li>multiplayerpeerextension</li>
<li>mutex</li>
<li>namespace</li>
<li>nan</li>
<li>nativeextension</li>
<li>nativeextensionmanager</li>
<li>navigationagent2d</li>
<li>navigationagent3d</li>
<li>navigationlink2d</li>
<li>navigationlink3d</li>
<li>navigationmesh</li>
<li>navigationmeshgenerator</li>
<li>navigationobstacle2d</li>
<li>navigationobstacle3d</li>
<li>navigationpathqueryparameters2d</li>
<li>navigationpathqueryparameters3d</li>
<li>navigationpathqueryresult2d</li>
<li>navigationpathqueryresult3d</li>
<li>navigationpolygon</li>
<li>navigationregion2d</li>
<li>navigationregion3d</li>
<li>navigationserver2d</li>
<li>navigationserver3d</li>
<li>nearest_po2</li>
<li>ninepatchrect</li>
<li>node</li>
<li>node2d</li>
<li>node3d</li>
<li>node3dgizmo</li>
<li>nodepath</li>
<li>not</li>
<li>object</li>
<li>occluder3d</li>
<li>occluderinstance3d</li>
<li>occluderpolygon2d</li>
<li>ok</li>
<li>omnilight3d</li>
<li>on_failure</li>
<li>on_success</li>
<li>op_add</li>
<li>op_and</li>
<li>op_bit_and</li>
<li>op_bit_negate</li>
<li>op_bit_or</li>
<li>op_bit_xor</li>
<li>op_divide</li>
<li>op_equal</li>
<li>op_greater</li>
<li>op_greater_equal</li>
<li>op_in</li>
<li>op_less</li>
<li>op_less_equal</li>
<li>op_max</li>
<li>op_module</li>
<li>op_multiply</li>
<li>op_negate</li>
<li>op_not</li>
<li>op_not_equal</li>
<li>op_or</li>
<li>op_positive</li>
<li>op_power</li>
<li>op_shift_left</li>
<li>op_shift_right</li>
<li>op_subtract</li>
<li>op_xor</li>
<li>optimizedtranslation</li>
<li>optionbutton</li>
<li>or</li>
<li>ormmaterial3d</li>
<li>os</li>
<li>packedbytearray</li>
<li>packedcolorarray</li>
<li>packeddatacontainer</li>
<li>packeddatacontainerref</li>
<li>packedfloat32array</li>
<li>packedfloat64array</li>
<li>packedint32array</li>
<li>packedint64array</li>
<li>packedscene</li>
<li>packedstringarray</li>
<li>packedvector2array</li>
<li>packedvector3array</li>
<li>packetpeer</li>
<li>packetpeerdtls</li>
<li>packetpeerextension</li>
<li>packetpeerstream</li>
<li>packetpeerudp</li>
<li>panel</li>
<li>panelcontainer</li>
<li>panoramaskymaterial</li>
<li>parallaxbackground</li>
<li>parallaxlayer</li>
<li>particleprocessmaterial</li>
<li>pass</li>
<li>path2d</li>
<li>path3d</li>
<li>pathfollow2d</li>
<li>pathfollow3d</li>
<li>pckpacker</li>
<li>performance</li>
<li>physicalbone2d</li>
<li>physicalbone3d</li>
<li>physicalskymaterial</li>
<li>physicsbody2d</li>
<li>physicsbody3d</li>
<li>physicsdirectbodystate2d</li>
<li>physicsdirectbodystate2dextension</li>
<li>physicsdirectbodystate3d</li>
<li>physicsdirectbodystate3dextension</li>
<li>physicsdirectspacestate2d</li>
<li>physicsdirectspacestate2dextension</li>
<li>physicsdirectspacestate3d</li>
<li>physicsdirectspacestate3dextension</li>
<li>physicsmaterial</li>
<li>physicspointqueryparameters2d</li>
<li>physicspointqueryparameters3d</li>
<li>physicsrayqueryparameters2d</li>
<li>physicsrayqueryparameters3d</li>
<li>physicsserver2d</li>
<li>physicsserver2dextension</li>
<li>physicsserver2dmanager</li>
<li>physicsserver3d</li>
<li>physicsserver3dextension</li>
<li>physicsserver3dmanager</li>
<li>physicsserver3drenderingserverhandler</li>
<li>physicsshapequeryparameters2d</li>
<li>physicsshapequeryparameters3d</li>
<li>physicstestmotionparameters2d</li>
<li>physicstestmotionparameters3d</li>
<li>physicstestmotionresult2d</li>
<li>physicstestmotionresult3d</li>
<li>pi</li>
<li>pingpong</li>
<li>pinjoint2d</li>
<li>pinjoint3d</li>
<li>placeholdercubemap</li>
<li>placeholdercubemaparray</li>
<li>placeholdermaterial</li>
<li>placeholdermesh</li>
<li>placeholdertexture2d</li>
<li>placeholdertexture2darray</li>
<li>placeholdertexture3d</li>
<li>placeholdertexturelayered</li>
<li>plane</li>
<li>planemesh</li>
<li>pointlight2d</li>
<li>pointmesh</li>
<li>polygon2d</li>
<li>polygonoccluder3d</li>
<li>polygonpathfinder</li>
<li>popup</li>
<li>popupmenu</li>
<li>popuppanel</li>
<li>portablecompressedtexture2d</li>
<li>posmod</li>
<li>pow</li>
<li>preload</li>
<li>primitivemesh</li>
<li>print</li>
<li>print_rich</li>
<li>print_verbose</li>
<li>printerr</li>
<li>printraw</li>
<li>prints</li>
<li>printt</li>
<li>prismmesh</li>
<li>proceduralskymaterial</li>
<li>progressbar</li>
<li>projection</li>
<li>projectsettings</li>
<li>property_hint_array_type</li>
<li>property_hint_color_no_alpha</li>
<li>property_hint_dir</li>
<li>property_hint_enum</li>
<li>property_hint_enum_suggestion</li>
<li>property_hint_exp_easing</li>
<li>property_hint_expression</li>
<li>property_hint_file</li>
<li>property_hint_flags</li>
<li>property_hint_global_dir</li>
<li>property_hint_global_file</li>
<li>property_hint_global_save_file</li>
<li>property_hint_hide_quaternion_edit</li>
<li>property_hint_image_compress_lossless</li>
<li>property_hint_image_compress_lossy</li>
<li>property_hint_int_is_objectid</li>
<li>property_hint_int_is_pointer</li>
<li>property_hint_layers_2d_navigation</li>
<li>property_hint_layers_2d_physics</li>
<li>property_hint_layers_2d_render</li>
<li>property_hint_layers_3d_navigation</li>
<li>property_hint_layers_3d_physics</li>
<li>property_hint_layers_3d_render</li>
<li>property_hint_link</li>
<li>property_hint_locale_id</li>
<li>property_hint_localizable_string</li>
<li>property_hint_max</li>
<li>property_hint_method_of_base_type</li>
<li>property_hint_method_of_instance</li>
<li>property_hint_method_of_script</li>
<li>property_hint_method_of_variant_type</li>
<li>property_hint_multiline_text</li>
<li>property_hint_node_path_to_edited_node</li>
<li>property_hint_node_path_valid_types</li>
<li>property_hint_node_type</li>
<li>property_hint_none</li>
<li>property_hint_object_id</li>
<li>property_hint_object_too_big</li>
<li>property_hint_password</li>
<li>property_hint_placeholder_text</li>
<li>property_hint_property_of_base_type</li>
<li>property_hint_property_of_instance</li>
<li>property_hint_property_of_script</li>
<li>property_hint_property_of_variant_type</li>
<li>property_hint_range</li>
<li>property_hint_resource_type</li>
<li>property_hint_save_file</li>
<li>property_hint_type_string</li>
<li>property_usage_animate_as_trigger</li>
<li>property_usage_array</li>
<li>property_usage_category</li>
<li>property_usage_checkable</li>
<li>property_usage_checked</li>
<li>property_usage_class_is_bitfield</li>
<li>property_usage_class_is_enum</li>
<li>property_usage_default</li>
<li>property_usage_default_intl</li>
<li>property_usage_deferred_set_resource</li>
<li>property_usage_do_not_share_on_duplicate</li>
<li>property_usage_editor</li>
<li>property_usage_editor_basic_setting</li>
<li>property_usage_editor_instantiate_object</li>
<li>property_usage_group</li>
<li>property_usage_high_end_gfx</li>
<li>property_usage_internal</li>
<li>property_usage_internationalized</li>
<li>property_usage_keying_increments</li>
<li>property_usage_nil_is_variant</li>
<li>property_usage_no_editor</li>
<li>property_usage_no_instance_state</li>
<li>property_usage_node_path_from_scene_root</li>
<li>property_usage_none</li>
<li>property_usage_read_only</li>
<li>property_usage_resource_not_persistent</li>
<li>property_usage_restart_if_changed</li>
<li>property_usage_script_default_value</li>
<li>property_usage_script_variable</li>
<li>property_usage_storage</li>
<li>property_usage_store_if_null</li>
<li>property_usage_subgroup</li>
<li>property_usage_update_all_if_modified</li>
<li>propertytweener</li>
<li>push_error</li>
<li>push_warning</li>
<li>quadmesh</li>
<li>quadoccluder3d</li>
<li>quaternion</li>
<li>rad_to_deg</li>
<li>rand_from_seed</li>
<li>randf</li>
<li>randf_range</li>
<li>randfn</li>
<li>randi</li>
<li>randi_range</li>
<li>randomize</li>
<li>randomnumbergenerator</li>
<li>range</li>
<li>raycast2d</li>
<li>raycast3d</li>
<li>rdattachmentformat</li>
<li>rdframebufferpass</li>
<li>rdpipelinecolorblendstate</li>
<li>rdpipelinecolorblendstateattachment</li>
<li>rdpipelinedepthstencilstate</li>
<li>rdpipelinemultisamplestate</li>
<li>rdpipelinerasterizationstate</li>
<li>rdpipelinespecializationconstant</li>
<li>rdsamplerstate</li>
<li>rdshaderfile</li>
<li>rdshadersource</li>
<li>rdshaderspirv</li>
<li>rdtextureformat</li>
<li>rdtextureview</li>
<li>rduniform</li>
<li>rdvertexattribute</li>
<li>rect2</li>
<li>rect2i</li>
<li>rectangleshape2d</li>
<li>refcounted</li>
<li>referencerect</li>
<li>reflectionprobe</li>
<li>remap</li>
<li>remotetransform2d</li>
<li>remotetransform3d</li>
<li>renderingdevice</li>
<li>renderingserver</li>
<li>resource</li>
<li>resourceformatloader</li>
<li>resourceformatsaver</li>
<li>resourceimporter</li>
<li>resourceloader</li>
<li>resourcepreloader</li>
<li>resourcesaver</li>
<li>resourceuid</li>
<li>return</li>
<li>ribbontrailmesh</li>
<li>richtexteffect</li>
<li>richtextlabel</li>
<li>rid</li>
<li>rid_allocate_id</li>
<li>rid_from_int64</li>
<li>rigidbody2d</li>
<li>rigidbody3d</li>
<li>rootmotionview</li>
<li>round</li>
<li>roundf</li>
<li>roundi</li>
<li>scenestate</li>
<li>scenetree</li>
<li>scenetreetimer</li>
<li>script</li>
<li>scriptcreatedialog</li>
<li>scripteditor</li>
<li>scripteditorbase</li>
<li>scriptextension</li>
<li>scriptlanguage</li>
<li>scriptlanguageextension</li>
<li>scrollbar</li>
<li>scrollcontainer</li>
<li>seed</li>
<li>segmentshape2d</li>
<li>self</li>
<li>semaphore</li>
<li>separationrayshape2d</li>
<li>separationrayshape3d</li>
<li>separator</li>
<li>shader</li>
<li>shaderglobalsoverride</li>
<li>shaderinclude</li>
<li>shadermaterial</li>
<li>shape2d</li>
<li>shape3d</li>
<li>shapecast2d</li>
<li>shapecast3d</li>
<li>shortcut</li>
<li>side_bottom</li>
<li>side_left</li>
<li>side_right</li>
<li>side_top</li>
<li>sign</li>
<li>signal</li>
<li>signf</li>
<li>signi</li>
<li>sin</li>
<li>sinh</li>
<li>skeleton2d</li>
<li>skeleton3d</li>
<li>skeletonik3d</li>
<li>skeletonmodification2d</li>
<li>skeletonmodification2dccdik</li>
<li>skeletonmodification2dfabrik</li>
<li>skeletonmodification2djiggle</li>
<li>skeletonmodification2dlookat</li>
<li>skeletonmodification2dphysicalbones</li>
<li>skeletonmodification2dstackholder</li>
<li>skeletonmodification2dtwoboneik</li>
<li>skeletonmodification3d</li>
<li>skeletonmodification3dccdik</li>
<li>skeletonmodification3dfabrik</li>
<li>skeletonmodification3djiggle</li>
<li>skeletonmodification3dlookat</li>
<li>skeletonmodification3dstackholder</li>
<li>skeletonmodification3dtwoboneik</li>
<li>skeletonmodificationstack2d</li>
<li>skeletonmodificationstack3d</li>
<li>skeletonprofile</li>
<li>skeletonprofilehumanoid</li>
<li>skin</li>
<li>skinreference</li>
<li>sky</li>
<li>slider</li>
<li>sliderjoint3d</li>
<li>smoothstep</li>
<li>snapped</li>
<li>softbody3d</li>
<li>spheremesh</li>
<li>sphereoccluder3d</li>
<li>sphereshape3d</li>
<li>spinbox</li>
<li>splitcontainer</li>
<li>spotlight3d</li>
<li>springarm3d</li>
<li>sprite2d</li>
<li>sprite3d</li>
<li>spritebase3d</li>
<li>spriteframes</li>
<li>sqrt</li>
<li>standardmaterial3d</li>
<li>static</li>
<li>staticbody2d</li>
<li>staticbody3d</li>
<li>step_decimals</li>
<li>str</li>
<li>str_to_var</li>
<li>streampeer</li>
<li>streampeerbuffer</li>
<li>streampeerextension</li>
<li>streampeergzip</li>
<li>streampeertcp</li>
<li>streampeertls</li>
<li>string</li>
<li>stringname</li>
<li>stylebox</li>
<li>styleboxempty</li>
<li>styleboxflat</li>
<li>styleboxline</li>
<li>styleboxtexture</li>
<li>subviewport</li>
<li>subviewportcontainer</li>
<li>super</li>
<li>surfacetool</li>
<li>syntaxhighlighter</li>
<li>systemfont</li>
<li>tabbar</li>
<li>tabcontainer</li>
<li>tan</li>
<li>tanh</li>
<li>tau</li>
<li>tcpserver</li>
<li>textedit</li>
<li>textline</li>
<li>textmesh</li>
<li>textparagraph</li>
<li>textserver</li>
<li>textserverdummy</li>
<li>textserverextension</li>
<li>textservermanager</li>
<li>texture</li>
<li>texture2d</li>
<li>texture2darray</li>
<li>texture3d</li>
<li>texturebutton</li>
<li>texturelayered</li>
<li>textureprogressbar</li>
<li>texturerect</li>
<li>theme</li>
<li>themedb</li>
<li>thread</li>
<li>tiledata</li>
<li>tilemap</li>
<li>tilemappattern</li>
<li>tileset</li>
<li>tilesetatlassource</li>
<li>tilesetscenescollectionsource</li>
<li>tilesetsource</li>
<li>time</li>
<li>timer</li>
<li>torusmesh</li>
<li>touchscreenbutton</li>
<li>trait</li>
<li>transform2d</li>
<li>transform3d</li>
<li>translation</li>
<li>translationserver</li>
<li>tree</li>
<li>treeitem</li>
<li>trianglemesh</li>
<li>tubetrailmesh</li>
<li>tween</li>
<li>tweener</li>
<li>type_aabb</li>
<li>type_array</li>
<li>type_basis</li>
<li>type_bool</li>
<li>type_callable</li>
<li>type_color</li>
<li>type_dictionary</li>
<li>type_float</li>
<li>type_int</li>
<li>type_max</li>
<li>type_nil</li>
<li>type_node_path</li>
<li>type_object</li>
<li>type_packed_byte_array</li>
<li>type_packed_color_array</li>
<li>type_packed_float32_array</li>
<li>type_packed_float64_array</li>
<li>type_packed_int32_array</li>
<li>type_packed_int64_array</li>
<li>type_packed_string_array</li>
<li>type_packed_vector2_array</li>
<li>type_packed_vector3_array</li>
<li>type_plane</li>
<li>type_projection</li>
<li>type_quaternion</li>
<li>type_rect2</li>
<li>type_rect2i</li>
<li>type_rid</li>
<li>type_signal</li>
<li>type_string</li>
<li>type_string_name</li>
<li>type_transform2d</li>
<li>type_transform3d</li>
<li>type_vector2</li>
<li>type_vector2i</li>
<li>type_vector3</li>
<li>type_vector3i</li>
<li>type_vector4</li>
<li>type_vector4i</li>
<li>typeof</li>
<li>udpserver</li>
<li>undoredo</li>
<li>var</li>
<li>var_to_bytes</li>
<li>var_to_bytes_with_objects</li>
<li>var_to_str</li>
<li>variant</li>
<li>vboxcontainer</li>
<li>vector2</li>
<li>vector2i</li>
<li>vector3</li>
<li>vector3i</li>
<li>vector4</li>
<li>vector4i</li>
<li>vehiclebody3d</li>
<li>vehiclewheel3d</li>
<li>vertical</li>
<li>vertical_alignment_bottom</li>
<li>vertical_alignment_center</li>
<li>vertical_alignment_fill</li>
<li>vertical_alignment_top</li>
<li>vflowcontainer</li>
<li>videostream</li>
<li>videostreamplayer</li>
<li>viewport</li>
<li>viewporttexture</li>
<li>visibleonscreenenabler2d</li>
<li>visibleonscreenenabler3d</li>
<li>visibleonscreennotifier2d</li>
<li>visibleonscreennotifier3d</li>
<li>visualinstance3d</li>
<li>visualshader</li>
<li>visualshadernode</li>
<li>visualshadernodebillboard</li>
<li>visualshadernodebooleanconstant</li>
<li>visualshadernodebooleanparameter</li>
<li>visualshadernodeclamp</li>
<li>visualshadernodecolorconstant</li>
<li>visualshadernodecolorfunc</li>
<li>visualshadernodecolorop</li>
<li>visualshadernodecolorparameter</li>
<li>visualshadernodecomment</li>
<li>visualshadernodecompare</li>
<li>visualshadernodeconstant</li>
<li>visualshadernodecubemap</li>
<li>visualshadernodecubemapparameter</li>
<li>visualshadernodecurvetexture</li>
<li>visualshadernodecurvexyztexture</li>
<li>visualshadernodecustom</li>
<li>visualshadernodederivativefunc</li>
<li>visualshadernodedeterminant</li>
<li>visualshadernodedistancefade</li>
<li>visualshadernodedotproduct</li>
<li>visualshadernodeexpression</li>
<li>visualshadernodefaceforward</li>
<li>visualshadernodefloatconstant</li>
<li>visualshadernodefloatfunc</li>
<li>visualshadernodefloatop</li>
<li>visualshadernodefloatparameter</li>
<li>visualshadernodefresnel</li>
<li>visualshadernodeglobalexpression</li>
<li>visualshadernodegroupbase</li>
<li>visualshadernodeif</li>
<li>visualshadernodeinput</li>
<li>visualshadernodeintconstant</li>
<li>visualshadernodeintfunc</li>
<li>visualshadernodeintop</li>
<li>visualshadernodeintparameter</li>
<li>visualshadernodeis</li>
<li>visualshadernodelinearscenedepth</li>
<li>visualshadernodemix</li>
<li>visualshadernodemultiplyadd</li>
<li>visualshadernodeouterproduct</li>
<li>visualshadernodeoutput</li>
<li>visualshadernodeparameter</li>
<li>visualshadernodeparameterref</li>
<li>visualshadernodeparticleaccelerator</li>
<li>visualshadernodeparticleboxemitter</li>
<li>visualshadernodeparticleconevelocity</li>
<li>visualshadernodeparticleemit</li>
<li>visualshadernodeparticleemitter</li>
<li>visualshadernodeparticlemeshemitter</li>
<li>visualshadernodeparticlemultiplybyaxisangle</li>
<li>visualshadernodeparticleoutput</li>
<li>visualshadernodeparticlerandomness</li>
<li>visualshadernodeparticleringemitter</li>
<li>visualshadernodeparticlesphereemitter</li>
<li>visualshadernodeproximityfade</li>
<li>visualshadernoderandomrange</li>
<li>visualshadernoderemap</li>
<li>visualshadernoderesizablebase</li>
<li>visualshadernodesample3d</li>
<li>visualshadernodescreenuvtosdf</li>
<li>visualshadernodesdfraymarch</li>
<li>visualshadernodesdftoscreenuv</li>
<li>visualshadernodesmoothstep</li>
<li>visualshadernodestep</li>
<li>visualshadernodeswitch</li>
<li>visualshadernodetexture</li>
<li>visualshadernodetexture2darray</li>
<li>visualshadernodetexture2darrayparameter</li>
<li>visualshadernodetexture2dparameter</li>
<li>visualshadernodetexture3d</li>
<li>visualshadernodetexture3dparameter</li>
<li>visualshadernodetextureparameter</li>
<li>visualshadernodetextureparametertriplanar</li>
<li>visualshadernodetexturesdf</li>
<li>visualshadernodetexturesdfnormal</li>
<li>visualshadernodetransformcompose</li>
<li>visualshadernodetransformconstant</li>
<li>visualshadernodetransformdecompose</li>
<li>visualshadernodetransformfunc</li>
<li>visualshadernodetransformop</li>
<li>visualshadernodetransformparameter</li>
<li>visualshadernodetransformvecmult</li>
<li>visualshadernodeuvfunc</li>
<li>visualshadernodeuvpolarcoord</li>
<li>visualshadernodevarying</li>
<li>visualshadernodevaryinggetter</li>
<li>visualshadernodevaryingsetter</li>
<li>visualshadernodevec2constant</li>
<li>visualshadernodevec2parameter</li>
<li>visualshadernodevec3constant</li>
<li>visualshadernodevec3parameter</li>
<li>visualshadernodevec4constant</li>
<li>visualshadernodevec4parameter</li>
<li>visualshadernodevectorbase</li>
<li>visualshadernodevectorcompose</li>
<li>visualshadernodevectordecompose</li>
<li>visualshadernodevectordistance</li>
<li>visualshadernodevectorfunc</li>
<li>visualshadernodevectorlen</li>
<li>visualshadernodevectorop</li>
<li>visualshadernodevectorrefract</li>
<li>void</li>
<li>voxelgi</li>
<li>voxelgidata</li>
<li>vscrollbar</li>
<li>vseparator</li>
<li>vslider</li>
<li>vsplitcontainer</li>
<li>weakref</li>
<li>while</li>
<li>window</li>
<li>workerthreadpool</li>
<li>world2d</li>
<li>world3d</li>
<li>worldboundaryshape2d</li>
<li>worldboundaryshape3d</li>
<li>worldenvironment</li>
<li>wrap</li>
<li>wrapf</li>
<li>wrapi</li>
<li>x509certificate</li>
<li>xmlparser</li>
<li>xranchor3d</li>
<li>xrcamera3d</li>
<li>xrcontroller3d</li>
<li>xrinterface</li>
<li>xrinterfaceextension</li>
<li>xrnode3d</li>
<li>xrorigin3d</li>
<li>xrpose</li>
<li>xrpositionaltracker</li>
<li>xrserver</li>
<li>yield</li>
</ul>

## FEATURE SET


### Client Modification Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|BasePath|✗|ToolingExtension
|Authorizations|✗|ToolingExtension
|UserAgent|✗|ToolingExtension
|MockServer|✗|ToolingExtension

### Data Type Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Custom|✓|OAS2,OAS3
|Int32|✓|OAS2,OAS3
|Int64|✓|OAS2,OAS3
|Float|✓|OAS2,OAS3
|Double|✓|OAS2,OAS3
|Decimal|✓|ToolingExtension
|String|✓|OAS2,OAS3
|Byte|✓|OAS2,OAS3
|Binary|✓|OAS2,OAS3
|Boolean|✓|OAS2,OAS3
|Date|✓|OAS2,OAS3
|DateTime|✓|OAS2,OAS3
|Password|✓|OAS2,OAS3
|File|✓|OAS2
|Uuid|✓|
|Array|✓|OAS2,OAS3
|Null|✓|OAS3
|AnyType|✗|OAS2,OAS3
|Object|✓|OAS2,OAS3
|Maps|✗|ToolingExtension
|CollectionFormat|✗|OAS2
|CollectionFormatMulti|✗|OAS2
|Enum|✓|OAS2,OAS3
|ArrayOfEnum|✗|ToolingExtension
|ArrayOfModel|✓|ToolingExtension
|ArrayOfCollectionOfPrimitives|✗|ToolingExtension
|ArrayOfCollectionOfModel|✗|ToolingExtension
|ArrayOfCollectionOfEnum|✗|ToolingExtension
|MapOfEnum|✗|ToolingExtension
|MapOfModel|✗|ToolingExtension
|MapOfCollectionOfPrimitives|✗|ToolingExtension
|MapOfCollectionOfModel|✗|ToolingExtension
|MapOfCollectionOfEnum|✗|ToolingExtension

### Documentation Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Readme|✓|ToolingExtension
|Model|✓|ToolingExtension
|Api|✓|ToolingExtension

### Global Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Host|✓|OAS2,OAS3
|BasePath|✓|OAS2,OAS3
|Info|✓|OAS2,OAS3
|Schemes|✓|OAS2,OAS3
|PartialSchemes|✓|OAS2,OAS3
|Consumes|✓|OAS2
|Produces|✓|OAS2
|ExternalDocumentation|✓|OAS2,OAS3
|Examples|✓|OAS2,OAS3
|XMLStructureDefinitions|✗|OAS2,OAS3
|MultiServer|✗|OAS3
|ParameterizedServer|✗|OAS3
|ParameterStyling|✓|OAS3
|Callbacks|✗|OAS3
|LinkObjects|✗|OAS3

### Parameter Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Path|✓|OAS2,OAS3
|Query|✓|OAS2,OAS3
|Header|✓|OAS2,OAS3
|Body|✓|OAS2
|FormUnencoded|✓|OAS2
|FormMultipart|✗|OAS2
|Cookie|✗|OAS3

### Schema Support Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|Simple|✓|OAS2,OAS3
|Composite|✓|OAS2,OAS3
|Polymorphism|✗|OAS2,OAS3
|Union|✗|OAS3
|allOf|✗|OAS2,OAS3
|anyOf|✗|OAS3
|oneOf|✗|OAS3
|not|✗|OAS3

### Security Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|BasicAuth|✗|OAS2,OAS3
|ApiKey|✓|OAS2,OAS3
|OpenIDConnect|✗|OAS3
|BearerToken|✓|OAS3
|OAuth2_Implicit|✓|OAS2,OAS3
|OAuth2_Password|✓|OAS2,OAS3
|OAuth2_ClientCredentials|✓|OAS2,OAS3
|OAuth2_AuthorizationCode|✓|OAS2,OAS3
|SignatureAuth|✗|OAS3
|AWSV4Signature|✗|ToolingExtension

### Wire Format Feature
| Name | Supported | Defined By |
| ---- | --------- | ---------- |
|JSON|✓|OAS2,OAS3
|XML|✗|OAS2,OAS3
|PROTOBUF|✗|ToolingExtension
|Custom|✗|OAS2,OAS3
