---
id: faq-extending
title: "FAQ: Extending"
---

## How do I use my own Java models?

See [Bringing your own Models](./customization.md#bringing-your-own-models).

## How do I disable certificate verification?

Please add `-Dio.swagger.v3.parser.util.RemoteUrl.trustAll=true` when generating the code.

## How do I skip files during code generation?

OpenAPI Generator has a built-in ignore file processor.

For example, to skip `git_push.sh`, one can create a file named `.openapi-generator-ignore` in the root of the output directory with the contents:
 
```
# Prevent generator from creating these files:
git_push.sh
```

The ignore file works just like .gitignore, and it is auto-generated by default.

If you need this functionality on initial generation, you can provide the option `--ignore-file-override` (CLI) or `ignoreFileOverride` (Maven and Gradle plugins) with a value targeting any existing file. The contents of that file will be evaluated relative to the output directory.


## How can I customize the auto-generated code?

Variants:

* "How can I add a header/footer to generated code?"
* "How can I add my own logging to generated code?"
* "How can I add my license to the top of files?"

OpenAPI Generator supports user-defined templates without need to recompile the artifact. We also support custom generators (templates and logic) if those generators are accessible on the classpath.

See [templating: Modifying Templates](./templating.md#modifying-templates) and [customization](./customization.md) docs for more details.
