/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.infrastructure;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openapitools.client.infrastructure.ApiAbstractionsKt;
import org.openapitools.client.infrastructure.ApiClient;
import org.openapitools.client.infrastructure.ApiResponse;
import org.openapitools.client.infrastructure.ClientError;
import org.openapitools.client.infrastructure.Informational;
import org.openapitools.client.infrastructure.PartConfig;
import org.openapitools.client.infrastructure.Redirection;
import org.openapitools.client.infrastructure.RequestConfig;
import org.openapitools.client.infrastructure.RequestMethod;
import org.openapitools.client.infrastructure.ResponseExtensionsKt;
import org.openapitools.client.infrastructure.Serializer;
import org.openapitools.client.infrastructure.ServerError;
import org.openapitools.client.infrastructure.Success;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0004J\u0012\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0004J\"\u0010\u0010\u001a\u00020\u0003\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u0002H\u0011H\u0084\b\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00110\u0014\"\u0006\b\u0000\u0010\u0015\u0018\u0001\"\u0006\b\u0001\u0010\u0011\u0018\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0084\bJ(\u0010\u0018\u001a\u00020\u0019\"\u0006\b\u0000\u0010\u0011\u0018\u00012\u0006\u0010\u001a\u001a\u0002H\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u001cJ.\u0010\u001d\u001a\u0004\u0018\u0001H\u0011\"\u0006\b\u0000\u0010\u0011\u0018\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/openapitools/client/infrastructure/ApiClient;", "", "baseUrl", "", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "getBaseUrl", "()Ljava/lang/String;", "getClient", "()Lokhttp3/OkHttpClient;", "guessContentTypeFromFile", "file", "Ljava/io/File;", "parameterToString", "value", "parseDateToQueryString", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "request", "Lorg/openapitools/client/infrastructure/ApiResponse;", "I", "requestConfig", "Lorg/openapitools/client/infrastructure/RequestConfig;", "requestBody", "Lokhttp3/RequestBody;", "content", "mediaType", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "body", "Lokhttp3/ResponseBody;", "(Lokhttp3/ResponseBody;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "kotlin-petstore-okhttp4-parameter-tests"})
public class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final OkHttpClient client;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    protected static final String Authorization = "Authorization";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String FormDataMediaType = "multipart/form-data";
    @NotNull
    protected static final String FormUrlEncMediaType = "application/x-www-form-urlencoded";
    @NotNull
    protected static final String XmlMediaType = "application/xml";
    @NotNull
    private static final Map<String, String> apiKey = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> apiKeyPrefix = new LinkedHashMap();
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @Nullable
    private static String accessToken;
    @NotNull
    public static final String baseUrlKey = "org.openapitools.client.baseUrl";
    @NotNull
    private static final Lazy<OkHttpClient> defaultClient$delegate;
    @NotNull
    private static final OkHttpClient.Builder builder;

    public ApiClient(@NotNull String baseUrl, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.baseUrl = baseUrl;
        this.client = client;
    }

    public /* synthetic */ ApiClient(String string, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            okHttpClient = Companion.getDefaultClient();
        }
        this(string, okHttpClient);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @NotNull
    protected final String guessContentTypeFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        String string = contentType;
        if (string == null) {
            string = "application/octet-stream";
        }
        return string;
    }

    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            File file = (File)content;
            String string = mediaType;
            if (string == null) {
                string = this.guessContentTypeFromFile((File)content);
            }
            requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            MultipartBody.Builder builder;
            MultipartBody.Builder $this$requestBody_u24lambda_u241 = builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map partHeaders;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                if (part.getBody() instanceof File) {
                    partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(part.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\"; filename=\"" + ((File)part.getBody()).getName() + '\"')));
                    MediaType fileMediaType = MediaType.Companion.parse(this.guessContentTypeFromFile((File)part.getBody()));
                    $this$requestBody_u24lambda_u241.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create((File)part.getBody(), fileMediaType));
                    continue;
                }
                partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(part.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + '\"')));
                $this$requestBody_u24lambda_u241.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create(this.parameterToString(part.getBody()), null));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            FormBody.Builder builder;
            FormBody.Builder $this$requestBody_u24lambda_u243 = builder = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl3 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                $this$requestBody_u24lambda_u243.add(name, this.parameterToString(part.getBody()));
            }
            requestBody = (RequestBody)builder.build();
        } else if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            if (content == null) {
                requestBody = Util.EMPTY_REQUEST;
            } else {
                Moshi moshi2 = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = moshi2.adapter(Object.class).toJson(content);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi.adapter(T::class.java).toJson(content)");
                String string2 = mediaType;
                if (string2 == null) {
                    string2 = JsonMediaType;
                }
                requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(string2));
            }
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final /* synthetic */ <T> T responseBody(ResponseBody body, String mediaType) {
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File tempFile = Files.createTempFile("tmp.org.openapitools.client", null, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            Closeable closeable = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)tempFile;
        }
        String bodyContent = body.string();
        if (((CharSequence)bodyContent).length() == 0) {
            return null;
        }
        if (!(mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null))) {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        Moshi $this$adapter$iv = Serializer.getMoshi();
        boolean $i$f$adapter = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return (T)_MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object responseBody$default(ApiClient $this, ResponseBody body, String mediaType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File tempFile = Files.createTempFile("tmp.org.openapitools.client", null, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            Closeable closeable = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
                Closeable closeable2 = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return tempFile;
        }
        String bodyContent = body.string();
        if (((CharSequence)bodyContent).length() == 0) {
            return null;
        }
        if (!(mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null))) {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        Moshi $this$adapter$iv = Serializer.getMoshi();
        boolean $i$f$adapter = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final /* synthetic */ <I, T> ApiResponse<T> request(RequestConfig<I> requestConfig) {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Object object;
        String string2;
        Map<String, String> headers;
        Map.Entry<String, List<String>> element$iv;
        Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl2 = httpUrl;
        Object object2 = new char[]{'/'};
        object2 = httpUrl2.newBuilder().addEncodedPathSegments(StringsKt.trimStart((String)requestConfig.getPath(), (char[])object2));
        Object $this$request_u24lambda_u248 = (HttpUrl.Builder)object2;
        boolean bl42 = false;
        Request.Builder $this$forEach$iv = requestConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object3 = $this$forEach$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Map.Entry<String, List<String>> query = element$iv = object3.next();
            boolean bl22 = false;
            Iterable iterable = query.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : iterable) {
                String queryValue = (String)element$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u248.addQueryParameter(query.getKey(), queryValue);
            }
        }
        HttpUrl url = ((HttpUrl.Builder)object2).build();
        if (requestConfig.getBody() != null && ((object2 = (Object)requestConfig.getHeaders().get(ContentType)) == null || object2.length() == 0)) {
            requestConfig.getHeaders().put(ContentType, JsonMediaType);
        }
        if ((object2 = (Object)requestConfig.getHeaders().get(Accept)) == null || object2.length() == 0) {
            requestConfig.getHeaders().put(Accept, JsonMediaType);
        }
        if (($this$request_u24lambda_u248 = (CharSequence)(headers = requestConfig.getHeaders()).get(Accept)) == null || $this$request_u24lambda_u248.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        if (headers.get(ContentType) != null) {
            String string3 = headers.get(ContentType);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type kotlin.String");
            String bl42 = StringsKt.substringBefore$default((String)string3, (String)";", null, (int)2, null);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = bl42.toLowerCase(locale);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string2 = null;
        }
        String contentType = string2;
        switch (WhenMappings.$EnumSwitchMapping$0[requestConfig.getMethod().ordinal()]) {
            case 1: {
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                RequestBody requestBody;
                ApiClient this_$iv;
                I content$iv;
                object3 = this;
                element$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File file = (File)content$iv;
                    String string5 = contentType;
                    if (string5 == null) {
                        string5 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string5));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder3 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl8 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach3 = false;
                    object = $this$forEach$iv$iv.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry element$iv$iv;
                        entry = element$iv$iv = object.next();
                        boolean bl7 = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + '\"')));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            builder3.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + '\"')));
                        builder3.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder4 = bl22 = new FormBody.Builder(null, 1, null);
                    boolean bl6 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        boolean bl5 = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        builder4.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi2 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string6 = moshi2.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"moshi.adapter(T::class.java).toJson(content)");
                        String string7 = contentType;
                        if (string7 == null) {
                            string7 = JsonMediaType;
                        }
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(string7));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url).head();
                break;
            }
            case 4: {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl5;
                RequestBody requestBody;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File file = (File)content$iv;
                    String string8 = contentType;
                    if (string8 == null) {
                        string8 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string8));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder5 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl3 = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + '\"')));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            builder5.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + '\"')));
                        builder5.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder6 = bl22 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        builder6.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi3 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string9 = moshi3.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"moshi.adapter(T::class.java).toJson(content)");
                        String string10 = contentType;
                        if (string10 == null) {
                            string10 = JsonMediaType;
                        }
                        requestBody = RequestBody.Companion.create(string9, MediaType.Companion.parse(string10));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl5;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File file = (File)content$iv;
                    String string11 = contentType;
                    if (string11 == null) {
                        string11 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string11));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder7 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl3 = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + '\"')));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            builder7.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + '\"')));
                        builder7.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder8 = bl22 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        builder8.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi4 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string12 = moshi4.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"moshi.adapter(T::class.java).toJson(content)");
                        String string13 = contentType;
                        if (string13 == null) {
                            string13 = JsonMediaType;
                        }
                        requestBody = RequestBody.Companion.create(string12, MediaType.Companion.parse(string13));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl5;
                MediaType fileMediaType$iv;
                Map partHeaders$iv;
                PartConfig part$iv;
                String name$iv;
                Map.Entry entry;
                Map $this$forEach$iv$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    File file = (File)content$iv;
                    String string14 = contentType;
                    if (string14 == null) {
                        string14 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string14));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder9 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl3 = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        if (part$iv.getBody() instanceof File) {
                            partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + "\"; filename=\"" + ((File)part$iv.getBody()).getName() + '\"')));
                            fileMediaType$iv = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)part$iv.getBody()));
                            builder9.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create((File)part$iv.getBody(), fileMediaType$iv));
                            continue;
                        }
                        partHeaders$iv = MapsKt.plus((Map)MapsKt.toMutableMap(part$iv.getHeaders()), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name$iv + '\"')));
                        builder9.addPart(Headers.Companion.of(partHeaders$iv), RequestBody.Companion.create(this_$iv.parameterToString(part$iv.getBody()), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder10 = bl22 = new FormBody.Builder(null, 1, null);
                    bl2 = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.openapitools.client.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        entry = element$iv$iv;
                        bl = false;
                        name$iv = (String)entry.getKey();
                        part$iv = (PartConfig)entry.getValue();
                        builder10.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        Moshi moshi5 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String string15 = moshi5.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"moshi.adapter(T::class.java).toJson(content)");
                        String string16 = contentType;
                        if (string16 == null) {
                            string16 = JsonMediaType;
                        }
                        requestBody = RequestBody.Companion.create(string15, MediaType.Companion.parse(string16));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u2410 = $this$forEach$iv = builder;
        boolean bl922 = false;
        Map<String, String> $this$forEach$iv3 = headers;
        boolean $i$f$forEach1122 = false;
        Iterator<Map.Entry<String, String>> bl22 = $this$forEach$iv3.entrySet().iterator();
        while (bl22.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header = entry = bl22.next();
            boolean bl10 = false;
            $this$request_u24lambda_u2410.addHeader(header.getKey(), header.getValue());
        }
        Request request = $this$forEach$iv.build();
        Response response = this.getClient().newCall(request).execute();
        String string17 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string17 != null && (string17 = StringsKt.substringBefore$default((String)string17, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach1122 = string17;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string18 = $i$f$forEach1122.toLowerCase(locale);
            string = string18;
            Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept = string;
        if (response.isRedirect()) {
            apiResponse = new Redirection(response.code(), response.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response)) {
            apiResponse = new Informational(response.message(), response.code(), response.headers().toMultimap());
        } else if (response.isSuccessful()) {
            Object object4;
            ApiClient bl922 = this;
            ResponseBody body$iv = response.body();
            boolean $i$f$responseBody = false;
            if (body$iv == null) {
                object4 = null;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                if (Intrinsics.areEqual(Object.class, File.class)) {
                    File tempFile$iv = Files.createTempFile("tmp.org.openapitools.client", null, new FileAttribute[0]).toFile();
                    tempFile$iv.deleteOnExit();
                    Closeable closeable = body$iv.byteStream();
                    Throwable header = null;
                    try {
                        long l;
                        InputStream inputStream$iv = (InputStream)closeable;
                        boolean bl11 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)tempFile$iv, (String)"tempFile");
                        object = new FileOutputStream(tempFile$iv);
                        Throwable throwable = null;
                        try {
                            FileOutputStream tempFileOutputStream$iv = (FileOutputStream)object;
                            boolean bl12 = false;
                            l = ByteStreamsKt.copyTo$default((InputStream)inputStream$iv, (OutputStream)tempFileOutputStream$iv, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            InlineMarker.finallyStart((int)1);
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            InlineMarker.finallyEnd((int)1);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable) {
                        header = throwable;
                        throw throwable;
                    }
                    finally {
                        InlineMarker.finallyStart((int)1);
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)header);
                        InlineMarker.finallyEnd((int)1);
                    }
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                    object4 = tempFile$iv;
                } else {
                    String bodyContent$iv = body$iv.string();
                    if (((CharSequence)bodyContent$iv).length() == 0) {
                        object4 = null;
                    } else if (accept == null || StringsKt.startsWith$default((String)accept, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept, (String)"json", (boolean)false, (int)2, null)) {
                        Moshi moshi6 = Serializer.getMoshi();
                        boolean $i$f$adapter = false;
                        Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
                        object4 = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi6, null).fromJson(bodyContent$iv);
                    } else {
                        throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                    }
                }
            }
            Map map = response.headers().toMultimap();
            int n = response.code();
            Object object5 = object4;
            apiResponse = new Success<Object>(object5, n, (Map<String, List<String>>)((Map<String, ? extends List<String>>)map));
        } else if (ResponseExtensionsKt.isClientError(response)) {
            ResponseBody responseBody = response.body();
            apiResponse = new ClientError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        } else {
            ResponseBody responseBody = response.body();
            apiResponse = new ServerError(response.message(), responseBody != null ? responseBody.string() : null, response.code(), response.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    protected final String parameterToString(@Nullable Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "";
        } else if (object instanceof Object[]) {
            string = ApiAbstractionsKt.toMultiValue$default((Object[])value, "csv", null, 4, null).toString();
        } else if (object instanceof Iterable) {
            string = ApiAbstractionsKt.toMultiValue$default((Iterable)value, "csv", null, 4, null).toString();
        } else if ((((object instanceof OffsetDateTime ? true : object instanceof OffsetTime) ? true : object instanceof LocalDateTime) ? true : object instanceof LocalDate) ? true : object instanceof LocalTime) {
            ApiClient this_$iv = this;
            boolean $i$f$parseDateToQueryString = false;
            String string2 = Serializer.getMoshi().adapter(Object.class).toJson(value);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moshi.adapter(T::class.java).toJson(value)");
            string = StringsKt.replace$default((String)string2, (String)"\"", (String)"", (boolean)false, (int)4, null);
        } else {
            string = value.toString();
        }
        return string;
    }

    protected final /* synthetic */ <T> String parseDateToQueryString(T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$parseDateToQueryString = false;
        Moshi moshi2 = Serializer.getMoshi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = moshi2.adapter(Object.class).toJson(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi.adapter(T::class.java).toJson(value)");
        return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final OkHttpClient getDefaultClient() {
        return Companion.getDefaultClient();
    }

    @NotNull
    public static final OkHttpClient.Builder getBuilder() {
        return Companion.getBuilder();
    }

    static {
        defaultClient$delegate = LazyKt.lazy((Function0)Companion.defaultClient.2.INSTANCE);
        builder = new OkHttpClient.Builder();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u00020\u00188\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\u001bR!\u0010\u001c\u001a\u00020\u001d8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010 R\u001c\u0010#\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\r\"\u0004\b%\u0010\u000fR\u001c\u0010&\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\r\"\u0004\b(\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/openapitools/client/infrastructure/ApiClient$Companion;", "", "()V", "Accept", "", "Authorization", "ContentType", "FormDataMediaType", "FormUrlEncMediaType", "JsonMediaType", "XmlMediaType", "accessToken", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "apiKey", "", "getApiKey", "()Ljava/util/Map;", "apiKeyPrefix", "getApiKeyPrefix", "baseUrlKey", "builder", "Lokhttp3/OkHttpClient$Builder;", "getBuilder$annotations", "getBuilder", "()Lokhttp3/OkHttpClient$Builder;", "defaultClient", "Lokhttp3/OkHttpClient;", "getDefaultClient$annotations", "getDefaultClient", "()Lokhttp3/OkHttpClient;", "defaultClient$delegate", "Lkotlin/Lazy;", "password", "getPassword", "setPassword", "username", "getUsername", "setUsername", "kotlin-petstore-okhttp4-parameter-tests"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getApiKey() {
            return apiKey;
        }

        @NotNull
        public final Map<String, String> getApiKeyPrefix() {
            return apiKeyPrefix;
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @Nullable
        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            accessToken = string;
        }

        @NotNull
        public final OkHttpClient getDefaultClient() {
            Lazy lazy = defaultClient$delegate;
            return (OkHttpClient)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClient$annotations() {
        }

        @NotNull
        public final OkHttpClient.Builder getBuilder() {
            return builder;
        }

        @JvmStatic
        public static /* synthetic */ void getBuilder$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.OPTIONS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

