let messages = {
    "body": ["大坏蛋！你都多久没理人家了呀，嘤嘤嘤～", "嗨～快来逗我玩吧！", "拿小拳拳锤你胸口！", "不要动手动脚的！快把手拿开~~", "真…真的是不知羞耻！", "Hentai！", "再摸的话我可要报警了！⌇●﹏●⌇", "110吗，这里有个变态一直在摸我(ó﹏ò｡)"]
}

// ============ 简化口型动画 ============
window._mouthValue = 0;
window._speakingTimer = null;

// 开始说话动画（随机口型）
window.startSpeaking = function(duration) {
    window.stopSpeaking();  // 先停止之前的
    
    var elapsed = 0;
    var interval = 80;  // 80ms更新一次
    
    window._speakingTimer = setInterval(function() {
        // 随机口型值，模拟说话
        var value = Math.random() > 0.2 
            ? 0.3 + Math.random() * 0.6   // 80%概率张嘴 (0.3-0.9)
            : Math.random() * 0.2;         // 20%概率闭嘴 (0-0.2)
        
        window.updateMouth(value);
        
        elapsed += interval;
        if (duration && elapsed >= duration) {
            window.stopSpeaking();
        }
    }, interval);
};

// 停止说话动画
window.stopSpeaking = function() {
    if (window._speakingTimer) {
        clearInterval(window._speakingTimer);
        window._speakingTimer = null;
    }
    window.updateMouth(0);  // 闭嘴
};

// 更新嘴巴开合度
window.updateMouth = function(value) {
    window._mouthValue = value;
    
    if (typeof document.setMouthOpenY === 'function') {
        document.setMouthOpenY(value);
    }
};

// 创建说话气泡
window._createSpeakBubble = function() {
    if (document.getElementById('speak-bubble')) return;
    
    var bubble = document.createElement('div');
    bubble.id = 'speak-bubble';
    bubble.style.cssText = `
        position: fixed;
        left: 10px;
        top: 50%;
        transform: translateY(-50%);
        max-width: 200px;
        padding: 12px 16px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 18px;
        border-bottom-left-radius: 4px;
        font-size: 14px;
        line-height: 1.5;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        opacity: 0;
        transition: opacity 0.3s ease;
        z-index: 9999;
        font-family: 'Microsoft YaHei', sans-serif;
        word-wrap: break-word;
        pointer-events: none;
    `;
    document.body.appendChild(bubble);
};

// 显示说话气泡
window.showSpeakBubble = function(text, duration) {
    window._createSpeakBubble();
    var bubble = document.getElementById('speak-bubble');
    if (!bubble) return;
    
    bubble.textContent = text;
    bubble.style.opacity = '1';
    
    // 清除之前的定时器
    if (window._bubbleTimer) {
        clearTimeout(window._bubbleTimer);
    }
    
    // 设置自动隐藏
    duration = duration || (text.length * 150 + 2000); // 根据文字长度动态计算
    window._bubbleTimer = setTimeout(function() {
        bubble.style.opacity = '0';
    }, duration);
};

// ============ 动作控制接口 ============

// 切换到下一个场景/模型
window.nextScene = function() {
    if (typeof document.nextScene === 'function') {
        document.nextScene();
        showMessage('换个造型~', 1500);
    }
}

// 模拟点击触发随机动作
window.triggerRandomMotion = function() {
    var canvas = document.getElementById('live2d');
    if (canvas) {
        // 随机点击不同位置触发不同动作
        var positions = [
            { x: 0.5, y: 0.3 },  // 头部
            { x: 0.5, y: 0.6 },  // 身体
            { x: 0.3, y: 0.5 },  // 左侧
            { x: 0.7, y: 0.5 },  // 右侧
        ];
        var pos = positions[Math.floor(Math.random() * positions.length)];
        var event = new MouseEvent('click', {
            bubbles: true,
            cancelable: true,
            clientX: canvas.width * pos.x,
            clientY: canvas.height * pos.y
        });
        canvas.dispatchEvent(event);
    }
}

// ============ 摇摆动画效果 ============
window._swingInterval = null;
window._swingAngle = 0;

window.startSwing = function() {
    var landlord = document.getElementById('landlord');
    if (!landlord) return;
    
    if (window._swingInterval) clearInterval(window._swingInterval);
    
    window._swingInterval = setInterval(function() {
        window._swingAngle += 0.15;
        var swing = Math.sin(window._swingAngle) * 3;  // 左右摇摆 ±3度
        var bounce = Math.abs(Math.sin(window._swingAngle * 2)) * 5;  // 上下弹跳
        landlord.style.transform = 'rotate(' + swing + 'deg) translateY(' + (-bounce) + 'px)';
    }, 50);
}

window.stopSwing = function() {
    if (window._swingInterval) {
        clearInterval(window._swingInterval);
        window._swingInterval = null;
    }
    var landlord = document.getElementById('landlord');
    if (landlord) {
        landlord.style.transform = '';
    }
}

// ============ 自动循环跳舞（增强版） ============
window._autoDanceInterval = null;
window.startAutoDance = function(interval) {
    interval = interval || 3000; // 缩短到3秒
    if (window._autoDanceInterval) {
        clearInterval(window._autoDanceInterval);
    }
    // 开始摇摆
    window.startSwing();
    // 定时触发动作
    window._autoDanceInterval = setInterval(function() {
        window.triggerRandomMotion();
    }, interval);
    showMessage('开始跳舞啦~🎵💃', 2000);
}

window.stopAutoDance = function() {
    if (window._autoDanceInterval) {
        clearInterval(window._autoDanceInterval);
        window._autoDanceInterval = null;
    }
    window.stopSwing();
    showMessage('休息一下~', 1500);
}

// 是否正在自动跳舞
window.isAutoDancing = function() {
    return window._autoDanceInterval !== null;
}

// ============ 原有代码 ============


remind = (function () {
    console.log('1111')
    let text;
    var now = new Date().getHours()
    console.log(now)
    if (now > 23 || now <= 5) {
        text = '你是夜猫子呀？这么晚还不睡觉，明天起的来嘛？';
    } else if (now > 5 && now <= 7) {
        text = '早上好！一日之计在于晨，美好的一天就要开始了！';
    } else if (now > 7 && now <= 11) {
        text = '上午好！工作顺利嘛，不要久坐，多起来走动走动哦！';
    } else if (now > 11 && now <= 14) {
        text = '中午了，工作了一个上午，现在是午餐时间！';
    } else if (now > 14 && now <= 17) {
        text = '午后很容易犯困呢，今天的运动目标完成了吗？';
    } else if (now > 17 && now <= 19) {
        text = '傍晚了！窗外夕阳的景色很美丽呢，最美不过夕阳红~~';
    } else if (now > 19 && now <= 21) {
        text = '晚上好，今天过得怎么样？';
    } else if (now > 21 && now <= 23) {
        text = '已经这么晚了呀，早点休息吧，晚安~~';
    } else {
        text = '嗨~ 快来逗我玩吧！';
    }
    showMessage(text, 2000)
});

// 绑定默认事件
window.bindDefaultEvent = () => {
    window.time = window.setInterval(remind, 1800000);
    document.touchHeadHandler = () => {
        showMessage('嗯嗯~~~', 2000)
    }
    document.touchBodyHandler = () => {
        const msg = messages.body[Math.floor(Math.random() * messages.body.length)];
        showMessage(msg, 800)
    }
}
// 绑定配置事件
window.bindConfigEvent = (config) => {
    // 绑定可选按钮事件
    if (config.warmReminder) {
        window.time = window.setInterval(remind, 1800000);
    }
    for (let i = 1; i <= 3; i++) {
        console.log('绑定', i);
        if (config[`btn${i}`] && config[`btn${i}`].trigger && config[`btn${i}`].icon) {
            console.log('绑定可选按钮事件', i);
            $(`#option${i} span`).html(config[`btn${i}`].icon)
            $(`#option${i}`).show()
            $(`#option${i}`).click(() => {
                const data = {
                    type: 'notice',
                    trigger: config[`btn${i}`].trigger,
                    code: window.code
                }
                window.ws.send(JSON.stringify(data))
            })
        }
    }
    if (config['header'] && config['header'].trigger) {
        document.touchHeadHandler = () => {
            const data = {
                type: 'notice',
                trigger: config['header'].trigger,
                code: window.code
            }
            window.ws.send(JSON.stringify(data))
        }
    } else {
        document.touchHeadHandler = () => {
            showMessage('嗯嗯~~~', 2000)
        }

    }
    if (config['body'] && config['body'].trigger) {
        document.touchBodyHandler = () => {
            let data = {
                type: 'notice',
                trigger: config['body'].trigger,
                code: window.code
            }
            window.ws.send(JSON.stringify(data))
        }
    } else {
        document.touchBodyHandler = () => {
            const msg = messages.body[Math.floor(Math.random() * messages.body.length)];
            showMessage(msg, 800)
        }
    }
}
/**
 * 显示消息框
 * @param text 文本
 * @param timeout
 */
function showMessage(text, timeout) {
    if (Array.isArray(text)) text = text[Math.floor(Math.random() * text.length + 1) - 1];
    //console.log('showMessage', text);
    $('.message').stop();
    $('.message').html(text).fadeTo(200, 1);
    if (timeout === null) timeout = 5000;
    hideMessage(timeout);
}

/**
 * 隐藏消息框
 * @param timeout
 */
function hideMessage(timeout) {
    $('.message').stop().css('opacity', 1);
    if (timeout === null) timeout = 5000;
    $('.message').delay(timeout).fadeTo(200, 0);
}
// 设置宽度
window.adjustSize = (width, height) => {
    $("#landlord").height(height).width(width)
    document.getElementById("live2d").width = width;
    document.getElementById("live2d").height = height;
}
adjustSize(900, 1040)

// 信息框
window.receiveMsg = (msg, duration = 2000) => {
    showMessage(msg, duration)
}