# -*- coding: utf-8 -*-
"""
Seed-VC 测试脚本
"""

import asyncio
from pathlib import Path


async def generate_test_audio():
    """生成测试音频"""
    import edge_tts
    
    cache_dir = Path(__file__).parent.parent.parent / "cache"
    cache_dir.mkdir(exist_ok=True)
    
    # 男声
    source_path = cache_dir / "seed_test_source.wav"
    if not source_path.exists():
        text = "大家好，我是一个男性声音，现在我们来测试Seed-VC的变声效果。"
        communicate = edge_tts.Communicate(text, "zh-CN-YunxiNeural")
        await communicate.save(str(source_path))
        print(f"✅ 生成男声: {source_path}")
    
    # 女声参考
    reference_path = cache_dir / "seed_test_reference.wav"
    if not reference_path.exists():
        text = "这是一段甜美的女声参考音频，声音要清晰自然。"
        communicate = edge_tts.Communicate(text, "zh-CN-XiaoyiNeural")
        await communicate.save(str(reference_path))
        print(f"✅ 生成女声参考: {reference_path}")
    
    return str(source_path), str(reference_path)


def test_convert():
    """测试语音转换"""
    from . import SeedVCInfer
    
    # 生成测试音频
    source_path, reference_path = asyncio.run(generate_test_audio())
    
    # 输出路径
    output_dir = Path(__file__).parent.parent.parent / "cache"
    output_path = output_dir / "seed_test_output.wav"
    
    # 创建推理器
    infer = SeedVCInfer(diffusion_steps=25)
    
    # 执行转换
    success = infer.convert_simple(
        source_path=source_path,
        reference_path=reference_path,
        output_path=str(output_path),
        semi_tone_shift=0
    )
    
    if success:
        print(f"\n✅ 测试完成!")
        print(f"📁 输出: {output_path}")
    else:
        print(f"\n❌ 测试失败")


if __name__ == "__main__":
    test_convert()
