# -*- coding: utf-8 -*-
"""
弹幕获取基类
定义统一的接口
"""

from abc import ABC, abstractmethod
from typing import Callable, Optional
import asyncio

from src.utils.events import EventEmitter, Event


class BaseDanmakuClient(ABC):
    """弹幕客户端基类"""
    
    def __init__(self, room_id: str):
        self.room_id = room_id
        self.is_connected = False
        self._event_emitter = EventEmitter()
        self._running = False
    
    @abstractmethod
    async def connect(self) -> bool:
        """连接到直播间"""
        pass
    
    @abstractmethod
    async def disconnect(self) -> None:
        """断开连接"""
        pass
    
    @abstractmethod
    async def start(self) -> None:
        """开始监听弹幕"""
        pass
    
    def on(self, event_type, callback: Callable) -> None:
        """注册事件监听器"""
        self._event_emitter.on(event_type, callback)
    
    def off(self, event_type, callback: Callable) -> None:
        """移除事件监听器"""
        self._event_emitter.off(event_type, callback)
    
    async def emit(self, event: Event) -> None:
        """触发事件"""
        await self._event_emitter.emit_async(event)
    
    @property
    def event_emitter(self) -> EventEmitter:
        """获取事件发射器"""
        return self._event_emitter
