# -*- coding: utf-8 -*-
"""
核心模块
包含插件管理器和更新检查器
"""

from .plugin_manager import PluginManager, PluginInfo, PluginStatus, get_plugin_manager
from .update_checker import UpdateChecker, UpdateInfo, UpdateStatus, get_update_checker
from .update_server import UpdateServerAPI, UpdateConfig, generate_static_update_files
from .module_loader import ModuleLoader, ModuleInfo, get_module_loader, load_module, reload_module
from .auto_updater import AutoUpdater, AutoUpdateConfig, get_auto_updater, check_for_updates_on_startup

__all__ = [
    'PluginManager',
    'PluginInfo', 
    'PluginStatus',
    'get_plugin_manager',
    'UpdateChecker',
    'UpdateInfo',
    'UpdateStatus',
    'get_update_checker',
    'UpdateServerAPI',
    'UpdateConfig',
    'generate_static_update_files',
    'ModuleLoader',
    'ModuleInfo',
    'get_module_loader',
    'load_module',
    'reload_module',
    'AutoUpdater',
    'AutoUpdateConfig',
    'get_auto_updater',
    'check_for_updates_on_startup',
]
