# -*- coding: utf-8 -*-
"""
梧桐抖音运营伴侣 - Flet UI 入口
"""

import sys
import os
import warnings
import ctypes
from pathlib import Path

# 抑制警告信息
warnings.filterwarnings("ignore")
os.environ["PYGAME_HIDE_SUPPORT_PROMPT"] = "1"


def is_admin():
    """检查是否以管理员身份运行"""
    try:
        return ctypes.windll.shell32.IsUserAnAdmin()
    except:
        return False


def run_as_admin():
    """以管理员身份重新运行"""
    if sys.platform == 'win32':
        try:
            # 获取当前脚本路径
            if getattr(sys, 'frozen', False):
                # 打包后的 exe
                script = sys.executable
                params = ' '.join(sys.argv[1:])
            else:
                # 开发环境
                script = sys.executable
                params = f'"{__file__}"'
                if len(sys.argv) > 1:
                    params += ' ' + ' '.join(sys.argv[1:])
            
            # 请求管理员权限运行
            ret = ctypes.windll.shell32.ShellExecuteW(
                None, "runas", script, params, None, 1
            )
            # 返回值 > 32 表示成功
            return ret > 32
        except Exception as e:
            print(f"请求管理员权限失败: {e}")
            return False
    return False


def check_admin_permission():
    """检查并请求管理员权限"""
    if sys.platform == 'win32' and not is_admin():
        # 尝试以管理员身份重新运行
        if run_as_admin():
            sys.exit(0)  # 成功启动新进程，退出当前进程
        else:
            # 用户拒绝或失败，退出程序
            ctypes.windll.user32.MessageBoxW(
                0, 
                "本程序需要管理员权限才能运行。\n请右键点击程序，选择【以管理员身份运行】。", 
                "需要管理员权限", 
                0x10  # MB_ICONERROR
            )
            sys.exit(1)


# 添加项目路径
ROOT_DIR = Path(__file__).parent.parent
if getattr(sys, 'frozen', False):
    ROOT_DIR = Path(sys._MEIPASS)
sys.path.insert(0, str(ROOT_DIR))

import flet as ft

# Flet兼容层 - 支持0.21.x和0.28.x双向兼容
# 新版 flet 使用大写 Icons/Colors，旧版使用小写 icons/colors
if not hasattr(ft, 'Icons') and hasattr(ft, 'icons'):
    ft.Icons = ft.icons
if not hasattr(ft, 'Colors') and hasattr(ft, 'colors'):
    ft.Colors = ft.colors
# 反向兼容：新版 flet 添加小写别名
if not hasattr(ft, 'icons') and hasattr(ft, 'Icons'):
    ft.icons = ft.Icons
if not hasattr(ft, 'colors') and hasattr(ft, 'Colors'):
    ft.colors = ft.Colors

from gui.flet_app.main import main


if __name__ == "__main__":
    # 检查管理员权限 - 自动开播需要管理员权限才能控制鼠标
    check_admin_permission()
    
    # 抑制退出时的异步错误
    import asyncio
    import atexit
    
    def cleanup():
        try:
            loop = asyncio.get_event_loop()
            if loop.is_running():
                loop.stop()
        except:
            pass
    
    atexit.register(cleanup)
    
    try:
        ft.app(target=main)
    except Exception as e:
        import traceback
        traceback.print_exc()
        input("Press Enter to exit...")