/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.io.BufferOutputStream;
import org.smartboot.http.common.utils.Constant;
import org.smartboot.http.server.impl.AbstractResponse;
import org.smartboot.http.server.impl.CommonRequest;

abstract class AbstractOutputStream
extends BufferOutputStream {
    protected final AbstractResponse response;
    protected final CommonRequest request;

    public AbstractOutputStream(CommonRequest request, AbstractResponse response) {
        super(request.getAioSession().writeBuffer());
        this.response = response;
        this.request = request;
    }

    protected void writeHeader(BufferOutputStream.HeaderWriteSource source) throws IOException {
        if (this.committed) {
            return;
        }
        this.convertCookieToHeader();
        boolean hasHeader = this.hasHeader();
        this.writeHeadPart(hasHeader);
        if (hasHeader) {
            this.writeHeaders();
        }
        this.committed = true;
    }

    protected abstract void writeHeadPart(boolean var1) throws IOException;

    protected void convertCookieToHeader() {
        List<Cookie> cookies = this.response.getCookies();
        if (cookies.size() > 0) {
            cookies.forEach(cookie -> this.response.addHeader(HeaderNameEnum.SET_COOKIE.getName(), cookie.toString()));
        }
    }

    protected boolean hasHeader() {
        return this.response.getHeaders().size() > 0;
    }

    private void writeHeaders() throws IOException {
        for (Map.Entry<String, HeaderValue> entry : this.response.getHeaders().entrySet()) {
            for (HeaderValue headerValue = entry.getValue(); headerValue != null; headerValue = headerValue.getNextValue()) {
                this.writeString(entry.getKey());
                this.writeBuffer.writeByte((byte)58);
                this.writeString(headerValue.getValue());
                this.writeBuffer.write(Constant.CRLF_BYTES);
            }
        }
        this.writeBuffer.write(Constant.CRLF_BYTES);
    }
}

