/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyueyi.quick.transfer.dictionary;

import com.github.liuyueyi.quick.transfer.Trie;
import com.github.liuyueyi.quick.transfer.dictionary.BasicDictionary;
import com.github.liuyueyi.quick.transfer.dictionary.SecondParserDictionary;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;

public class DictionaryFactory {
    public static final String EMPTY = "";
    public static final String SHARP = "#";
    public static final String EQUAL = "=";

    private static String[] split(String content, String split) {
        int index = content.indexOf(split);
        if (index < 0) {
            return new String[]{content};
        }
        return new String[]{content.substring(0, index), content.substring(index + 1)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicDictionary loadDictionary(String mappingFile, boolean reverse) {
        HashMap<Character, Character> charMap = new HashMap<Character, Character>(8192);
        Trie<String> dict = new Trie<String>();
        int maxLen = 2;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(Objects.requireNonNull(DictionaryFactory.class.getClassLoader().getResourceAsStream(mappingFile))), StandardCharsets.UTF_8));
            String line = null;
            while (null != (line = in.readLine())) {
                String[] pair;
                if (line.isEmpty() || line.startsWith(SHARP) || (pair = DictionaryFactory.split(line, EQUAL)).length < 2) continue;
                if (reverse) {
                    if (pair[0].length() == 1 && pair[1].length() == 1) {
                        charMap.put(Character.valueOf(pair[1].charAt(0)), Character.valueOf(pair[0].charAt(0)));
                        continue;
                    }
                    maxLen = Math.max(pair[0].length(), maxLen);
                    dict.add(pair[1], pair[0]);
                    continue;
                }
                if (pair[0].length() == 1 && pair[1].length() == 1) {
                    charMap.put(Character.valueOf(pair[0].charAt(0)), Character.valueOf(pair[1].charAt(0)));
                    continue;
                }
                maxLen = Math.max(pair[0].length(), maxLen);
                dict.add(pair[0], pair[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new BasicDictionary(mappingFile, charMap, dict, maxLen);
    }

    public static SecondParserDictionary loadSecondDictionary(BasicDictionary parent, String mappingFile, boolean reverse) {
        BasicDictionary current = DictionaryFactory.loadDictionary(mappingFile, reverse);
        return new SecondParserDictionary(mappingFile, parent, current.getChars(), current.getDict(), current.getMaxLen(), reverse);
    }
}

