/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyueyi.quick.transfer.dictionary;

import com.github.liuyueyi.quick.transfer.constants.TransType;
import com.github.liuyueyi.quick.transfer.dictionary.BasicDictionary;
import com.github.liuyueyi.quick.transfer.dictionary.DictionaryFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DictionaryContainer {
    private static volatile DictionaryContainer instance;
    private final Map<String, BasicDictionary> dictionaryMap = new HashMap<String, BasicDictionary>(8, 1.0f);
    private Map<String, Set<String>> selfExcludeWords = new HashMap<String, Set<String>>(16);

    private DictionaryContainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DictionaryContainer getInstance() {
        if (instance != null) return instance;
        Class<DictionaryContainer> clazz = DictionaryContainer.class;
        synchronized (DictionaryContainer.class) {
            if (instance != null) return instance;
            instance = new DictionaryContainer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Deprecated
    public BasicDictionary getDictionary(String key) {
        return this.getDictionary(TransType.typeOf(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicDictionary getDictionary(TransType transType) {
        BasicDictionary dictionary = this.dictionaryMap.get(transType.getType());
        if (dictionary != null) {
            return dictionary;
        }
        DictionaryContainer dictionaryContainer = this;
        synchronized (dictionaryContainer) {
            dictionary = this.dictionaryMap.get(transType.getType());
            if (dictionary != null) {
                return dictionary;
            }
            switch (transType) {
                case SIMPLE_TO_TRADITIONAL: {
                    dictionary = DictionaryFactory.loadDictionary("tc/s2t.txt", false);
                    break;
                }
                case SIMPLE_TO_HONGKONG: {
                    dictionary = DictionaryFactory.loadSecondDictionary(this.getDictionary(TransType.SIMPLE_TO_TRADITIONAL), "tc/t2hk.txt", false);
                    break;
                }
                case SIMPLE_TO_TAIWAN: {
                    dictionary = DictionaryFactory.loadSecondDictionary(this.getDictionary(TransType.SIMPLE_TO_TRADITIONAL), "tc/t2tw.txt", false);
                    break;
                }
                case TRADITIONAL_TO_SIMPLE: {
                    dictionary = DictionaryFactory.loadDictionary("tc/t2s.txt", false);
                    break;
                }
                case HONGKONG_TO_SIMPLE: {
                    dictionary = DictionaryFactory.loadSecondDictionary(this.getDictionary(TransType.TRADITIONAL_TO_SIMPLE), "tc/t2hk.txt", true);
                    break;
                }
                case TAIWAN_TO_SIMPLE: {
                    dictionary = DictionaryFactory.loadSecondDictionary(this.getDictionary(TransType.TRADITIONAL_TO_SIMPLE), "tc/t2tw.txt", true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u8f6c\u5316\u65b9\u5f0f" + (Object)((Object)transType));
                }
            }
            this.dictionaryMap.put(transType.getType(), dictionary);
        }
        this.doLoadGlobalSelfExcludeWords((Collection<String>)this.selfExcludeWords.get("g"));
        this.doLoadSelfExcludeWords(transType, (Collection<String>)this.selfExcludeWords.get(transType.getType()));
        return dictionary;
    }

    public void unloadDictionary(TransType transType) {
        this.dictionaryMap.remove(transType.getType());
    }

    public void loadExcludeDict(TransType transType, Collection<String> dict) {
        String key = transType == null ? "g" : transType.getType();
        Set old = this.selfExcludeWords.computeIfAbsent(key, k -> new HashSet());
        old.addAll(dict);
        if (transType == null) {
            this.doLoadGlobalSelfExcludeWords(dict);
        } else {
            this.doLoadSelfExcludeWords(transType, dict);
        }
    }

    private void doLoadGlobalSelfExcludeWords(Collection<String> selfExcludeWords) {
        if (selfExcludeWords == null || selfExcludeWords.isEmpty()) {
            return;
        }
        for (String word : selfExcludeWords) {
            for (BasicDictionary dictionary : this.dictionaryMap.values()) {
                dictionary.remove(word);
            }
        }
    }

    private void doLoadSelfExcludeWords(TransType transType, Collection<String> selfExcludeWords) {
        if (selfExcludeWords == null || selfExcludeWords.isEmpty()) {
            return;
        }
        BasicDictionary dictionary = this.dictionaryMap.get(transType.getType());
        if (dictionary == null) {
            return;
        }
        for (String word : selfExcludeWords) {
            dictionary.remove(word);
        }
    }
}

