/*
 * Decompiled with CFR 0.152.
 */
package com.github.liuyueyi.quick.transfer.dictionary;

import com.github.liuyueyi.quick.transfer.Trie;
import com.github.liuyueyi.quick.transfer.TrieNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class BasicDictionary {
    protected String name;
    protected Map<Character, Character> charMap = null;
    protected Trie<String> dict = null;
    private int maxLen = 2;

    public Map<Character, Character> getChars() {
        return this.charMap;
    }

    public Trie<String> getDict() {
        return this.dict;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public BasicDictionary(String name, Map<Character, Character> chars, Trie<String> dict, int maxLen) {
        this.name = name;
        this.charMap = chars;
        this.dict = dict;
        this.maxLen = maxLen;
    }

    public char convert(char ch) {
        Character tmp = this.charMap.get(Character.valueOf(ch));
        if (tmp == null) {
            return ch;
        }
        return tmp.charValue();
    }

    public void convert(Reader reader, Writer writer) throws IOException {
        PushbackReader in = new PushbackReader(new BufferedReader(reader), this.maxLen);
        char[] buf = new char[this.maxLen];
        int len = -1;
        while ((len = in.read(buf)) != -1) {
            TrieNode<String> node = this.dict.bestMatch(buf, 0, len);
            if (node != null) {
                int offset = node.getLevel();
                writer.write(node.getValue());
                in.unread(buf, offset, len - offset);
                continue;
            }
            in.unread(buf, 0, len);
            char ch = (char)in.read();
            writer.write(this.convert(ch));
        }
    }

    public String convert(String str) {
        String ret = str;
        StringReader in = new StringReader(str);
        StringWriter out = new StringWriter();
        try {
            this.convert(in, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ret = ((Object)out).toString();
        return ret;
    }

    public void remove(String key) {
        if (key.length() == 1) {
            this.charMap.remove(Character.valueOf(key.charAt(0)));
        } else {
            this.dict.add(key, key);
        }
    }

    public void add(String key, String value) {
        if (key.length() == 1 && value.length() == 1) {
            this.charMap.put(Character.valueOf(key.charAt(0)), Character.valueOf(value.charAt(0)));
        } else {
            this.dict.add(key, value);
        }
    }
}

