/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.websocket;

import java.nio.charset.StandardCharsets;
import org.smartboot.http.common.utils.StringUtils;

public class CloseReason {
    public static final int NORMAL_CLOSURE = 1000;
    public static final int GOING_AWAY = 1001;
    public static final int WRONG_CODE = 1002;
    public static final int PROTOCOL_ERROR = 1003;
    public static final int MSG_CONTAINS_INVALID_DATA = 1007;
    public static final int MSG_VIOLATES_POLICY = 1008;
    public static final int MSG_TOO_BIG = 1009;
    public static final int MISSING_EXTENSIONS = 1010;
    public static final int UNEXPECTED_ERROR = 1011;
    private final int code;
    private final String reason;

    public CloseReason(int code, String reason) {
        this.code = code;
        this.reason = reason;
    }

    public CloseReason(byte[] payload) {
        if (payload.length == 0) {
            this.code = 1000;
            this.reason = "";
        } else {
            this.code = (payload[0] & 0xFF) << 8 | payload[1] & 0xFF;
            this.reason = payload.length > 2 ? new String(payload, 2, payload.length - 2, StandardCharsets.UTF_8) : "";
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public byte[] toBytes() {
        byte[] payload;
        if (StringUtils.isBlank(this.reason)) {
            payload = new byte[]{(byte)(this.code >>> 8 & 0xFF), (byte)(this.code & 0xFF)};
        } else {
            byte[] data = this.reason.getBytes(StandardCharsets.UTF_8);
            payload = new byte[data.length + 2];
            payload[0] = (byte)(this.code >>> 8 & 0xFF);
            payload[1] = (byte)(this.code & 0xFF);
            System.arraycopy(data, 0, payload, 2, data.length);
        }
        return payload;
    }
}

