/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.VirtualBuffer;

public final class WriteBuffer
extends OutputStream {
    private final VirtualBuffer[] items;
    private final BufferPage bufferPage;
    private final Consumer<VirtualBuffer> writeConsumer;
    private final int chunkSize;
    private int takeIndex;
    private int putIndex;
    private int count;
    private VirtualBuffer writeInBuf;
    private boolean closed = false;
    private byte[] cacheByte;
    private final Semaphore semaphore = new Semaphore(1);
    private Consumer<WriteBuffer> completionConsumer;

    WriteBuffer(BufferPage bufferPage, Consumer<VirtualBuffer> writeConsumer, int chunkSize, int capacity) {
        this.bufferPage = bufferPage;
        this.writeConsumer = writeConsumer;
        this.items = new VirtualBuffer[capacity];
        this.chunkSize = chunkSize;
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    public void writeShort(short v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[1] = (byte)(v & 0xFF);
        this.write(this.cacheByte, 0, 2);
    }

    public synchronized void writeByte(byte b) {
        if (this.writeInBuf == null) {
            this.writeInBuf = this.bufferPage.allocate(this.chunkSize);
        }
        this.writeInBuf.buffer().put(b);
        this.flushWriteBuffer(false);
    }

    private void flushWriteBuffer(boolean forceFlush) {
        if (!forceFlush && this.writeInBuf.buffer().hasRemaining()) {
            return;
        }
        this.writeInBuf.buffer().flip();
        VirtualBuffer virtualBuffer = this.writeInBuf;
        this.writeInBuf = null;
        if (this.count == 0 && this.semaphore.tryAcquire()) {
            this.writeConsumer.accept(virtualBuffer);
            return;
        }
        try {
            while (this.count == this.items.length) {
                this.wait();
                if (!this.closed) continue;
                virtualBuffer.clean();
                return;
            }
            this.items[this.putIndex] = virtualBuffer;
            if (++this.putIndex == this.items.length) {
                this.putIndex = 0;
            }
            ++this.count;
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            this.flush();
        }
    }

    public void writeInt(int v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 24 & 0xFF);
        this.cacheByte[1] = (byte)(v >>> 16 & 0xFF);
        this.cacheByte[2] = (byte)(v >>> 8 & 0xFF);
        this.cacheByte[3] = (byte)(v & 0xFF);
        this.write(this.cacheByte, 0, 4);
    }

    public void writeLong(long v) throws IOException {
        this.initCacheBytes();
        this.cacheByte[0] = (byte)(v >>> 56 & 0xFFL);
        this.cacheByte[1] = (byte)(v >>> 48 & 0xFFL);
        this.cacheByte[2] = (byte)(v >>> 40 & 0xFFL);
        this.cacheByte[3] = (byte)(v >>> 32 & 0xFFL);
        this.cacheByte[4] = (byte)(v >>> 24 & 0xFFL);
        this.cacheByte[5] = (byte)(v >>> 16 & 0xFFL);
        this.cacheByte[6] = (byte)(v >>> 8 & 0xFFL);
        this.cacheByte[7] = (byte)(v & 0xFFL);
        this.write(this.cacheByte, 0, 8);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.writeInBuf == null) {
            int m;
            this.writeInBuf = this.chunkSize >= len ? this.bufferPage.allocate(this.chunkSize) : this.bufferPage.allocate((m = len % this.chunkSize) == 0 ? len : len + this.chunkSize - m);
        }
        ByteBuffer writeBuffer = this.writeInBuf.buffer();
        if (this.closed) {
            this.writeInBuf.clean();
            this.writeInBuf = null;
            throw new IOException("writeBuffer has closed");
        }
        int remaining = writeBuffer.remaining();
        if (remaining > len) {
            writeBuffer.put(b, off, len);
        } else {
            writeBuffer.put(b, off, remaining);
            this.flushWriteBuffer(true);
            if (len > remaining) {
                this.write(b, off + remaining, len - remaining);
            }
        }
    }

    public synchronized void write(byte[] bytes, int offset, int len, Consumer<WriteBuffer> consumer) throws IOException {
        if (this.completionConsumer != null) {
            throw new WritePendingException();
        }
        this.completionConsumer = consumer;
        this.write(bytes, offset, len);
        this.flush();
    }

    public synchronized void write(byte[] bytes, Consumer<WriteBuffer> consumer) throws IOException {
        this.write(bytes, 0, bytes.length, consumer);
    }

    public synchronized void transferFrom(ByteBuffer byteBuffer, Consumer<WriteBuffer> consumer) throws IOException {
        if (!byteBuffer.hasRemaining()) {
            throw new IllegalStateException("none remaining byteBuffer");
        }
        if (this.writeInBuf != null && this.writeInBuf.buffer().position() > 0) {
            this.flushWriteBuffer(true);
        }
        if (this.completionConsumer != null) {
            throw new WritePendingException();
        }
        if (this.writeInBuf != null && this.writeInBuf.buffer().position() > 0) {
            throw new IllegalStateException();
        }
        this.completionConsumer = consumer;
        VirtualBuffer wrap = VirtualBuffer.wrap(byteBuffer);
        if (this.count == 0 && this.semaphore.tryAcquire()) {
            this.writeConsumer.accept(wrap);
            return;
        }
        try {
            while (this.count == this.items.length) {
                this.wait();
                if (!this.closed) continue;
                return;
            }
            this.items[this.putIndex] = wrap;
            if (++this.putIndex == this.items.length) {
                this.putIndex = 0;
            }
            ++this.count;
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            this.flush();
        }
    }

    private void initCacheBytes() {
        if (this.cacheByte == null) {
            this.cacheByte = new byte[8];
        }
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new RuntimeException("OutputStream has closed");
        }
        if (this.semaphore.tryAcquire()) {
            VirtualBuffer virtualBuffer = this.poll();
            if (virtualBuffer == null) {
                this.semaphore.release();
            } else {
                this.writeConsumer.accept(virtualBuffer);
            }
        }
    }

    @Override
    public synchronized void close() {
        VirtualBuffer byteBuf;
        if (this.closed) {
            return;
        }
        this.flush();
        this.closed = true;
        if (this.writeInBuf != null) {
            this.writeInBuf.clean();
            this.writeInBuf = null;
        }
        while ((byteBuf = this.poll()) != null) {
            byteBuf.clean();
        }
    }

    boolean isEmpty() {
        return this.count == 0 && (this.writeInBuf == null || this.writeInBuf.buffer().position() == 0);
    }

    void finishWrite() {
        this.semaphore.release();
    }

    private VirtualBuffer pollItem() {
        if (this.count == 0) {
            return null;
        }
        VirtualBuffer x = this.items[this.takeIndex];
        this.items[this.takeIndex] = null;
        if (++this.takeIndex == this.items.length) {
            this.takeIndex = 0;
        }
        if (this.count-- == this.items.length) {
            this.notifyAll();
        }
        return x;
    }

    synchronized VirtualBuffer poll() {
        VirtualBuffer item = this.pollItem();
        if (item != null) {
            return item;
        }
        if (this.writeInBuf != null && this.writeInBuf.buffer().position() > 0) {
            this.writeInBuf.buffer().flip();
            VirtualBuffer buffer = this.writeInBuf;
            this.writeInBuf = null;
            return buffer;
        }
        if (this.completionConsumer != null) {
            Consumer<WriteBuffer> consumer = this.completionConsumer;
            this.completionConsumer = null;
            consumer.accept(this);
        }
        return null;
    }
}

