/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl.factory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.smartboot.socket.extension.ssl.factory.SSLContextFactory;

public class PemServerSSLContextFactory
implements SSLContextFactory {
    private List<byte[]> certificates = new ArrayList<byte[]>();
    private byte[] keyBytes;

    public PemServerSSLContextFactory(InputStream fullPem) throws IOException {
        this.readPem(fullPem);
    }

    public PemServerSSLContextFactory(InputStream certPem, InputStream keyPem) throws IOException {
        this.readPem(certPem);
        this.readPem(keyPem);
    }

    @Override
    public SSLContext create() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate[] chain = new Certificate[this.certificates.size()];
        for (int i = 0; i < this.certificates.size(); ++i) {
            chain[i] = cf.generateCertificate(new ByteArrayInputStream(this.certificates.get(i)));
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(this.keyBytes);
        PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("keyAlias", privateKey, new char[0], chain);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(ks, "".toCharArray());
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
        this.certificates = null;
        this.keyBytes = null;
        return sslContext;
    }

    private void readPem(InputStream inputStream) throws IOException {
        String line;
        InputStreamReader reader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        block11: while ((line = bufferedReader.readLine()) != null) {
            switch (line) {
                case "-----BEGIN CERTIFICATE-----": 
                case "-----BEGIN PRIVATE KEY-----": {
                    sb.setLength(0);
                    continue block11;
                }
                case "-----END CERTIFICATE-----": {
                    this.certificates.add(Base64.getDecoder().decode(sb.toString()));
                    continue block11;
                }
                case "-----END PRIVATE KEY-----": {
                    this.keyBytes = Base64.getDecoder().decode(sb.toString());
                    continue block11;
                }
            }
            sb.append(line);
        }
    }
}

