/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.rss;

import book.model.RssArticle;
import book.webBook.DebugLog;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002R\u000e\u0010\u0011\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lbook/webBook/rss/RssParserDefault;", "", "<init>", "()V", "parseXML", "Lkotlin/Pair;", "", "Lbook/model/RssArticle;", "", "sortName", "xml", "sourceUrl", "userid", "debugLogger", "Lbook/webBook/DebugLog;", "getImageUrl", "input", "RSS_ITEM", "RSS_ITEM_TITLE", "RSS_ITEM_LINK", "RSS_ITEM_CATEGORY", "RSS_ITEM_THUMBNAIL", "RSS_ITEM_ENCLOSURE", "RSS_ITEM_DESCRIPTION", "RSS_ITEM_CONTENT", "RSS_ITEM_PUB_DATE", "RSS_ITEM_TIME", "RSS_ITEM_URL", "RSS_ITEM_TYPE", "book"})
public final class RssParserDefault {
    @NotNull
    public static final RssParserDefault INSTANCE = new RssParserDefault();
    @NotNull
    private static final String RSS_ITEM = "item";
    @NotNull
    private static final String RSS_ITEM_TITLE = "title";
    @NotNull
    private static final String RSS_ITEM_LINK = "link";
    @NotNull
    private static final String RSS_ITEM_CATEGORY = "category";
    @NotNull
    private static final String RSS_ITEM_THUMBNAIL = "media:thumbnail";
    @NotNull
    private static final String RSS_ITEM_ENCLOSURE = "enclosure";
    @NotNull
    private static final String RSS_ITEM_DESCRIPTION = "description";
    @NotNull
    private static final String RSS_ITEM_CONTENT = "content:encoded";
    @NotNull
    private static final String RSS_ITEM_PUB_DATE = "pubDate";
    @NotNull
    private static final String RSS_ITEM_TIME = "time";
    @NotNull
    private static final String RSS_ITEM_URL = "url";
    @NotNull
    private static final String RSS_ITEM_TYPE = "type";

    private RssParserDefault() {
    }

    @NotNull
    public final Pair<List<RssArticle>, String> parseXML(@NotNull String sortName, @NotNull String xml, @NotNull String sourceUrl, @NotNull String userid, @Nullable DebugLog debugLogger) throws XmlPullParserException, IOException {
        List articleList;
        block40: {
            Intrinsics.checkNotNullParameter((Object)sortName, (String)"sortName");
            Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
            Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
            Intrinsics.checkNotNullParameter((Object)userid, (String)"userid");
            articleList = new ArrayList();
            RssArticle currentArticle = new RssArticle(null, null, null, 0L, null, null, null, null, null, null, false, null, userid, 4095, null);
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(false);
            XmlPullParser xmlPullParser = factory.newPullParser();
            xmlPullParser.setInput((Reader)new StringReader(xml));
            boolean insideItem = false;
            int eventType = xmlPullParser.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM, (boolean)true)) {
                        insideItem = true;
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_TITLE, (boolean)true)) {
                        if (insideItem) {
                            String string = xmlPullParser.nextText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextText(...)");
                            currentArticle.setTitle(((Object)StringsKt.trim((CharSequence)string)).toString());
                        }
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_LINK, (boolean)true)) {
                        if (insideItem) {
                            String string = xmlPullParser.nextText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextText(...)");
                            currentArticle.setLink(((Object)StringsKt.trim((CharSequence)string)).toString());
                        }
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_THUMBNAIL, (boolean)true)) {
                        if (insideItem) {
                            currentArticle.setImage(xmlPullParser.getAttributeValue(null, RSS_ITEM_URL));
                        }
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_ENCLOSURE, (boolean)true)) {
                        String type;
                        if (insideItem && (type = xmlPullParser.getAttributeValue(null, RSS_ITEM_TYPE)) != null && StringsKt.contains$default((CharSequence)type, (CharSequence)"image/", (boolean)false, (int)2, null)) {
                            currentArticle.setImage(xmlPullParser.getAttributeValue(null, RSS_ITEM_URL));
                        }
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_DESCRIPTION, (boolean)true)) {
                        if (insideItem) {
                            String description = xmlPullParser.nextText();
                            Intrinsics.checkNotNull((Object)description);
                            currentArticle.setDescription(((Object)StringsKt.trim((CharSequence)description)).toString());
                            if (currentArticle.getImage() == null) {
                                currentArticle.setImage(this.getImageUrl(description));
                            }
                        }
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_CONTENT, (boolean)true)) {
                        if (insideItem) {
                            String string = xmlPullParser.nextText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextText(...)");
                            String content = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            currentArticle.setContent(content);
                            if (currentArticle.getImage() == null) {
                                currentArticle.setImage(this.getImageUrl(content));
                            }
                        }
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_PUB_DATE, (boolean)true)) {
                        if (insideItem) {
                            int nextTokenType = xmlPullParser.next();
                            if (nextTokenType != 4) continue;
                            String string = xmlPullParser.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            currentArticle.setPubDate(((Object)StringsKt.trim((CharSequence)string)).toString());
                            continue;
                        }
                    } else if (StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM_TIME, (boolean)true) && insideItem) {
                        currentArticle.setPubDate(xmlPullParser.nextText());
                    }
                } else if (eventType == 3 && StringsKt.equals((String)xmlPullParser.getName(), (String)RSS_ITEM, (boolean)true)) {
                    insideItem = false;
                    currentArticle.setUserid(userid);
                    currentArticle.setOrigin(sourceUrl);
                    currentArticle.setSort(sortName);
                    articleList.add(currentArticle);
                    currentArticle = new RssArticle(null, null, null, 0L, null, null, null, null, null, null, false, null, null, 8191, null);
                }
                eventType = xmlPullParser.next();
            }
            RssArticle rssArticle = (RssArticle)CollectionsKt.firstOrNull((List)articleList);
            if (rssArticle == null) break block40;
            RssArticle it = rssArticle;
            boolean bl = false;
            DebugLog debugLog = debugLogger;
            if (debugLog != null) {
                DebugLog.DefaultImpls.log$default(debugLog, sourceUrl, "\u250c\u83b7\u53d6\u6807\u9898", false, 4, null);
            }
            DebugLog debugLog2 = debugLogger;
            if (debugLog2 != null) {
                DebugLog.DefaultImpls.log$default(debugLog2, sourceUrl, "\u2514" + it.getTitle(), false, 4, null);
            }
            DebugLog debugLog3 = debugLogger;
            if (debugLog3 != null) {
                DebugLog.DefaultImpls.log$default(debugLog3, sourceUrl, "\u250c\u83b7\u53d6\u65f6\u95f4", false, 4, null);
            }
            DebugLog debugLog4 = debugLogger;
            if (debugLog4 != null) {
                DebugLog.DefaultImpls.log$default(debugLog4, sourceUrl, "\u2514" + it.getPubDate(), false, 4, null);
            }
            DebugLog debugLog5 = debugLogger;
            if (debugLog5 != null) {
                DebugLog.DefaultImpls.log$default(debugLog5, sourceUrl, "\u250c\u83b7\u53d6\u63cf\u8ff0", false, 4, null);
            }
            DebugLog debugLog6 = debugLogger;
            if (debugLog6 != null) {
                DebugLog.DefaultImpls.log$default(debugLog6, sourceUrl, "\u2514" + it.getDescription(), false, 4, null);
            }
            DebugLog debugLog7 = debugLogger;
            if (debugLog7 != null) {
                DebugLog.DefaultImpls.log$default(debugLog7, sourceUrl, "\u250c\u83b7\u53d6\u56fe\u7247url", false, 4, null);
            }
            DebugLog debugLog8 = debugLogger;
            if (debugLog8 != null) {
                DebugLog.DefaultImpls.log$default(debugLog8, sourceUrl, "\u2514" + it.getImage(), false, 4, null);
            }
            DebugLog debugLog9 = debugLogger;
            if (debugLog9 != null) {
                DebugLog.DefaultImpls.log$default(debugLog9, sourceUrl, "\u250c\u83b7\u53d6\u6587\u7ae0\u94fe\u63a5", false, 4, null);
            }
            DebugLog debugLog10 = debugLogger;
            if (debugLog10 != null) {
                DebugLog.DefaultImpls.log$default(debugLog10, sourceUrl, "\u2514" + it.getLink(), false, 4, null);
            }
        }
        return new Pair((Object)articleList, null);
    }

    public static /* synthetic */ Pair parseXML$default(RssParserDefault rssParserDefault, String string, String string2, String string3, String string4, DebugLog debugLog, int n, Object object) throws XmlPullParserException, IOException {
        if ((n & 0x10) != 0) {
            debugLog = null;
        }
        return rssParserDefault.parseXML(string, string2, string3, string4, debugLog);
    }

    private final String getImageUrl(String input) {
        String url = null;
        String string = "(<img [^>]*>)";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pattern patternImg = pattern;
        Matcher matcherImg = patternImg.matcher(input);
        if (matcherImg.find()) {
            String imgTag = matcherImg.group(1);
            String string2 = "src\\s*=\\s*\"([^\"]+)\"";
            int n2 = 0;
            Pattern pattern2 = Pattern.compile(string2, n2);
            Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
            Pattern patternLink = pattern2;
            String string3 = imgTag;
            Intrinsics.checkNotNull((Object)string3);
            Matcher matcherLink = patternLink.matcher(string3);
            if (matcherLink.find()) {
                String string4 = matcherLink.group(1);
                Intrinsics.checkNotNull((Object)string4);
                url = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            }
        }
        return url;
    }
}

