/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.localBook;

import book.model.Book;
import book.model.BookChapter;
import book.util.FileUtils;
import book.util.help.BookHelp;
import book.webBook.exception.TocEmptyException;
import book.webBook.localBook.CbzFile;
import book.webBook.localBook.EpubFile;
import book.webBook.localBook.TextFile;
import book.webBook.localBook.UmdFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u00102\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000fJ\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fR\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u000b"}, d2={"Lbook/webBook/localBook/LocalBook;", "", "<init>", "()V", "nameAuthorPatterns", "", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "[Ljava/util/regex/Pattern;", "getBookInputStream", "Ljava/io/InputStream;", "book", "Lbook/model/Book;", "getChapterList", "Ljava/util/ArrayList;", "Lbook/model/BookChapter;", "Lkotlin/collections/ArrayList;", "getContent", "", "chapter", "analyzeNameAuthor", "Lkotlin/Pair;", "fileName", "deleteBook", ""})
@SourceDebugExtension(value={"SMAP\nLocalBook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalBook.kt\nbook/webBook/localBook/LocalBook\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class LocalBook {
    @NotNull
    public static final LocalBook INSTANCE = new LocalBook();
    @NotNull
    private static final Pattern[] nameAuthorPatterns;

    private LocalBook() {
    }

    @NotNull
    public final InputStream getBookInputStream(@NotNull Book book) throws FileNotFoundException, SecurityException {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        File file = book.getLocalFile();
        if (file.exists()) {
            return new FileInputStream(file);
        }
        throw new FileNotFoundException(book.getName() + " \u6587\u4ef6\u4e0d\u5b58\u5728");
    }

    @NotNull
    public final ArrayList<BookChapter> getChapterList(@NotNull Book book) throws Exception {
        ArrayList<BookChapter> chapters;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        ArrayList<BookChapter> arrayList = book.isEpub() ? EpubFile.Companion.getChapterList(book) : (book.isUmd() ? UmdFile.Companion.getChapterList(book) : (chapters = book.isCbz() ? CbzFile.Companion.getChapterList(book) : TextFile.Companion.getChapterList(book)));
        if (chapters.isEmpty()) {
            throw new TocEmptyException("Chapterlist is empty  " + book.getLocalFile());
        }
        return chapters;
    }

    @Nullable
    public final String getContent(@NotNull Book book, @NotNull BookChapter chapter) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)chapter, (String)"chapter");
        return book.isEpub() ? EpubFile.Companion.getContent(book, chapter) : (book.isUmd() ? UmdFile.Companion.getContent(book, chapter) : (book.isCbz() ? CbzFile.Companion.getContent(book, chapter) : TextFile.Companion.getContent(book, chapter)));
    }

    @NotNull
    public final Pair<String, String> analyzeNameAuthor(@NotNull String fileName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String tempFileName = StringsKt.substringBeforeLast$default((String)fileName, (String)".", null, (int)2, null);
        String name = null;
        String author = null;
        for (Pattern pattern : nameAuthorPatterns) {
            String string2;
            String group1;
            Matcher matcher;
            Matcher matcher2;
            Matcher it = matcher2 = pattern.matcher(tempFileName);
            boolean bl = false;
            Matcher matcher3 = matcher = it.find() ? matcher2 : null;
            if (matcher == null) continue;
            Matcher $this$analyzeNameAuthor_u24lambda_u241 = matcher;
            boolean bl2 = false;
            String string3 = $this$analyzeNameAuthor_u24lambda_u241.group(2);
            Intrinsics.checkNotNull((Object)string3);
            name = string3;
            String string4 = $this$analyzeNameAuthor_u24lambda_u241.group(1);
            if (string4 == null) {
                string4 = group1 = "";
            }
            if ((string2 = $this$analyzeNameAuthor_u24lambda_u241.group(3)) == null) {
                string2 = "";
            }
            String group3 = string2;
            author = BookHelp.INSTANCE.formatBookAuthor(group1 + group3);
            return new Pair((Object)name, (Object)author);
        }
        name = BookHelp.INSTANCE.formatBookName(tempFileName);
        String it = string = BookHelp.INSTANCE.formatBookAuthor(StringsKt.replace$default((String)tempFileName, (String)name, (String)"", (boolean)false, (int)4, null));
        boolean bl = false;
        String string5 = it.length() != tempFileName.length() ? string : null;
        if (string5 == null) {
            string5 = "";
        }
        author = string5;
        return new Pair((Object)name, (Object)author);
    }

    public final void deleteBook(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        try {
            boolean bl = false;
            File bookFile = book.getLocalFile();
            if ((book.isLocalTxt() || book.isUmd()) && bookFile.exists()) {
                bookFile.delete();
            }
            if (book.isEpub() && (bookFile = bookFile.getParentFile()) != null && bookFile.exists()) {
                FileUtils.INSTANCE.delete(bookFile, true);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    static {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("(.*?)\u300a([^\u300a\u300b]+)\u300b.*?\u4f5c\u8005\uff1a(.*)"), Pattern.compile("(.*?)\u300a([^\u300a\u300b]+)\u300b(.*)"), Pattern.compile("(^)(.+) \u4f5c\u8005\uff1a(.+)$"), Pattern.compile("(^)(.+) by (.+)$")};
        nameAuthorPatterns = patternArray;
    }
}

