/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.analyzeRule;

import book.app.App;
import book.model.BaseSource;
import book.model.Book;
import book.model.BookChapter;
import book.util.AppConst;
import book.util.AppPattern;
import book.util.Base64;
import book.util.EncoderUtils;
import book.util.GSONKt;
import book.util.JsURL;
import book.util.MaputilKt;
import book.util.NetworkUtils;
import book.util.ParameterizedTypeImpl;
import book.util.StringKt;
import book.util.StringUtils;
import book.util.crypto.AsymmetricCrypto;
import book.util.help.CacheManager;
import book.util.help.CacheManagerKt;
import book.util.help.CookieStore;
import book.util.http.ConcurrentRateLimiter;
import book.util.http.HttpHelperKt;
import book.util.http.JsonpResponse;
import book.util.http.OkHttpClientKt;
import book.util.http.RequestMethod;
import book.util.http.StrResponse;
import book.webBook.DebugLog;
import book.webBook.analyzeRule.AnalyzeUrl;
import book.webBook.analyzeRule.JsExtensions;
import book.webBook.analyzeRule.QueryTTF;
import book.webBook.analyzeRule.RuleAnalyzer;
import book.webBook.analyzeRule.RuleDataInterface;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.script.ScriptBindings;
import com.script.rhino.RhinoScriptEngine;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Connection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 \u0083\u00012\u00020\u0001:\u0006\u0083\u0001\u0084\u0001\u0085\u0001B\u00b9\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\u0016\b\u0002\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0006\u0010R\u001a\u00020SJ\b\u0010T\u001a\u00020\u0003H\u0016J\b\u0010U\u001a\u00020SH\u0002J\b\u0010V\u001a\u00020SH\u0002J\b\u0010W\u001a\u00020SH\u0002J\u0010\u0010X\u001a\u00020S2\u0006\u0010Y\u001a\u00020\u0003H\u0002J\u001c\u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020\u00032\n\b\u0002\u0010]\u001a\u0004\u0018\u00010[J\u0016\u0010^\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003J\u000e\u0010_\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010`\u001a\u00020SJ0\u0010a\u001a\u00020b2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010c\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010K\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010dJ*\u0010e\u001a\u00020b2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010c\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010K\u001a\u00020\u0017H\u0007J\u000e\u0010f\u001a\u00020gH\u0086@\u00a2\u0006\u0002\u0010hJ\b\u0010i\u001a\u00020jH\u0002J\u0006\u0010k\u001a\u00020gJ\n\u0010l\u001a\u0004\u0018\u00010mH\u0002J\u000e\u0010n\u001a\u00020mH\u0086@\u00a2\u0006\u0002\u0010hJ\u0006\u0010o\u001a\u00020mJ\u000e\u0010p\u001a\u00020qH\u0086@\u00a2\u0006\u0002\u0010hJ\u0012\u0010w\u001a\u00020S2\b\u0010x\u001a\u0004\u0018\u00010[H\u0016J\u0012\u0010y\u001a\u00020S2\b\u0010x\u001a\u0004\u0018\u00010[H\u0016J\u0006\u0010z\u001a\u00020qJ&\u0010{\u001a\u00020b2\u0006\u0010|\u001a\u00020\u00032\u0006\u0010}\u001a\u00020[2\u0006\u0010~\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u007fJ\u0007\u0010\u0080\u0001\u001a\u00020\u0003J\u0007\u0010\u0081\u0001\u001a\u00020\u0017J\u000b\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001eR\u0015\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b$\u0010!R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010'R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001e\u00104\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u001eR\u001e\u00106\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001eR\"\u00108\u001a\u0004\u0018\u00010\u00032\b\u00103\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001eR\"\u0010:\u001a\u0004\u0018\u00010\u00032\b\u00103\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001eR-\u0010<\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030=j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010C\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030Dj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010t\"\u0004\bu\u0010v\u00a8\u0006\u0086\u0001"}, d2={"Lbook/webBook/analyzeRule/AnalyzeUrl;", "Lbook/webBook/analyzeRule/JsExtensions;", "mUrl", "", "key", "page", "", "speakText", "speakSpeed", "baseUrl", "source", "Lbook/model/BaseSource;", "ruleData", "Lbook/webBook/analyzeRule/RuleDataInterface;", "readTimeout", "", "chapter", "Lbook/model/BookChapter;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "headerMapF", "", "needanalyzeUrl", "", "debugLog", "Lbook/webBook/DebugLog;", "hasLoginHeader", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lbook/model/BaseSource;Lbook/webBook/analyzeRule/RuleDataInterface;Ljava/lang/Long;Lbook/model/BookChapter;Lkotlin/coroutines/CoroutineContext;Ljava/util/Map;ZLbook/webBook/DebugLog;Z)V", "getMUrl", "()Ljava/lang/String;", "getKey", "getPage", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSpeakText", "getSpeakSpeed", "getBaseUrl", "setBaseUrl", "(Ljava/lang/String;)V", "Ljava/lang/Long;", "getNeedanalyzeUrl", "()Z", "getDebugLog", "()Lbook/webBook/DebugLog;", "setDebugLog", "(Lbook/webBook/DebugLog;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "value", "ruleUrl", "getRuleUrl", "url", "getUrl", "body", "getBody", "type", "getType", "headerMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getHeaderMap", "()Ljava/util/HashMap;", "urlNoQuery", "queryStr", "fieldMap", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "charset", "method", "Lbook/util/http/RequestMethod;", "proxy", "retry", "useWebView", "usePhone", "webJs", "enabledCookieJar", "concurrentRateLimiter", "Lbook/util/http/ConcurrentRateLimiter;", "domain", "initUrl", "", "toString", "analyzeJs", "replaceKeyPageJs", "analyzeUrl", "analyzeFields", "fieldsTxt", "evalJS", "", "jsStr", "result", "put", "get", "setCookie", "getStrResponseAwait", "Lbook/util/http/StrResponse;", "sourceRegex", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStrResponse", "getResponseAwait", "Lokhttp3/Response;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClient", "Lokhttp3/OkHttpClient;", "getResponse", "getByteArrayIfDataUri", "", "getByteArrayAwait", "getByteArray", "getInputStreamAwait", "Ljava/io/InputStream;", "toastc", "getToastc", "()I", "setToastc", "(I)V", "toast", "msg", "longToast", "getInputStream", "upload", "fileName", "file", "contentType", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUserAgent", "isPost", "getSource", "Companion", "UrlOption", "ConcurrentRecord", "book"})
@SourceDebugExtension(value={"SMAP\nAnalyzeUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeUrl.kt\nbook/webBook/analyzeRule/AnalyzeUrl\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 GSON.kt\nbook/util/GSONKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ScriptBindingsExtensions.kt\ncom/script/ScriptBindingsExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 ConcurrentRateLimiter.kt\nbook/util/http/ConcurrentRateLimiter\n*L\n1#1,727:1\n108#2:728\n80#2,22:729\n108#2:751\n80#2,22:752\n33#3,2:774\n30#3:776\n33#3,2:800\n30#3:802\n216#4,2:777\n216#4,2:803\n6#5,8:779\n1#6:787\n1863#7,2:788\n124#8,5:790\n124#8,5:795\n*S KotlinDebug\n*F\n+ 1 AnalyzeUrl.kt\nbook/webBook/analyzeRule/AnalyzeUrl\n*L\n195#1:728\n195#1:729,22\n197#1:751\n197#1:752,22\n217#1:774,2\n217#1:776\n578#1:800,2\n578#1:802\n222#1:777,2\n579#1:803,2\n293#1:779,8\n344#1:788,2\n376#1:790,5\n468#1:795,5\n*E\n"})
public final class AnalyzeUrl
implements JsExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mUrl;
    @Nullable
    private final String key;
    @Nullable
    private final Integer page;
    @Nullable
    private final String speakText;
    @Nullable
    private final Integer speakSpeed;
    @NotNull
    private String baseUrl;
    @Nullable
    private final BaseSource source;
    @Nullable
    private final RuleDataInterface ruleData;
    @Nullable
    private final Long readTimeout;
    @Nullable
    private final BookChapter chapter;
    @NotNull
    private CoroutineContext coroutineContext;
    private final boolean needanalyzeUrl;
    @Nullable
    private DebugLog debugLog;
    @NotNull
    private String ruleUrl;
    @NotNull
    private String url;
    @Nullable
    private String body;
    @Nullable
    private String type;
    @NotNull
    private final HashMap<String, String> headerMap;
    @NotNull
    private String urlNoQuery;
    @Nullable
    private String queryStr;
    @NotNull
    private final LinkedHashMap<String, String> fieldMap;
    @Nullable
    private String charset;
    @NotNull
    private RequestMethod method;
    @Nullable
    private String proxy;
    private int retry;
    private boolean useWebView;
    private boolean usePhone;
    @Nullable
    private String webJs;
    private final boolean enabledCookieJar;
    @NotNull
    private final ConcurrentRateLimiter concurrentRateLimiter;
    @NotNull
    private final String domain;
    private int toastc;
    @NotNull
    private static final Pattern paramPattern;
    private static final Pattern pagePattern;
    @NotNull
    private static final HashMap<String, ConcurrentRecord> concurrentRecordMap;

    public AnalyzeUrl(@NotNull String mUrl, @Nullable String key, @Nullable Integer page, @Nullable String speakText, @Nullable Integer speakSpeed, @NotNull String baseUrl, @Nullable BaseSource source, @Nullable RuleDataInterface ruleData, @Nullable Long readTimeout, @Nullable BookChapter chapter, @NotNull CoroutineContext coroutineContext, @Nullable Map<String, String> headerMapF, boolean needanalyzeUrl, @Nullable DebugLog debugLog, boolean hasLoginHeader) {
        Intrinsics.checkNotNullParameter((Object)mUrl, (String)"mUrl");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.mUrl = mUrl;
        this.key = key;
        this.page = page;
        this.speakText = speakText;
        this.speakSpeed = speakSpeed;
        this.baseUrl = baseUrl;
        this.source = source;
        this.ruleData = ruleData;
        this.readTimeout = readTimeout;
        this.chapter = chapter;
        this.coroutineContext = coroutineContext;
        this.needanalyzeUrl = needanalyzeUrl;
        this.debugLog = debugLog;
        this.ruleUrl = "";
        this.url = "";
        this.headerMap = new HashMap();
        this.urlNoQuery = "";
        this.fieldMap = new LinkedHashMap();
        this.method = RequestMethod.GET;
        Object object = this.source;
        this.enabledCookieJar = object != null && (object = object.getEnabledCookieJar()) != null ? (Boolean)object : false;
        this.concurrentRateLimiter = new ConcurrentRateLimiter(this.source);
        if (this.source != null) {
            if (headerMapF != null) {
                this.headerMap.putAll(headerMapF);
            }
            AnalyzeUrl analyzeUrl = this;
            try {
                AnalyzeUrl $this$_init__u24lambda_u240 = analyzeUrl;
                boolean bl = false;
                HashMap<String, String> hashMap = $this$_init__u24lambda_u240.headerMap;
                BaseSource baseSource = $this$_init__u24lambda_u240.source;
                Intrinsics.checkNotNull((Object)baseSource);
                hashMap.putAll((Map<String, String>)baseSource.getHeaderMap(hasLoginHeader));
                Object object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if (this.headerMap.containsKey("proxy")) {
                this.proxy = this.headerMap.get("proxy");
                this.headerMap.remove("proxy");
            }
            if (!StringsKt.isBlank((CharSequence)this.mUrl) && StringsKt.isBlank((CharSequence)this.baseUrl) && !StringsKt.startsWith$default((String)this.mUrl, (String)"http://", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)this.mUrl, (String)"https://", (boolean)false, (int)2, null)) {
                this.baseUrl = this.source.getKey();
            }
        }
        this.initUrl();
        Object object4 = this.source;
        if (object4 == null || (object4 = object4.getKey()) == null) {
            object4 = this.url;
        }
        this.domain = NetworkUtils.INSTANCE.getSubDomain((String)object4);
    }

    public /* synthetic */ AnalyzeUrl(String string, String string2, Integer n, String string3, Integer n2, String string4, BaseSource baseSource, RuleDataInterface ruleDataInterface, Long l, BookChapter bookChapter, CoroutineContext coroutineContext, Map map, boolean bl, DebugLog debugLog, boolean bl2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            string3 = null;
        }
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            string4 = "";
        }
        if ((n3 & 0x40) != 0) {
            baseSource = null;
        }
        if ((n3 & 0x80) != 0) {
            ruleDataInterface = null;
        }
        if ((n3 & 0x100) != 0) {
            l = null;
        }
        if ((n3 & 0x200) != 0) {
            bookChapter = null;
        }
        if ((n3 & 0x400) != 0) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        if ((n3 & 0x800) != 0) {
            map = null;
        }
        if ((n3 & 0x1000) != 0) {
            bl = true;
        }
        if ((n3 & 0x4000) != 0) {
            bl2 = true;
        }
        this(string, string2, n, string3, n2, string4, baseSource, ruleDataInterface, l, bookChapter, coroutineContext, map, bl, debugLog, bl2);
    }

    @NotNull
    public final String getMUrl() {
        return this.mUrl;
    }

    @Nullable
    public final String getKey() {
        return this.key;
    }

    @Nullable
    public final Integer getPage() {
        return this.page;
    }

    @Nullable
    public final String getSpeakText() {
        return this.speakText;
    }

    @Nullable
    public final Integer getSpeakSpeed() {
        return this.speakSpeed;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public final void setBaseUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.baseUrl = string;
    }

    public final boolean getNeedanalyzeUrl() {
        return this.needanalyzeUrl;
    }

    @Override
    @Nullable
    public DebugLog getDebugLog() {
        return this.debugLog;
    }

    @Override
    public void setDebugLog(@Nullable DebugLog debugLog) {
        this.debugLog = debugLog;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        Logger logger = LoggerFactory.getLogger(AnalyzeUrl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @NotNull
    public final String getRuleUrl() {
        return this.ruleUrl;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Nullable
    public final String getBody() {
        return this.body;
    }

    @Nullable
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final HashMap<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public final void initUrl() {
        this.coroutineContext = this.coroutineContext.minusKey((CoroutineContext.Key)ContinuationInterceptor.Key);
        if (this.chapter != null && this.source != null) {
            String string = this.source.getUserid();
            if (string == null) {
                string = "";
            }
            this.chapter.setUserid(string);
            RuleDataInterface ruleDataInterface = this.ruleData;
            if (ruleDataInterface != null) {
                String string2 = this.source.getUserid();
                if (string2 == null) {
                    string2 = "";
                }
                ruleDataInterface.setUserid(string2);
            }
        }
        this.ruleUrl = this.mUrl;
        this.analyzeJs();
        if (this.needanalyzeUrl) {
            this.replaceKeyPageJs();
        }
        if (this.needanalyzeUrl) {
            this.analyzeUrl();
        }
        this.getLogger().info("ruleUrl " + this.ruleUrl);
        this.getLogger().info("baseUrl " + this.baseUrl);
    }

    @NotNull
    public String toString() {
        int hashCode = this.hashCode();
        String hexHash = Integer.toHexString(hashCode);
        String s = "io.legado.app.model.analyzeRule.AnalyzeUrl@" + hexHash;
        return s;
    }

    private final void analyzeJs() {
        String it;
        int start = 0;
        Matcher jsMatcher = AppPattern.INSTANCE.getJS_PATTERN().matcher(this.ruleUrl);
        String result = null;
        result = this.ruleUrl;
        while (jsMatcher.find()) {
            String string;
            if (jsMatcher.start() > start) {
                String string2 = this.ruleUrl.substring(start, jsMatcher.start());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                it = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                boolean bl = false;
                if (((CharSequence)it).length() > 0) {
                    result = StringsKt.replace$default((String)it, (String)"@result", (String)result, (boolean)false, (int)4, null);
                }
            }
            if ((string = jsMatcher.group(2)) == null) {
                string = jsMatcher.group(1);
            }
            String string3 = string;
            Intrinsics.checkNotNull((Object)string3);
            result = String.valueOf(this.evalJS(string3, result));
            start = jsMatcher.end();
        }
        if (this.ruleUrl.length() > start) {
            String string = this.ruleUrl.substring(start);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            it = ((Object)StringsKt.trim((CharSequence)string)).toString();
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                result = StringsKt.replace$default((String)it, (String)"@result", (String)result, (boolean)false, (int)4, null);
            }
        }
        this.ruleUrl = result;
    }

    private final void replaceKeyPageJs() {
        block10: {
            RuleAnalyzer analyze;
            String url;
            if (StringsKt.contains$default((CharSequence)this.ruleUrl, (CharSequence)"{{", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)this.ruleUrl, (CharSequence)"}}", (boolean)false, (int)2, null) && ((CharSequence)(url = (analyze = new RuleAnalyzer(this.ruleUrl, false, 2, null)).innerRule("{{", "}}", (Function1<? super String, String>)((Function1)arg_0 -> AnalyzeUrl.replaceKeyPageJs$lambda$3(this, arg_0))))).length() > 0) {
                this.ruleUrl = url;
            }
            Integer n = this.page;
            if (n == null) break block10;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Matcher matcher = pagePattern.matcher(this.ruleUrl);
            while (matcher.find()) {
                String string;
                String string2 = matcher.group(1);
                Intrinsics.checkNotNull((Object)string2);
                Object object = new String[]{","};
                List pages = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)0, (int)6, null);
                if (this.page < pages.size()) {
                    Intrinsics.checkNotNullExpressionValue((Object)matcher.group(), (String)"group(...)");
                    object = (String)pages.get(this.page - 1);
                    var9_9 = this.ruleUrl;
                    var10_10 = this;
                    $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl2 = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    var20_20 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    v3 = var10_10;
                    string = StringsKt.replace$default((String)var9_9, (String)var8_8, (String)var20_20, (boolean)false, (int)4, null);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)matcher.group(), (String)"group(...)");
                    $this$trim$iv = (String)CollectionsKt.last((List)pages);
                    var9_9 = this.ruleUrl;
                    $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl4 = false;
                        boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    var20_20 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    v3 = var10_10;
                    string = StringsKt.replace$default((String)var9_9, (String)var8_8, (String)var20_20, (boolean)false, (int)4, null);
                }
                v3.ruleUrl = string;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeUrl() {
        String string;
        Object it;
        String string2;
        Matcher urlMatcher = paramPattern.matcher(this.ruleUrl);
        if (urlMatcher.find()) {
            String string3 = this.ruleUrl.substring(0, urlMatcher.start());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string2 = this.ruleUrl;
        }
        String urlNoOption = string2;
        this.url = NetworkUtils.INSTANCE.getAbsoluteURL(this.baseUrl, urlNoOption);
        String string4 = NetworkUtils.INSTANCE.getBaseUrl(this.url);
        if (string4 != null) {
            it = string4;
            boolean bl = false;
            this.baseUrl = it;
        }
        if (urlNoOption.length() != this.ruleUrl.length()) {
            Object $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22;
            Object object = GSONKt.getGSON();
            String string5 = this.ruleUrl.substring(urlMatcher.end());
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String json$iv = string5;
            boolean $i$f$fromJsonObject = false;
            try {
                void $this$fromJsonObject$iv;
                boolean $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = false;
                boolean $i$f$genericType = false;
                Type type = new TypeToken<UrlOption>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                Object object2 = $this$fromJsonObject$iv.fromJson(json$iv, type);
                if (!(object2 instanceof UrlOption)) {
                    object2 = null;
                }
                $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = Result.constructor-impl((Object)((UrlOption)object2));
            }
            catch (Throwable $i$f$genericType) {
                $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$genericType));
            }
            object = $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22;
            UrlOption urlOption = (UrlOption)(Result.isFailure-impl((Object)object) ? null : object);
            if (urlOption != null) {
                UrlOption option = urlOption;
                boolean bl = false;
                String string6 = option.getMethod();
                if (string6 != null) {
                    String it2 = string6;
                    boolean bl2 = false;
                    if (StringsKt.equals((String)it2, (String)"POST", (boolean)true)) {
                        this.method = RequestMethod.POST;
                    }
                }
                Map<?, ?> map = option.getHeaderMap();
                if (map != null) {
                    Map<?, ?> $this$forEach$iv = map;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<?, ?>> bl2 = $this$forEach$iv.entrySet().iterator();
                    while (bl2.hasNext()) {
                        Map.Entry<?, ?> element$iv;
                        Map.Entry<?, ?> entry = element$iv = bl2.next();
                        boolean bl3 = false;
                        ((Map)this.headerMap).put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                    }
                }
                String string7 = option.getBody();
                if (string7 != null) {
                    String it3 = string7;
                    boolean bl4 = false;
                    this.body = it3;
                }
                this.type = option.getType();
                this.charset = option.getCharset();
                this.retry = option.getRetry();
                this.useWebView = option.useWebView();
                this.usePhone = option.usePhone();
                this.webJs = option.getWebJs();
                String string8 = option.getJs();
                if (string8 != null) {
                    String jsStr = string8;
                    boolean bl5 = false;
                    Object object3 = this.evalJS(jsStr, this.url);
                    if (object3 != null && (object3 = object3.toString()) != null) {
                        Object it4 = object3;
                        boolean bl6 = false;
                        this.url = it4;
                    }
                }
            }
        }
        if ((string = this.headerMap.get("User-Agent")) == null) {
            it = this;
            boolean bl = false;
            ((Map)this.headerMap).put("User-Agent", AppConst.INSTANCE.getUserAgent());
            string = Unit.INSTANCE;
        }
        this.urlNoQuery = this.url;
        switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
            case 1: {
                int pos = StringsKt.indexOf$default((CharSequence)this.url, (char)'?', (int)0, (boolean)false, (int)6, null);
                if (pos == -1) break;
                String string9 = this.url.substring(pos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                this.analyzeFields(string9);
                String string10 = this.url.substring(0, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"substring(...)");
                this.urlNoQuery = string10;
                break;
            }
            case 2: {
                String string11 = this.body;
                if (string11 != null) {
                    CharSequence charSequence;
                    String it5 = string11;
                    boolean bl = false;
                    if (StringKt.isJson(it5) || StringKt.isXml(it5) || !((charSequence = (CharSequence)this.headerMap.get("Content-Type")) == null || charSequence.length() == 0)) break;
                    this.analyzeFields(it5);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void analyzeFields(String fieldsTxt) {
        this.queryStr = fieldsTxt;
        String[] stringArray = new String[]{"&"};
        for (String query : StringKt.splitNotBlank(fieldsTxt, stringArray)) {
            String string;
            String value;
            int pos = StringsKt.indexOf$default((CharSequence)query, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (pos != -1 && pos + 1 != query.length()) {
                String string2 = query.substring(pos + 1, query.length());
                v1 = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                v1 = value = "";
            }
            if (pos != -1 && pos != 0) {
                String string3 = query.substring(0, pos);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = "";
            }
            String queryM = string;
            CharSequence charSequence = this.charset;
            if (charSequence == null || charSequence.length() == 0) {
                if (NetworkUtils.INSTANCE.hasUrlEncoded(value)) {
                    ((Map)this.fieldMap).put(queryM, value);
                    continue;
                }
                ((Map)this.fieldMap).put(queryM, URLEncoder.encode(value, "UTF-8"));
                continue;
            }
            if (Intrinsics.areEqual((Object)this.charset, (Object)"escape")) {
                ((Map)this.fieldMap).put(queryM, EncoderUtils.INSTANCE.escape(value));
                continue;
            }
            ((Map)this.fieldMap).put(queryM, URLEncoder.encode(value, this.charset));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object evalJS(@NotNull String jsStr, @Nullable Object result) {
        Scriptable scope;
        block8: {
            Intrinsics.checkNotNullParameter((Object)jsStr, (String)"jsStr");
            String userid = "";
            if (this.source != null) {
                String string = this.source.getUserid();
                if (string == null) {
                    string = "";
                }
                userid = string;
                BookChapter bookChapter = this.chapter;
                if (bookChapter != null) {
                    bookChapter.setUserid(userid);
                }
                RuleDataInterface ruleDataInterface = this.ruleData;
                if (ruleDataInterface != null) {
                    ruleDataInterface.setUserid(userid);
                }
            }
            boolean $i$f$buildScriptBindings = false;
            ScriptBindings bindings$iv = new ScriptBindings();
            Context.enter();
            try {
                ScriptBindings bindings = bindings$iv;
                boolean bl = false;
                bindings.set("java", (Object)this);
                bindings.set("baseUrl", (Object)this.baseUrl);
                BaseSource baseSource = this.source;
                CookieStore cookieStore = baseSource != null ? baseSource.getCookieManger() : null;
                Intrinsics.checkNotNull((Object)cookieStore);
                bindings.set("cookie", (Object)cookieStore);
                BaseSource baseSource2 = this.source;
                CacheManager cacheManager = baseSource2 != null ? baseSource2.getCacheManger() : null;
                Intrinsics.checkNotNull((Object)cacheManager);
                bindings.set("cache", (Object)cacheManager);
                bindings.set("page", (Object)this.page);
                bindings.set("key", (Object)this.key);
                bindings.set("speakText", (Object)this.speakText);
                bindings.set("speakSpeed", (Object)this.speakSpeed);
                RuleDataInterface ruleDataInterface = this.ruleData;
                bindings.set("book", (Object)(ruleDataInterface instanceof Book ? (Book)ruleDataInterface : null));
                bindings.set("source", (Object)this.source);
                bindings.set("result", result);
                this.binding(bindings);
            }
            finally {
                Context.exit();
            }
            ScriptBindings bindings = bindings$iv;
            scope = RhinoScriptEngine.INSTANCE.getRuntimeScope(bindings);
            BaseSource baseSource = this.source;
            if (baseSource == null || (baseSource = baseSource.getShareScope()) == null) break block8;
            BaseSource it = baseSource;
            boolean bl = false;
            scope.setPrototype((Scriptable)it);
        }
        return RhinoScriptEngine.INSTANCE.eval(this.getjs(jsStr), scope, this.coroutineContext);
    }

    public static /* synthetic */ Object evalJS$default(AnalyzeUrl analyzeUrl, String string, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return analyzeUrl.evalJS(string, object);
    }

    @NotNull
    public final String put(@NotNull String key, @NotNull String value) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (this.source != null) {
                    String string = this.source.getUserid();
                    if (string == null) {
                        string = "";
                    }
                    String userid = string;
                    BookChapter bookChapter = this.chapter;
                    if (bookChapter != null) {
                        bookChapter.setUserid(userid);
                    }
                    RuleDataInterface ruleDataInterface = this.ruleData;
                    if (ruleDataInterface != null) {
                        ruleDataInterface.setUserid(userid);
                    }
                }
                BookChapter bookChapter = this.chapter;
                if (bookChapter == null) break block4;
                bookChapter.putVariable(key, value);
                break block5;
            }
            RuleDataInterface ruleDataInterface = this.ruleData;
            if (ruleDataInterface == null) break block5;
            ruleDataInterface.putVariable(key, value);
        }
        return value;
    }

    @NotNull
    public final String get(@NotNull String key) {
        Object object;
        block11: {
            Object object2;
            Object object3;
            block10: {
                Object object4;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                if (this.source != null) {
                    String string = this.source.getUserid();
                    if (string == null) {
                        string = "";
                    }
                    String userid = string;
                    BookChapter bookChapter = this.chapter;
                    if (bookChapter != null) {
                        bookChapter.setUserid(userid);
                    }
                    RuleDataInterface ruleDataInterface = this.ruleData;
                    if (ruleDataInterface != null) {
                        ruleDataInterface.setUserid(userid);
                    }
                }
                if ((object = this.chapter) == null || (object = ((BookChapter)object).getVariable(key)) == null) break block10;
                Object it = object4 = object;
                boolean bl = false;
                object = ((CharSequence)it).length() > 0 ? object4 : null;
                if (object != null) break block11;
            }
            if ((object3 = this.ruleData) != null && (object3 = object3.getVariable(key)) != null) {
                Object object5;
                Object it = object5 = object3;
                boolean bl = false;
                object2 = ((CharSequence)it).length() > 0 ? object5 : null;
            } else {
                object2 = object = null;
            }
            if (object2 == null) {
                object = "";
            }
        }
        return object;
    }

    public final void setCookie() {
        Object cookie;
        BaseSource baseSource = this.source;
        CookieStore store = baseSource != null ? baseSource.getCookieManger() : null;
        Object object = store;
        if (object == null || (object = ((CookieStore)object).getCookie(this.urlNoQuery)) == null) {
            object = "";
        }
        if (((CharSequence)(cookie = object)).length() > 0) {
            String key = null;
            key = "Cookie";
            Set<String> set = this.headerMap.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv.iterator();
            while (stringArray.hasNext()) {
                Object element$iv = stringArray.next();
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                String string = it;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = "Cookie";
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string3 = string.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string2, (Object)string3)) continue;
                key = it;
            }
            String oldc = this.headerMap.get(key);
            this.headerMap.remove(key);
            Object object2 = store;
            if (object2 != null && (object2 = ((CookieStore)object2).mergeCookies(stringArray = new String[]{oldc, cookie})) != null) {
                Object it = object2;
                boolean bl = false;
                this.headerMap.put("Cookie", (String)it);
            }
        }
        if (this.enabledCookieJar) {
            Map map = this.headerMap;
            String string = CacheManagerKt.getCookieJarHeader();
            Object object3 = this.source;
            if (object3 == null || (object3 = object3.getcookieJarHeaderid()) == null) {
                object3 = "";
            }
            Object object4 = object3;
            map.put(string, object4);
        } else {
            this.headerMap.remove(CacheManagerKt.getCookieJarHeader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object getStrResponseAwait(@Nullable String var1_1, @Nullable String var2_2, boolean var3_3, @NotNull Continuation<? super StrResponse> $completion) {
        if (!($completion instanceof getStrResponseAwait.1)) ** GOTO lbl-1000
        var28_5 = $completion;
        if ((var28_5.label & -2147483648) != 0) {
            var28_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ AnalyzeUrl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getStrResponseAwait(null, null, false, (Continuation<? super StrResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var31_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.type == null) break;
                var25_8 = StringUtils.INSTANCE;
                var24_9 = this.url;
                $continuation.L$0 = var24_9;
                $continuation.L$1 = var25_8;
                $continuation.label = 1;
                v0 = this.getByteArrayAwait((Continuation<? super byte[]>)$continuation);
                if (v0 == var31_7) {
                    return var31_7;
                }
                ** GOTO lbl27
            }
            case 1: {
                var25_8 = (StringUtils)$continuation.L$1;
                var24_9 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                var26_10 = v0;
                var29_11 = var25_8.byteToHexString((byte[])var26_10);
                var30_12 = var24_9;
                return new StrResponse(var30_12, var29_11);
            }
        }
        this.getLogger().info("ajaxurl:" + this.urlNoQuery + ",type:" + this.type);
        strResponse = new Ref.ObjectRef();
        this_$iv = this.concurrentRateLimiter;
        $i$f$withLimit = false;
        $continuation.L$0 = this;
        $continuation.L$1 = jsStr;
        $continuation.L$2 = sourceRegex;
        $continuation.L$3 = strResponse;
        $continuation.L$4 = this_$iv;
        $continuation.Z$0 = useWebView;
        $continuation.label = 2;
        v1 = this_$iv.getConcurrentRecord((Continuation<? super ConcurrentRecord>)$continuation);
        if (v1 == var31_7) {
            return var31_7;
        }
        ** GOTO lbl56
        {
            case 2: {
                $i$f$withLimit = false;
                useWebView = $continuation.Z$0;
                this_$iv = (ConcurrentRateLimiter)$continuation.L$4;
                strResponse = (Ref.ObjectRef)$continuation.L$3;
                sourceRegex = (String)$continuation.L$2;
                jsStr = (String)$continuation.L$1;
                this = (AnalyzeUrl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl56:
                // 2 sources

                var8_18 = (ConcurrentRecord)v1;
                $i$a$-withLimit-AnalyzeUrl$getStrResponseAwait$2 = false;
                this.setCookie();
                if (!this.useWebView || !useWebView) ** GOTO lbl106
                if (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()] != 2) ** GOTO lbl91
                var11_21 = this.headerMap.get("Content-Type");
                if (var11_21 == null || StringsKt.isBlank((CharSequence)var11_21) != false) {
                    if (((Map)this.fieldMap).isEmpty() == false || (var11_21 = (CharSequence)this.body) == null || StringsKt.isBlank((CharSequence)var11_21) != false) {
                        ((Map)this.headerMap).put("Content-Type", "application/x-www-form-urlencoded");
                        v2 = this.fieldMap.entrySet();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-entries>(...)");
                        this.body = CollectionsKt.joinToString$default((Iterable)v2, (CharSequence)"&", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getStrResponseAwait$lambda$26$lambda$22(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/CharSequence;)(), (int)30, null);
                    } else {
                        ((Map)this.headerMap).put("Content-Type", "application/json; charset=UTF-8");
                    }
                }
                v3 = App.INSTANCE.getWebviewbody();
                v4 = this.webJs;
                if (v4 == null) {
                    v4 = jsStr;
                }
                if ((v5 = this.getSource()) == null || (v5 = v5.getUsertocken()) == null) {
                    v5 = "";
                }
                v6 = GSONKt.getGSON().toJson(this.headerMap);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toJson(...)");
                v7 = this.body;
                if (v7 == null) {
                    v7 = "";
                }
                if ((v8 = sourceRegex) == null) {
                    v8 = "";
                }
                var23_26 = v3.invoke((Object)"", (Object)this.url, (Object)v4, v5, (Object)v6, (Object)v7, (Object)v8, (Object)"");
                this_$iv.fetchEnd(var8_18);
                return var23_26;
lbl91:
                // 2 sources

                v9 = App.INSTANCE.getWebview();
                v10 = this.webJs;
                if (v10 == null) {
                    v10 = var1_1;
                }
                if ((v11 = this.getSource()) == null || (v11 = v11.getUsertocken()) == null) {
                    v11 = "";
                }
                var11_22 = GSONKt.getGSON().toJson(this.headerMap);
                Intrinsics.checkNotNullExpressionValue((Object)var11_22, (String)"toJson(...)");
                v12 = sourceRegex;
                if (v12 == null) {
                    v12 = "";
                }
                var22_27 = v9.invoke((Object)"", (Object)this.url, (Object)v10, v11, (Object)var11_22, (Object)v12, (Object)"");
                this_$iv.fetchEnd(var8_18);
                return var22_27;
lbl106:
                // 2 sources

                v13 = this.source;
                if (!(v13 != null ? Intrinsics.areEqual((Object)v13.getPhonehttp(), (Object)Boxing.boxBoolean((boolean)true)) : false) && !this.usePhone) ** GOTO lbl145
                if (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()] != 2) ** GOTO lbl134
                var11_23 = this.headerMap.get("Content-Type");
                if (var11_23 == null || StringsKt.isBlank((CharSequence)var11_23) != false) {
                    if (((Map)this.fieldMap).isEmpty() == false || (var11_23 = (CharSequence)this.body) == null || StringsKt.isBlank((CharSequence)var11_23) != false) {
                        ((Map)this.headerMap).put("Content-Type", "application/x-www-form-urlencoded");
                        v14 = this.fieldMap.entrySet();
                        Intrinsics.checkNotNullExpressionValue(v14, (String)"<get-entries>(...)");
                        this.body = CollectionsKt.joinToString$default((Iterable)v14, (CharSequence)"&", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getStrResponseAwait$lambda$26$lambda$23(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/CharSequence;)(), (int)30, null);
                    } else {
                        ((Map)this.headerMap).put("Content-Type", "application/json; charset=UTF-8");
                    }
                }
                v15 = App.INSTANCE.getPost();
                v16 = this.body;
                if (v16 == null) {
                    v16 = "";
                }
                v17 = GSONKt.getGSON().toJson(this.headerMap);
                Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"toJson(...)");
                v18 = this.getSource();
                if (v18 == null || (v18 = v18.getUsertocken()) == null) {
                    v18 = "";
                }
                body = (JsonpResponse)v15.invoke((Object)this.url, (Object)v16, (Object)v17, v18, (Object)Boxing.boxBoolean((boolean)true));
                var21_28 = new StrResponse(body.getUrl(), body.body());
                this_$iv.fetchEnd(var8_18);
                return var21_28;
lbl134:
                // 2 sources

                v19 = App.INSTANCE.getGet();
                v20 = GSONKt.getGSON().toJson(this.headerMap);
                Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"toJson(...)");
                v21 = this.getSource();
                if (v21 == null || (v21 = v21.getUsertocken()) == null) {
                    v21 = "";
                }
                body = (JsonpResponse)v19.invoke((Object)this.url, (Object)v20, v21, (Object)Boxing.boxBoolean((boolean)true));
                var20_29 = new StrResponse(body.getUrl(), body.body());
                this_$iv.fetchEnd(var8_18);
                return var20_29;
lbl145:
                // 2 sources

                var14_30 = strResponse;
                $continuation.L$0 = strResponse;
                $continuation.L$1 = this_$iv;
                $continuation.L$2 = concurrentRecord$iv;
                $continuation.L$3 = var14_30;
                $continuation.L$4 = null;
                $continuation.label = 3;
                v22 = OkHttpClientKt.newCallStrResponse(this.getClient(), this.retry, (Function1<? super Request.Builder, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getStrResponseAwait$lambda$26$lambda$24(book.webBook.analyzeRule.AnalyzeUrl okhttp3.Request$Builder ), (Lokhttp3/Request$Builder;)Lkotlin/Unit;)((AnalyzeUrl)this), (Continuation<? super StrResponse>)$continuation);
                ** if (v22 != var31_7) goto lbl155
lbl154:
                // 1 sources

                return var31_7;
lbl155:
                // 1 sources

                ** GOTO lbl167
            }
            case 3: {
                $i$a$-withLimit-AnalyzeUrl$getStrResponseAwait$2 = false;
                $i$f$withLimit = false;
                var14_30 = (Ref.ObjectRef)$continuation.L$3;
                concurrentRecord$iv = (ConcurrentRecord)$continuation.L$2;
                this_$iv = (ConcurrentRateLimiter)$continuation.L$1;
                strResponse = (Ref.ObjectRef)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v22 = $result;
lbl167:
                    // 2 sources

                    var10_31 = (StrResponse)v22;
                    $i$a$-let-AnalyzeUrl$getStrResponseAwait$2$4 = false;
                    var12_32 = it.getRaw().body();
                    if (var12_32 != null && (var13_33 = var12_32.contentType()) != null && (var15_34 = var13_33.toString()) != null) {
                        var16_35 = var15_34;
                        v23 = AppPattern.INSTANCE.getXmlContentTypeRegex().matches(var16_35);
                    } else {
                        v23 = isXml = false;
                    }
                    if (!isXml) ** GOTO lbl-1000
                    v24 = it.getBody();
                    v25 = v24 != null && (v24 = StringsKt.trim((CharSequence)v24).toString()) != null ? !StringsKt.startsWith((String)v24, (String)"<?xml", (boolean)true) : false;
                    if (v25) {
                        v26 = new StrResponse(it.getRaw(), "<?xml version=\"1.0\"?>" + it.getBody());
                    } else lbl-1000:
                    // 2 sources

                    {
                        v26 = it;
                    }
                    var14_30.element = v26;
                    var19_37 = strResponse.element;
                    return var19_37;
                }
                catch (Throwable var18_38) {
                    throw var18_38;
                }
                finally {
                    this_$iv.fetchEnd(concurrentRecord$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getStrResponseAwait$default(AnalyzeUrl analyzeUrl, String string, String string2, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return analyzeUrl.getStrResponseAwait(string, string2, bl, (Continuation<? super StrResponse>)continuation);
    }

    @JvmOverloads
    @NotNull
    public final StrResponse getStrResponse(@Nullable String jsStr, @Nullable String sourceRegex, boolean useWebView) {
        return (StrResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super StrResponse>, Object>(this, jsStr, sourceRegex, useWebView, null){
            int label;
            final /* synthetic */ AnalyzeUrl this$0;
            final /* synthetic */ String $jsStr;
            final /* synthetic */ String $sourceRegex;
            final /* synthetic */ boolean $useWebView;
            {
                this.this$0 = $receiver;
                this.$jsStr = $jsStr;
                this.$sourceRegex = $sourceRegex;
                this.$useWebView = $useWebView;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getStrResponseAwait(this.$jsStr, this.$sourceRegex, this.$useWebView, (Continuation<? super StrResponse>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super StrResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ StrResponse getStrResponse$default(AnalyzeUrl analyzeUrl, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return analyzeUrl.getStrResponse(string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object getResponseAwait(@NotNull Continuation<? super Response> $completion) {
        if (!($completion instanceof getResponseAwait.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AnalyzeUrl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getResponseAwait((Continuation<? super Response>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this_$iv = this.concurrentRateLimiter;
                $i$f$withLimit = false;
                $continuation.L$0 = this;
                $continuation.L$1 = this_$iv;
                $continuation.label = 1;
                v0 = this_$iv.getConcurrentRecord((Continuation<? super ConcurrentRecord>)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                $i$f$withLimit = false;
                this_$iv = (ConcurrentRateLimiter)$continuation.L$1;
                this = (AnalyzeUrl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                concurrentRecord$iv = (ConcurrentRecord)v0;
                $i$a$-withLimit-AnalyzeUrl$getResponseAwait$2 = false;
                this.setCookie();
                $continuation.L$0 = this_$iv;
                $continuation.L$1 = concurrentRecord$iv;
                $continuation.label = 2;
                v1 = OkHttpClientKt.newCallResponse(this.getClient(), this.retry, (Function1<? super Request.Builder, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getResponseAwait$lambda$28$lambda$27(book.webBook.analyzeRule.AnalyzeUrl okhttp3.Request$Builder ), (Lokhttp3/Request$Builder;)Lkotlin/Unit;)((AnalyzeUrl)this), (Continuation<? super Response>)$continuation);
                ** if (v1 != var10_4) goto lbl38
lbl37:
                // 1 sources

                return var10_4;
lbl38:
                // 1 sources

                ** GOTO lbl48
            }
            case 2: {
                $i$f$withLimit = false;
                $i$a$-withLimit-AnalyzeUrl$getResponseAwait$2 = false;
                concurrentRecord$iv = (ConcurrentRecord)$continuation.L$1;
                this_$iv = (ConcurrentRateLimiter)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    var7_14 = response = (Response)v1;
                    return var7_14;
                }
                catch (Throwable var6_13) {
                    throw var6_13;
                }
                finally {
                    this_$iv.fetchEnd(concurrentRecord$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final OkHttpClient getClient() {
        OkHttpClient client = HttpHelperKt.getProxyClient$default(this.proxy, null, 2, null);
        if (this.readTimeout == null) {
            return client;
        }
        return client.newBuilder().readTimeout(this.readTimeout.longValue(), TimeUnit.MILLISECONDS).callTimeout(Math.max(60000L, this.readTimeout * (long)2), TimeUnit.MILLISECONDS).build();
    }

    @NotNull
    public final Response getResponse() {
        return (Response)BuildersKt.runBlocking((CoroutineContext)this.coroutineContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Response>, Object>(this, null){
            int label;
            final /* synthetic */ AnalyzeUrl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getResponseAwait((Continuation<? super Response>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Response> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final byte[] getByteArrayIfDataUri() {
        MatchResult dataUriFindResult = Regex.find$default((Regex)AppPattern.INSTANCE.getDataUriRegex(), (CharSequence)this.urlNoQuery, (int)0, (int)2, null);
        if (dataUriFindResult != null) {
            String dataUriBase64 = (String)dataUriFindResult.getGroupValues().get(1);
            byte[] byteArray = Base64.decode(dataUriBase64, 0);
            return byteArray;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getByteArrayAwait(@NotNull Continuation<? super byte[]> $completion) {
        if (!($completion instanceof getByteArrayAwait.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ AnalyzeUrl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getByteArrayAwait((Continuation<? super byte[]>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getByteArrayIfDataUri();
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-AnalyzeUrl$getByteArrayAwait$2 = false;
                    return it;
                }
                $continuation.label = 1;
                v1 = this.getResponseAwait((Continuation<? super Response>)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                v2 = ((Response)v1).body();
                Intrinsics.checkNotNull((Object)v2);
                return v2.bytes();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final byte[] getByteArray() {
        return (byte[])BuildersKt.runBlocking((CoroutineContext)this.coroutineContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, null){
            int label;
            final /* synthetic */ AnalyzeUrl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getByteArrayAwait((Continuation<? super byte[]>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getInputStreamAwait(@NotNull Continuation<? super InputStream> $completion) {
        if (!($completion instanceof getInputStreamAwait.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ AnalyzeUrl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getInputStreamAwait((Continuation<? super InputStream>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getByteArrayIfDataUri();
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-AnalyzeUrl$getInputStreamAwait$2 = false;
                    return new ByteArrayInputStream(it);
                }
                $continuation.label = 1;
                v1 = this.getResponseAwait((Continuation<? super Response>)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl25:
                // 2 sources

                v2 = ((Response)v1).body();
                Intrinsics.checkNotNull((Object)v2);
                return v2.byteStream();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final int getToastc() {
        return this.toastc;
    }

    public final void setToastc(int n) {
        this.toastc = n;
    }

    @Override
    public void toast(@Nullable Object msg) {
        this.getLogger().info("toast:" + msg);
        if (this.toastc > 10) {
            throw new Exception("toast \u8c03\u7528\u6b21\u6570\u8d85\u8fc710\u6b21");
        }
        ++this.toastc;
        Function2<String, String, Unit> function2 = App.INSTANCE.getToast();
        String string = String.valueOf(msg);
        Object object = this.getSource();
        if (object == null || (object = object.getUsertocken()) == null) {
            object = "";
        }
        function2.invoke((Object)string, object);
    }

    @Override
    public void longToast(@Nullable Object msg) {
        this.toast(msg);
    }

    @NotNull
    public final InputStream getInputStream() {
        return (InputStream)BuildersKt.runBlocking((CoroutineContext)this.coroutineContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super InputStream>, Object>(this, null){
            int label;
            final /* synthetic */ AnalyzeUrl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getInputStreamAwait((Continuation<? super InputStream>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super InputStream> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public final Object upload(@NotNull String fileName, @NotNull Object file, @NotNull String contentType, @NotNull Continuation<? super StrResponse> $completion) {
        return OkHttpClientKt.newCallStrResponse(HttpHelperKt.getProxyClient$default(this.proxy, null, 2, null), this.retry, (Function1<? super Request.Builder, Unit>)((Function1)arg_0 -> AnalyzeUrl.upload$lambda$32(this, fileName, file, contentType, arg_0)), $completion);
    }

    @NotNull
    public final String getUserAgent() {
        String string = MaputilKt.get(this.headerMap, "User-Agent", true);
        if (string == null) {
            string = AppConst.INSTANCE.getUserAgent();
        }
        return string;
    }

    public final boolean isPost() {
        return this.method == RequestMethod.POST;
    }

    @Override
    @Nullable
    public BaseSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String androidId() {
        return JsExtensions.DefaultImpls.androidId(this);
    }

    @Override
    public void binding(@NotNull ScriptBindings bindings) {
        JsExtensions.DefaultImpls.binding(this, bindings);
    }

    @Override
    @NotNull
    public String qread() {
        return JsExtensions.DefaultImpls.qread(this);
    }

    @Override
    @Nullable
    public String ajax(@NotNull String urlStr) {
        return JsExtensions.DefaultImpls.ajax(this, urlStr);
    }

    @Override
    @NotNull
    public StrResponse[] ajaxAll(@NotNull String[] urlList) {
        return JsExtensions.DefaultImpls.ajaxAll(this, urlList);
    }

    @Override
    @NotNull
    public StrResponse connect(@NotNull String urlStr) {
        return JsExtensions.DefaultImpls.connect(this, urlStr);
    }

    @Override
    @NotNull
    public StrResponse connect(@NotNull String urlStr, @Nullable String header) {
        return JsExtensions.DefaultImpls.connect(this, urlStr, header);
    }

    @Override
    @NotNull
    public StrResponse webview(@Nullable String html, @Nullable String url, @Nullable String js) {
        return JsExtensions.DefaultImpls.webview(this, html, url, js);
    }

    @Override
    @Nullable
    public String webViewGetSource(@Nullable String html, @Nullable String url, @Nullable String js, @NotNull String sourceRegex) {
        return JsExtensions.DefaultImpls.webViewGetSource(this, html, url, js, sourceRegex);
    }

    @Override
    @Nullable
    public String webViewGetOverrideUrl(@Nullable String html, @Nullable String url, @Nullable String js, @NotNull String overrideUrlRegex) {
        return JsExtensions.DefaultImpls.webViewGetOverrideUrl(this, html, url, js, overrideUrlRegex);
    }

    @Override
    @Nullable
    public String webView(@Nullable String html, @Nullable String url, @Nullable String js) {
        return JsExtensions.DefaultImpls.webView(this, html, url, js);
    }

    @Override
    @NotNull
    public String getWebViewUA() {
        return JsExtensions.DefaultImpls.getWebViewUA(this);
    }

    @Override
    @NotNull
    public String getWebViewUANEW() {
        return JsExtensions.DefaultImpls.getWebViewUANEW(this);
    }

    @Override
    @NotNull
    public String importScript(@NotNull String path) {
        return JsExtensions.DefaultImpls.importScript(this, path);
    }

    @Override
    @Nullable
    public String cacheFile(@NotNull String urlStr) {
        return JsExtensions.DefaultImpls.cacheFile(this, urlStr);
    }

    @Override
    @NotNull
    public String cacheFile(@NotNull String urlStr, int saveTime) {
        return JsExtensions.DefaultImpls.cacheFile(this, urlStr, saveTime);
    }

    @Override
    @NotNull
    public String getCookie(@NotNull String tag, @Nullable String key) {
        return JsExtensions.DefaultImpls.getCookie(this, tag, key);
    }

    @Override
    @NotNull
    public String getCookie(@NotNull String key) {
        return JsExtensions.DefaultImpls.getCookie(this, key);
    }

    @Override
    @NotNull
    public StrResponse startBrowserAwait(@NotNull String url, @NotNull String title, boolean refetchAfterSuccess) {
        return JsExtensions.DefaultImpls.startBrowserAwait(this, url, title, refetchAfterSuccess);
    }

    @Override
    @NotNull
    public StrResponse startBrowserAwait(@NotNull String url, @NotNull String title) {
        return JsExtensions.DefaultImpls.startBrowserAwait(this, url, title);
    }

    @Override
    public void startBrowserDp(@NotNull String url, @NotNull String title) {
        JsExtensions.DefaultImpls.startBrowserDp(this, url, title);
    }

    @Override
    public void startBrowser(@NotNull String url, @NotNull String title) {
        JsExtensions.DefaultImpls.startBrowser(this, url, title);
    }

    @Override
    @NotNull
    public String downloadFile(@NotNull String url) {
        return JsExtensions.DefaultImpls.downloadFile(this, url);
    }

    @Override
    @NotNull
    public String downloadFile(@NotNull String content, @NotNull String url) {
        return JsExtensions.DefaultImpls.downloadFile(this, content, url);
    }

    @Override
    @NotNull
    public Connection.Response get(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.get(this, urlStr, headers);
    }

    @Override
    @NotNull
    public Connection.Response getusePhone(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.getusePhone(this, urlStr, headers);
    }

    @Override
    @NotNull
    public Connection.Response head(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.head(this, urlStr, headers);
    }

    @Override
    @NotNull
    public Connection.Response headusePhone(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.headusePhone(this, urlStr, headers);
    }

    @Override
    @NotNull
    public String getVerificationCode(@NotNull String imageUrl) {
        return JsExtensions.DefaultImpls.getVerificationCode(this, imageUrl);
    }

    @Override
    @NotNull
    public String getVerificationCodeusePhone(@NotNull String imageUrl) {
        return JsExtensions.DefaultImpls.getVerificationCodeusePhone(this, imageUrl);
    }

    @Override
    @NotNull
    public Connection.Response post(@NotNull String urlStr, @NotNull String body, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.post(this, urlStr, body, headers);
    }

    @Override
    @NotNull
    public Connection.Response postusePhone(@NotNull String urlStr, @NotNull String body, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.postusePhone(this, urlStr, body, headers);
    }

    @Override
    @NotNull
    public byte[] strToBytes(@NotNull String str) {
        return JsExtensions.DefaultImpls.strToBytes(this, str);
    }

    @Override
    @NotNull
    public byte[] strToBytes(@NotNull String str, @NotNull String charset) {
        return JsExtensions.DefaultImpls.strToBytes(this, str, charset);
    }

    @Override
    @NotNull
    public String bytesToStr(@NotNull byte[] bytes2) {
        return JsExtensions.DefaultImpls.bytesToStr(this, bytes2);
    }

    @Override
    @NotNull
    public String bytesToStr(@NotNull byte[] bytes2, @NotNull String charset) {
        return JsExtensions.DefaultImpls.bytesToStr(this, bytes2, charset);
    }

    @Override
    @NotNull
    public String base64Decode(@NotNull String str) {
        return JsExtensions.DefaultImpls.base64Decode(this, str);
    }

    @Override
    @NotNull
    public String base64Decode(@Nullable String str, @NotNull String charset) {
        return JsExtensions.DefaultImpls.base64Decode((JsExtensions)this, str, charset);
    }

    @Override
    @NotNull
    public String base64Decode(@NotNull String str, int flags) {
        return JsExtensions.DefaultImpls.base64Decode((JsExtensions)this, str, flags);
    }

    @Override
    @Nullable
    public byte[] base64DecodeToByteArray(@Nullable String str) {
        return JsExtensions.DefaultImpls.base64DecodeToByteArray(this, str);
    }

    @Override
    @Nullable
    public byte[] base64DecodeToByteArray(@Nullable String str, int flags) {
        return JsExtensions.DefaultImpls.base64DecodeToByteArray(this, str, flags);
    }

    @Override
    @Nullable
    public String base64Encode(@NotNull String str) {
        return JsExtensions.DefaultImpls.base64Encode(this, str);
    }

    @Override
    @Nullable
    public String base64Encode(@NotNull String str, int flags) {
        return JsExtensions.DefaultImpls.base64Encode(this, str, flags);
    }

    @Override
    @Nullable
    public byte[] hexDecodeToByteArray(@NotNull String hex) {
        return JsExtensions.DefaultImpls.hexDecodeToByteArray(this, hex);
    }

    @Override
    @Nullable
    public String hexDecodeToString(@NotNull String hex) {
        return JsExtensions.DefaultImpls.hexDecodeToString(this, hex);
    }

    @Override
    @Nullable
    public String hexEncodeToString(@NotNull String utf8) {
        return JsExtensions.DefaultImpls.hexEncodeToString(this, utf8);
    }

    @Override
    @Nullable
    public String timeFormatUTC(long time, @NotNull String format, int sh) {
        return JsExtensions.DefaultImpls.timeFormatUTC(this, time, format, sh);
    }

    @Override
    @NotNull
    public String timeFormat(long time) {
        return JsExtensions.DefaultImpls.timeFormat(this, time);
    }

    @Override
    @NotNull
    public String utf8ToGbk(@NotNull String str) {
        return JsExtensions.DefaultImpls.utf8ToGbk(this, str);
    }

    @Override
    @NotNull
    public String encodeURI(@NotNull String str) {
        return JsExtensions.DefaultImpls.encodeURI(this, str);
    }

    @Override
    @NotNull
    public String encodeURI(@NotNull String str, @NotNull String enc) {
        return JsExtensions.DefaultImpls.encodeURI(this, str, enc);
    }

    @Override
    @NotNull
    public String htmlFormat(@NotNull String str) {
        return JsExtensions.DefaultImpls.htmlFormat(this, str);
    }

    @Override
    @NotNull
    public String t2s(@NotNull String text) {
        return JsExtensions.DefaultImpls.t2s(this, text);
    }

    @Override
    @NotNull
    public String s2t(@NotNull String text) {
        return JsExtensions.DefaultImpls.s2t(this, text);
    }

    @Override
    @NotNull
    public File getFile(@NotNull String path) {
        return JsExtensions.DefaultImpls.getFile(this, path);
    }

    @Override
    @Nullable
    public byte[] readFile(@NotNull String path) {
        return JsExtensions.DefaultImpls.readFile(this, path);
    }

    @Override
    @NotNull
    public String readTxtFile(@NotNull String path) {
        return JsExtensions.DefaultImpls.readTxtFile(this, path);
    }

    @Override
    @NotNull
    public String readTxtFile(@NotNull String path, @NotNull String charsetName) {
        return JsExtensions.DefaultImpls.readTxtFile(this, path, charsetName);
    }

    @Override
    public void deleteFile(@NotNull String path) {
        JsExtensions.DefaultImpls.deleteFile(this, path);
    }

    @Override
    @NotNull
    public String unzipFile(@NotNull String zipPath) {
        return JsExtensions.DefaultImpls.unzipFile(this, zipPath);
    }

    @Override
    @NotNull
    public String getTxtInFolder(@NotNull String unzipPath) {
        return JsExtensions.DefaultImpls.getTxtInFolder(this, unzipPath);
    }

    @Override
    @NotNull
    public String getZipStringContent(@NotNull String url, @NotNull String path) {
        return JsExtensions.DefaultImpls.getZipStringContent(this, url, path);
    }

    @Override
    @NotNull
    public String getZipStringContent(@NotNull String url, @NotNull String path, @NotNull String charsetName) {
        return JsExtensions.DefaultImpls.getZipStringContent(this, url, path, charsetName);
    }

    @Override
    @Nullable
    public byte[] getZipByteArrayContent(@NotNull String url, @NotNull String path) {
        return JsExtensions.DefaultImpls.getZipByteArrayContent(this, url, path);
    }

    @Override
    @Nullable
    public QueryTTF queryBase64TTF(@Nullable String base64) {
        return JsExtensions.DefaultImpls.queryBase64TTF(this, base64);
    }

    @Override
    @Nullable
    public QueryTTF queryTTF(@Nullable String str) {
        return JsExtensions.DefaultImpls.queryTTF(this, str);
    }

    @Override
    @NotNull
    public String replaceFont(@NotNull String text, @Nullable QueryTTF font1, @Nullable QueryTTF font2) {
        return JsExtensions.DefaultImpls.replaceFont(this, text, font1, font2);
    }

    @Override
    @Nullable
    public String toNumChapter(@Nullable String s) {
        return JsExtensions.DefaultImpls.toNumChapter(this, s);
    }

    @Override
    @NotNull
    public JsURL toURL(@NotNull String urlStr) {
        return JsExtensions.DefaultImpls.toURL(this, urlStr);
    }

    @Override
    @NotNull
    public JsURL toURL(@NotNull String url, @Nullable String baseUrl) {
        return JsExtensions.DefaultImpls.toURL(this, url, baseUrl);
    }

    @Override
    @Nullable
    public Object log(@Nullable Object msg) {
        return JsExtensions.DefaultImpls.log(this, msg);
    }

    @Override
    public void logType(@Nullable Object any) {
        JsExtensions.DefaultImpls.logType(this, any);
    }

    @Override
    @NotNull
    public String randomUUID() {
        return JsExtensions.DefaultImpls.randomUUID(this);
    }

    @Override
    public void openUrl(@NotNull String url) {
        JsExtensions.DefaultImpls.openUrl(this, url);
    }

    @Override
    public void openUrl(@NotNull String url, @Nullable String mimeType) {
        JsExtensions.DefaultImpls.openUrl(this, url, mimeType);
    }

    @Override
    @NotNull
    public String md5Encode(@NotNull String str) {
        return JsExtensions.DefaultImpls.md5Encode(this, str);
    }

    @Override
    @NotNull
    public String md5Encode16(@NotNull String str) {
        return JsExtensions.DefaultImpls.md5Encode16(this, str);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @Nullable byte[] key, @Nullable byte[] iv) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key, iv);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @NotNull byte[] key) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @NotNull String key) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @NotNull String key, @Nullable String iv) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key, iv);
    }

    @Override
    @NotNull
    public AsymmetricCrypto createAsymmetricCrypto(@NotNull String transformation) {
        return JsExtensions.DefaultImpls.createAsymmetricCrypto(this, transformation);
    }

    @Override
    @NotNull
    public Sign createSign(@NotNull String algorithm) {
        return JsExtensions.DefaultImpls.createSign(this, algorithm);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decrypt(str)", imports={}))
    @Nullable
    public byte[] aesDecodeToByteArray(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesDecodeToByteArray(this, str, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(str)", imports={}))
    @Nullable
    public String aesDecodeToString(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesDecodeToString(this, str, key, transformation, iv);
    }

    @Override
    @NotNull
    public String getjs(@NotNull String js) {
        return JsExtensions.DefaultImpls.getjs(this, js);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String aesDecodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesDecodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decrypt(str)", imports={}))
    @Nullable
    public byte[] aesBase64DecodeToByteArray(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesBase64DecodeToByteArray(this, str, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(str)", imports={}))
    @Nullable
    public String aesBase64DecodeToString(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesBase64DecodeToString(this, str, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decrypt(data)", imports={}))
    @Nullable
    public byte[] aesEncodeToByteArray(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToByteArray(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String aesEncodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data).toByteArray()", imports={}))
    @Nullable
    public byte[] aesEncodeToBase64ByteArray(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToBase64ByteArray(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String aesEncodeToBase64String(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToBase64String(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String aesEncodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String desDecodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desDecodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String desBase64DecodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desBase64DecodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encrypt(data)", imports={}))
    @Nullable
    public String desEncodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desEncodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String desEncodeToBase64String(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desEncodeToBase64String(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String tripleDESDecodeStr(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESDecodeStr(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String tripleDESDecodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESDecodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String tripleDESEncodeBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESEncodeBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String tripleDESEncodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESEncodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @NotNull
    public String digestHex(@NotNull String data, @NotNull String algorithm) {
        return JsExtensions.DefaultImpls.digestHex(this, data, algorithm);
    }

    @Override
    @NotNull
    public String digestBase64Str(@NotNull String data, @NotNull String algorithm) {
        return JsExtensions.DefaultImpls.digestBase64Str(this, data, algorithm);
    }

    @Override
    @NotNull
    public String HMacHex(@NotNull String data, @NotNull String algorithm, @NotNull String key) {
        return JsExtensions.DefaultImpls.HMacHex(this, data, algorithm, key);
    }

    @Override
    @NotNull
    public String HMacBase64(@NotNull String data, @NotNull String algorithm, @NotNull String key) {
        return JsExtensions.DefaultImpls.HMacBase64(this, data, algorithm, key);
    }

    @JvmOverloads
    @NotNull
    public final StrResponse getStrResponse(@Nullable String jsStr, @Nullable String sourceRegex) {
        return AnalyzeUrl.getStrResponse$default(this, jsStr, sourceRegex, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final StrResponse getStrResponse(@Nullable String jsStr) {
        return AnalyzeUrl.getStrResponse$default(this, jsStr, null, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final StrResponse getStrResponse() {
        return AnalyzeUrl.getStrResponse$default(this, null, null, false, 7, null);
    }

    private static final String replaceKeyPageJs$lambda$3(AnalyzeUrl this$0, String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = AnalyzeUrl.evalJS$default(this$0, it, null, 2, null);
        if (object == null) {
            object = "";
        }
        Object jsEval = object;
        if (jsEval instanceof String) {
            string = (String)jsEval;
        } else if (jsEval instanceof Double && ((Number)jsEval).doubleValue() % 1.0 == 0.0) {
            String string2 = "%.0f";
            Object[] objectArray = new Object[]{jsEval};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string = jsEval.toString();
        }
        return string;
    }

    private static final CharSequence getStrResponseAwait$lambda$26$lambda$22(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "=" + it.getValue();
    }

    private static final CharSequence getStrResponseAwait$lambda$26$lambda$23(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + "=" + it.getValue();
    }

    private static final Unit getStrResponseAwait$lambda$26$lambda$24(AnalyzeUrl this$0, Request.Builder $this$newCallStrResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$newCallStrResponse, (String)"$this$newCallStrResponse");
        OkHttpClientKt.addHeaders($this$newCallStrResponse, (Map<String, String>)this$0.headerMap);
        if (WhenMappings.$EnumSwitchMapping$0[this$0.method.ordinal()] == 2) {
            CharSequence charSequence;
            $this$newCallStrResponse.url(this$0.urlNoQuery);
            String contentType = this$0.headerMap.get("Content-Type");
            String body = this$0.body;
            if (!((Map)this$0.fieldMap).isEmpty() || (charSequence = (CharSequence)body) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                OkHttpClientKt.postForm($this$newCallStrResponse, (Map<String, String>)this$0.fieldMap, true);
            } else {
                charSequence = contentType;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    RequestBody requestBody = RequestBody.Companion.create(body, MediaType.Companion.get(contentType));
                    $this$newCallStrResponse.post(requestBody);
                } else {
                    OkHttpClientKt.postJson($this$newCallStrResponse, body);
                }
            }
        } else {
            OkHttpClientKt.get($this$newCallStrResponse, this$0.urlNoQuery, (Map<String, String>)this$0.fieldMap, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getResponseAwait$lambda$28$lambda$27(AnalyzeUrl this$0, Request.Builder $this$newCallResponse) {
        Intrinsics.checkNotNullParameter((Object)$this$newCallResponse, (String)"$this$newCallResponse");
        OkHttpClientKt.addHeaders($this$newCallResponse, (Map<String, String>)this$0.headerMap);
        if (WhenMappings.$EnumSwitchMapping$0[this$0.method.ordinal()] == 2) {
            CharSequence charSequence;
            $this$newCallResponse.url(this$0.urlNoQuery);
            String contentType = this$0.headerMap.get("Content-Type");
            String body = this$0.body;
            if (!((Map)this$0.fieldMap).isEmpty() || (charSequence = (CharSequence)body) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                OkHttpClientKt.postForm($this$newCallResponse, (Map<String, String>)this$0.fieldMap, true);
            } else {
                charSequence = contentType;
                if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                    RequestBody requestBody = RequestBody.Companion.create(body, MediaType.Companion.get(contentType));
                    $this$newCallResponse.post(requestBody);
                } else {
                    OkHttpClientKt.postJson($this$newCallResponse, body);
                }
            }
        } else {
            OkHttpClientKt.get($this$newCallResponse, this$0.urlNoQuery, (Map<String, String>)this$0.fieldMap, true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit upload$lambda$32(AnalyzeUrl this$0, String $fileName, Object $file, String $contentType, Request.Builder $this$newCallStrResponse) {
        Object $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22;
        Object $this$fromJsonObject$iv;
        Intrinsics.checkNotNullParameter((Object)$this$newCallStrResponse, (String)"$this$newCallStrResponse");
        $this$newCallStrResponse.url(this$0.urlNoQuery);
        Gson gson = GSONKt.getGSON();
        String json$iv = this$0.body;
        boolean $i$f$fromJsonObject = false;
        try {
            boolean $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = false;
            boolean $i$f$genericType = false;
            Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            Object object = $this$fromJsonObject$iv.fromJson(json$iv, type);
            if (!(object instanceof HashMap)) {
                object = null;
            }
            $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = Result.constructor-impl((Object)((HashMap)object));
        }
        catch (Throwable $i$f$genericType) {
            $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$f$genericType));
        }
        $this$fromJsonObject$iv = $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22;
        Object object = Result.isFailure-impl((Object)$this$fromJsonObject$iv) ? null : $this$fromJsonObject$iv;
        Intrinsics.checkNotNull((Object)object);
        HashMap bodyMap = (HashMap)object;
        Map $this$forEach$iv = bodyMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)entry.getValue().toString(), (Object)"fileRequest")) continue;
            Map map = bodyMap;
            Object k = entry.getKey();
            Object object2 = new Pair[]{new Pair((Object)"fileName", (Object)$fileName), new Pair((Object)"file", $file), new Pair((Object)"contentType", (Object)$contentType)};
            object2 = MapsKt.mapOf((Pair[])object2);
            map.put(k, object2);
        }
        OkHttpClientKt.postMultipart($this$newCallStrResponse, this$0.type, bodyMap);
        return Unit.INSTANCE;
    }

    static {
        Pattern pattern = Pattern.compile("\\s*,\\s*(?=\\{)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        paramPattern = pattern;
        pagePattern = Pattern.compile("<(.*?)>");
        concurrentRecordMap = new HashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lbook/webBook/analyzeRule/AnalyzeUrl$Companion;", "", "<init>", "()V", "paramPattern", "Ljava/util/regex/Pattern;", "getParamPattern", "()Ljava/util/regex/Pattern;", "pagePattern", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "concurrentRecordMap", "Ljava/util/HashMap;", "", "Lbook/webBook/analyzeRule/AnalyzeUrl$ConcurrentRecord;", "Lkotlin/collections/HashMap;", "book"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getParamPattern() {
            return paramPattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lbook/webBook/analyzeRule/AnalyzeUrl$ConcurrentRecord;", "", "isConcurrent", "", "time", "", "frequency", "", "<init>", "(ZJI)V", "()Z", "getTime", "()J", "setTime", "(J)V", "getFrequency", "()I", "setFrequency", "(I)V", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "book"})
    public static final class ConcurrentRecord {
        private final boolean isConcurrent;
        private long time;
        private int frequency;

        public ConcurrentRecord(boolean isConcurrent, long time, int frequency) {
            this.isConcurrent = isConcurrent;
            this.time = time;
            this.frequency = frequency;
        }

        public final boolean isConcurrent() {
            return this.isConcurrent;
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }

        public final int getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(int n) {
            this.frequency = n;
        }

        public final boolean component1() {
            return this.isConcurrent;
        }

        public final long component2() {
            return this.time;
        }

        public final int component3() {
            return this.frequency;
        }

        @NotNull
        public final ConcurrentRecord copy(boolean isConcurrent, long time, int frequency) {
            return new ConcurrentRecord(isConcurrent, time, frequency);
        }

        public static /* synthetic */ ConcurrentRecord copy$default(ConcurrentRecord concurrentRecord, boolean bl, long l, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = concurrentRecord.isConcurrent;
            }
            if ((n2 & 2) != 0) {
                l = concurrentRecord.time;
            }
            if ((n2 & 4) != 0) {
                n = concurrentRecord.frequency;
            }
            return concurrentRecord.copy(bl, l, n);
        }

        @NotNull
        public String toString() {
            return "ConcurrentRecord(isConcurrent=" + this.isConcurrent + ", time=" + this.time + ", frequency=" + this.frequency + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isConcurrent);
            result = result * 31 + Long.hashCode(this.time);
            result = result * 31 + Integer.hashCode(this.frequency);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConcurrentRecord)) {
                return false;
            }
            ConcurrentRecord concurrentRecord = (ConcurrentRecord)other;
            if (this.isConcurrent != concurrentRecord.isConcurrent) {
                return false;
            }
            if (this.time != concurrentRecord.time) {
                return false;
            }
            return this.frequency == concurrentRecord.frequency;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0018\b\u0086\b\u0018\u00002\u00020\u0001B\u007f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0017\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\r\u001a\u00020\u001cJ\u000e\u0010\r\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u001f\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010 J\u0010\u0010!\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010\"\u001a\u0004\u0018\u00010\u0003J\u0010\u0010#\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010$\u001a\u0004\u0018\u00010\u0003J\u0010\u0010%\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\b\u0010&\u001a\u0004\u0018\u00010\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J\u0010\u0010+\u001a\u0004\u0018\u00010\bH\u00c2\u0003\u00a2\u0006\u0002\u0010,J\u000b\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0001H\u00c2\u0003J\u0086\u0001\u00102\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001\u00a2\u0006\u0002\u00103J\u0013\u00104\u001a\u00020\u001c2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\bH\u00d6\u0001J\t\u00107\u001a\u00020\u0003H\u00d6\u0001R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lbook/webBook/analyzeRule/AnalyzeUrl$UrlOption;", "", "method", "", "charset", "headers", "body", "retry", "", "type", "webView", "webJs", "js", "usePhone", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "Ljava/lang/Integer;", "setMethod", "", "value", "getMethod", "setCharset", "getCharset", "setRetry", "getRetry", "setType", "getType", "useWebView", "", "boolean", "setHeaders", "getHeaderMap", "", "setBody", "getBody", "setWebJs", "getWebJs", "setJs", "getJs", "component1", "component2", "component3", "component4", "component5", "()Ljava/lang/Integer;", "component6", "component7", "component8", "component9", "component10", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lbook/webBook/analyzeRule/AnalyzeUrl$UrlOption;", "equals", "other", "hashCode", "toString", "book"})
    @SourceDebugExtension(value={"SMAP\nAnalyzeUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeUrl.kt\nbook/webBook/analyzeRule/AnalyzeUrl$UrlOption\n+ 2 GSON.kt\nbook/util/GSONKt\n*L\n1#1,727:1\n33#2,2:728\n30#2:730\n33#2,2:731\n30#2:733\n33#2,2:734\n30#2:736\n39#2,2:737\n*S KotlinDebug\n*F\n+ 1 AnalyzeUrl.kt\nbook/webBook/analyzeRule/AnalyzeUrl$UrlOption\n*L\n677#1:728,2\n677#1:730\n684#1:731,2\n684#1:733\n692#1:734,2\n692#1:736\n693#1:737,2\n*E\n"})
    public static final class UrlOption {
        @Nullable
        private String method;
        @Nullable
        private String charset;
        @Nullable
        private Object headers;
        @Nullable
        private Object body;
        @Nullable
        private Integer retry;
        @Nullable
        private String type;
        @Nullable
        private Object webView;
        @Nullable
        private String webJs;
        @Nullable
        private String js;
        @Nullable
        private Object usePhone;

        public UrlOption(@Nullable String method, @Nullable String charset, @Nullable Object headers, @Nullable Object body, @Nullable Integer retry, @Nullable String type, @Nullable Object webView, @Nullable String webJs, @Nullable String js, @Nullable Object usePhone) {
            this.method = method;
            this.charset = charset;
            this.headers = headers;
            this.body = body;
            this.retry = retry;
            this.type = type;
            this.webView = webView;
            this.webJs = webJs;
            this.js = js;
            this.usePhone = usePhone;
        }

        public /* synthetic */ UrlOption(String string, String string2, Object object, Object object2, Integer n, String string3, Object object3, String string4, String string5, Object object4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                object = null;
            }
            if ((n2 & 8) != 0) {
                object2 = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            if ((n2 & 0x20) != 0) {
                string3 = null;
            }
            if ((n2 & 0x40) != 0) {
                object3 = null;
            }
            if ((n2 & 0x80) != 0) {
                string4 = null;
            }
            if ((n2 & 0x100) != 0) {
                string5 = null;
            }
            if ((n2 & 0x200) != 0) {
                object4 = null;
            }
            this(string, string2, object, object2, n, string3, object3, string4, string5, object4);
        }

        public final void setMethod(@Nullable String value) {
            CharSequence charSequence = value;
            this.method = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
        }

        @Nullable
        public final String getMethod() {
            return this.method;
        }

        public final void setCharset(@Nullable String value) {
            CharSequence charSequence = value;
            this.charset = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
        }

        @Nullable
        public final String getCharset() {
            return this.charset;
        }

        public final void setRetry(@Nullable String value) {
            CharSequence charSequence = value;
            this.retry = charSequence == null || charSequence.length() == 0 ? null : StringsKt.toIntOrNull((String)value);
        }

        public final int getRetry() {
            Integer n = this.retry;
            return n != null ? n : 0;
        }

        public final void setType(@Nullable String value) {
            CharSequence charSequence = value;
            this.type = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        public final boolean useWebView() {
            Object object = this.webView;
            return object != null && !Intrinsics.areEqual((Object)object, (Object)"") && !Intrinsics.areEqual((Object)object, (Object)false) && !Intrinsics.areEqual((Object)object, (Object)"false");
        }

        public final boolean usePhone() {
            Object object = this.usePhone;
            return object != null && !Intrinsics.areEqual((Object)object, (Object)"") && !Intrinsics.areEqual((Object)object, (Object)false) && !Intrinsics.areEqual((Object)object, (Object)"false");
        }

        public final void usePhone(boolean bl) {
            this.usePhone = bl ? Boolean.valueOf(true) : null;
        }

        public final void useWebView(boolean bl) {
            this.webView = bl ? Boolean.valueOf(true) : null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setHeaders(@Nullable String value) {
            Object object;
            UrlOption urlOption = this;
            Object object2 = value;
            if (object2 == null || StringsKt.isBlank((CharSequence)object2)) {
                object = null;
            } else {
                Object object3;
                object2 = GSONKt.getGSON();
                UrlOption urlOption2 = urlOption;
                boolean $i$f$fromJsonObject = false;
                try {
                    void $this$fromJsonObject$iv;
                    boolean bl = false;
                    boolean $i$f$genericType = false;
                    Type type = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                    Object object4 = $this$fromJsonObject$iv.fromJson(value, type);
                    if (!(object4 instanceof Map)) {
                        object4 = null;
                    }
                    object3 = Result.constructor-impl((Object)((Map)object4));
                }
                catch (Throwable throwable) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                urlOption = urlOption2;
                object2 = object3;
                object = Result.isFailure-impl((Object)object2) ? null : object2;
            }
            urlOption.headers = object;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Map<?, ?> getHeaderMap() {
            Map map;
            Object value = this.headers;
            if (value instanceof Map) {
                map = (Map)value;
            } else if (value instanceof String) {
                Object object;
                Object object2 = GSONKt.getGSON();
                String json$iv = (String)value;
                boolean $i$f$fromJsonObject = false;
                try {
                    void $this$fromJsonObject$iv;
                    boolean bl = false;
                    boolean $i$f$genericType = false;
                    Type type = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                    Object object3 = $this$fromJsonObject$iv.fromJson(json$iv, type);
                    if (!(object3 instanceof Map)) {
                        object3 = null;
                    }
                    object = Result.constructor-impl((Object)((Map)object3));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                map = (Map)(Result.isFailure-impl((Object)object2) ? null : object2);
            } else {
                map = null;
            }
            return map;
        }

        /*
         * WARNING - void declaration
         */
        public final void setBody(@Nullable String value) {
            String string;
            UrlOption urlOption = this;
            CharSequence charSequence = value;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                string = null;
            } else if (StringKt.isJsonObject(value)) {
                Object $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22;
                charSequence = GSONKt.getGSON();
                UrlOption urlOption2 = urlOption;
                boolean $i$f$fromJsonObject = false;
                try {
                    boolean $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = false;
                    boolean $i$f$genericType = false;
                    Type type = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                    Object object = $this$fromJsonObject$iv.fromJson(value, type);
                    if (!(object instanceof Map)) {
                        object = null;
                    }
                    $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = Result.constructor-impl((Object)((Map)object));
                }
                catch (Throwable throwable) {
                    $i$a$-runCatching-GSONKt$fromJsonObject$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                urlOption = urlOption2;
                string = Result.box-impl((Object)$i$a$-runCatching-GSONKt$fromJsonObject$1$iv22);
            } else if (StringKt.isJsonArray(value)) {
                Object object;
                $this$fromJsonObject$iv = GSONKt.getGSON();
                UrlOption urlOption3 = urlOption;
                boolean $i$f$fromJsonArray = false;
                try {
                    void $this$fromJsonArray$iv;
                    boolean bl = false;
                    Object object2 = $this$fromJsonArray$iv.fromJson(value, (Type)new ParameterizedTypeImpl(Map.class));
                    object = Result.constructor-impl((Object)(object2 instanceof List ? (List)object2 : null));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                urlOption = urlOption3;
                string = Result.box-impl((Object)object);
            } else {
                string = value;
            }
            urlOption.body = string;
        }

        @Nullable
        public final String getBody() {
            String string;
            Object object = this.body;
            if (object != null) {
                Object it = object;
                boolean bl = false;
                string = it instanceof String ? (String)it : GSONKt.getGSON().toJson(it);
            } else {
                string = null;
            }
            return string;
        }

        public final void setWebJs(@Nullable String value) {
            CharSequence charSequence = value;
            this.webJs = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
        }

        @Nullable
        public final String getWebJs() {
            return this.webJs;
        }

        public final void setJs(@Nullable String value) {
            CharSequence charSequence = value;
            this.js = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
        }

        @Nullable
        public final String getJs() {
            return this.js;
        }

        private final String component1() {
            return this.method;
        }

        private final String component2() {
            return this.charset;
        }

        private final Object component3() {
            return this.headers;
        }

        private final Object component4() {
            return this.body;
        }

        private final Integer component5() {
            return this.retry;
        }

        private final String component6() {
            return this.type;
        }

        private final Object component7() {
            return this.webView;
        }

        private final String component8() {
            return this.webJs;
        }

        private final String component9() {
            return this.js;
        }

        private final Object component10() {
            return this.usePhone;
        }

        @NotNull
        public final UrlOption copy(@Nullable String method, @Nullable String charset, @Nullable Object headers, @Nullable Object body, @Nullable Integer retry, @Nullable String type, @Nullable Object webView, @Nullable String webJs, @Nullable String js, @Nullable Object usePhone) {
            return new UrlOption(method, charset, headers, body, retry, type, webView, webJs, js, usePhone);
        }

        public static /* synthetic */ UrlOption copy$default(UrlOption urlOption, String string, String string2, Object object, Object object2, Integer n, String string3, Object object3, String string4, String string5, Object object4, int n2, Object object5) {
            if ((n2 & 1) != 0) {
                string = urlOption.method;
            }
            if ((n2 & 2) != 0) {
                string2 = urlOption.charset;
            }
            if ((n2 & 4) != 0) {
                object = urlOption.headers;
            }
            if ((n2 & 8) != 0) {
                object2 = urlOption.body;
            }
            if ((n2 & 0x10) != 0) {
                n = urlOption.retry;
            }
            if ((n2 & 0x20) != 0) {
                string3 = urlOption.type;
            }
            if ((n2 & 0x40) != 0) {
                object3 = urlOption.webView;
            }
            if ((n2 & 0x80) != 0) {
                string4 = urlOption.webJs;
            }
            if ((n2 & 0x100) != 0) {
                string5 = urlOption.js;
            }
            if ((n2 & 0x200) != 0) {
                object4 = urlOption.usePhone;
            }
            return urlOption.copy(string, string2, object, object2, n, string3, object3, string4, string5, object4);
        }

        @NotNull
        public String toString() {
            return "UrlOption(method=" + this.method + ", charset=" + this.charset + ", headers=" + this.headers + ", body=" + this.body + ", retry=" + this.retry + ", type=" + this.type + ", webView=" + this.webView + ", webJs=" + this.webJs + ", js=" + this.js + ", usePhone=" + this.usePhone + ")";
        }

        public int hashCode() {
            int result = this.method == null ? 0 : this.method.hashCode();
            result = result * 31 + (this.charset == null ? 0 : this.charset.hashCode());
            result = result * 31 + (this.headers == null ? 0 : this.headers.hashCode());
            result = result * 31 + (this.body == null ? 0 : this.body.hashCode());
            result = result * 31 + (this.retry == null ? 0 : ((Object)this.retry).hashCode());
            result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
            result = result * 31 + (this.webView == null ? 0 : this.webView.hashCode());
            result = result * 31 + (this.webJs == null ? 0 : this.webJs.hashCode());
            result = result * 31 + (this.js == null ? 0 : this.js.hashCode());
            result = result * 31 + (this.usePhone == null ? 0 : this.usePhone.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UrlOption)) {
                return false;
            }
            UrlOption urlOption = (UrlOption)other;
            if (!Intrinsics.areEqual((Object)this.method, (Object)urlOption.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.charset, (Object)urlOption.charset)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headers, (Object)urlOption.headers)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)urlOption.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.retry, (Object)urlOption.retry)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)urlOption.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.webView, (Object)urlOption.webView)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.webJs, (Object)urlOption.webJs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.js, (Object)urlOption.js)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.usePhone, (Object)urlOption.usePhone);
        }

        public UrlOption() {
            this(null, null, null, null, null, null, null, null, null, null, 1023, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

