/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.analyzeRule;

import book.app.App;
import book.model.BaseBook;
import book.model.BaseSource;
import book.model.BookChapter;
import book.model.RssArticle;
import book.util.AppPattern;
import book.util.GSONKt;
import book.util.JsURL;
import book.util.NetworkUtils;
import book.util.StringKt;
import book.util.TextUtils;
import book.util.crypto.AsymmetricCrypto;
import book.util.help.CacheManager;
import book.util.help.CookieStore;
import book.util.http.StrResponse;
import book.webBook.DebugLog;
import book.webBook.analyzeRule.AnalyzeByJSonPath;
import book.webBook.analyzeRule.AnalyzeByJSoup;
import book.webBook.analyzeRule.AnalyzeByRegex;
import book.webBook.analyzeRule.AnalyzeByXPath;
import book.webBook.analyzeRule.AnalyzeUrl;
import book.webBook.analyzeRule.JsExtensions;
import book.webBook.analyzeRule.QueryTTF;
import book.webBook.analyzeRule.RuleDataInterface;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.google.gson.reflect.TypeToken;
import com.script.ScriptBindings;
import com.script.rhino.RhinoScriptEngine;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Connection;
import org.jsoup.nodes.Node;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000f\b\u0016\u0018\u0000 |2\u00020\u0001:\u0003z{|B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010E\u001a\u00020CJ\u001e\u0010F\u001a\u00020\u00002\b\u0010-\u001a\u0004\u0018\u00010,2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010G\u001a\u00020\u00002\b\u00100\u001a\u0004\u0018\u00010\u0013J\u0010\u0010H\u001a\u0004\u0018\u0001022\u0006\u0010I\u001a\u00020\u0013J\u0010\u0010J\u001a\u00020:2\u0006\u0010K\u001a\u00020,H\u0002J\u0010\u0010L\u001a\u00020<2\u0006\u0010K\u001a\u00020,H\u0002J\u0010\u0010M\u001a\u00020>2\u0006\u0010K\u001a\u00020,H\u0002J0\u0010N\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010O2\b\u0010P\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010R\u001a\u000207H\u0007J8\u0010N\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010O2\u0010\u0010S\u001a\f\u0012\b\u0012\u00060TR\u00020\u00000O2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010R\u001a\u000207H\u0007J(\u0010U\u001a\u00020\u00132\b\u0010V\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010R\u001a\u000207H\u0007J\u0018\u0010U\u001a\u00020\u00132\b\u0010V\u001a\u0004\u0018\u00010\u00132\u0006\u0010W\u001a\u000207J:\u0010U\u001a\u00020\u00132\u0010\u0010S\u001a\f\u0012\b\u0012\u00060TR\u00020\u00000O2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010R\u001a\u0002072\b\b\u0002\u0010W\u001a\u000207H\u0007J\u000e\u0010X\u001a\u0002072\u0006\u0010Y\u001a\u00020\u0013J\u000e\u0010Z\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020\u0013J\u0010\u0010[\u001a\u0004\u0018\u00010,2\u0006\u0010V\u001a\u00020\u0013J\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020,0O2\u0006\u0010V\u001a\u00020\u0013J\u001c\u0010]\u001a\u00020^2\u0012\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130`H\u0002J4\u0010a\u001a\u00020\u00132\u0006\u0010V\u001a\u00020\u00132\"\u0010b\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130cj\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013`dH\u0002J\u001c\u0010e\u001a\u00020\u00132\u0006\u0010f\u001a\u00020\u00132\n\u0010P\u001a\u00060TR\u00020\u0000H\u0002J$\u0010g\u001a\f\u0012\b\u0012\u00060TR\u00020\u00000O2\b\u0010V\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010h\u001a\u000207J\u0016\u0010i\u001a\u00020\u00132\u0006\u0010j\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0013J\u000e\u0010k\u001a\u00020\u00132\u0006\u0010j\u001a\u00020\u0013J\u0012\u0010r\u001a\u00020^2\b\u0010s\u001a\u0004\u0018\u00010,H\u0016J\u0012\u0010t\u001a\u00020^2\b\u0010s\u001a\u0004\u0018\u00010,H\u0016J\u001c\u0010u\u001a\u0004\u0018\u00010,2\u0006\u0010v\u001a\u00020\u00132\n\b\u0002\u0010f\u001a\u0004\u0018\u00010,J\n\u0010w\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010x\u001a\u0004\u0018\u00010\u00132\u0006\u0010y\u001a\u00020\u0013H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR(\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010 \u001a\u0004\u0018\u00010!@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\"\u0010-\u001a\u0004\u0018\u00010,2\b\u0010 \u001a\u0004\u0018\u00010,@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\"\u00100\u001a\u0004\u0018\u00010\u00132\b\u0010 \u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010)R\"\u00103\u001a\u0004\u0018\u0001022\b\u0010 \u001a\u0004\u0018\u000102@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010l\u001a\u00020mX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010o\"\u0004\bp\u0010q\u00a8\u0006\u0018"}, d2={"Lbook/webBook/analyzeRule/AnalyzeRule;", "Lbook/webBook/analyzeRule/JsExtensions;", "ruleData", "Lbook/webBook/analyzeRule/RuleDataInterface;", "debugLog", "Lbook/webBook/DebugLog;", "source", "Lbook/model/BaseSource;", "<init>", "(Lbook/webBook/analyzeRule/RuleDataInterface;Lbook/webBook/DebugLog;Lbook/model/BaseSource;)V", "getRuleData", "()Lbook/webBook/analyzeRule/RuleDataInterface;", "setRuleData", "(Lbook/webBook/analyzeRule/RuleDataInterface;)V", "getDebugLog", "()Lbook/webBook/DebugLog;", "setDebugLog", "(Lbook/webBook/DebugLog;)V", "toString", "", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "book", "Lbook/model/BaseBook;", "getBook", "()Lbook/model/BaseBook;", "rssArticle", "Lbook/model/RssArticle;", "getRssArticle", "()Lbook/model/RssArticle;", "value", "Lbook/model/BookChapter;", "chapter", "getChapter", "()Lbook/model/BookChapter;", "setChapter", "(Lbook/model/BookChapter;)V", "nextChapterUrl", "getNextChapterUrl", "()Ljava/lang/String;", "setNextChapterUrl", "(Ljava/lang/String;)V", "", "content", "getContent", "()Ljava/lang/Object;", "baseUrl", "getBaseUrl", "Ljava/net/URL;", "redirectUrl", "getRedirectUrl", "()Ljava/net/URL;", "isJSON", "", "isRegex", "analyzeByXPath", "Lbook/webBook/analyzeRule/AnalyzeByXPath;", "analyzeByJSoup", "Lbook/webBook/analyzeRule/AnalyzeByJSoup;", "analyzeByJSonPath", "Lbook/webBook/analyzeRule/AnalyzeByJSonPath;", "objectChangedXP", "objectChangedJS", "objectChangedJP", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "setCoroutineContext", "context", "setContent", "setBaseUrl", "setRedirectUrl", "url", "getAnalyzeByXPath", "o", "getAnalyzeByJSoup", "getAnalyzeByJSonPath", "getStringList", "", "rule", "mContent", "isUrl", "ruleList", "Lbook/webBook/analyzeRule/AnalyzeRule$SourceRule;", "getString", "ruleStr", "unescape", "isUnicodeEscaped", "input", "unescapeUnicode", "getElement", "getElements", "putRule", "", "map", "", "splitPutRule", "putMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "replaceRegex", "result", "splitSourceRule", "allInOne", "put", "key", "get", "toastc", "", "getToastc", "()I", "setToastc", "(I)V", "toast", "msg", "longToast", "evalJS", "jsStr", "getSource", "ajax", "urlStr", "SourceRule", "Mode", "Companion"})
@SourceDebugExtension(value={"SMAP\nAnalyzeRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeRule.kt\nbook/webBook/analyzeRule/AnalyzeRule\n+ 2 GSON.kt\nbook/util/GSONKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ScriptBindingsExtensions.kt\ncom/script/ScriptBindingsExtensionsKt\n*L\n1#1,872:1\n33#2,2:873\n30#2:875\n108#3:876\n80#3,22:877\n108#3:899\n80#3,22:900\n1#4:922\n6#5,8:923\n*S KotlinDebug\n*F\n+ 1 AnalyzeRule.kt\nbook/webBook/analyzeRule/AnalyzeRule\n*L\n439#1:873,2\n439#1:875\n497#1:876\n497#1:877,22\n507#1:899\n507#1:900,22\n785#1:923,8\n*E\n"})
public class AnalyzeRule
implements JsExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RuleDataInterface ruleData;
    @Nullable
    private DebugLog debugLog;
    @Nullable
    private final BaseSource source;
    @Nullable
    private BookChapter chapter;
    @Nullable
    private String nextChapterUrl;
    @Nullable
    private Object content;
    @Nullable
    private String baseUrl;
    @Nullable
    private URL redirectUrl;
    private boolean isJSON;
    private boolean isRegex;
    @Nullable
    private AnalyzeByXPath analyzeByXPath;
    @Nullable
    private AnalyzeByJSoup analyzeByJSoup;
    @Nullable
    private AnalyzeByJSonPath analyzeByJSonPath;
    private boolean objectChangedXP;
    private boolean objectChangedJS;
    private boolean objectChangedJP;
    @NotNull
    private CoroutineContext coroutineContext;
    private int toastc;
    private static final Pattern putPattern = Pattern.compile("@put:(\\{[^}]+?\\})", 2);
    private static final Pattern evalPattern = Pattern.compile("@get:\\{[^}]+?\\}|\\{\\{[\\w\\W]*?\\}\\}", 2);
    private static final Pattern regexPattern = Pattern.compile("\\$\\d{1,2}");
    private static final Pattern titleNumPattern = Pattern.compile("(\u7b2c)(.+?)(\u7ae0)");

    public AnalyzeRule(@Nullable RuleDataInterface ruleData, @Nullable DebugLog debugLog, @Nullable BaseSource source) {
        block4: {
            this.ruleData = ruleData;
            this.debugLog = debugLog;
            this.source = source;
            this.coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
            if (this.source == null) break block4;
            String string = this.source.getUserid();
            if (string == null) {
                string = "";
            }
            String userid = string;
            BookChapter bookChapter = this.chapter;
            if (bookChapter != null) {
                bookChapter.setUserid(userid);
            }
            RuleDataInterface ruleDataInterface = this.ruleData;
            if (ruleDataInterface != null) {
                ruleDataInterface.setUserid(userid);
            }
            BaseBook baseBook = this.getBook();
            if (baseBook != null) {
                baseBook.setUserid(userid);
            }
        }
    }

    public /* synthetic */ AnalyzeRule(RuleDataInterface ruleDataInterface, DebugLog debugLog, BaseSource baseSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ruleDataInterface = null;
        }
        if ((n & 2) != 0) {
            debugLog = null;
        }
        if ((n & 4) != 0) {
            baseSource = null;
        }
        this(ruleDataInterface, debugLog, baseSource);
    }

    @Nullable
    public final RuleDataInterface getRuleData() {
        return this.ruleData;
    }

    public final void setRuleData(@Nullable RuleDataInterface ruleDataInterface) {
        this.ruleData = ruleDataInterface;
    }

    @Override
    @Nullable
    public DebugLog getDebugLog() {
        return this.debugLog;
    }

    @Override
    public void setDebugLog(@Nullable DebugLog debugLog) {
        this.debugLog = debugLog;
    }

    @NotNull
    public String toString() {
        int hashCode = this.hashCode();
        String hexHash = Integer.toHexString(hashCode);
        String s = "io.legado.app.model.analyzeRule.AnalyzeRule@" + hexHash;
        return s;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        Logger logger = LoggerFactory.getLogger(AnalyzeRule.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return logger;
    }

    @Nullable
    public final BaseBook getBook() {
        RuleDataInterface ruleDataInterface = this.ruleData;
        return ruleDataInterface instanceof BaseBook ? (BaseBook)ruleDataInterface : null;
    }

    @Nullable
    public final RssArticle getRssArticle() {
        RuleDataInterface ruleDataInterface = this.ruleData;
        return ruleDataInterface instanceof RssArticle ? (RssArticle)ruleDataInterface : null;
    }

    @Nullable
    public final BookChapter getChapter() {
        return this.chapter;
    }

    public final void setChapter(@Nullable BookChapter value) {
        if (this.source != null) {
            BookChapter bookChapter = this.chapter;
            if (bookChapter != null) {
                String string = this.source.getUserid();
                if (string == null) {
                    string = "";
                }
                bookChapter.setUserid(string);
            }
        }
        this.chapter = value;
    }

    @Nullable
    public final String getNextChapterUrl() {
        return this.nextChapterUrl;
    }

    public final void setNextChapterUrl(@Nullable String string) {
        this.nextChapterUrl = string;
    }

    @Nullable
    public final Object getContent() {
        return this.content;
    }

    @Nullable
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @Nullable
    public final URL getRedirectUrl() {
        return this.redirectUrl;
    }

    @NotNull
    public final AnalyzeRule setCoroutineContext(@NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.coroutineContext = context.minusKey((CoroutineContext.Key)ContinuationInterceptor.Key);
        return this;
    }

    @JvmOverloads
    @NotNull
    public final AnalyzeRule setContent(@Nullable Object content, @Nullable String baseUrl) {
        if (content == null) {
            throw new AssertionError((Object)"\u5185\u5bb9\u4e0d\u53ef\u7a7a\uff08Content cannot be null\uff09");
        }
        this.content = content;
        this.isJSON = content instanceof Node ? false : StringKt.isJson(content.toString());
        this.setBaseUrl(baseUrl);
        this.analyzeByXPath = null;
        this.analyzeByJSoup = null;
        this.analyzeByJSonPath = null;
        return this;
    }

    public static /* synthetic */ AnalyzeRule setContent$default(AnalyzeRule analyzeRule, Object object, String string, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setContent");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return analyzeRule.setContent(object, string);
    }

    @NotNull
    public final AnalyzeRule setBaseUrl(@Nullable String baseUrl) {
        block0: {
            String string = baseUrl;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.baseUrl = baseUrl;
        }
        return this;
    }

    @Nullable
    public final URL setRedirectUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            this.redirectUrl = new URL(url);
        }
        catch (Exception e) {
            this.getLogger().info("URL(" + url + ") error\n" + e.getLocalizedMessage());
        }
        return this.redirectUrl;
    }

    private final AnalyzeByXPath getAnalyzeByXPath(Object o) {
        AnalyzeByXPath analyzeByXPath;
        if (!Intrinsics.areEqual((Object)o, (Object)this.content)) {
            analyzeByXPath = new AnalyzeByXPath(o);
        } else {
            if (this.analyzeByXPath == null || this.objectChangedXP) {
                Object object = this.content;
                Intrinsics.checkNotNull((Object)object);
                this.analyzeByXPath = new AnalyzeByXPath(object);
                this.objectChangedXP = false;
            }
            AnalyzeByXPath analyzeByXPath2 = this.analyzeByXPath;
            analyzeByXPath = analyzeByXPath2;
            Intrinsics.checkNotNull((Object)analyzeByXPath2);
        }
        return analyzeByXPath;
    }

    private final AnalyzeByJSoup getAnalyzeByJSoup(Object o) {
        AnalyzeByJSoup analyzeByJSoup;
        if (!Intrinsics.areEqual((Object)o, (Object)this.content)) {
            analyzeByJSoup = new AnalyzeByJSoup(o);
        } else {
            if (this.analyzeByJSoup == null || this.objectChangedJS) {
                Object object = this.content;
                Intrinsics.checkNotNull((Object)object);
                this.analyzeByJSoup = new AnalyzeByJSoup(object);
                this.objectChangedJS = false;
            }
            AnalyzeByJSoup analyzeByJSoup2 = this.analyzeByJSoup;
            analyzeByJSoup = analyzeByJSoup2;
            Intrinsics.checkNotNull((Object)analyzeByJSoup2);
        }
        return analyzeByJSoup;
    }

    private final AnalyzeByJSonPath getAnalyzeByJSonPath(Object o) {
        AnalyzeByJSonPath analyzeByJSonPath;
        if (!Intrinsics.areEqual((Object)o, (Object)this.content)) {
            analyzeByJSonPath = new AnalyzeByJSonPath(o);
        } else {
            if (this.analyzeByJSonPath == null || this.objectChangedJP) {
                Object object = this.content;
                Intrinsics.checkNotNull((Object)object);
                this.analyzeByJSonPath = new AnalyzeByJSonPath(object);
                this.objectChangedJP = false;
            }
            AnalyzeByJSonPath analyzeByJSonPath2 = this.analyzeByJSonPath;
            analyzeByJSonPath = analyzeByJSonPath2;
            Intrinsics.checkNotNull((Object)analyzeByJSonPath2);
        }
        return analyzeByJSonPath;
    }

    @JvmOverloads
    @Nullable
    public final List<String> getStringList(@Nullable String rule, @Nullable Object mContent, boolean isUrl) {
        CharSequence charSequence = rule;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        List<SourceRule> ruleList = this.splitSourceRule(rule, false);
        return this.getStringList(ruleList, mContent, isUrl);
    }

    public static /* synthetic */ List getStringList$default(AnalyzeRule analyzeRule, String string, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStringList");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return analyzeRule.getStringList(string, object, bl);
    }

    @JvmOverloads
    @Nullable
    public final List<String> getStringList(@NotNull List<SourceRule> ruleList, @Nullable Object mContent, boolean isUrl) {
        Object object;
        String[] content;
        Intrinsics.checkNotNullParameter(ruleList, (String)"ruleList");
        Object result = null;
        String[] stringArray = mContent;
        if (mContent == null) {
            stringArray = this.content;
        }
        if ((content = stringArray) != null && !((Collection)ruleList).isEmpty()) {
            result = content;
            if (content instanceof NativeObject) {
                Object object2 = ((NativeObject)content).get((Object)ruleList.get(0).getRule$book());
                result = object2 != null ? object2.toString() : null;
            } else {
                for (SourceRule sourceRule : ruleList) {
                    this.putRule((Map<String, String>)sourceRule.getPutMap$book());
                    sourceRule.makeUpRule(result);
                    if (result == null) continue;
                    Object it = result;
                    boolean bl = false;
                    if (((CharSequence)sourceRule.getRule$book()).length() > 0) {
                        switch (WhenMappings.$EnumSwitchMapping$0[sourceRule.getMode$book().ordinal()]) {
                            case 1: {
                                Object object3 = this.evalJS(sourceRule.getRule$book(), result);
                                break;
                            }
                            case 2: {
                                Object object3 = this.getAnalyzeByJSonPath(it).getStringList$book(sourceRule.getRule$book());
                                break;
                            }
                            case 3: {
                                Object object3 = this.getAnalyzeByXPath(it).getStringList$book(sourceRule.getRule$book());
                                break;
                            }
                            case 4: {
                                Object object3 = this.getAnalyzeByJSoup(it).getStringList$book(sourceRule.getRule$book());
                                break;
                            }
                            default: {
                                Object object3 = result = sourceRule.getRule$book();
                            }
                        }
                    }
                    if (((CharSequence)sourceRule.getReplaceRegex$book()).length() > 0 && result instanceof List) {
                        ArrayList<String> newList = new ArrayList<String>();
                        for (Object item : (List)result) {
                            newList.add(this.replaceRegex(String.valueOf(item), sourceRule));
                        }
                        result = newList;
                        continue;
                    }
                    if (!(((CharSequence)sourceRule.getReplaceRegex$book()).length() > 0)) continue;
                    result = this.replaceRegex(String.valueOf(result), sourceRule);
                }
            }
        }
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            object = new String[]{"\n"};
            result = StringsKt.split$default((CharSequence)((String)result), (String[])object, (boolean)false, (int)0, (int)6, null);
        }
        if (isUrl) {
            ArrayList<String> urlList = new ArrayList<String>();
            if (result instanceof List) {
                for (Object url : (List)result) {
                    String absoluteURL = NetworkUtils.INSTANCE.getAbsoluteURL(this.redirectUrl, String.valueOf(url));
                    if (!(((CharSequence)absoluteURL).length() > 0) || urlList.contains(absoluteURL)) continue;
                    urlList.add(absoluteURL);
                }
            }
            return urlList;
        }
        object = result;
        return object instanceof List ? (List)object : null;
    }

    public static /* synthetic */ List getStringList$default(AnalyzeRule analyzeRule, List list, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getStringList");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return analyzeRule.getStringList(list, object, bl);
    }

    @JvmOverloads
    @NotNull
    public final String getString(@Nullable String ruleStr, @Nullable Object mContent, boolean isUrl) {
        if (TextUtils.isEmpty(ruleStr)) {
            return "";
        }
        List ruleList = AnalyzeRule.splitSourceRule$default(this, ruleStr, false, 2, null);
        return AnalyzeRule.getString$default(this, ruleList, mContent, isUrl, false, 8, null);
    }

    public static /* synthetic */ String getString$default(AnalyzeRule analyzeRule, String string, Object object, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getString");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return analyzeRule.getString(string, object, bl);
    }

    @NotNull
    public final String getString(@Nullable String ruleStr, boolean unescape) {
        if (TextUtils.isEmpty(ruleStr)) {
            return "";
        }
        List ruleList = AnalyzeRule.splitSourceRule$default(this, ruleStr, false, 2, null);
        return AnalyzeRule.getString$default(this, ruleList, null, false, unescape, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String getString(@NotNull List<SourceRule> ruleList, @Nullable Object mContent, boolean isUrl, boolean unescape) {
        String str;
        Object content;
        Intrinsics.checkNotNullParameter(ruleList, (String)"ruleList");
        Object result = null;
        Object object = mContent;
        if (object == null) {
            object = this.content;
        }
        if ((content = object) != null && !((Collection)ruleList).isEmpty()) {
            result = content;
            if (result instanceof NativeObject) {
                String string;
                String string2;
                SourceRule sourceRule = (SourceRule)CollectionsKt.first(ruleList);
                this.putRule((Map<String, String>)sourceRule.getPutMap$book());
                sourceRule.makeUpRule(result);
                if (sourceRule.getParamSize() > 1) {
                    v1 = sourceRule.getRule$book();
                } else {
                    Object object2 = ((NativeObject)result).get((Object)sourceRule.getRule$book());
                    v1 = string2 = object2 != null ? object2.toString() : null;
                }
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    string = this.replaceRegex(it, sourceRule);
                } else {
                    string = null;
                }
                result = string;
            } else {
                for (SourceRule sourceRule : ruleList) {
                    this.putRule((Map<String, String>)sourceRule.getPutMap$book());
                    sourceRule.makeUpRule(result);
                    if (result == null) continue;
                    boolean bl = false;
                    if (!StringsKt.isBlank((CharSequence)sourceRule.getRule$book()) || ((CharSequence)sourceRule.getReplaceRegex$book()).length() == 0) {
                        switch (WhenMappings.$EnumSwitchMapping$0[sourceRule.getMode$book().ordinal()]) {
                            case 1: {
                                Object it;
                                Object object3 = this.evalJS(sourceRule.getRule$book(), it);
                                break;
                            }
                            case 2: {
                                Object it;
                                Object object3 = this.getAnalyzeByJSonPath(it).getString(sourceRule.getRule$book());
                                break;
                            }
                            case 3: {
                                Object it;
                                Object object3 = this.getAnalyzeByXPath(it).getString(sourceRule.getRule$book());
                                break;
                            }
                            case 4: {
                                Object object3;
                                Object it;
                                if (isUrl) {
                                    object3 = this.getAnalyzeByJSoup(it).getString0$book(sourceRule.getRule$book());
                                    break;
                                }
                                object3 = this.getAnalyzeByJSoup(it).getString$book(sourceRule.getRule$book());
                                break;
                            }
                            default: {
                                Object object3 = result = sourceRule.getRule$book();
                            }
                        }
                    }
                    if (result == null || !(((CharSequence)sourceRule.getReplaceRegex$book()).length() > 0)) continue;
                    result = this.replaceRegex(result.toString(), sourceRule);
                }
            }
        }
        if (result == null) {
            result = "";
        }
        String resultStr = result.toString();
        String string = str = unescape && StringsKt.indexOf$default((CharSequence)resultStr, (char)'&', (int)0, (boolean)false, (int)6, null) > -1 ? StringEscapeUtils.unescapeHtml4((String)resultStr) : resultStr;
        if (isUrl) {
            String string3;
            String string4 = str;
            Intrinsics.checkNotNull((Object)string4);
            if (StringsKt.isBlank((CharSequence)string4)) {
                string3 = this.baseUrl;
                if (string3 == null) {
                    string3 = "";
                }
            } else {
                string4 = str;
                Intrinsics.checkNotNull((Object)string4);
                string3 = NetworkUtils.INSTANCE.getAbsoluteURL(this.redirectUrl, string4);
            }
            return string3;
        }
        String string5 = str;
        Intrinsics.checkNotNull((Object)string5);
        if (this.isUnicodeEscaped(string5)) {
            string5 = str;
            Intrinsics.checkNotNull((Object)string5);
            str = this.unescapeUnicode(string5);
        }
        string5 = str;
        Intrinsics.checkNotNull((Object)string5);
        return string5;
    }

    public static /* synthetic */ String getString$default(AnalyzeRule analyzeRule, List list, Object object, boolean bl, boolean bl2, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getString");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return analyzeRule.getString(list, object, bl, bl2);
    }

    public final boolean isUnicodeEscaped(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Regex pattern = new Regex("\\\\u[0-9a-fA-F]{4}");
        return pattern.containsMatchIn((CharSequence)input);
    }

    @NotNull
    public final String unescapeUnicode(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '\\' && i + 5 < input.length() && input.charAt(i + 1) == 'u') {
                int n;
                Intrinsics.checkNotNullExpressionValue((Object)input.substring(i + 2, i + 6), (String)"substring(...)");
                try {
                    String hex;
                    int charCode = Integer.parseInt(hex, CharsKt.checkRadix((int)16));
                    sb.append((char)charCode);
                    n = i += 6;
                }
                catch (NumberFormatException e) {
                    sb.append(input.charAt(i));
                    n = i++;
                }
                continue;
            }
            sb.append(input.charAt(i));
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final Object getElement(@NotNull String ruleStr) {
        Intrinsics.checkNotNullParameter((Object)ruleStr, (String)"ruleStr");
        if (TextUtils.isEmpty(ruleStr)) {
            return null;
        }
        Object result = null;
        Object content = this.content;
        List<SourceRule> ruleList = this.splitSourceRule(ruleStr, true);
        if (content != null && !((Collection)ruleList).isEmpty()) {
            result = content;
            for (SourceRule sourceRule : ruleList) {
                this.putRule((Map<String, String>)sourceRule.getPutMap$book());
                sourceRule.makeUpRule(result);
                if (result != null) {
                    boolean bl = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[sourceRule.getMode$book().ordinal()]) {
                        case 5: {
                            String[] stringArray = new String[]{"&&"};
                            Object object = AnalyzeByRegex.getElement$default(AnalyzeByRegex.INSTANCE, result.toString(), StringKt.splitNotBlank(sourceRule.getRule$book(), stringArray), 0, 4, null);
                            break;
                        }
                        case 1: {
                            Object it;
                            Object object = this.evalJS(sourceRule.getRule$book(), it);
                            break;
                        }
                        case 2: {
                            Object it;
                            Object object = this.getAnalyzeByJSonPath(it).getObject$book(sourceRule.getRule$book());
                            break;
                        }
                        case 3: {
                            Object it;
                            Object object = this.getAnalyzeByXPath(it).getElements$book(sourceRule.getRule$book());
                            break;
                        }
                        default: {
                            Object it;
                            Object object = result = this.getAnalyzeByJSoup(it).getElements$book(sourceRule.getRule$book());
                        }
                    }
                    if (!(((CharSequence)sourceRule.getReplaceRegex$book()).length() > 0)) continue;
                    result = this.replaceRegex(String.valueOf(result), sourceRule);
                }
            }
        }
        return result;
    }

    @NotNull
    public final List<Object> getElements(@NotNull String ruleStr) {
        Iterator<SourceRule> iterator;
        Intrinsics.checkNotNullParameter((Object)ruleStr, (String)"ruleStr");
        Object result = null;
        Iterator<SourceRule> content = this.content;
        List<SourceRule> ruleList = this.splitSourceRule(ruleStr, true);
        if (content != null && !((Collection)ruleList).isEmpty()) {
            result = content;
            iterator = ruleList.iterator();
            while (iterator.hasNext()) {
                SourceRule sourceRule = iterator.next();
                this.putRule((Map<String, String>)sourceRule.getPutMap$book());
                if (result == null) continue;
                String rule = sourceRule.getRule$book();
                result = switch (WhenMappings.$EnumSwitchMapping$0[sourceRule.getMode$book().ordinal()]) {
                    case 5 -> {
                        String[] var9_8 = new String[]{"&&"};
                        yield AnalyzeByRegex.getElements$default(AnalyzeByRegex.INSTANCE, result.toString(), StringKt.splitNotBlank(rule, var9_8), 0, 4, null);
                    }
                    case 1 -> this.evalJS(rule, result);
                    case 2 -> this.getAnalyzeByJSonPath(result).getList$book(rule);
                    case 3 -> this.getAnalyzeByXPath(result).getElements$book(rule);
                    default -> this.getAnalyzeByJSoup(result).getElements$book(rule);
                };
            }
        }
        if ((iterator = result) != null) {
            Iterator<SourceRule> it = iterator;
            boolean bl = false;
            return (List)((Object)it);
        }
        return new ArrayList();
    }

    private final void putRule(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.put(key, AnalyzeRule.getString$default(this, value, null, false, 6, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String splitPutRule(String ruleStr, HashMap<String, String> putMap) {
        String vRuleStr = ruleStr;
        Matcher putMatcher = putPattern.matcher(vRuleStr);
        while (putMatcher.find()) {
            Map map;
            Object object;
            String string = putMatcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            vRuleStr = StringsKt.replace$default((String)vRuleStr, (String)string, (String)"", (boolean)false, (int)4, null);
            Object object2 = GSONKt.getGSON();
            String json$iv = putMatcher.group(1);
            boolean $i$f$fromJsonObject = false;
            try {
                void $this$fromJsonObject$iv;
                boolean bl = false;
                boolean $i$f$genericType = false;
                Type type = new TypeToken<Map<String, ? extends String>>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                Object object3 = $this$fromJsonObject$iv.fromJson(json$iv, type);
                if (!(object3 instanceof Map)) {
                    object3 = null;
                }
                object = Result.constructor-impl((Object)((Map)object3));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if ((map = (Map)(Result.isFailure-impl((Object)(object2 = object)) ? null : object2)) == null) continue;
            Map it = map;
            boolean bl = false;
            putMap.putAll(it);
        }
        return vRuleStr;
    }

    private final String replaceRegex(String result, SourceRule rule) {
        String string;
        if (((CharSequence)rule.getReplaceRegex$book()).length() == 0) {
            return result;
        }
        String vResult = null;
        vResult = result;
        if (rule.getReplaceFirst$book()) {
            Object object;
            Object $i$a$-runCatching-AnalyzeRule$replaceRegex$22;
            try {
                String string2;
                boolean $i$a$-runCatching-AnalyzeRule$replaceRegex$22 = false;
                Pattern pattern = Pattern.compile(rule.getReplaceRegex$book());
                Matcher matcher = pattern.matcher(vResult);
                if (matcher.find()) {
                    String string3 = matcher.group(0);
                    Intrinsics.checkNotNull((Object)string3);
                    var7_14 = string3;
                    Regex regex = new Regex(rule.getReplaceRegex$book());
                    String string4 = rule.getReplacement$book();
                    string2 = regex.replaceFirst(var7_14, string4);
                } else {
                    string2 = "";
                }
                $i$a$-runCatching-AnalyzeRule$replaceRegex$22 = Result.constructor-impl((Object)string2);
            }
            catch (Throwable pattern) {
                $i$a$-runCatching-AnalyzeRule$replaceRegex$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)pattern));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-AnalyzeRule$replaceRegex$22);
            if (throwable == null) {
                object = $i$a$-runCatching-AnalyzeRule$replaceRegex$22;
            } else {
                it = throwable;
                boolean bl2 = false;
                object = StringsKt.replaceFirst$default((String)vResult, (String)rule.getReplaceRegex$book(), (String)rule.getReplacement$book(), (boolean)false, (int)4, null);
            }
            string = (String)object;
        } else {
            Object object;
            Object object2;
            try {
                boolean bl = false;
                it = vResult;
                Regex bl2 = new Regex(rule.getReplaceRegex$book());
                var7_14 = rule.getReplacement$book();
                object2 = Result.constructor-impl((Object)bl2.replace((CharSequence)it, var7_14));
            }
            catch (Throwable it) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                it = throwable;
                boolean bl = false;
                object = StringsKt.replace$default((String)vResult, (String)rule.getReplaceRegex$book(), (String)rule.getReplacement$book(), (boolean)false, (int)4, null);
            }
            string = (String)object;
        }
        vResult = string;
        return vResult;
    }

    @NotNull
    public final List<SourceRule> splitSourceRule(@Nullable String ruleStr, boolean allInOne) {
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        boolean startFound$iv$iv;
        int endIndex$iv$iv;
        int startIndex$iv$iv;
        boolean $i$f$trim;
        CharSequence $this$trim$iv$iv;
        String $this$trim$iv;
        boolean $i$f$trim2;
        CharSequence charSequence = ruleStr;
        if (charSequence == null || charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<SourceRule> ruleList = new ArrayList<SourceRule>();
        Mode mMode = Mode.Default;
        int start = 0;
        if (allInOne && StringsKt.startsWith$default((String)ruleStr, (String)":", (boolean)false, (int)2, null)) {
            mMode = Mode.Regex;
            this.isRegex = true;
            start = 1;
        } else if (this.isRegex) {
            mMode = Mode.Regex;
        }
        String tmp = null;
        Matcher jsMatcher = AppPattern.INSTANCE.getJS_PATTERN().matcher(ruleStr);
        while (jsMatcher.find()) {
            String string;
            if (jsMatcher.start() > start) {
                Intrinsics.checkNotNullExpressionValue((Object)ruleStr.substring(start, jsMatcher.start()), (String)"substring(...)");
                $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (((CharSequence)(tmp = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() > 0) {
                    ruleList.add(new SourceRule(this, tmp, mMode));
                }
            }
            if ((string = jsMatcher.group(2)) == null) {
                string = jsMatcher.group(1);
            }
            $this$trim$iv = string;
            Intrinsics.checkNotNull((Object)$this$trim$iv);
            ruleList.add(new SourceRule(this, $this$trim$iv, Mode.Js));
            start = jsMatcher.end();
        }
        if (ruleStr.length() > start) {
            String string = ruleStr.substring(start);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$trim$iv = string;
            $i$f$trim2 = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (((CharSequence)(tmp = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() > 0) {
                ruleList.add(new SourceRule(this, tmp, mMode));
            }
        }
        return ruleList;
    }

    public static /* synthetic */ List splitSourceRule$default(AnalyzeRule analyzeRule, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: splitSourceRule");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return analyzeRule.splitSourceRule(string, bl);
    }

    @NotNull
    public final String put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.source != null) {
            String string = this.source.getUserid();
            if (string == null) {
                string = "";
            }
            String userid = string;
            BookChapter bookChapter = this.chapter;
            if (bookChapter != null) {
                bookChapter.setUserid(userid);
            }
            BaseBook baseBook = this.getBook();
            if (baseBook != null) {
                baseBook.setUserid(userid);
            }
            RuleDataInterface ruleDataInterface = this.ruleData;
            if (ruleDataInterface != null) {
                ruleDataInterface.setUserid(userid);
            }
        }
        BookChapter bookChapter = this.chapter;
        if (bookChapter != null) {
            v5 = bookChapter.putVariable(key, value);
        } else {
            BaseBook baseBook = this.getBook();
            if (baseBook != null) {
                v5 = baseBook.putVariable(key, value);
            } else {
                RuleDataInterface ruleDataInterface = this.ruleData;
                v5 = ruleDataInterface != null ? Boolean.valueOf(ruleDataInterface.putVariable(key, value)) : null;
                if (v5 == null) {
                    BaseSource baseSource = this.source;
                    v5 = baseSource != null ? baseSource.put(key, value) : null;
                }
            }
        }
        return value;
    }

    @NotNull
    public final String get(@NotNull String key) {
        Object object;
        block23: {
            Object object2;
            Object object3;
            block22: {
                Object object4;
                BookChapter bookChapter;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                String string = key;
                if (Intrinsics.areEqual((Object)string, (Object)"bookName")) {
                    BaseBook baseBook = this.getBook();
                    if (baseBook != null) {
                        BaseBook it = baseBook;
                        boolean bl = false;
                        return it.getName();
                    }
                } else if (Intrinsics.areEqual((Object)string, (Object)"title") && (bookChapter = this.chapter) != null) {
                    BookChapter it = bookChapter;
                    boolean bl = false;
                    return it.getTitle();
                }
                if (this.source != null) {
                    String string2 = this.source.getUserid();
                    if (string2 == null) {
                        string2 = "";
                    }
                    String userid = string2;
                    BookChapter bookChapter2 = this.chapter;
                    if (bookChapter2 != null) {
                        bookChapter2.setUserid(userid);
                    }
                    BaseBook baseBook = this.getBook();
                    if (baseBook != null) {
                        baseBook.setUserid(userid);
                    }
                    RuleDataInterface ruleDataInterface = this.ruleData;
                    if (ruleDataInterface != null) {
                        ruleDataInterface.setUserid(userid);
                    }
                }
                if ((object = this.chapter) == null || (object = ((BookChapter)object).getVariable(key)) == null) break block22;
                Object it = object4 = object;
                boolean bl = false;
                object = ((CharSequence)it).length() > 0 ? object4 : null;
                if (object != null) break block23;
            }
            if ((object3 = this.getBook()) != null && (object3 = object3.getVariable(key)) != null) {
                Object object5;
                Object it = object5 = object3;
                boolean bl = false;
                object2 = ((CharSequence)it).length() > 0 ? object5 : null;
            } else {
                object2 = object = null;
            }
            if (object2 == null) {
                Object object6;
                Object object7 = this.ruleData;
                if (object7 != null && (object7 = object7.getVariable(key)) != null) {
                    Object object8;
                    Object it = object8 = object7;
                    boolean bl = false;
                    object6 = ((CharSequence)it).length() > 0 ? object8 : null;
                } else {
                    object6 = object = null;
                }
                if (object6 == null) {
                    Object object9;
                    Object object10 = this.source;
                    if (object10 != null && (object10 = object10.get(key)) != null) {
                        Object object11;
                        Object it = object11 = object10;
                        boolean bl = false;
                        object9 = ((CharSequence)it).length() > 0 ? object11 : null;
                    } else {
                        object9 = object = null;
                    }
                    if (object9 == null) {
                        object = "";
                    }
                }
            }
        }
        return object;
    }

    public final int getToastc() {
        return this.toastc;
    }

    public final void setToastc(int n) {
        this.toastc = n;
    }

    @Override
    public void toast(@Nullable Object msg) {
        this.getLogger().info("toast:" + msg);
        if (this.toastc > 10) {
            throw new Exception("toast \u8c03\u7528\u6b21\u6570\u8d85\u8fc710\u6b21");
        }
        ++this.toastc;
        Function2<String, String, Unit> function2 = App.INSTANCE.getToast();
        String string = String.valueOf(msg);
        Object object = this.getSource();
        if (object == null || (object = object.getUsertocken()) == null) {
            object = "";
        }
        function2.invoke((Object)string, object);
    }

    @Override
    public void longToast(@Nullable Object msg) {
        this.toast(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object evalJS(@NotNull String jsStr, @Nullable Object result) {
        Scriptable scope;
        block9: {
            Intrinsics.checkNotNullParameter((Object)jsStr, (String)"jsStr");
            String userid = "";
            if (this.source != null) {
                String string = this.source.getUserid();
                if (string == null) {
                    string = "";
                }
                userid = string;
                BookChapter bookChapter = this.chapter;
                if (bookChapter != null) {
                    bookChapter.setUserid(userid);
                }
                RuleDataInterface ruleDataInterface = this.ruleData;
                if (ruleDataInterface != null) {
                    ruleDataInterface.setUserid(userid);
                }
                BaseBook baseBook = this.getBook();
                if (baseBook != null) {
                    baseBook.setUserid(userid);
                }
            }
            boolean $i$f$buildScriptBindings = false;
            ScriptBindings bindings$iv = new ScriptBindings();
            Context.enter();
            try {
                ScriptBindings bindings = bindings$iv;
                boolean bl = false;
                bindings.set("java", (Object)this);
                BaseSource baseSource = this.source;
                CookieStore cookieStore = baseSource != null ? baseSource.getCookieManger() : null;
                Intrinsics.checkNotNull((Object)cookieStore);
                bindings.set("cookie", (Object)cookieStore);
                BaseSource baseSource2 = this.source;
                CacheManager cacheManager = baseSource2 != null ? baseSource2.getCacheManger() : null;
                Intrinsics.checkNotNull((Object)cacheManager);
                bindings.set("cache", (Object)cacheManager);
                bindings.set("source", (Object)this.source);
                bindings.set("book", (Object)this.getBook());
                bindings.set("result", result);
                bindings.set("baseUrl", (Object)this.baseUrl);
                bindings.set("chapter", (Object)this.chapter);
                BookChapter bookChapter = this.chapter;
                bindings.set("title", (Object)(bookChapter != null ? bookChapter.getTitle() : null));
                bindings.set("src", this.content);
                bindings.set("nextChapterUrl", (Object)this.nextChapterUrl);
                bindings.set("rssArticle", (Object)this.getRssArticle());
                this.binding(bindings);
            }
            finally {
                Context.exit();
            }
            ScriptBindings bindings = bindings$iv;
            scope = RhinoScriptEngine.INSTANCE.getRuntimeScope(bindings);
            BaseSource baseSource = this.source;
            if (baseSource == null || (baseSource = baseSource.getShareScope()) == null) break block9;
            BaseSource it = baseSource;
            boolean bl = false;
            scope.setPrototype((Scriptable)it);
        }
        return RhinoScriptEngine.INSTANCE.eval(this.getjs(jsStr), scope, this.coroutineContext);
    }

    public static /* synthetic */ Object evalJS$default(AnalyzeRule analyzeRule, String string, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: evalJS");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        return analyzeRule.evalJS(string, object);
    }

    @Override
    @Nullable
    public BaseSource getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public String ajax(@NotNull String urlStr) {
        Intrinsics.checkNotNullParameter((Object)urlStr, (String)"urlStr");
        this.getLogger().info("ajax url: " + urlStr);
        return (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(urlStr, this, null){
            int label;
            final /* synthetic */ String $urlStr;
            final /* synthetic */ AnalyzeRule this$0;
            {
                this.$urlStr = $urlStr;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.$urlStr;
                        var3_4 = this.this$0;
                        $i$a$-runCatching-AnalyzeRule$ajax$1$1 = false;
                        analyzeUrl = new AnalyzeUrl((String)var2_3, null, null, null, null, null, AnalyzeRule.access$getSource$p(var3_4), var3_4.getBook(), null, null, null, null, false, var3_4.getDebugLog(), false, 24382, null);
                        this.label = 1;
                        v0 = AnalyzeUrl.getStrResponseAwait$default(analyzeUrl, null, null, false, (Continuation)this, 7, null);
                        ** if (v0 != var8_2) goto lbl16
lbl15:
                        // 1 sources

                        return var8_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$a$-runCatching-AnalyzeRule$ajax$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            $i$a$-runCatching-AnalyzeRule$ajax$1$1 = Result.constructor-impl((Object)((StrResponse)v0).getBody());
                        }
                        catch (Throwable var5_9) {
                            $i$a$-runCatching-AnalyzeRule$ajax$1$1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_9));
                        }
                        var2_3 = $i$a$-runCatching-AnalyzeRule$ajax$1$1;
                        var3_4 = this.this$0;
                        $i$a$-runCatching-AnalyzeRule$ajax$1$1 = this.$urlStr;
                        v1 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v1 != null) {
                            it = var5_8 = v1;
                            $i$a$-onFailure-AnalyzeRule$ajax$1$2 = false;
                            var3_4.log("ajax(" + (String)$i$a$-runCatching-AnalyzeRule$ajax$1$1 + ") error\n" + ExceptionsKt.stackTraceToString((Throwable)it));
                        }
                        v2 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v2 == null) {
                            v3 = var2_3;
                        } else {
                            it = v2;
                            $i$a$-getOrElse-AnalyzeRule$ajax$1$3 = false;
                            v3 = it.getMessage();
                        }
                        return v3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    @NotNull
    public String androidId() {
        return JsExtensions.DefaultImpls.androidId(this);
    }

    @Override
    public void binding(@NotNull ScriptBindings bindings) {
        JsExtensions.DefaultImpls.binding(this, bindings);
    }

    @Override
    @NotNull
    public String qread() {
        return JsExtensions.DefaultImpls.qread(this);
    }

    @Override
    @NotNull
    public StrResponse[] ajaxAll(@NotNull String[] urlList) {
        return JsExtensions.DefaultImpls.ajaxAll(this, urlList);
    }

    @Override
    @NotNull
    public StrResponse connect(@NotNull String urlStr) {
        return JsExtensions.DefaultImpls.connect(this, urlStr);
    }

    @Override
    @NotNull
    public StrResponse connect(@NotNull String urlStr, @Nullable String header) {
        return JsExtensions.DefaultImpls.connect(this, urlStr, header);
    }

    @Override
    @NotNull
    public StrResponse webview(@Nullable String html, @Nullable String url, @Nullable String js) {
        return JsExtensions.DefaultImpls.webview(this, html, url, js);
    }

    @Override
    @Nullable
    public String webViewGetSource(@Nullable String html, @Nullable String url, @Nullable String js, @NotNull String sourceRegex) {
        return JsExtensions.DefaultImpls.webViewGetSource(this, html, url, js, sourceRegex);
    }

    @Override
    @Nullable
    public String webViewGetOverrideUrl(@Nullable String html, @Nullable String url, @Nullable String js, @NotNull String overrideUrlRegex) {
        return JsExtensions.DefaultImpls.webViewGetOverrideUrl(this, html, url, js, overrideUrlRegex);
    }

    @Override
    @Nullable
    public String webView(@Nullable String html, @Nullable String url, @Nullable String js) {
        return JsExtensions.DefaultImpls.webView(this, html, url, js);
    }

    @Override
    @NotNull
    public String getWebViewUA() {
        return JsExtensions.DefaultImpls.getWebViewUA(this);
    }

    @Override
    @NotNull
    public String getWebViewUANEW() {
        return JsExtensions.DefaultImpls.getWebViewUANEW(this);
    }

    @Override
    @NotNull
    public String importScript(@NotNull String path) {
        return JsExtensions.DefaultImpls.importScript(this, path);
    }

    @Override
    @Nullable
    public String cacheFile(@NotNull String urlStr) {
        return JsExtensions.DefaultImpls.cacheFile(this, urlStr);
    }

    @Override
    @NotNull
    public String cacheFile(@NotNull String urlStr, int saveTime) {
        return JsExtensions.DefaultImpls.cacheFile(this, urlStr, saveTime);
    }

    @Override
    @NotNull
    public String getCookie(@NotNull String tag, @Nullable String key) {
        return JsExtensions.DefaultImpls.getCookie(this, tag, key);
    }

    @Override
    @NotNull
    public String getCookie(@NotNull String key) {
        return JsExtensions.DefaultImpls.getCookie(this, key);
    }

    @Override
    @NotNull
    public StrResponse startBrowserAwait(@NotNull String url, @NotNull String title, boolean refetchAfterSuccess) {
        return JsExtensions.DefaultImpls.startBrowserAwait(this, url, title, refetchAfterSuccess);
    }

    @Override
    @NotNull
    public StrResponse startBrowserAwait(@NotNull String url, @NotNull String title) {
        return JsExtensions.DefaultImpls.startBrowserAwait(this, url, title);
    }

    @Override
    public void startBrowserDp(@NotNull String url, @NotNull String title) {
        JsExtensions.DefaultImpls.startBrowserDp(this, url, title);
    }

    @Override
    public void startBrowser(@NotNull String url, @NotNull String title) {
        JsExtensions.DefaultImpls.startBrowser(this, url, title);
    }

    @Override
    @NotNull
    public String downloadFile(@NotNull String url) {
        return JsExtensions.DefaultImpls.downloadFile(this, url);
    }

    @Override
    @NotNull
    public String downloadFile(@NotNull String content, @NotNull String url) {
        return JsExtensions.DefaultImpls.downloadFile(this, content, url);
    }

    @Override
    @NotNull
    public Connection.Response get(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.get(this, urlStr, headers);
    }

    @Override
    @NotNull
    public Connection.Response getusePhone(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.getusePhone(this, urlStr, headers);
    }

    @Override
    @NotNull
    public Connection.Response head(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.head(this, urlStr, headers);
    }

    @Override
    @NotNull
    public Connection.Response headusePhone(@NotNull String urlStr, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.headusePhone(this, urlStr, headers);
    }

    @Override
    @NotNull
    public String getVerificationCode(@NotNull String imageUrl) {
        return JsExtensions.DefaultImpls.getVerificationCode(this, imageUrl);
    }

    @Override
    @NotNull
    public String getVerificationCodeusePhone(@NotNull String imageUrl) {
        return JsExtensions.DefaultImpls.getVerificationCodeusePhone(this, imageUrl);
    }

    @Override
    @NotNull
    public Connection.Response post(@NotNull String urlStr, @NotNull String body, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.post(this, urlStr, body, headers);
    }

    @Override
    @NotNull
    public Connection.Response postusePhone(@NotNull String urlStr, @NotNull String body, @NotNull Map<String, String> headers) {
        return JsExtensions.DefaultImpls.postusePhone(this, urlStr, body, headers);
    }

    @Override
    @NotNull
    public byte[] strToBytes(@NotNull String str) {
        return JsExtensions.DefaultImpls.strToBytes(this, str);
    }

    @Override
    @NotNull
    public byte[] strToBytes(@NotNull String str, @NotNull String charset) {
        return JsExtensions.DefaultImpls.strToBytes(this, str, charset);
    }

    @Override
    @NotNull
    public String bytesToStr(@NotNull byte[] bytes2) {
        return JsExtensions.DefaultImpls.bytesToStr(this, bytes2);
    }

    @Override
    @NotNull
    public String bytesToStr(@NotNull byte[] bytes2, @NotNull String charset) {
        return JsExtensions.DefaultImpls.bytesToStr(this, bytes2, charset);
    }

    @Override
    @NotNull
    public String base64Decode(@NotNull String str) {
        return JsExtensions.DefaultImpls.base64Decode(this, str);
    }

    @Override
    @NotNull
    public String base64Decode(@Nullable String str, @NotNull String charset) {
        return JsExtensions.DefaultImpls.base64Decode((JsExtensions)this, str, charset);
    }

    @Override
    @NotNull
    public String base64Decode(@NotNull String str, int flags) {
        return JsExtensions.DefaultImpls.base64Decode((JsExtensions)this, str, flags);
    }

    @Override
    @Nullable
    public byte[] base64DecodeToByteArray(@Nullable String str) {
        return JsExtensions.DefaultImpls.base64DecodeToByteArray(this, str);
    }

    @Override
    @Nullable
    public byte[] base64DecodeToByteArray(@Nullable String str, int flags) {
        return JsExtensions.DefaultImpls.base64DecodeToByteArray(this, str, flags);
    }

    @Override
    @Nullable
    public String base64Encode(@NotNull String str) {
        return JsExtensions.DefaultImpls.base64Encode(this, str);
    }

    @Override
    @Nullable
    public String base64Encode(@NotNull String str, int flags) {
        return JsExtensions.DefaultImpls.base64Encode(this, str, flags);
    }

    @Override
    @Nullable
    public byte[] hexDecodeToByteArray(@NotNull String hex) {
        return JsExtensions.DefaultImpls.hexDecodeToByteArray(this, hex);
    }

    @Override
    @Nullable
    public String hexDecodeToString(@NotNull String hex) {
        return JsExtensions.DefaultImpls.hexDecodeToString(this, hex);
    }

    @Override
    @Nullable
    public String hexEncodeToString(@NotNull String utf8) {
        return JsExtensions.DefaultImpls.hexEncodeToString(this, utf8);
    }

    @Override
    @Nullable
    public String timeFormatUTC(long time, @NotNull String format, int sh) {
        return JsExtensions.DefaultImpls.timeFormatUTC(this, time, format, sh);
    }

    @Override
    @NotNull
    public String timeFormat(long time) {
        return JsExtensions.DefaultImpls.timeFormat(this, time);
    }

    @Override
    @NotNull
    public String utf8ToGbk(@NotNull String str) {
        return JsExtensions.DefaultImpls.utf8ToGbk(this, str);
    }

    @Override
    @NotNull
    public String encodeURI(@NotNull String str) {
        return JsExtensions.DefaultImpls.encodeURI(this, str);
    }

    @Override
    @NotNull
    public String encodeURI(@NotNull String str, @NotNull String enc) {
        return JsExtensions.DefaultImpls.encodeURI(this, str, enc);
    }

    @Override
    @NotNull
    public String htmlFormat(@NotNull String str) {
        return JsExtensions.DefaultImpls.htmlFormat(this, str);
    }

    @Override
    @NotNull
    public String t2s(@NotNull String text) {
        return JsExtensions.DefaultImpls.t2s(this, text);
    }

    @Override
    @NotNull
    public String s2t(@NotNull String text) {
        return JsExtensions.DefaultImpls.s2t(this, text);
    }

    @Override
    @NotNull
    public File getFile(@NotNull String path) {
        return JsExtensions.DefaultImpls.getFile(this, path);
    }

    @Override
    @Nullable
    public byte[] readFile(@NotNull String path) {
        return JsExtensions.DefaultImpls.readFile(this, path);
    }

    @Override
    @NotNull
    public String readTxtFile(@NotNull String path) {
        return JsExtensions.DefaultImpls.readTxtFile(this, path);
    }

    @Override
    @NotNull
    public String readTxtFile(@NotNull String path, @NotNull String charsetName) {
        return JsExtensions.DefaultImpls.readTxtFile(this, path, charsetName);
    }

    @Override
    public void deleteFile(@NotNull String path) {
        JsExtensions.DefaultImpls.deleteFile(this, path);
    }

    @Override
    @NotNull
    public String unzipFile(@NotNull String zipPath) {
        return JsExtensions.DefaultImpls.unzipFile(this, zipPath);
    }

    @Override
    @NotNull
    public String getTxtInFolder(@NotNull String unzipPath) {
        return JsExtensions.DefaultImpls.getTxtInFolder(this, unzipPath);
    }

    @Override
    @NotNull
    public String getZipStringContent(@NotNull String url, @NotNull String path) {
        return JsExtensions.DefaultImpls.getZipStringContent(this, url, path);
    }

    @Override
    @NotNull
    public String getZipStringContent(@NotNull String url, @NotNull String path, @NotNull String charsetName) {
        return JsExtensions.DefaultImpls.getZipStringContent(this, url, path, charsetName);
    }

    @Override
    @Nullable
    public byte[] getZipByteArrayContent(@NotNull String url, @NotNull String path) {
        return JsExtensions.DefaultImpls.getZipByteArrayContent(this, url, path);
    }

    @Override
    @Nullable
    public QueryTTF queryBase64TTF(@Nullable String base64) {
        return JsExtensions.DefaultImpls.queryBase64TTF(this, base64);
    }

    @Override
    @Nullable
    public QueryTTF queryTTF(@Nullable String str) {
        return JsExtensions.DefaultImpls.queryTTF(this, str);
    }

    @Override
    @NotNull
    public String replaceFont(@NotNull String text, @Nullable QueryTTF font1, @Nullable QueryTTF font2) {
        return JsExtensions.DefaultImpls.replaceFont(this, text, font1, font2);
    }

    @Override
    @Nullable
    public String toNumChapter(@Nullable String s) {
        return JsExtensions.DefaultImpls.toNumChapter(this, s);
    }

    @Override
    @NotNull
    public JsURL toURL(@NotNull String urlStr) {
        return JsExtensions.DefaultImpls.toURL(this, urlStr);
    }

    @Override
    @NotNull
    public JsURL toURL(@NotNull String url, @Nullable String baseUrl) {
        return JsExtensions.DefaultImpls.toURL(this, url, baseUrl);
    }

    @Override
    @Nullable
    public Object log(@Nullable Object msg) {
        return JsExtensions.DefaultImpls.log(this, msg);
    }

    @Override
    public void logType(@Nullable Object any) {
        JsExtensions.DefaultImpls.logType(this, any);
    }

    @Override
    @NotNull
    public String randomUUID() {
        return JsExtensions.DefaultImpls.randomUUID(this);
    }

    @Override
    public void openUrl(@NotNull String url) {
        JsExtensions.DefaultImpls.openUrl(this, url);
    }

    @Override
    public void openUrl(@NotNull String url, @Nullable String mimeType) {
        JsExtensions.DefaultImpls.openUrl(this, url, mimeType);
    }

    @Override
    @NotNull
    public String md5Encode(@NotNull String str) {
        return JsExtensions.DefaultImpls.md5Encode(this, str);
    }

    @Override
    @NotNull
    public String md5Encode16(@NotNull String str) {
        return JsExtensions.DefaultImpls.md5Encode16(this, str);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @Nullable byte[] key, @Nullable byte[] iv) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key, iv);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @NotNull byte[] key) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @NotNull String key) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key);
    }

    @Override
    @NotNull
    public SymmetricCrypto createSymmetricCrypto(@NotNull String transformation, @NotNull String key, @Nullable String iv) {
        return JsExtensions.DefaultImpls.createSymmetricCrypto((JsExtensions)this, transformation, key, iv);
    }

    @Override
    @NotNull
    public AsymmetricCrypto createAsymmetricCrypto(@NotNull String transformation) {
        return JsExtensions.DefaultImpls.createAsymmetricCrypto(this, transformation);
    }

    @Override
    @NotNull
    public Sign createSign(@NotNull String algorithm) {
        return JsExtensions.DefaultImpls.createSign(this, algorithm);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decrypt(str)", imports={}))
    @Nullable
    public byte[] aesDecodeToByteArray(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesDecodeToByteArray(this, str, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(str)", imports={}))
    @Nullable
    public String aesDecodeToString(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesDecodeToString(this, str, key, transformation, iv);
    }

    @Override
    @NotNull
    public String getjs(@NotNull String js) {
        return JsExtensions.DefaultImpls.getjs(this, js);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String aesDecodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesDecodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decrypt(str)", imports={}))
    @Nullable
    public byte[] aesBase64DecodeToByteArray(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesBase64DecodeToByteArray(this, str, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(str)", imports={}))
    @Nullable
    public String aesBase64DecodeToString(@NotNull String str, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesBase64DecodeToString(this, str, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decrypt(data)", imports={}))
    @Nullable
    public byte[] aesEncodeToByteArray(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToByteArray(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String aesEncodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data).toByteArray()", imports={}))
    @Nullable
    public byte[] aesEncodeToBase64ByteArray(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToBase64ByteArray(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String aesEncodeToBase64String(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeToBase64String(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String aesEncodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.aesEncodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String desDecodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desDecodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String desBase64DecodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desBase64DecodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encrypt(data)", imports={}))
    @Nullable
    public String desEncodeToString(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desEncodeToString(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String desEncodeToBase64String(@NotNull String data, @NotNull String key, @NotNull String transformation, @NotNull String iv) {
        return JsExtensions.DefaultImpls.desEncodeToBase64String(this, data, key, transformation, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String tripleDESDecodeStr(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESDecodeStr(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).decryptStr(data)", imports={}))
    @Nullable
    public String tripleDESDecodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESDecodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String tripleDESEncodeBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESEncodeBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @Deprecated(message="\u8fc7\u4e8e\u7e41\u7410\u5f03\u7528", replaceWith=@ReplaceWith(expression="createSymmetricCrypto(transformation, key, iv).encryptBase64(data)", imports={}))
    @Nullable
    public String tripleDESEncodeArgsBase64Str(@NotNull String data, @NotNull String key, @NotNull String mode, @NotNull String padding, @NotNull String iv) {
        return JsExtensions.DefaultImpls.tripleDESEncodeArgsBase64Str(this, data, key, mode, padding, iv);
    }

    @Override
    @NotNull
    public String digestHex(@NotNull String data, @NotNull String algorithm) {
        return JsExtensions.DefaultImpls.digestHex(this, data, algorithm);
    }

    @Override
    @NotNull
    public String digestBase64Str(@NotNull String data, @NotNull String algorithm) {
        return JsExtensions.DefaultImpls.digestBase64Str(this, data, algorithm);
    }

    @Override
    @NotNull
    public String HMacHex(@NotNull String data, @NotNull String algorithm, @NotNull String key) {
        return JsExtensions.DefaultImpls.HMacHex(this, data, algorithm, key);
    }

    @Override
    @NotNull
    public String HMacBase64(@NotNull String data, @NotNull String algorithm, @NotNull String key) {
        return JsExtensions.DefaultImpls.HMacBase64(this, data, algorithm, key);
    }

    @JvmOverloads
    @NotNull
    public final AnalyzeRule setContent(@Nullable Object content) {
        return AnalyzeRule.setContent$default(this, content, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final List<String> getStringList(@Nullable String rule, @Nullable Object mContent) {
        return AnalyzeRule.getStringList$default(this, rule, mContent, false, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final List<String> getStringList(@Nullable String rule) {
        return AnalyzeRule.getStringList$default(this, rule, null, false, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final List<String> getStringList(@NotNull List<SourceRule> ruleList, @Nullable Object mContent) {
        Intrinsics.checkNotNullParameter(ruleList, (String)"ruleList");
        return AnalyzeRule.getStringList$default(this, ruleList, mContent, false, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final List<String> getStringList(@NotNull List<SourceRule> ruleList) {
        Intrinsics.checkNotNullParameter(ruleList, (String)"ruleList");
        return AnalyzeRule.getStringList$default(this, ruleList, null, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String getString(@Nullable String ruleStr, @Nullable Object mContent) {
        return AnalyzeRule.getString$default(this, ruleStr, mContent, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final String getString(@Nullable String ruleStr) {
        return AnalyzeRule.getString$default(this, ruleStr, null, false, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final String getString(@NotNull List<SourceRule> ruleList, @Nullable Object mContent, boolean isUrl) {
        Intrinsics.checkNotNullParameter(ruleList, (String)"ruleList");
        return AnalyzeRule.getString$default(this, ruleList, mContent, isUrl, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final String getString(@NotNull List<SourceRule> ruleList, @Nullable Object mContent) {
        Intrinsics.checkNotNullParameter(ruleList, (String)"ruleList");
        return AnalyzeRule.getString$default(this, ruleList, mContent, false, false, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final String getString(@NotNull List<SourceRule> ruleList) {
        Intrinsics.checkNotNullParameter(ruleList, (String)"ruleList");
        return AnalyzeRule.getString$default(this, ruleList, null, false, false, 14, null);
    }

    public AnalyzeRule() {
        this(null, null, null, 7, null);
    }

    public static final /* synthetic */ BaseSource access$getSource$p(AnalyzeRule $this) {
        return $this.source;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lbook/webBook/analyzeRule/AnalyzeRule$Companion;", "", "<init>", "()V", "putPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "evalPattern", "regexPattern", "titleNumPattern", "book"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lbook/webBook/analyzeRule/AnalyzeRule$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "XPath", "Json", "Default", "Js", "Regex", "book"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode XPath = new Mode();
        public static final /* enum */ Mode Json = new Mode();
        public static final /* enum */ Mode Default = new Mode();
        public static final /* enum */ Mode Js = new Mode();
        public static final /* enum */ Mode Regex = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.XPath, Mode.Json, Mode.Default, Mode.Js, Mode.Regex};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010\u0001J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010.\u001a\u00020%R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR0\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001ej\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020%X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lbook/webBook/analyzeRule/AnalyzeRule$SourceRule;", "", "ruleStr", "", "mode", "Lbook/webBook/analyzeRule/AnalyzeRule$Mode;", "<init>", "(Lbook/webBook/analyzeRule/AnalyzeRule;Ljava/lang/String;Lbook/webBook/analyzeRule/AnalyzeRule$Mode;)V", "getMode$book", "()Lbook/webBook/analyzeRule/AnalyzeRule$Mode;", "setMode$book", "(Lbook/webBook/analyzeRule/AnalyzeRule$Mode;)V", "rule", "getRule$book", "()Ljava/lang/String;", "setRule$book", "(Ljava/lang/String;)V", "replaceRegex", "getReplaceRegex$book", "setReplaceRegex$book", "replacement", "getReplacement$book", "setReplacement$book", "replaceFirst", "", "getReplaceFirst$book", "()Z", "setReplaceFirst$book", "(Z)V", "putMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getPutMap$book", "()Ljava/util/HashMap;", "ruleParam", "Ljava/util/ArrayList;", "ruleType", "", "getRuleType", "jsRuleType", "defaultRuleType", "splitRegex", "", "makeUpRule", "result", "isRule", "getParamSize", "book"})
    public final class SourceRule {
        @NotNull
        private Mode mode;
        @NotNull
        private String rule;
        @NotNull
        private String replaceRegex;
        @NotNull
        private String replacement;
        private boolean replaceFirst;
        @NotNull
        private final HashMap<String, String> putMap;
        @NotNull
        private final ArrayList<String> ruleParam;
        @NotNull
        private final ArrayList<Integer> ruleType;
        private final int getRuleType;
        private final int jsRuleType;
        private final int defaultRuleType;
        final /* synthetic */ AnalyzeRule this$0;

        public SourceRule(@NotNull AnalyzeRule this$0, @NotNull String ruleStr, Mode mode) {
            String string;
            Intrinsics.checkNotNullParameter((Object)ruleStr, (String)"ruleStr");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            this.this$0 = this$0;
            this.mode = mode;
            this.replaceRegex = "";
            this.replacement = "";
            this.putMap = new HashMap();
            this.ruleParam = new ArrayList();
            this.ruleType = new ArrayList();
            this.getRuleType = -2;
            this.jsRuleType = -1;
            if (this.mode == Mode.Js || this.mode == Mode.Regex) {
                string = ruleStr;
            } else if (StringsKt.startsWith((String)ruleStr, (String)"@CSS:", (boolean)true)) {
                this.mode = Mode.Default;
                string = ruleStr;
            } else if (StringsKt.startsWith$default((String)ruleStr, (String)"@@", (boolean)false, (int)2, null)) {
                this.mode = Mode.Default;
                String string2 = ruleStr.substring(2);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else if (StringsKt.startsWith((String)ruleStr, (String)"@XPath:", (boolean)true)) {
                this.mode = Mode.XPath;
                String string3 = ruleStr.substring(7);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else if (StringsKt.startsWith((String)ruleStr, (String)"@Json:", (boolean)true)) {
                this.mode = Mode.Json;
                String string4 = ruleStr.substring(6);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            } else if (this.this$0.isJSON || StringsKt.startsWith$default((String)ruleStr, (String)"$.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)ruleStr, (String)"$[", (boolean)false, (int)2, null)) {
                this.mode = Mode.Json;
                string = ruleStr;
            } else if (StringsKt.startsWith$default((String)ruleStr, (String)"/", (boolean)false, (int)2, null)) {
                this.mode = Mode.XPath;
                string = ruleStr;
            } else {
                string = ruleStr;
            }
            this.rule = string;
            this.rule = this.this$0.splitPutRule(this.rule, this.putMap);
            int start = 0;
            String tmp = null;
            Matcher evalMatcher = evalPattern.matcher(this.rule);
            if (evalMatcher.find()) {
                String string5 = this.rule.substring(start, evalMatcher.start());
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                tmp = string5;
                if (!(this.mode == Mode.Js || this.mode == Mode.Regex || evalMatcher.start() != 0 && StringsKt.contains$default((CharSequence)tmp, (CharSequence)"##", (boolean)false, (int)2, null))) {
                    this.mode = Mode.Regex;
                }
                do {
                    if (evalMatcher.start() > start) {
                        String string6 = this.rule.substring(start, evalMatcher.start());
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        tmp = string6;
                        this.splitRegex(tmp);
                    }
                    tmp = evalMatcher.group();
                    if (StringsKt.startsWith((String)tmp, (String)"@get:", (boolean)true)) {
                        this.ruleType.add(this.getRuleType);
                        String string7 = tmp.substring(6, StringsKt.getLastIndex((CharSequence)tmp));
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                        this.ruleParam.add(string7);
                    } else if (StringsKt.startsWith$default((String)tmp, (String)"{{", (boolean)false, (int)2, null)) {
                        this.ruleType.add(this.jsRuleType);
                        String string8 = tmp.substring(2, tmp.length() - 2);
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                        this.ruleParam.add(string8);
                    } else {
                        this.splitRegex(tmp);
                    }
                    start = evalMatcher.end();
                } while (evalMatcher.find());
            }
            if (this.rule.length() > start) {
                String string9 = this.rule.substring(start);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                tmp = string9;
                this.splitRegex(tmp);
            }
        }

        public /* synthetic */ SourceRule(AnalyzeRule analyzeRule, String string, Mode mode, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                mode = Mode.Default;
            }
            this(analyzeRule, string, mode);
        }

        @NotNull
        public final Mode getMode$book() {
            return this.mode;
        }

        public final void setMode$book(@NotNull Mode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
            this.mode = mode;
        }

        @NotNull
        public final String getRule$book() {
            return this.rule;
        }

        public final void setRule$book(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.rule = string;
        }

        @NotNull
        public final String getReplaceRegex$book() {
            return this.replaceRegex;
        }

        public final void setReplaceRegex$book(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.replaceRegex = string;
        }

        @NotNull
        public final String getReplacement$book() {
            return this.replacement;
        }

        public final void setReplacement$book(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.replacement = string;
        }

        public final boolean getReplaceFirst$book() {
            return this.replaceFirst;
        }

        public final void setReplaceFirst$book(boolean bl) {
            this.replaceFirst = bl;
        }

        @NotNull
        public final HashMap<String, String> getPutMap$book() {
            return this.putMap;
        }

        private final void splitRegex(String ruleStr) {
            int start = 0;
            String tmp = null;
            String[] stringArray = new String[]{"##"};
            List ruleStrArray = StringsKt.split$default((CharSequence)ruleStr, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Matcher regexMatcher = regexPattern.matcher((CharSequence)ruleStrArray.get(0));
            if (regexMatcher.find()) {
                if (this.mode != Mode.Js && this.mode != Mode.Regex) {
                    this.mode = Mode.Regex;
                }
                do {
                    if (regexMatcher.start() > start) {
                        String string = ruleStr.substring(start, regexMatcher.start());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        tmp = string;
                        this.ruleType.add(this.defaultRuleType);
                        this.ruleParam.add(tmp);
                    }
                    tmp = regexMatcher.group();
                    String string = tmp.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    this.ruleType.add(Integer.parseInt(string));
                    this.ruleParam.add(tmp);
                    start = regexMatcher.end();
                } while (regexMatcher.find());
            }
            if (ruleStr.length() > start) {
                String string = ruleStr.substring(start);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                tmp = string;
                this.ruleType.add(this.defaultRuleType);
                this.ruleParam.add(tmp);
            }
        }

        public final void makeUpRule(@Nullable Object result) {
            StringBuilder infoVal = new StringBuilder();
            if (!((Collection)this.ruleParam).isEmpty()) {
                int index = this.ruleParam.size();
                while (index-- > 0) {
                    StringBuilder stringBuilder;
                    Integer n = this.ruleType.get(index);
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
                    int regType = ((Number)n).intValue();
                    if (regType > this.defaultRuleType) {
                        if ((result instanceof List ? (List)result : null) != null) {
                            List $this$makeUpRule_u24lambda_u241;
                            $this$makeUpRule_u24lambda_u241 = $this$makeUpRule_u24lambda_u241;
                            boolean bl = false;
                            if ($this$makeUpRule_u24lambda_u241.size() > regType) {
                                if ((String)$this$makeUpRule_u24lambda_u241.get(regType) != null) {
                                    String it;
                                    boolean bl2 = false;
                                    infoVal.insert(0, it);
                                }
                            }
                            stringBuilder = Unit.INSTANCE;
                            continue;
                        }
                        stringBuilder = infoVal.insert(0, this.ruleParam.get(index));
                        continue;
                    }
                    if (regType == this.jsRuleType) {
                        String string = this.ruleParam.get(index);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                        if (this.isRule(string)) {
                            Object[] objectArray = new SourceRule[1];
                            String string2 = this.ruleParam.get(index);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                            objectArray[0] = new SourceRule(this.this$0, string2, null, 2, null);
                            String it = AnalyzeRule.getString$default(this.this$0, CollectionsKt.arrayListOf((Object[])objectArray), null, false, false, 14, null);
                            boolean bl = false;
                            stringBuilder = infoVal.insert(0, it);
                            continue;
                        }
                        String string3 = this.ruleParam.get(index);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
                        Object jsEval = this.this$0.evalJS(string3, result);
                        if (jsEval == null) {
                            stringBuilder = Unit.INSTANCE;
                            continue;
                        }
                        if (jsEval instanceof String) {
                            stringBuilder = infoVal.insert(0, (String)jsEval);
                            continue;
                        }
                        if (jsEval instanceof Double && ((Number)jsEval).doubleValue() % 1.0 == 0.0) {
                            Locale locale = Locale.ROOT;
                            String string4 = "%.0f";
                            Object[] objectArray = new Object[]{jsEval};
                            String string5 = String.format(locale, string4, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
                            stringBuilder = infoVal.insert(0, string5);
                            continue;
                        }
                        stringBuilder = infoVal.insert(0, jsEval.toString());
                        continue;
                    }
                    if (regType == this.getRuleType) {
                        String string = this.ruleParam.get(index);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                        stringBuilder = infoVal.insert(0, this.this$0.get(string));
                        continue;
                    }
                    stringBuilder = infoVal.insert(0, this.ruleParam.get(index));
                }
                this.rule = infoVal.toString();
            }
            String[] stringArray = new String[]{"##"};
            List ruleStrS = StringsKt.split$default((CharSequence)this.rule, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            this.rule = ((Object)StringsKt.trim((CharSequence)((String)ruleStrS.get(0)))).toString();
            if (ruleStrS.size() > 1) {
                this.replaceRegex = (String)ruleStrS.get(1);
            }
            if (ruleStrS.size() > 2) {
                this.replacement = (String)ruleStrS.get(2);
            }
            if (ruleStrS.size() > 3) {
                this.replaceFirst = true;
            }
        }

        private final boolean isRule(String ruleStr) {
            return StringsKt.startsWith$default((CharSequence)ruleStr, (char)'@', (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)ruleStr, (String)"$.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)ruleStr, (String)"$[", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)ruleStr, (String)"//", (boolean)false, (int)2, null);
        }

        public final int getParamSize() {
            return this.ruleParam.size();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Mode.values().length];
            try {
                nArray[Mode.Js.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.Json.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.XPath.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.Default.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mode.Regex.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

