/*
 * Decompiled with CFR 0.152.
 */
package book.webBook.analyzeRule;

import book.util.TextUtils;
import book.webBook.analyzeRule.RuleAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.seimicrawler.xpath.JXDocument;
import org.seimicrawler.xpath.JXNode;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001d\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0010J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lbook/webBook/analyzeRule/AnalyzeByXPath;", "", "doc", "<init>", "(Ljava/lang/Object;)V", "jxNode", "parse", "strToJXDocument", "Lorg/seimicrawler/xpath/JXDocument;", "html", "", "getResult", "", "Lorg/seimicrawler/xpath/JXNode;", "xPath", "getElements", "getElements$book", "getStringList", "getStringList$book", "getString", "rule", "book"})
@SourceDebugExtension(value={"SMAP\nAnalyzeByXPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyzeByXPath.kt\nbook/webBook/analyzeRule/AnalyzeByXPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1557#2:149\n1628#2,3:150\n*S KotlinDebug\n*F\n+ 1 AnalyzeByXPath.kt\nbook/webBook/analyzeRule/AnalyzeByXPath\n*L\n91#1:149\n91#1:150,3\n*E\n"})
public final class AnalyzeByXPath {
    @NotNull
    private Object jxNode;

    public AnalyzeByXPath(@NotNull Object doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.jxNode = this.parse(doc);
    }

    private final Object parse(Object doc) {
        Object object;
        Object object2 = doc;
        if (object2 instanceof JXNode) {
            if (((JXNode)doc).isElement()) {
                object = doc;
            } else {
                String string = ((JXNode)doc).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                object = this.strToJXDocument(string);
            }
        } else if (object2 instanceof Document) {
            JXDocument jXDocument = JXDocument.create((Document)((Document)doc));
            object = jXDocument;
            Intrinsics.checkNotNullExpressionValue((Object)jXDocument, (String)"create(...)");
        } else if (object2 instanceof Element) {
            Element[] elementArray = new Element[]{doc};
            JXDocument jXDocument = JXDocument.create((Elements)new Elements(elementArray));
            object = jXDocument;
            Intrinsics.checkNotNullExpressionValue((Object)jXDocument, (String)"create(...)");
        } else if (object2 instanceof Elements) {
            JXDocument jXDocument = JXDocument.create((Elements)((Elements)doc));
            object = jXDocument;
            Intrinsics.checkNotNullExpressionValue((Object)jXDocument, (String)"create(...)");
        } else {
            object = this.strToJXDocument(doc.toString());
        }
        return object;
    }

    private final JXDocument strToJXDocument(String html) {
        Object html1 = html;
        if (StringsKt.endsWith$default((String)html1, (String)"</td>", (boolean)false, (int)2, null)) {
            html1 = "<tr>" + (String)html1 + "</tr>";
        }
        if (StringsKt.endsWith$default((String)html1, (String)"</tr>", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)html1, (String)"</tbody>", (boolean)false, (int)2, null)) {
            html1 = "<table>" + (String)html1 + "</table>";
        }
        JXDocument jXDocument = JXDocument.create((String)html1);
        Intrinsics.checkNotNullExpressionValue((Object)jXDocument, (String)"create(...)");
        return jXDocument;
    }

    private final List<JXNode> getResult(String xPath) {
        List list;
        Object node = this.jxNode;
        if (node instanceof JXNode) {
            list = ((JXNode)node).sel(xPath);
        } else {
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.seimicrawler.xpath.JXDocument");
            list = ((JXDocument)node).selN(xPath);
        }
        return list;
    }

    @Nullable
    public final List<JXNode> getElements$book(@NotNull String xPath) {
        ArrayList jxNodes;
        block8: {
            Intrinsics.checkNotNullParameter((Object)xPath, (String)"xPath");
            if (((CharSequence)xPath).length() == 0) {
                return null;
            }
            jxNodes = new ArrayList();
            RuleAnalyzer ruleAnalyzes = new RuleAnalyzer(xPath, false, 2, null);
            String[] stringArray = new String[]{"&&", "||", "%%"};
            ArrayList<String> rules = ruleAnalyzes.splitRule(stringArray);
            if (rules.size() == 1) {
                String string = rules.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                return this.getResult(string);
            }
            ArrayList<List<JXNode>> results = new ArrayList<List<JXNode>>();
            Iterator<String> iterator = rules.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> iterator2 = iterator;
            while (iterator2.hasNext()) {
                String rl;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                List<JXNode> temp = this.getElements$book(rl);
                if (temp == null || !(!((Collection)temp).isEmpty())) continue;
                results.add(temp);
                if (!(!((Collection)temp).isEmpty()) || !Intrinsics.areEqual((Object)ruleAnalyzes.getElementsType(), (Object)"||")) continue;
            }
            if (results.size() <= 0) break block8;
            if (Intrinsics.areEqual((Object)"%%", (Object)ruleAnalyzes.getElementsType())) {
                int rl = ((Collection)results.get(0)).size();
                for (int i = 0; i < rl; ++i) {
                    Iterator iterator3;
                    Intrinsics.checkNotNullExpressionValue(results.iterator(), (String)"iterator(...)");
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        List temp = (List)e;
                        if (i >= temp.size()) continue;
                        jxNodes.add(temp.get(i));
                    }
                }
            } else {
                Iterator iterator4 = results.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
                iterator2 = iterator4;
                while (iterator2.hasNext()) {
                    String string = iterator2.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"next(...)");
                    List temp = (List)((Object)string);
                    jxNodes.addAll(temp);
                }
            }
        }
        return jxNodes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStringList$book(@NotNull String xPath) {
        ArrayList<String> result;
        block9: {
            Intrinsics.checkNotNullParameter((Object)xPath, (String)"xPath");
            result = new ArrayList<String>();
            RuleAnalyzer ruleAnalyzes = new RuleAnalyzer(xPath, false, 2, null);
            String[] stringArray = new String[]{"&&", "||", "%%"};
            ArrayList<String> rules = ruleAnalyzes.splitRule(stringArray);
            if (rules.size() == 1) {
                List<JXNode> list = this.getResult(xPath);
                if (list != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JXNode jXNode = (JXNode)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(result.add(it.asString()));
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                }
                return result;
            }
            ArrayList<List<String>> results = new ArrayList<List<String>>();
            Iterator<String> iterator = rules.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<String> $this$map$iv = iterator;
            while ($this$map$iv.hasNext()) {
                String rl;
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv.next(), (String)"next(...)");
                List<String> temp = this.getStringList$book(rl);
                if (!(!((Collection)temp).isEmpty())) continue;
                results.add(temp);
                if (!(!((Collection)temp).isEmpty()) || !Intrinsics.areEqual((Object)ruleAnalyzes.getElementsType(), (Object)"||")) continue;
            }
            if (results.size() <= 0) break block9;
            if (Intrinsics.areEqual((Object)"%%", (Object)ruleAnalyzes.getElementsType())) {
                int rl = ((Collection)results.get(0)).size();
                for (int i = 0; i < rl; ++i) {
                    Iterator iterator2;
                    Intrinsics.checkNotNullExpressionValue(results.iterator(), (String)"iterator(...)");
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        List temp = (List)e;
                        if (i >= temp.size()) continue;
                        result.add((String)temp.get(i));
                    }
                }
            } else {
                Iterator iterator3 = results.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
                Iterator iterator4 = iterator3;
                while (iterator4.hasNext()) {
                    Object e = iterator4.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    List temp = (List)e;
                    result.addAll(temp);
                }
            }
        }
        return result;
    }

    @Nullable
    public final String getString(@NotNull String rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        RuleAnalyzer ruleAnalyzes = new RuleAnalyzer(rule, false, 2, null);
        Object object = new String[]{"&&", "||"};
        ArrayList<String> rules = ruleAnalyzes.splitRule((String)object);
        if (rules.size() == 1) {
            object = this.getResult(rule);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                return TextUtils.join((CharSequence)"\n", (Iterable)it);
            }
            return null;
        }
        ArrayList<String> textList = new ArrayList<String>();
        Iterator<String> iterator = rules.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String rl;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            String temp = this.getString(rl);
            CharSequence charSequence = temp;
            if (charSequence == null || charSequence.length() == 0) continue;
            textList.add(temp);
            if (!Intrinsics.areEqual((Object)ruleAnalyzes.getElementsType(), (Object)"||")) continue;
            break;
        }
        return CollectionsKt.joinToString$default((Iterable)textList, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

