/*
 * Decompiled with CFR 0.152.
 */
package book.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\tJ!\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ1\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019\u00a2\u0006\u0002\u0010\u001eJ \u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\tJA\u0010\u001f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010 J)\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002\u00a2\u0006\u0002\u0010#J'\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00182\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\u00020\t2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\u0018H\u0002\u00a2\u0006\u0002\u0010)R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006+"}, d2={"Lbook/util/http/SSLHelper;", "", "<init>", "()V", "sslSocketFactory", "Lbook/util/http/SSLHelper$SSLParams;", "getSslSocketFactory", "()Lbook/util/http/SSLHelper$SSLParams;", "unsafeTrustManager", "Ljavax/net/ssl/X509TrustManager;", "getUnsafeTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "unsafeSSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getUnsafeSSLSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "unsafeSSLSocketFactory$delegate", "Lkotlin/Lazy;", "unsafeHostnameVerifier", "Ljavax/net/ssl/HostnameVerifier;", "getUnsafeHostnameVerifier", "()Ljavax/net/ssl/HostnameVerifier;", "trustManager", "certificates", "", "Ljava/io/InputStream;", "([Ljava/io/InputStream;)Lbook/util/http/SSLHelper$SSLParams;", "bksFile", "password", "", "(Ljava/io/InputStream;Ljava/lang/String;[Ljava/io/InputStream;)Lbook/util/http/SSLHelper$SSLParams;", "getSslSocketFactoryBase", "(Ljavax/net/ssl/X509TrustManager;Ljava/io/InputStream;Ljava/lang/String;[Ljava/io/InputStream;)Lbook/util/http/SSLHelper$SSLParams;", "prepareKeyManager", "Ljavax/net/ssl/KeyManager;", "(Ljava/io/InputStream;Ljava/lang/String;)[Ljavax/net/ssl/KeyManager;", "prepareTrustManager", "Ljavax/net/ssl/TrustManager;", "([Ljava/io/InputStream;)[Ljavax/net/ssl/TrustManager;", "chooseTrustManager", "trustManagers", "([Ljavax/net/ssl/TrustManager;)Ljavax/net/ssl/X509TrustManager;", "SSLParams", "book"})
public final class SSLHelper {
    @NotNull
    public static final SSLHelper INSTANCE = new SSLHelper();
    @NotNull
    private static final X509TrustManager unsafeTrustManager = new X509TrustManager(){

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    @NotNull
    private static final Lazy unsafeSSLSocketFactory$delegate = LazyKt.lazy(SSLHelper::unsafeSSLSocketFactory_delegate$lambda$0);
    @NotNull
    private static final HostnameVerifier unsafeHostnameVerifier = SSLHelper::unsafeHostnameVerifier$lambda$1;

    private SSLHelper() {
    }

    @Nullable
    public final SSLParams getSslSocketFactory() {
        return this.getSslSocketFactoryBase(null, null, null, new InputStream[0]);
    }

    @NotNull
    public final X509TrustManager getUnsafeTrustManager() {
        return unsafeTrustManager;
    }

    @NotNull
    public final SSLSocketFactory getUnsafeSSLSocketFactory() {
        Lazy lazy = unsafeSSLSocketFactory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (SSLSocketFactory)object;
    }

    @NotNull
    public final HostnameVerifier getUnsafeHostnameVerifier() {
        return unsafeHostnameVerifier;
    }

    @Nullable
    public final SSLParams getSslSocketFactory(@NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        return this.getSslSocketFactoryBase(trustManager, null, null, new InputStream[0]);
    }

    @Nullable
    public final SSLParams getSslSocketFactory(InputStream ... certificates) {
        Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
        return this.getSslSocketFactoryBase(null, null, null, Arrays.copyOf(certificates, certificates.length));
    }

    @Nullable
    public final SSLParams getSslSocketFactory(@NotNull InputStream bksFile, @NotNull String password, InputStream ... certificates) {
        Intrinsics.checkNotNullParameter((Object)bksFile, (String)"bksFile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
        return this.getSslSocketFactoryBase(null, bksFile, password, Arrays.copyOf(certificates, certificates.length));
    }

    @Nullable
    public final SSLParams getSslSocketFactory(@NotNull InputStream bksFile, @NotNull String password, @NotNull X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)bksFile, (String)"bksFile");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        return this.getSslSocketFactoryBase(trustManager, bksFile, password, new InputStream[0]);
    }

    private final SSLParams getSslSocketFactoryBase(X509TrustManager trustManager, InputStream bksFile, String password, InputStream ... certificates) {
        SSLParams sslParams = new SSLParams();
        try {
            KeyManager[] keyManagers = this.prepareKeyManager(bksFile, password);
            TrustManager[] trustManagers = this.prepareTrustManager(Arrays.copyOf(certificates, certificates.length));
            X509TrustManager x509TrustManager = trustManager;
            if (x509TrustManager == null) {
                x509TrustManager = this.chooseTrustManager(trustManagers);
            }
            X509TrustManager manager = x509TrustManager;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{manager};
            sslContext.init(keyManagers, trustManagerArray, null);
            sslParams.setSSLSocketFactory(sslContext.getSocketFactory());
            sslParams.setTrustManager(manager);
            return sslParams;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    private final KeyManager[] prepareKeyManager(InputStream bksFile, String password) {
        try {
            if (bksFile == null || password == null) {
                return null;
            }
            KeyStore clientKeyStore = KeyStore.getInstance("BKS");
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            clientKeyStore.load(bksFile, cArray);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] cArray2 = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
            kmf.init(clientKeyStore, cArray2);
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final TrustManager[] prepareTrustManager(InputStream ... certificates) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        int n = certificates.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            InputStream certStream = certificates[i];
            String certificateAlias = Integer.toString(index);
            Certificate cert = certificateFactory.generateCertificate(certStream);
            keyStore.setCertificateEntry(certificateAlias, cert);
            try {
                certStream.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        TrustManager[] trustManagerArray = tmf.getTrustManagers();
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getTrustManagers(...)");
        return trustManagerArray;
    }

    private final X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new NullPointerException();
    }

    private static final SSLSocketFactory unsafeSSLSocketFactory_delegate$lambda$0() {
        SSLSocketFactory sSLSocketFactory;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            X509TrustManager[] x509TrustManagerArray = new X509TrustManager[1];
            x509TrustManagerArray[0] = unsafeTrustManager;
            sslContext.init(null, x509TrustManagerArray, new SecureRandom());
            sSLSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sSLSocketFactory;
    }

    private static final boolean unsafeHostnameVerifier$lambda$1(String string, SSLSession sSLSession) {
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lbook/util/http/SSLHelper$SSLParams;", "", "<init>", "()V", "sSLSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "getSSLSocketFactory", "()Ljavax/net/ssl/SSLSocketFactory;", "setSSLSocketFactory", "(Ljavax/net/ssl/SSLSocketFactory;)V", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "getTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "setTrustManager", "(Ljavax/net/ssl/X509TrustManager;)V", "book"})
    public static final class SSLParams {
        public SSLSocketFactory sSLSocketFactory;
        public X509TrustManager trustManager;

        @NotNull
        public final SSLSocketFactory getSSLSocketFactory() {
            SSLSocketFactory sSLSocketFactory = this.sSLSocketFactory;
            if (sSLSocketFactory != null) {
                return sSLSocketFactory;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sSLSocketFactory");
            return null;
        }

        public final void setSSLSocketFactory(@NotNull SSLSocketFactory sSLSocketFactory) {
            Intrinsics.checkNotNullParameter((Object)sSLSocketFactory, (String)"<set-?>");
            this.sSLSocketFactory = sSLSocketFactory;
        }

        @NotNull
        public final X509TrustManager getTrustManager() {
            X509TrustManager x509TrustManager = this.trustManager;
            if (x509TrustManager != null) {
                return x509TrustManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"trustManager");
            return null;
        }

        public final void setTrustManager(@NotNull X509TrustManager x509TrustManager) {
            Intrinsics.checkNotNullParameter((Object)x509TrustManager, (String)"<set-?>");
            this.trustManager = x509TrustManager;
        }
    }
}

