/*
 * Decompiled with CFR 0.152.
 */
package book.util.http;

import java.io.BufferedInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Connection;
import org.jsoup.nodes.Document;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020 H\u0016J\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020 H\u0016J\b\u0010\n\u001a\u00020!H\u0016J\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0018\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050%2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\u0018\u0010&\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0018\u0010)\u001a\u00020(2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010*\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0005H\u0016J\u001a\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050%0\u000eH\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0018\u0010,\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020(2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010.\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\n\u00100\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u00100\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u0005H\u0016J\n\u00101\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\u0001H\u0016J\b\u00107\u001a\u000208H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR,\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0007\"\u0004\b\u0016\u0010\tR\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0007\"\u0004\b\u001f\u0010\t\u00a8\u00069"}, d2={"Lbook/util/http/JsonpResponse;", "Lorg/jsoup/Connection$Response;", "<init>", "()V", "url", "", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "method", "getMethod", "setMethod", "headers", "", "", "getHeaders", "()Ljava/util/Map;", "setHeaders", "(Ljava/util/Map;)V", "body", "getBody", "setBody", "statusCode", "", "getStatusCode", "()I", "setStatusCode", "(I)V", "statusMessage", "getStatusMessage", "setStatusMessage", "Ljava/net/URL;", "Lorg/jsoup/Connection$Method;", "header", "name", "value", "", "addHeader", "hasHeader", "", "hasHeaderWithValue", "removeHeader", "multiHeaders", "cookie", "hasCookie", "removeCookie", "cookies", "charset", "contentType", "parse", "Lorg/jsoup/nodes/Document;", "bodyAsBytes", "", "bufferUp", "bodyStream", "Ljava/io/BufferedInputStream;", "book"})
@SourceDebugExtension(value={"SMAP\nJsonpResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonpResponse.kt\nbook/util/http/JsonpResponse\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,242:1\n216#2,2:243\n216#2,2:245\n216#2,2:247\n216#2:249\n217#2:298\n216#2,2:299\n1863#3:250\n1864#3:297\n108#4:251\n80#4,22:252\n108#4:274\n80#4,22:275\n*S KotlinDebug\n*F\n+ 1 JsonpResponse.kt\nbook/util/http/JsonpResponse\n*L\n57#1:243,2\n77#1:245,2\n103#1:247,2\n127#1:249\n127#1:298\n161#1:299,2\n129#1:250\n129#1:297\n133#1:251\n133#1:252,22\n136#1:274\n136#1:275,22\n*E\n"})
public final class JsonpResponse
implements Connection.Response {
    @NotNull
    private String url = "";
    @NotNull
    private String method = "get";
    @NotNull
    private Map<String, List<String>> headers = new LinkedHashMap();
    @NotNull
    private String body = "";
    private int statusCode = 200;
    @NotNull
    private String statusMessage = "";

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.method = string;
    }

    @NotNull
    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public final void setHeaders(@NotNull Map<String, List<String>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.headers = map;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    public final void setBody(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.body = string;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final void setStatusCode(int n) {
        this.statusCode = n;
    }

    @NotNull
    public final String getStatusMessage() {
        return this.statusMessage;
    }

    public final void setStatusMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.statusMessage = string;
    }

    @NotNull
    public URL url() {
        return new URL(this.url);
    }

    @NotNull
    public Connection.Response url(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type org.jsoup.Connection.Response");
        return (Connection.Response)uRLConnection;
    }

    @NotNull
    public Connection.Method method() {
        String string = this.method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string, (Object)"get")) {
            return Connection.Method.GET;
        }
        String string2 = this.method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string2, (Object)"post")) {
            return Connection.Method.POST;
        }
        String string3 = this.method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string3, (Object)"delete")) {
            return Connection.Method.DELETE;
        }
        String string4 = this.method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string4, (Object)"patch")) {
            return Connection.Method.PATCH;
        }
        String string5 = this.method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string5, (Object)"head")) {
            return Connection.Method.HEAD;
        }
        throw new Exception("method error");
    }

    @NotNull
    public Connection.Response method(@NotNull Connection.Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Connection.Base base = this.url(this.url()).method(method);
        Intrinsics.checkNotNullExpressionValue((Object)base, (String)"method(...)");
        return (Connection.Response)base;
    }

    @Nullable
    public String header(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object value = null;
        Map<String, List<String>> $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> it = element$iv = iterator.next();
            boolean bl = false;
            try {
                boolean bl2 = false;
                String string = it.getKey().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String string2 = name.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string, (Object)string2)) {
                    value = CollectionsKt.first(it.getValue());
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        return (String)value;
    }

    @NotNull
    public Connection.Response header(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public List<String> headers(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List list = this.headers.get(name);
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        return list;
    }

    @NotNull
    public Map<String, String> headers() {
        Map myheader = new LinkedHashMap();
        Map<String, List<String>> $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> it = element$iv = iterator.next();
            boolean bl = false;
            try {
                boolean bl2 = false;
                myheader.put(it.getKey(), CollectionsKt.first(it.getValue()));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
        return myheader;
    }

    @NotNull
    public Connection.Response addHeader(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public boolean hasHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.headers.containsKey(name);
    }

    public boolean hasHeaderWithValue(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.hasHeader(name) && Intrinsics.areEqual((Object)this.header(name), (Object)value);
    }

    @NotNull
    public Connection.Response removeHeader(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public Map<String, List<String>> multiHeaders() {
        Map newh = null;
        newh = new LinkedHashMap();
        Map<String, List<String>> $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> it = element$iv = iterator.next();
            boolean bl = false;
            Map map = newh;
            String string = it.getKey();
            List list = CollectionsKt.toMutableList((Collection)it.getValue());
            if (list == null) {
                list = new ArrayList();
            }
            List list2 = list;
            map.put(string, list2);
        }
        return newh;
    }

    @Nullable
    public String cookie(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.cookies().get(name);
    }

    @NotNull
    public Connection.Response cookie(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public boolean hasCookie(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.cookies().containsKey(name);
    }

    @NotNull
    public Connection.Response removeCookie(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public Map<String, String> cookies() {
        Map cookieMap = null;
        cookieMap = new LinkedHashMap();
        Map<String, List<String>> $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> it1 = element$iv = iterator.next();
            boolean bl = false;
            String string = it1.getKey().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)"set-cookie")) continue;
            Iterable $this$forEach$iv2 = it1.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean $i$f$trim;
                String key;
                String value;
                block16: {
                    block15: {
                        String it = (String)element$iv2;
                        boolean bl2 = false;
                        int pos = StringsKt.indexOf$default((CharSequence)it, (char)'=', (int)0, (boolean)false, (int)6, null);
                        if (pos != -1 && pos + 1 != it.length()) {
                            String string2 = it.substring(pos + 1, it.length());
                            v2 = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        } else {
                            v2 = value = "";
                        }
                        if (pos != -1 && pos != 0) {
                            String string3 = it.substring(0, pos);
                            v4 = string3;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        } else {
                            v4 = key = "";
                        }
                        if (!StringsKt.isBlank((CharSequence)value)) break block15;
                        String $this$trim$iv = value;
                        boolean $i$f$trim2 = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        $i$f$trim = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl3 = false;
                            boolean bl4 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        if (!Intrinsics.areEqual((Object)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (Object)"null")) break block16;
                    }
                    value = "";
                }
                Map map = cookieMap;
                String string4 = ((Object)StringsKt.trim((CharSequence)key)).toString();
                String $this$trim$iv = value;
                $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim3 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl5 = false;
                    boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String string5 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                map.put(string4, string5);
            }
        }
        return cookieMap;
    }

    public int statusCode() {
        return this.statusCode;
    }

    @NotNull
    public String statusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public String charset() {
        return Charset.defaultCharset().name();
    }

    @NotNull
    public Connection.Response charset(@NotNull String charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public String contentType() {
        String contentType = null;
        Map<String, List<String>> $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv;
            Map.Entry<String, List<String>> it = element$iv = iterator.next();
            boolean bl = false;
            String string = it.getKey().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)"content-type")) continue;
            contentType = ((String)CollectionsKt.first(it.getValue())).toString();
        }
        return contentType;
    }

    @NotNull
    public Document parse() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public String body() {
        return this.body;
    }

    @NotNull
    public byte[] bodyAsBytes() {
        String string = this.body;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public Connection.Response bufferUp() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public BufferedInputStream bodyStream() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }
}

