/*
 * Decompiled with CFR 0.152.
 */
package book.util.help;

import book.util.GSONKt;
import book.util.NetworkUtils;
import book.util.TextUtils;
import book.util.help.CookieManager;
import java.io.File;
import java.net.IDN;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 92\u00020\u0001:\u00019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020 0\u001fJ\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u001a\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0016J\u001a\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0003J%\u0010(\u001a\u0004\u0018\u00010\u00032\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030*\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010+J/\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030-2\u0016\u0010)\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030*\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0002002\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u00102\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0016\u00103\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003J\u0010\u00103\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001c\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030-2\u0006\u0010#\u001a\u00020\u0003H\u0016J \u00105\u001a\u0004\u0018\u00010\u00032\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u000107H\u0016J\b\u00108\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lbook/util/help/CookieStore;", "Lbook/util/help/CookieManager;", "userid", "", "<init>", "(Ljava/lang/String;)V", "getUserid", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "mainpath", "cookiepath", "mycookiepath", "checkfile", "", "path", "clear", "loadRequest", "Lokhttp3/Request;", "request", "savejsonResponse", "response", "Lorg/jsoup/Connection$Response;", "saveResponse", "Lokhttp3/Response;", "saveCookiesFromHeaders", "url", "Lokhttp3/HttpUrl;", "headers", "Lokhttp3/Headers;", "getString", "", "Lokhttp3/Cookie;", "getkey", "setCookie", "cookie", "replaceCookie", "getKey", "tag", "key", "mergeCookies", "cookies", "", "([Ljava/lang/String;)Ljava/lang/String;", "mergeCookiesToMap", "", "([Ljava/lang/String;)Ljava/util/Map;", "encodeChineseUrl", "Ljava/net/URI;", "getcookie", "getCookie", "removeCookie", "cookieToMap", "mapToCookie", "cookieMap", "", "toString", "Companion", "book"})
@SourceDebugExtension(value={"SMAP\nCookieStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CookieStore.kt\nbook/util/help/CookieStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,275:1\n1872#2,3:276\n1557#2:279\n1628#2,3:280\n2669#2,5:283\n2675#2:289\n739#2,9:290\n739#2,9:303\n1#3:288\n37#4:299\n36#4,3:300\n37#4:312\n36#4,3:313\n108#5:316\n80#5,22:317\n108#5:339\n80#5,22:340\n*S KotlinDebug\n*F\n+ 1 CookieStore.kt\nbook/util/help/CookieStore\n*L\n115#1:276,3\n164#1:279\n164#1:280,3\n166#1:283,5\n166#1:289\n230#1:290,9\n232#1:303,9\n230#1:299\n230#1:300,3\n232#1:312\n232#1:313,3\n239#1:316\n239#1:317,22\n240#1:339\n240#1:340,22\n*E\n"})
public final class CookieStore
implements CookieManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String userid;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String mainpath;
    @NotNull
    private final String cookiepath;
    @NotNull
    private final String mycookiepath;
    @NotNull
    private static final HashMap<String, CookieStore> Stores = new HashMap();

    public CookieStore(@NotNull String userid) {
        Intrinsics.checkNotNullParameter((Object)userid, (String)"userid");
        this.userid = userid;
        Logger logger = LoggerFactory.getLogger(CookieStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.mainpath = "storage";
        this.cookiepath = this.mainpath + "/cookies";
        this.mycookiepath = this.cookiepath + "/" + this.userid;
        this.checkfile(this.mainpath);
        this.checkfile(this.cookiepath);
        this.checkfile(this.mycookiepath);
    }

    @NotNull
    public final String getUserid() {
        return this.userid;
    }

    public final void checkfile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            file.delete();
            file.mkdirs();
        }
    }

    public final void clear() {
        File file = new File(this.mycookiepath);
        if (file.exists()) {
            FilesKt.deleteRecursively((File)file);
        }
        this.checkfile(this.mycookiepath);
    }

    @NotNull
    public final Request loadRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String url = null;
        url = request.url().toString();
        int pos = StringsKt.indexOf$default((CharSequence)url, (char)'?', (int)0, (boolean)false, (int)6, null);
        if (pos != -1) {
            String string = url.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            url = string;
        }
        String cookie = this.getCookie(url);
        String requestCookie = request.header("Cookie");
        String[] stringArray = new String[]{requestCookie, cookie};
        String string = this.mergeCookies(stringArray);
        if (string == null) {
            return request;
        }
        String newCookie = string;
        try {
            boolean bl = false;
            return request.newBuilder().header("Cookie", newCookie).build();
        }
        catch (Throwable throwable) {
            block4: {
                Throwable throwable2;
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
                if (throwable3 == null) break block4;
                Throwable it = throwable2 = throwable3;
                boolean bl = false;
                this.removeCookie(url);
            }
            return request;
        }
    }

    public final void savejsonResponse(@NotNull Connection.Response response) {
        String cookieString;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string = response.url().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String url = string;
        int pos = StringsKt.indexOf$default((CharSequence)url, (char)'?', (int)0, (boolean)false, (int)6, null);
        if (pos != -1) {
            String string2 = url.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            url = string2;
        }
        if ((cookieString = this.mapToCookie(response.cookies())) != null) {
            this.replaceCookie(url, cookieString);
        }
        this.logger.info("savejsonResponse " + url + ", " + cookieString + "," + GSONKt.getGSON().toJson((Object)response.cookies()));
    }

    public final void saveResponse(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpUrl url = response.request().url();
        Headers headers = response.headers();
        this.saveCookiesFromHeaders(url, headers);
    }

    private final void saveCookiesFromHeaders(HttpUrl url, Headers headers) {
        List cookies = Cookie.Companion.parseAll(url, headers);
        String url2 = url.toString();
        int pos = StringsKt.indexOf$default((CharSequence)url2, (char)'?', (int)0, (boolean)false, (int)6, null);
        if (pos != -1) {
            String string = url2.substring(0, pos);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            url2 = string;
        }
        String cookieString = this.getString(cookies);
        this.replaceCookie(url2, cookieString);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getString(@NotNull List<Cookie> $this$getString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$getString, (String)"<this>");
        StringBuilder $this$getString_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = $this$getString;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void cookie;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Cookie cookie2 = (Cookie)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index > 0) {
                $this$getString_u24lambda_u243.append("; ");
            }
            $this$getString_u24lambda_u243.append(cookie.name()).append('=').append(cookie.value());
        }
        return stringBuilder.toString();
    }

    private final String getkey(String url) {
        return NetworkUtils.INSTANCE.getSubDomain(url);
    }

    @Override
    public void setCookie(@NotNull String url, @Nullable String cookie) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.logger.info("setCookie url:" + url + "\uff0ccookie:" + cookie);
        String key = this.getkey(url);
        File file = new File(this.mycookiepath + "/" + key);
        String string = cookie;
        if (string == null) {
            string = "";
        }
        FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
    }

    @Override
    public void replaceCookie(@NotNull String url, @NotNull String cookie) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        if (TextUtils.isEmpty(url) || TextUtils.isEmpty(cookie)) {
            return;
        }
        String oldCookie = this.getCookie(url);
        if (TextUtils.isEmpty(oldCookie)) {
            this.setCookie(url, cookie);
        } else {
            Map<String, String> cookieMap = this.cookieToMap(oldCookie);
            cookieMap.putAll(this.cookieToMap(cookie));
            String newCookie = this.mapToCookie(cookieMap);
            this.setCookie(url, newCookie);
        }
    }

    @NotNull
    public final String getKey(@NotNull String tag, @Nullable String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        String cookie = this.getCookie(tag);
        Map<String, String> cookieMap = this.cookieToMap(cookie);
        this.logger.info("tag:" + tag + ", key:" + key + " ");
        if (key != null) {
            string = cookieMap.get(key);
            if (string == null) {
                string = "";
            }
        } else {
            string = cookie;
        }
        return string;
    }

    public static /* synthetic */ String getKey$default(CookieStore cookieStore, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return cookieStore.getKey(string, string2);
    }

    @Nullable
    public final String mergeCookies(String ... cookies) {
        Intrinsics.checkNotNullParameter((Object)cookies, (String)"cookies");
        Map<String, String> cookieMap = this.mergeCookiesToMap(Arrays.copyOf(cookies, cookies.length));
        return this.mapToCookie(cookieMap);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> mergeCookiesToMap(String ... cookies) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cookies, (String)"cookies");
        Iterable $this$map$iv = ArraysKt.filterNotNull((Object[])cookies);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cookieToMap((String)it));
        }
        Iterable $this$reduce$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void cookieMap;
            Map $i$f$mapTo2 = (Map)iterator$iv.next();
            Map acc = (Map)accumulator$iv;
            boolean bl = false;
            Object $this$mergeCookiesToMap_u24lambda_u246_u24lambda_u245 = object = acc;
            boolean bl2 = false;
            $this$mergeCookiesToMap_u24lambda_u246_u24lambda_u245.putAll(cookieMap);
            accumulator$iv = object;
        }
        return (Map)accumulator$iv;
    }

    private final URI encodeChineseUrl(String url) {
        Regex regex = new Regex("^(https?://)([^/]+)(.*)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)url, (int)0, (int)2, null);
        if (matchResult == null) {
            throw new IllegalArgumentException("Invalid URL");
        }
        MatchResult match = matchResult;
        MatchResult.Destructured destructured = match.getDestructured();
        String protocol = (String)destructured.getMatch().getGroupValues().get(1);
        String rawHost = (String)destructured.getMatch().getGroupValues().get(2);
        String path = (String)destructured.getMatch().getGroupValues().get(3);
        String encodedHost = IDN.toASCII(rawHost);
        return new URI(protocol + encodedHost + path);
    }

    private final String getcookie(String url) {
        String key = this.getkey(url);
        this.logger.info("cookie url:" + key);
        String ck = null;
        ck = "";
        CookieStore cookieStore = this;
        try {
            CookieStore $this$getcookie_u24lambda_u247 = cookieStore;
            boolean bl = false;
            ck = FilesKt.readText$default((File)new File($this$getcookie_u24lambda_u247.mycookiepath + "/" + key), null, (int)1, null);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return ck;
    }

    @Override
    @NotNull
    public String getCookie(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.logger.info("getCookie:" + url);
        String ck = this.getcookie(url);
        Map<String, String> cookieMap = this.cookieToMap(ck);
        while (ck.length() > 4096) {
            String removeKey = (String)CollectionsKt.random((Collection)cookieMap.keySet(), (Random)((Random)Random.Default));
            this.removeCookie(url, removeKey);
            cookieMap.remove(removeKey);
            String string = this.mapToCookie(cookieMap);
            if (string == null) {
                string = "";
            }
            ck = string;
        }
        return ck;
    }

    public final void removeCookie(@NotNull String url, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String ck = this.getcookie(url);
        if (((CharSequence)ck).length() == 0) {
            return;
        }
        Map<String, String> cookieMap = this.cookieToMap(ck);
        cookieMap.remove(key);
        this.setCookie(url, this.mapToCookie(cookieMap));
    }

    @Override
    public void removeCookie(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.logger.info("removeCookie :" + url);
        String key = this.getkey(url);
        File file = new File(this.mycookiepath + "/" + key);
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> cookieToMap(@NotNull String cookie) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Map cookieMap = new LinkedHashMap();
        if (StringsKt.isBlank((CharSequence)cookie)) {
            return cookieMap;
        }
        Object object = cookie;
        Regex regex = new Regex(";");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String pair : thisCollection$iv.toArray(new String[0])) {
            boolean $i$f$trim;
            String key;
            String value;
            void $this$toTypedArray$iv2;
            List list2;
            Collection $this$dropLastWhile$iv2;
            Object bl = pair;
            Regex regex2 = new Regex("=");
            int n2 = 0;
            bl = regex2.split((CharSequence)bl, n2);
            boolean $i$f$dropLastWhile2 = false;
            if (!$this$dropLastWhile$iv2.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv2 = list2;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] pairs = thisCollection$iv2.toArray(new String[0]);
            if (pairs.length == 1) continue;
            int pos = StringsKt.indexOf$default((CharSequence)pair, (char)'=', (int)0, (boolean)false, (int)6, null);
            if (pos != -1 && pos + 1 != pair.length()) {
                String string = pair.substring(pos + 1, pair.length());
                v3 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                v3 = value = "";
            }
            if (pos != -1 && pos != 0) {
                String string = pair.substring(0, pos);
                v5 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            } else {
                v5 = key = "";
            }
            if (!(!StringsKt.isBlank((CharSequence)value))) {
                String $this$trim$iv = value;
                boolean $i$f$trim2 = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl3 = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!Intrinsics.areEqual((Object)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (Object)"null")) continue;
            }
            Map map = cookieMap;
            String string = ((Object)StringsKt.trim((CharSequence)key)).toString();
            String $this$trim$iv = value;
            $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim3 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl5 = false;
                boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            map.put(string, string2);
        }
        return cookieMap;
    }

    @Override
    @Nullable
    public String mapToCookie(@Nullable Map<String, String> cookieMap) {
        if (cookieMap == null || cookieMap.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean isadd = false;
        for (String key : cookieMap.keySet()) {
            String value = cookieMap.get(key);
            if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)key)).toString(), (Object)"path")) continue;
            String string = value;
            boolean bl = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
            if (!bl) continue;
            isadd = true;
            builder.append(key).append("=").append(value).append(";");
        }
        if (!isadd) {
            return null;
        }
        return builder.deleteCharAt(builder.lastIndexOf(";")).toString();
    }

    @NotNull
    public String toString() {
        int hashCode = this.hashCode();
        String hexHash = Integer.toHexString(hashCode);
        return "io.legado.app.help.http.CookieStore@" + hexHash;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lbook/util/help/CookieStore$Companion;", "", "<init>", "()V", "Stores", "Ljava/util/HashMap;", "", "Lbook/util/help/CookieStore;", "Lkotlin/collections/HashMap;", "getStores", "()Ljava/util/HashMap;", "book"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, CookieStore> getStores() {
            return Stores;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

