/*
 * Decompiled with CFR 0.152.
 */
package book.util.help;

import book.util.MyCache;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"cookieJarHeader", "", "getCookieJarHeader", "()Ljava/lang/String;", "Md5", "srcStr", "hash", "algorithm", "memoryLruCache", "Lbook/util/MyCache;", "getMemoryLruCache", "()Lbook/util/MyCache;", "book"})
public final class CacheManagerKt {
    @NotNull
    private static final String cookieJarHeader = "CookieJar";
    @NotNull
    private static final MyCache memoryLruCache = new MyCache(100);

    @NotNull
    public static final String getCookieJarHeader() {
        return cookieJarHeader;
    }

    @NotNull
    public static final String Md5(@NotNull String srcStr) {
        Intrinsics.checkNotNullParameter((Object)srcStr, (String)"srcStr");
        return CacheManagerKt.hash("MD5", srcStr);
    }

    @NotNull
    public static final String hash(@NotNull String algorithm, @NotNull String srcStr) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)srcStr, (String)"srcStr");
        try {
            StringBuilder result = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            Charset charset = Charset.forName("utf-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = srcStr.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            for (byte b : md.digest(byArray)) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    result.append("0");
                }
                result.append(hex);
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static final MyCache getMemoryLruCache() {
        return memoryLruCache;
    }
}

