/*
 * Decompiled with CFR 0.152.
 */
package book.util.help;

import book.model.Book;
import book.model.BookChapter;
import book.model.BookSource;
import book.util.AppPattern;
import book.util.FileKt;
import book.util.FileUtils;
import book.util.MD5Utils;
import book.util.NetworkUtils;
import book.util.help.BookHelp;
import book.webBook.analyzeRule.AnalyzeUrl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J6\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u001e\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0005J6\u0010 \u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u001eJ(\u0010!\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lbook/util/help/BookHelp;", "", "<init>", "()V", "cacheImageFolderName", "", "downloadImages", "Ljava/util/concurrent/CopyOnWriteArraySet;", "formatFolderName", "folderName", "formatAuthor", "author", "formatBookName", "name", "formatBookAuthor", "getBookCacheDir", "Ljava/io/File;", "book", "Lbook/model/Book;", "getContent", "bookChapter", "Lbook/model/BookChapter;", "delContent", "", "saveContent", "scope", "Lkotlinx/coroutines/CoroutineScope;", "bookSource", "Lbook/model/BookSource;", "content", "(Lkotlinx/coroutines/CoroutineScope;Lbook/model/BookSource;Lbook/model/Book;Lbook/model/BookChapter;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveText", "saveImages", "saveImage", "src", "(Lbook/model/BookSource;Lbook/model/Book;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getImage", "getImageSuffix"})
@SourceDebugExtension(value={"SMAP\nBookHelp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookHelp.kt\nbook/util/help/BookHelp\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n108#2:186\n80#2,22:187\n108#2:209\n80#2,22:210\n108#2:232\n80#2,22:233\n1863#3,2:255\n1863#3,2:257\n*S KotlinDebug\n*F\n+ 1 BookHelp.kt\nbook/util/help/BookHelp\n*L\n29#1:186\n29#1:187,22\n39#1:209\n39#1:210,22\n48#1:232\n48#1:233,22\n127#1:255,2\n140#1:257,2\n*E\n"})
public final class BookHelp {
    @NotNull
    public static final BookHelp INSTANCE = new BookHelp();
    @NotNull
    private static final String cacheImageFolderName = "images";
    @NotNull
    private static final CopyOnWriteArraySet<String> downloadImages = new CopyOnWriteArraySet();

    private BookHelp() {
    }

    private final String formatFolderName(String folderName) {
        CharSequence charSequence = folderName;
        Regex regex = new Regex("[\\\\/:*?\"<>|.]");
        String string = "";
        return regex.replace(charSequence, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final String formatAuthor(@Nullable String author) {
        String string;
        if (author == null) return "";
        Regex regex = new Regex("\u4f5c\\s*\u8005[\\s:\uff1a]*");
        CharSequence charSequence = author;
        String string2 = "";
        String string3 = regex.replace(charSequence, string2);
        if (string3 == null) return "";
        Regex regex2 = new Regex("\\s+");
        CharSequence charSequence2 = string3;
        String string4 = " ";
        charSequence = regex2.replace(charSequence2, string4);
        if (charSequence == null) return "";
        CharSequence charSequence3 = charSequence;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = charSequence3;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if ((string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()) == null) return "";
        String string5 = string;
        return string5;
    }

    @NotNull
    public final String formatBookName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CharSequence charSequence = name;
        Regex regex = AppPattern.INSTANCE.getNameRegex();
        String string = "";
        String $this$trim$iv = regex.replace(charSequence, string);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public final String formatBookAuthor(@NotNull String author) {
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        CharSequence charSequence = author;
        Regex regex = AppPattern.INSTANCE.getAuthorRegex();
        String string = "";
        String $this$trim$iv = regex.replace(charSequence, string);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public final File getBookCacheDir(@NotNull Book book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        String md5Encode = MD5Utils.INSTANCE.md5Encode(book.getBookUrl()).toString();
        String bookDir = book.getBookDir();
        if (((CharSequence)bookDir).length() == 0) {
            throw new Exception("bookDir\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] stringArray = new String[]{md5Encode};
        File localCacheDir = FileKt.getFile(new File(bookDir), stringArray);
        if (!localCacheDir.exists()) {
            localCacheDir.mkdirs();
        }
        return localCacheDir;
    }

    @Nullable
    public final String getContent(@NotNull Book book, @NotNull BookChapter bookChapter) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)bookChapter, (String)"bookChapter");
        File file = this.getBookCacheDir(book);
        String[] stringArray = new String[1];
        String string = "%d.txt";
        Object[] objectArray = new Object[]{bookChapter.getIndex()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
        File file2 = FileKt.getFile(file, stringArray);
        if (file2.exists()) {
            return FilesKt.readText$default((File)file2, null, (int)1, null);
        }
        if (book.isLocalBook()) {
            throw new Exception("\u8fd9\u4e2a\u8fd8\u6ca1\u505a");
        }
        return null;
    }

    public final void delContent(@NotNull Book book, @NotNull BookChapter bookChapter) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)bookChapter, (String)"bookChapter");
        File file = this.getBookCacheDir(book);
        String[] stringArray = new String[1];
        String string = "%d.txt";
        Object[] objectArray = new Object[]{bookChapter.getIndex()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
        FileUtils.INSTANCE.createFileIfNotExist(file, stringArray).delete();
    }

    @Nullable
    public final Object saveContent(@NotNull CoroutineScope scope, @NotNull BookSource bookSource, @NotNull Book book, @NotNull BookChapter bookChapter, @NotNull String content, @NotNull Continuation<? super Unit> $completion) {
        this.saveText(book, bookChapter, content);
        Object object = this.saveImages(scope, bookSource, book, bookChapter, content, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void saveText(@NotNull Book book, @NotNull BookChapter bookChapter, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)bookChapter, (String)"bookChapter");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File file = this.getBookCacheDir(book);
        String[] stringArray = new String[1];
        String string = "%d.txt";
        Object[] objectArray = new Object[]{bookChapter.getIndex()};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
        FilesKt.writeText$default((File)FileUtils.INSTANCE.createFileIfNotExist(file, stringArray), (String)content, null, (int)2, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object saveImages(@NotNull CoroutineScope var1_1, @NotNull BookSource var2_2, @NotNull Book var3_3, @NotNull BookChapter var4_4, @NotNull String var5_5, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof saveImages.1)) ** GOTO lbl-1000
        var20_7 = $completion;
        if ((var20_7.label & -2147483648) != 0) {
            var20_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BookHelp this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveImages(null, null, null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                awaitList = new ArrayList<Deferred>();
                var8_11 = new String[]{"\n"};
                $this$forEach$iv = StringsKt.split$default((CharSequence)((CharSequence)content), (String[])var8_11, (boolean)false, (int)0, (int)6, null);
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    it /* !! */  = (String)element$iv /* !! */ ;
                    $i$a$-forEach-BookHelp$saveImages$2 = false;
                    matcher = AppPattern.INSTANCE.getImgPattern().matcher((CharSequence)it /* !! */ );
                    if (!matcher.find()) continue;
                    if (matcher.group(1) == null) continue;
                    $i$a$-let-BookHelp$saveImages$2$1 = false;
                    mSrc = NetworkUtils.INSTANCE.getAbsoluteURL(bookChapter.getUrl(), src);
                    req = BuildersKt.async$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>((BookSource)bookSource, (Book)book, mSrc, null){
                        int label;
                        final /* synthetic */ BookSource $bookSource;
                        final /* synthetic */ Book $book;
                        final /* synthetic */ String $mSrc;
                        {
                            this.$bookSource = $bookSource;
                            this.$book = $book;
                            this.$mSrc = $mSrc;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = BookHelp.INSTANCE.saveImage(this.$bookSource, this.$book, this.$mSrc, (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Boxing.boxInt((int)1);
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Boxing.boxInt((int)1);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Integer> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    awaitList.add(req);
                }
                $this$forEach$iv = awaitList;
                $i$f$forEach = false;
                var10_13 = $this$forEach$iv.iterator();
lbl32:
                // 3 sources

                while (var10_13.hasNext()) {
                    element$iv /* !! */  = var10_13.next();
                    it /* !! */  = (Deferred)element$iv /* !! */ ;
                    $i$a$-forEach-BookHelp$saveImages$3 = false;
                    $continuation.L$0 = var10_13;
                    $continuation.label = 1;
                    v0 = it /* !! */ .await((Continuation)$continuation);
                    if (v0 != var21_9) continue;
                    return var21_9;
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-BookHelp$saveImages$3 = false;
                var10_13 = (Iterator<T>)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl32
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Object saveImage(@Nullable BookSource var1_1, @NotNull Book var2_2, @NotNull String var3_3, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof saveImage.1)) ** GOTO lbl-1000
        var11_5 = $completion;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ BookHelp this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveImage(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 3 sources

                while (BookHelp.downloadImages.contains(src)) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = bookSource;
                    $continuation.L$2 = book;
                    $continuation.L$3 = src;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)100L, (Continuation)$continuation);
                    if (v0 != var12_7) continue;
                    return var12_7;
                }
                break;
            }
            case 1: {
                src = (String)$continuation.L$3;
                book = (Book)$continuation.L$2;
                bookSource = (BookSource)$continuation.L$1;
                this = (BookHelp)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl12
            }
        }
        if (this.getImage(book, src).exists()) {
            return Unit.INSTANCE;
        }
        BookHelp.downloadImages.add(src);
        analyzeUrl = new AnalyzeUrl(src, null, null, null, null, null, bookSource, null, null, null, null, null, false, null, false, 24510, null);
        $continuation.L$0 = book;
        $continuation.L$1 = src;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.label = 2;
        v1 = analyzeUrl.getByteArrayAwait((Continuation<? super byte[]>)$continuation);
        ** if (v1 != var12_7) goto lbl45
lbl44:
        // 1 sources

        return var12_7;
lbl45:
        // 1 sources

        ** GOTO lbl53
        {
            case 2: {
                src = (String)$continuation.L$1;
                book = (Book)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl53:
                    // 2 sources

                    it = (byte[])v1;
                    $i$a$-let-BookHelp$saveImage$2 = false;
                    var9_11 = new String[]{"images", MD5Utils.INSTANCE.md5Encode16(src) + "." + BookHelp.INSTANCE.getImageSuffix(src)};
                    FilesKt.writeBytes((File)FileUtils.INSTANCE.createFileIfNotExist(BookHelp.INSTANCE.getBookCacheDir(book), var9_11), (byte[])it);
                    BookHelp.downloadImages.remove(src);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Unit.INSTANCE;
                }
                return Unit.INSTANCE;
            }
        }
        finally {
            BookHelp.downloadImages.remove(src);
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final File getImage(@NotNull Book book, @NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        String[] stringArray = new String[]{cacheImageFolderName, MD5Utils.INSTANCE.md5Encode16(src) + "." + this.getImageSuffix(src)};
        return FileKt.getFile(this.getBookCacheDir(book), stringArray);
    }

    @NotNull
    public final String getImageSuffix(@NotNull String src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        String suffix = StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)src, (String)".", null, (int)2, null), (String)",", null, (int)2, null);
        Regex fileSuffixRegex = new Regex("^[a-z0-9]+$", RegexOption.IGNORE_CASE);
        if (suffix.length() > 5 || !fileSuffixRegex.matches((CharSequence)suffix)) {
            suffix = "jpg";
        }
        return suffix;
    }
}

