/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lbook/util/Utf8BomUtils;", "", "<init>", "()V", "UTF8_BOM_BYTES", "", "removeUTF8BOM", "", "xmlText", "bytes", "hasBom", "", "book"})
public final class Utf8BomUtils {
    @NotNull
    public static final Utf8BomUtils INSTANCE = new Utf8BomUtils();
    @NotNull
    private static final byte[] UTF8_BOM_BYTES;

    private Utf8BomUtils() {
    }

    @NotNull
    public final String removeUTF8BOM(@NotNull String xmlText) {
        boolean containsBOM;
        Intrinsics.checkNotNullParameter((Object)xmlText, (String)"xmlText");
        String string = xmlText;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes2 = byArray;
        boolean bl = containsBOM = bytes2.length > 3 && bytes2[0] == UTF8_BOM_BYTES[0] && bytes2[1] == UTF8_BOM_BYTES[1] && bytes2[2] == UTF8_BOM_BYTES[2];
        if (containsBOM) {
            return new String(bytes2, 3, bytes2.length - 3, Charsets.UTF_8);
        }
        return xmlText;
    }

    @NotNull
    public final byte[] removeUTF8BOM(@NotNull byte[] bytes2) {
        boolean containsBOM;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        boolean bl = containsBOM = bytes2.length > 3 && bytes2[0] == UTF8_BOM_BYTES[0] && bytes2[1] == UTF8_BOM_BYTES[1] && bytes2[2] == UTF8_BOM_BYTES[2];
        if (containsBOM) {
            byte[] copy = new byte[bytes2.length - 3];
            System.arraycopy(bytes2, 3, copy, 0, bytes2.length - 3);
            return copy;
        }
        return bytes2;
    }

    public final boolean hasBom(@NotNull byte[] bytes2) {
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        return bytes2.length > 3 && bytes2[0] == UTF8_BOM_BYTES[0] && bytes2[1] == UTF8_BOM_BYTES[1] && bytes2[2] == UTF8_BOM_BYTES[2];
    }

    static {
        byte[] byArray = new byte[]{-17, -69, -65};
        UTF8_BOM_BYTES = byArray;
    }
}

