/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.util.TextUtils;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010\u0005J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005J\u0016\u0010'\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0007J\u0012\u0010)\u001a\u0004\u0018\u00010\u00052\b\u0010*\u001a\u0004\u0018\u00010\u0005J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0005J\u0010\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010/J\u000e\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00062"}, d2={"Lbook/util/StringUtils;", "", "<init>", "()V", "TAG", "", "HOUR_OF_DAY", "", "DAY_OF_YESTERDAY", "TIME_UNIT", "ChnMap", "Ljava/util/HashMap;", "", "chnMap", "getChnMap", "()Ljava/util/HashMap;", "dateConvert", "time", "", "pattern", "source", "toSize", "length", "toFirstCapital", "str", "halfToFull", "input", "fullToHalf", "chineseNumToInt", "chNum", "stringToInt", "isContainNumber", "", "company", "isNumeric", "wordCountFormat", "wc", "trim", "s", "repeat", "n", "removeUTFCharacters", "data", "formatHtml", "html", "byteToHexString", "bytes", "", "hexStringToByte", "hexString", "book"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();
    @NotNull
    private static final String TAG = "StringUtils";
    private static final int HOUR_OF_DAY = 24;
    private static final int DAY_OF_YESTERDAY = 2;
    private static final int TIME_UNIT = 60;
    @NotNull
    private static final HashMap<Character, Integer> ChnMap = INSTANCE.getChnMap();

    private StringUtils() {
    }

    private final HashMap<Character, Integer> getChnMap() {
        Integer n;
        int i;
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        String cnStr = "\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341";
        char[] cArray = cnStr.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] c = cArray;
        for (i = 0; i < 11; ++i) {
            n = i;
            ((Map)map).put(Character.valueOf(c[i]), n);
        }
        cnStr = "\u3007\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe";
        char[] cArray2 = cnStr.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
        c = cArray2;
        for (i = 0; i < 11; ++i) {
            n = i;
            ((Map)map).put(Character.valueOf(c[i]), n);
        }
        ((Map)map).put(Character.valueOf('\u4e24'), 2);
        ((Map)map).put(Character.valueOf('\u767e'), 100);
        ((Map)map).put(Character.valueOf('\u4f70'), 100);
        ((Map)map).put(Character.valueOf('\u5343'), 1000);
        ((Map)map).put(Character.valueOf('\u4edf'), 1000);
        ((Map)map).put(Character.valueOf('\u4e07'), 10000);
        ((Map)map).put(Character.valueOf('\u4ebf'), 100000000);
        return map;
    }

    @NotNull
    public final String dateConvert(long time, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        String string = format.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final String dateConvert(@NotNull String source, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        Calendar calendar = Calendar.getInstance();
        try {
            Object object;
            Date date = format.parse(source);
            long curTime = calendar.getTimeInMillis();
            calendar.setTime(date);
            long difSec = Math.abs((curTime - date.getTime()) / (long)1000);
            long difMin = difSec / (long)60;
            long difHour = difMin / (long)60;
            long difDate = difHour / (long)60;
            int oldHour = calendar.get(10);
            if (oldHour == 0) {
                if (difDate == 0L) {
                    return "\u4eca\u5929";
                }
                if (difDate < 2L) {
                    return "\u6628\u5929";
                }
                SimpleDateFormat convertFormat = new SimpleDateFormat("yyyy-MM-dd");
                String string = convertFormat.format(date);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                return string;
            }
            if (difSec < 60L) {
                object = difSec + "\u79d2\u524d";
            } else if (difMin < 60L) {
                object = difMin + "\u5206\u949f\u524d";
            } else if (difHour < 24L) {
                object = difHour + "\u5c0f\u65f6\u524d";
            } else if (difDate < 2L) {
                object = "\u6628\u5929";
            } else {
                SimpleDateFormat convertFormat = new SimpleDateFormat("yyyy-MM-dd");
                String string = convertFormat.format(date);
                Intrinsics.checkNotNull((Object)string);
                object = string;
            }
            return object;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    @NotNull
    public final String toSize(long length) {
        if (length <= 0L) {
            return "0";
        }
        String[] stringArray = new String[]{"b", "kb", "M", "G", "T"};
        String[] units = stringArray;
        int digitGroups = (int)(Math.log10(length) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)length / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    @NotNull
    public final String toFirstCapital(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String string = str.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String string4 = str.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        return string3 + string4;
    }

    @NotNull
    public final String halfToFull(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] c = cArray;
        int n = c.length;
        for (int i = 0; i < n; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            char c2 = c[i];
            boolean bl = '!' <= c2 ? c2 < '\u007f' : false;
            if (!bl) continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    @NotNull
    public final String fullToHalf(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        char[] cArray = input.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] c = cArray;
        int n = c.length;
        for (int i = 0; i < n; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            char c2 = c[i];
            boolean bl = '\uff01' <= c2 ? c2 < '\uff5f' : false;
            if (!bl) continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    /*
     * Unable to fully structure code
     */
    public final int chineseNumToInt(@NotNull String chNum) {
        Intrinsics.checkNotNullParameter((Object)chNum, (String)"chNum");
        result = 0;
        tmp = 0;
        billion = 0;
        v0 = chNum.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toCharArray(...)");
        cn = v0;
        if (cn.length > 1 && new Regex("^[\u3007\u96f6\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396]$").matches((CharSequence)(var6_6 = (CharSequence)chNum))) {
            var7_9 = cn.length;
            for (i = 0; i < var7_9; ++i) {
                v1 = StringUtils.ChnMap.get(Character.valueOf(cn[i]));
                Intrinsics.checkNotNull((Object)v1);
                cn[i] = (char)(48 + ((Number)v1).intValue());
            }
            return Integer.parseInt(new String(cn));
        }
        try {
            $i$a$-runCatching-StringUtils$chineseNumToInt$1 = false;
            var8_13 = cn.length;
            for (i = 0; i < var8_13; ++i) {
                v2 = StringUtils.ChnMap.get(Character.valueOf(cn[i]));
                Intrinsics.checkNotNull((Object)v2);
                tmpNum = ((Number)v2).intValue();
                if (tmpNum == 100000000) {
                    result += tmp;
                    billion = billion * 100000000 + (result *= tmpNum);
                    result = 0;
                    tmp = 0;
                    continue;
                }
                if (tmpNum == 10000) {
                    result += tmp;
                    result *= tmpNum;
                    tmp = 0;
                    continue;
                }
                if (tmpNum >= 10) {
                    if (tmp == 0) {
                        tmp = 1;
                    }
                    result += tmpNum * tmp;
                    tmp = 0;
                    continue;
                }
                if (i < 2 || i != cn.length - 1) ** GOTO lbl-1000
                v3 = StringUtils.ChnMap.get(Character.valueOf(cn[i - 1]));
                Intrinsics.checkNotNull((Object)v3);
                if (((Number)v3).intValue() > 10) {
                    v4 = StringUtils.ChnMap.get(Character.valueOf(cn[i - 1]));
                    Intrinsics.checkNotNull((Object)v4);
                    v5 = tmpNum * ((Number)v4).intValue() / 10;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = tmp * 10 + tmpNum;
                }
                tmp = v5;
            }
            var6_6 = Result.constructor-impl((Object)(result += tmp + billion));
        }
        catch (Throwable var7_11) {
            var6_6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var7_11));
        }
        var7_12 = -1;
        return ((Number)(Result.isFailure-impl((Object)var6_6) != false ? var7_12 : var6_6)).intValue();
    }

    public final int stringToInt(@Nullable String str) {
        if (str != null) {
            Object object;
            Object object2 = this.fullToHalf(str);
            Regex regex = new Regex("\\s+");
            String string = "";
            String num = regex.replace((CharSequence)object2, string);
            try {
                boolean bl = false;
                object2 = Result.constructor-impl((Object)Integer.parseInt(num));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                Throwable it = throwable;
                boolean bl = false;
                object = INSTANCE.chineseNumToInt(num);
            }
            return ((Number)object).intValue();
        }
        return -1;
    }

    public final boolean isContainNumber(@NotNull String company) {
        Intrinsics.checkNotNullParameter((Object)company, (String)"company");
        Pattern p = Pattern.compile("[0-9]+");
        Matcher m = p.matcher(company);
        return m.find();
    }

    public final boolean isNumeric(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Pattern pattern = Pattern.compile("-?[0-9]+");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    @NotNull
    public final String wordCountFormat(@Nullable String wc) {
        if (wc == null) {
            return "";
        }
        Object wordsS = "";
        if (this.isNumeric(wc)) {
            int words = Integer.parseInt(wc);
            if (words > 0) {
                wordsS = words + "\u5b57";
                if (words > 10000) {
                    DecimalFormat df = new DecimalFormat("#.#");
                    wordsS = df.format((double)((float)words * 1.0f) / 10000.0) + "\u4e07\u5b57";
                }
            }
        } else {
            wordsS = wc;
        }
        return wordsS;
    }

    @NotNull
    public final String trim(@NotNull String s) {
        String string;
        int start;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (((CharSequence)s).length() == 0) {
            return "";
        }
        int len = s.length();
        int end = len - 1;
        for (start = 0; start < end && (s.charAt(start) <= ' ' || s.charAt(start) == '\u3000'); ++start) {
        }
        while (start < end && (s.charAt(end) <= ' ' || s.charAt(end) == '\u3000')) {
            --end;
        }
        if (end < len) {
            ++end;
        }
        if (start > 0 || end < len) {
            String string2 = s.substring(start, end);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = s;
        }
        return string;
    }

    @NotNull
    public final String repeat(@NotNull String str, int n) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(str);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nullable
    public final String removeUTFCharacters(@Nullable String data) {
        if (data == null) {
            return null;
        }
        Pattern p = Pattern.compile("\\\\u(\\p{XDigit}{4})");
        Matcher m = p.matcher(data);
        StringBuffer buf = new StringBuffer(data.length());
        while (m.find()) {
            String string = m.group(1);
            Intrinsics.checkNotNull((Object)string);
            String ch = String.valueOf((char)Integer.parseInt(string, 16));
            m.appendReplacement(buf, Matcher.quoteReplacement(ch));
        }
        m.appendTail(buf);
        return buf.toString();
    }

    @NotNull
    public final String formatHtml(@NotNull String html) {
        String string;
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        if (TextUtils.isEmpty(html)) {
            string = "";
        } else {
            CharSequence charSequence = html;
            Regex regex = new Regex("(?i)<(br[\\s/]*|/*p.*?|/*div.*?)>");
            String string2 = "\n";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("<[script>]*.*?>|&nbsp;");
            string2 = "";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("\\s*\\n+\\s*");
            string2 = "\n\u3000\u3000";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("^[\\n\\s]+");
            string2 = "\u3000\u3000";
            charSequence = regex.replace(charSequence, string2);
            regex = new Regex("[\\n\\s]+$");
            string2 = "";
            string = regex.replace(charSequence, string2);
        }
        return string;
    }

    @NotNull
    public final String byteToHexString(@Nullable byte[] bytes2) {
        if (bytes2 == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes2.length * 2);
        for (byte b : bytes2) {
            int hex = 0xFF & b;
            if (hex < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(hex));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final byte[] hexStringToByte(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter((Object)hexString, (String)"hexString");
        String hexStr = StringsKt.replace$default((String)hexString, (String)" ", (String)"", (boolean)false, (int)4, null);
        int len = hexStr.length();
        byte[] bytes2 = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes2[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return bytes2;
    }
}

