/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\t\u00a8\u0006\u0010"}, d2={"Lbook/util/MapDeserializerDoubleAsIntFix;", "Lcom/google/gson/JsonDeserializer;", "", "", "", "<init>", "()V", "deserialize", "jsonElement", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "jsonDeserializationContext", "Lcom/google/gson/JsonDeserializationContext;", "read", "json", "book"})
public final class MapDeserializerDoubleAsIntFix
implements JsonDeserializer<Map<String, ? extends Object>> {
    @Nullable
    public Map<String, Object> deserialize(@NotNull JsonElement jsonElement, @NotNull Type type, @NotNull JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)jsonDeserializationContext, (String)"jsonDeserializationContext");
        Object object = this.read(jsonElement);
        return object instanceof Map ? (Map)object : null;
    }

    @Nullable
    public final Object read(@NotNull JsonElement json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (json.isJsonArray()) {
            List list = new ArrayList();
            JsonArray arr = json.getAsJsonArray();
            Iterator iterator = arr.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                JsonElement anArr = (JsonElement)iterator2.next();
                Intrinsics.checkNotNull((Object)anArr);
                list.add(this.read(anArr));
            }
            return list;
        }
        if (json.isJsonObject()) {
            Map map = (Map)new LinkedTreeMap();
            JsonObject obj = json.getAsJsonObject();
            Set entitySet = obj.entrySet();
            for (Map.Entry entry : entitySet) {
                Intrinsics.checkNotNull((Object)entry);
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                Intrinsics.checkNotNull((Object)value);
                map.put(key, this.read(value));
            }
            return map;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive prim = json.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
            if (prim.isNumber()) {
                Number number = prim.getAsNumber();
                Intrinsics.checkNotNullExpressionValue((Object)number, (String)"getAsNumber(...)");
                Number num = number;
                return Math.ceil(num.doubleValue()) == (double)num.longValue() ? (Number)num.longValue() : (Number)num.doubleValue();
            }
        }
        return null;
    }
}

