/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.util.NetworkUtils;
import book.webBook.analyzeRule.AnalyzeUrl;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0005J\u001c\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lbook/util/HtmlFormatter;", "", "<init>", "()V", "nbspRegex", "Lkotlin/text/Regex;", "espRegex", "noPrintRegex", "wrapHtmlRegex", "commentRegex", "notImgHtmlRegex", "otherHtmlRegex", "formatImagePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "indent1Regex", "indent2Regex", "lastRegex", "format", "", "html", "otherRegex", "formatKeepImg", "redirectUrl", "Ljava/net/URL;", "book"})
public final class HtmlFormatter {
    @NotNull
    public static final HtmlFormatter INSTANCE = new HtmlFormatter();
    @NotNull
    private static final Regex nbspRegex = new Regex("(&nbsp;)+");
    @NotNull
    private static final Regex espRegex = new Regex("(&ensp;|&emsp;)");
    @NotNull
    private static final Regex noPrintRegex = new Regex("(&thinsp;|&zwnj;|&zwj;|\u2009|\u200c|\u200d)");
    @NotNull
    private static final Regex wrapHtmlRegex = new Regex("</?(?:div|p|br|hr|h\\d|article|dd|dl)[^>]*>");
    @NotNull
    private static final Regex commentRegex = new Regex("<!--[^>]*-->");
    @NotNull
    private static final Regex notImgHtmlRegex = new Regex("</?(?!img)[a-zA-Z]+(?=[ >])[^<>]*>");
    @NotNull
    private static final Regex otherHtmlRegex = new Regex("</?[a-zA-Z]+(?=[ >])[^<>]*>");
    private static final Pattern formatImagePattern = Pattern.compile("<img[^>]*\\ssrc\\s*=\\s*\"([^\"{>]*\\{(?:[^{}]|\\{[^}>]+\\})+\\})\"[^>]*>|<img[^>]*\\sdata-[^=>]*=\\s*\"([^\">]*)\"[^>]*>|<img[^>]*\\ssrc\\s*=\\s*\"([^\">]*)\"[^>]*>", 2);
    @NotNull
    private static final Regex indent1Regex = new Regex("\\s*\\n+\\s*");
    @NotNull
    private static final Regex indent2Regex = new Regex("^[\\n\\s]+");
    @NotNull
    private static final Regex lastRegex = new Regex("[\\n\\s]+$");

    private HtmlFormatter() {
    }

    @NotNull
    public final String format(@Nullable String html, @NotNull Regex otherRegex) {
        Intrinsics.checkNotNullParameter((Object)otherRegex, (String)"otherRegex");
        if (html == null) {
            return "";
        }
        CharSequence charSequence = html;
        Object object = nbspRegex;
        String string = " ";
        charSequence = object.replace(charSequence, string);
        object = espRegex;
        string = " ";
        charSequence = object.replace(charSequence, string);
        object = noPrintRegex;
        string = "";
        charSequence = object.replace(charSequence, string);
        object = wrapHtmlRegex;
        string = "\n";
        charSequence = object.replace(charSequence, string);
        object = commentRegex;
        string = "";
        charSequence = object.replace(charSequence, string);
        object = "";
        charSequence = otherRegex.replace(charSequence, (String)object);
        object = indent1Regex;
        string = "\n\u3000\u3000";
        charSequence = object.replace(charSequence, string);
        object = indent2Regex;
        string = "\u3000\u3000";
        charSequence = object.replace(charSequence, string);
        object = lastRegex;
        string = "";
        return object.replace(charSequence, string);
    }

    public static /* synthetic */ String format$default(HtmlFormatter htmlFormatter, String string, Regex regex, int n, Object object) {
        if ((n & 2) != 0) {
            regex = otherHtmlRegex;
        }
        return htmlFormatter.format(string, regex);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatKeepImg(@Nullable String html, @Nullable URL redirectUrl) {
        if (html == null) {
            return "";
        }
        String keepImgHtml = this.format(html, notImgHtmlRegex);
        Matcher matcher = formatImagePattern.matcher(keepImgHtml);
        int appendPos = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String string;
            URL uRL;
            NetworkUtils networkUtils;
            String[] stringArray;
            StringBuilder stringBuilder;
            String param;
            block10: {
                block9: {
                    String string2;
                    void it;
                    param = null;
                    param = "";
                    stringBuilder = sb;
                    stringArray = new String[2];
                    Intrinsics.checkNotNullExpressionValue((Object)keepImgHtml.substring(appendPos, matcher.start()), (String)"substring(...)");
                    String[] stringArray2 = stringArray;
                    int n = 1;
                    networkUtils = NetworkUtils.INSTANCE;
                    uRL = redirectUrl;
                    string = matcher.group(1);
                    if (string == null) break block9;
                    String string3 = string;
                    URL uRL2 = uRL;
                    NetworkUtils networkUtils2 = networkUtils;
                    int n2 = n;
                    String[] stringArray3 = stringArray2;
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl = false;
                    Matcher urlMatcher = AnalyzeUrl.Companion.getParamPattern().matcher((CharSequence)it);
                    if (urlMatcher.find()) {
                        String string4;
                        char c = ',';
                        Intrinsics.checkNotNullExpressionValue((Object)it.substring(urlMatcher.end()), (String)"substring(...)");
                        param = c + string4;
                        String string5 = it.substring(0, urlMatcher.start());
                        string2 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    } else {
                        string2 = it;
                    }
                    void var19_19 = string2;
                    stringBuilder = stringBuilder2;
                    stringArray2 = stringArray3;
                    n = n2;
                    networkUtils = networkUtils2;
                    uRL = uRL2;
                    void v8 = var19_19;
                    string = v8;
                    if (v8 != null) break block10;
                }
                if ((string = matcher.group(2)) == null) {
                    String string6 = matcher.group(3);
                    string = string6;
                    Intrinsics.checkNotNull((Object)string6);
                }
            }
            stringArray2[n] = "<img src=\"" + networkUtils.getAbsoluteURL(uRL, string) + param + "\">";
            StringsKt.append((StringBuilder)stringBuilder, (String[])stringArray);
            appendPos = matcher.end();
        }
        if (appendPos < keepImgHtml.length()) {
            String string = keepImgHtml.substring(appendPos, keepImgHtml.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            sb.append(string);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String formatKeepImg$default(HtmlFormatter htmlFormatter, String string, URL uRL, int n, Object object) {
        if ((n & 2) != 0) {
            uRL = null;
        }
        return htmlFormatter.formatKeepImg(string, uRL);
    }
}

