/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import book.util.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"createFileIfNotExist", "Ljava/io/File;", "createFileReplace", "createFolderIfNotExist", "createFolderReplace", "checkWrite", "", "outputStream", "Ljava/io/FileOutputStream;", "append", "book"})
@SourceDebugExtension(value={"SMAP\nFileExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileExtensions.kt\nbook/util/FileExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class FileExtensionsKt {
    @NotNull
    public static final File createFileIfNotExist(@NotNull File $this$createFileIfNotExist) {
        Intrinsics.checkNotNullParameter((Object)$this$createFileIfNotExist, (String)"<this>");
        if (!$this$createFileIfNotExist.exists()) {
            File file = $this$createFileIfNotExist.getParentFile();
            if (file != null) {
                FileExtensionsKt.createFolderIfNotExist(file);
            }
            $this$createFileIfNotExist.createNewFile();
        }
        return $this$createFileIfNotExist;
    }

    @NotNull
    public static final File createFileReplace(@NotNull File $this$createFileReplace) {
        Intrinsics.checkNotNullParameter((Object)$this$createFileReplace, (String)"<this>");
        if (!$this$createFileReplace.exists()) {
            String string = $this$createFileReplace.getParent();
            if (string != null) {
                String it = string;
                boolean bl = false;
                new File(it).mkdirs();
            }
            v1 = $this$createFileReplace.createNewFile();
        } else {
            $this$createFileReplace.delete();
            v1 = $this$createFileReplace.createNewFile();
        }
        return $this$createFileReplace;
    }

    @NotNull
    public static final File createFolderIfNotExist(@NotNull File $this$createFolderIfNotExist) {
        Intrinsics.checkNotNullParameter((Object)$this$createFolderIfNotExist, (String)"<this>");
        if (!$this$createFolderIfNotExist.exists()) {
            $this$createFolderIfNotExist.mkdirs();
        }
        return $this$createFolderIfNotExist;
    }

    @NotNull
    public static final File createFolderReplace(@NotNull File $this$createFolderReplace) {
        Intrinsics.checkNotNullParameter((Object)$this$createFolderReplace, (String)"<this>");
        if ($this$createFolderReplace.exists()) {
            FileUtils.INSTANCE.delete($this$createFolderReplace, true);
        }
        $this$createFolderReplace.mkdirs();
        return $this$createFolderReplace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean checkWrite(@NotNull File $this$checkWrite) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$checkWrite, (String)"<this>");
        File file = null;
        try {
            boolean bl2;
            int n3;
            Closeable it;
            String filename = String.valueOf(System.currentTimeMillis());
            Object object = new String[]{filename};
            file = FileUtils.INSTANCE.createFileIfNotExist($this$checkWrite, (String)object);
            object = FileExtensionsKt.outputStream$default(file, false, 1, null);
            Object object2 = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)object, (Charset)object2);
            int n2 = 8192;
            object = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n2);
            object2 = null;
            try {
                it = (BufferedWriter)object;
                n3 = 0;
                it.write(filename);
                it = Unit.INSTANCE;
            }
            catch (Throwable n3) {
                object2 = n3;
                throw n3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = new FileInputStream(file);
            object2 = Charsets.UTF_8;
            it = new InputStreamReader((InputStream)object, (Charset)object2);
            n3 = 8192;
            object = it instanceof BufferedReader ? (BufferedReader)it : new BufferedReader((Reader)it, n3);
            object2 = null;
            try {
                it = (BufferedReader)object;
                boolean bl3 = false;
                bl2 = Intrinsics.areEqual((Object)TextStreamsKt.readText((Reader)((Reader)it)), (Object)filename);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            bl = bl2;
        }
        catch (Exception e) {
            bl = false;
        }
        finally {
            File file2 = file;
            if (file2 != null) {
                file2.delete();
            }
        }
        return bl;
    }

    @NotNull
    public static final FileOutputStream outputStream(@NotNull File $this$outputStream, boolean append) {
        Intrinsics.checkNotNullParameter((Object)$this$outputStream, (String)"<this>");
        return new FileOutputStream($this$outputStream, append);
    }

    public static /* synthetic */ FileOutputStream outputStream$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FileExtensionsKt.outputStream(file, bl);
    }
}

