/*
 * Decompiled with CFR 0.152.
 */
package book.util;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0011R\u0011\u0010\"\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0011R\u0011\u0010$\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0011R\u0011\u0010&\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0011\u00a8\u0006("}, d2={"Lbook/util/AppPattern;", "", "<init>", "()V", "JS_PATTERN", "Ljava/util/regex/Pattern;", "getJS_PATTERN", "()Ljava/util/regex/Pattern;", "EXP_PATTERN", "getEXP_PATTERN", "titleNumPattern", "getTitleNumPattern", "imgPattern", "getImgPattern", "dataUriRegex", "Lkotlin/text/Regex;", "getDataUriRegex", "()Lkotlin/text/Regex;", "nameRegex", "getNameRegex", "authorRegex", "getAuthorRegex", "fileNameRegex", "getFileNameRegex", "splitGroupRegex", "getSplitGroupRegex", "debugMessageSymbolRegex", "getDebugMessageSymbolRegex", "bookFileRegex", "getBookFileRegex", "semicolonRegex", "getSemicolonRegex", "bdRegex", "getBdRegex", "rnRegex", "getRnRegex", "notReadAloudRegex", "getNotReadAloudRegex", "xmlContentTypeRegex", "getXmlContentTypeRegex", "book"})
public final class AppPattern {
    @NotNull
    public static final AppPattern INSTANCE = new AppPattern();
    @NotNull
    private static final Pattern JS_PATTERN;
    @NotNull
    private static final Pattern EXP_PATTERN;
    @NotNull
    private static final Pattern titleNumPattern;
    @NotNull
    private static final Pattern imgPattern;
    @NotNull
    private static final Regex dataUriRegex;
    @NotNull
    private static final Regex nameRegex;
    @NotNull
    private static final Regex authorRegex;
    @NotNull
    private static final Regex fileNameRegex;
    @NotNull
    private static final Regex splitGroupRegex;
    @NotNull
    private static final Regex debugMessageSymbolRegex;
    @NotNull
    private static final Regex bookFileRegex;
    @NotNull
    private static final Regex semicolonRegex;
    @NotNull
    private static final Regex bdRegex;
    @NotNull
    private static final Regex rnRegex;
    @NotNull
    private static final Regex notReadAloudRegex;
    @NotNull
    private static final Regex xmlContentTypeRegex;

    private AppPattern() {
    }

    @NotNull
    public final Pattern getJS_PATTERN() {
        return JS_PATTERN;
    }

    @NotNull
    public final Pattern getEXP_PATTERN() {
        return EXP_PATTERN;
    }

    @NotNull
    public final Pattern getTitleNumPattern() {
        return titleNumPattern;
    }

    @NotNull
    public final Pattern getImgPattern() {
        return imgPattern;
    }

    @NotNull
    public final Regex getDataUriRegex() {
        return dataUriRegex;
    }

    @NotNull
    public final Regex getNameRegex() {
        return nameRegex;
    }

    @NotNull
    public final Regex getAuthorRegex() {
        return authorRegex;
    }

    @NotNull
    public final Regex getFileNameRegex() {
        return fileNameRegex;
    }

    @NotNull
    public final Regex getSplitGroupRegex() {
        return splitGroupRegex;
    }

    @NotNull
    public final Regex getDebugMessageSymbolRegex() {
        return debugMessageSymbolRegex;
    }

    @NotNull
    public final Regex getBookFileRegex() {
        return bookFileRegex;
    }

    @NotNull
    public final Regex getSemicolonRegex() {
        return semicolonRegex;
    }

    @NotNull
    public final Regex getBdRegex() {
        return bdRegex;
    }

    @NotNull
    public final Regex getRnRegex() {
        return rnRegex;
    }

    @NotNull
    public final Regex getNotReadAloudRegex() {
        return notReadAloudRegex;
    }

    @NotNull
    public final Regex getXmlContentTypeRegex() {
        return xmlContentTypeRegex;
    }

    static {
        Pattern pattern = Pattern.compile("<js>([\\w\\W]*?)</js>|@js:([\\w\\W]*)", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        JS_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("\\{\\{([\\w\\W]*?)\\}\\}");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        EXP_PATTERN = pattern2;
        Pattern pattern3 = Pattern.compile("(\u7b2c)(.+?)(\u7ae0)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        titleNumPattern = pattern3;
        Pattern pattern4 = Pattern.compile("<img[^>]*src=\"([^\"]*(?:\"[^>]+\\})?)\"[^>]*>");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        imgPattern = pattern4;
        dataUriRegex = new Regex("data:.*?;base64,(.*)");
        nameRegex = new Regex("\\s+\u4f5c\\s*\u8005.*|\\s+\\S+\\s+\u8457");
        authorRegex = new Regex("^\\s*\u4f5c\\s*\u8005[:\uff1a\\s]+|\\s+\u8457");
        fileNameRegex = new Regex("[\\\\/:*?\"<>|.]");
        splitGroupRegex = new Regex("[,;\uff0c\uff1b]");
        debugMessageSymbolRegex = new Regex("[\u21d2\u25c7\u250c\u2514\u2261]");
        bookFileRegex = new Regex(".*\\.(txt|epub|umd)", RegexOption.IGNORE_CASE);
        semicolonRegex = new Regex(";");
        bdRegex = new Regex("(\\p{P})+");
        rnRegex = new Regex("[\\r\\n]");
        notReadAloudRegex = new Regex("^(\\s|\\p{C}|\\p{P}|\\p{Z}|\\p{S})+$");
        xmlContentTypeRegex = new Regex("(application|text)/\\w*\\+?xml.*");
    }
}

