/*
 * Decompiled with CFR 0.152.
 */
package book.model;

import book.model.BaseBook;
import book.model.SearchBook;
import book.util.AppPattern;
import book.util.FileUtils;
import book.util.GSONKt;
import book.util.MD5Utils;
import book.webBook.localBook.CbzFile;
import book.webBook.localBook.EpubFile;
import book.webBook.localBook.LocalBook;
import book.webBook.localBook.UmdFile;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@JsonIgnoreProperties(value={"variableMap", "infoHtml", "tocHtml", "config", "rootDir", "readConfig", "localBook", "epub", "epubRootDir", "onLineTxt", "localTxt", "umd", "realAuthor", "unreadChapterNum", "folderName", "localFile", "kindList", "_userNameSpace", "bookDir", "userNameSpace"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\bP\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b)\b\u0087\b\u0018\u0000 \u00d3\u00012\u00020\u0001:\u0006\u00d3\u0001\u00d4\u0001\u00d5\u0001B\u00df\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0011\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u0015\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u001f\u001a\u00020 \u0012\b\b\u0002\u0010!\u001a\u00020\u0011\u0012\b\b\u0002\u0010\"\u001a\u00020\u0011\u0012\b\b\u0002\u0010#\u001a\u00020 \u0012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&\u0012\b\b\u0002\u0010'\u001a\u00020\u0003\u00a2\u0006\u0004\b(\u0010)J\b\u0010|\u001a\u00020\u0003H\u0016J\u0006\u0010}\u001a\u00020 J\u0006\u0010~\u001a\u00020 J\u0006\u0010\u007f\u001a\u00020 J\u0007\u0010\u0080\u0001\u001a\u00020 J\u0007\u0010\u0081\u0001\u001a\u00020 J\u0007\u0010\u0082\u0001\u001a\u00020 J\u0007\u0010\u0083\u0001\u001a\u00020 J\u0016\u0010\u0084\u0001\u001a\u00020 2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001H\u0096\u0002J\t\u0010\u0087\u0001\u001a\u00020\u0011H\u0016J\u0007\u0010\u0095\u0001\u001a\u00020\u0003J\u0007\u0010\u0096\u0001\u001a\u00020\u0011J\t\u0010\u0097\u0001\u001a\u0004\u0018\u00010\u0003J\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010\u0003J\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001J\t\u0010\u009b\u0001\u001a\u00020&H\u0002J\u0011\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u0007\u0010\u009e\u0001\u001a\u00020\u0015J\u0010\u0010\u009f\u0001\u001a\u00020 2\u0007\u0010\u009e\u0001\u001a\u00020\u0015J\u0007\u0010\u00a0\u0001\u001a\u00020\u0003J\b\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001J\u0011\u0010\u00a4\u0001\u001a\u00030\u009d\u00012\u0007\u0010\u00a5\u0001\u001a\u00020\u0003J\u0011\u0010\u00a7\u0001\u001a\u00030\u009d\u00012\u0007\u0010\u00a8\u0001\u001a\u00020\u0003J\u0007\u0010\u00a9\u0001\u001a\u00020\u0003J\u0007\u0010\u00aa\u0001\u001a\u00020\u0003J\u0007\u0010\u00ab\u0001\u001a\u00020 J\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001J\u0007\u0010\u00ae\u0001\u001a\u00020\u0003J\u0013\u0010\u00af\u0001\u001a\u00030\u009d\u00012\t\b\u0002\u0010\u00b0\u0001\u001a\u00020 J\u0007\u0010\u00b1\u0001\u001a\u00020\u0003J\n\u0010\u00b2\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u00b3\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u00b4\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u00b5\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u00b6\u0001\u001a\u00020\u0003H\u00c6\u0003J\n\u0010\u00b7\u0001\u001a\u00020\u0003H\u00c6\u0003J\f\u0010\u00b8\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\f\u0010\u00b9\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\f\u0010\u00ba\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\f\u0010\u00bb\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\f\u0010\u00bc\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\f\u0010\u00bd\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\f\u0010\u00be\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\n\u0010\u00bf\u0001\u001a\u00020\u0011H\u00c6\u0003J\n\u0010\u00c0\u0001\u001a\u00020\u0011H\u00c6\u0003J\f\u0010\u00c1\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\n\u0010\u00c2\u0001\u001a\u00020\u0015H\u00c6\u0003J\n\u0010\u00c3\u0001\u001a\u00020\u0015H\u00c6\u0003J\n\u0010\u00c4\u0001\u001a\u00020\u0011H\u00c6\u0003J\n\u0010\u00c5\u0001\u001a\u00020\u0011H\u00c6\u0003J\f\u0010\u00c6\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\n\u0010\u00c7\u0001\u001a\u00020\u0011H\u00c6\u0003J\n\u0010\u00c8\u0001\u001a\u00020\u001cH\u00c6\u0003J\n\u0010\u00c9\u0001\u001a\u00020\u0015H\u00c6\u0003J\f\u0010\u00ca\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\n\u0010\u00cb\u0001\u001a\u00020 H\u00c6\u0003J\n\u0010\u00cc\u0001\u001a\u00020\u0011H\u00c6\u0003J\n\u0010\u00cd\u0001\u001a\u00020\u0011H\u00c6\u0003J\n\u0010\u00ce\u0001\u001a\u00020 H\u00c6\u0003J\f\u0010\u00cf\u0001\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\f\u0010\u00d0\u0001\u001a\u0004\u0018\u00010&H\u00c6\u0003J\n\u0010\u00d1\u0001\u001a\u00020\u0003H\u00c6\u0003J\u00e2\u0002\u0010\u00d2\u0001\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\u00112\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001a\u001a\u00020\u00112\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00152\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u00112\b\b\u0002\u0010\"\u001a\u00020\u00112\b\b\u0002\u0010#\u001a\u00020 2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010'\u001a\u00020\u0003H\u00c6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010+\"\u0004\b/\u0010-R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010+\"\u0004\b1\u0010-R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010+\"\u0004\b5\u0010-R\u001a\u0010\b\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010+\"\u0004\b7\u0010-R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010+\"\u0004\b9\u0010-R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010+\"\u0004\b;\u0010-R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010+\"\u0004\b=\u0010-R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010+\"\u0004\b?\u0010-R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010+\"\u0004\bA\u0010-R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010+\"\u0004\bC\u0010-R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010+\"\u0004\bE\u0010-R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010\u0012\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010G\"\u0004\bK\u0010IR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010+\"\u0004\bM\u0010-R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001a\u0010\u0016\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010O\"\u0004\bS\u0010QR\u001a\u0010\u0017\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010G\"\u0004\bU\u0010IR\u001a\u0010\u0018\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010G\"\u0004\bW\u0010IR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010+\"\u0004\bY\u0010-R\u001a\u0010\u001a\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010G\"\u0004\b[\u0010IR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010O\"\u0004\ba\u0010QR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010+\"\u0004\bc\u0010-R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR\u001a\u0010!\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010G\"\u0004\bi\u0010IR\u001a\u0010\"\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010G\"\u0004\bk\u0010IR\u001a\u0010#\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010e\"\u0004\bm\u0010gR \u0010$\u001a\u0004\u0018\u00010\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010+\"\u0004\bo\u0010-R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010q\"\u0004\br\u0010sR\u001a\u0010'\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010+\"\u0004\bu\u0010-R\"\u0010v\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010wX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{R>\u0010\u0088\u0001\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0089\u0001j\u000f\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u008a\u00018VX\u0097\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u008d\u0001\u0010\u008e\u0001\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R#\u0010\u008f\u0001\u001a\u0004\u0018\u00010\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0090\u0001\u0010+\"\u0005\b\u0091\u0001\u0010-R#\u0010\u0092\u0001\u001a\u0004\u0018\u00010\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0093\u0001\u0010+\"\u0005\b\u0094\u0001\u0010-R\u0013\u0010\u00a3\u0001\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u00a6\u0001\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00d6\u0001"}, d2={"Lbook/model/Book;", "Lbook/model/BaseBook;", "bookUrl", "", "tocUrl", "origin", "originName", "name", "author", "kind", "customTag", "coverUrl", "customCoverUrl", "intro", "customIntro", "charset", "type", "", "group", "latestChapterTitle", "latestChapterTime", "", "lastCheckTime", "lastCheckCount", "totalChapterNum", "durChapterTitle", "durChapterIndex", "durChapterPos", "", "durChapterTime", "wordCount", "canUpdate", "", "order", "originOrder", "useReplaceRule", "variable", "readConfig", "Lbook/model/Book$ReadConfig;", "userid", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;JJIILjava/lang/String;IDJLjava/lang/String;ZIIZLjava/lang/String;Lbook/model/Book$ReadConfig;Ljava/lang/String;)V", "getBookUrl", "()Ljava/lang/String;", "setBookUrl", "(Ljava/lang/String;)V", "getTocUrl", "setTocUrl", "getOrigin", "setOrigin", "getOriginName", "setOriginName", "getName", "setName", "getAuthor", "setAuthor", "getKind", "setKind", "getCustomTag", "setCustomTag", "getCoverUrl", "setCoverUrl", "getCustomCoverUrl", "setCustomCoverUrl", "getIntro", "setIntro", "getCustomIntro", "setCustomIntro", "getCharset", "setCharset", "getType", "()I", "setType", "(I)V", "getGroup", "setGroup", "getLatestChapterTitle", "setLatestChapterTitle", "getLatestChapterTime", "()J", "setLatestChapterTime", "(J)V", "getLastCheckTime", "setLastCheckTime", "getLastCheckCount", "setLastCheckCount", "getTotalChapterNum", "setTotalChapterNum", "getDurChapterTitle", "setDurChapterTitle", "getDurChapterIndex", "setDurChapterIndex", "getDurChapterPos", "()D", "setDurChapterPos", "(D)V", "getDurChapterTime", "setDurChapterTime", "getWordCount", "setWordCount", "getCanUpdate", "()Z", "setCanUpdate", "(Z)V", "getOrder", "setOrder", "getOriginOrder", "setOriginOrder", "getUseReplaceRule", "setUseReplaceRule", "getVariable", "setVariable", "getReadConfig", "()Lbook/model/Book$ReadConfig;", "setReadConfig", "(Lbook/model/Book$ReadConfig;)V", "getUserid", "setUserid", "downloadUrls", "", "getDownloadUrls", "()Ljava/util/List;", "setDownloadUrls", "(Ljava/util/List;)V", "toString", "isLocalBook", "isLocalTxt", "isLocalEpub", "isEpub", "isCbz", "isUmd", "isOnLineTxt", "equals", "other", "", "hashCode", "variableMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getVariableMap", "()Ljava/util/HashMap;", "variableMap$delegate", "Lkotlin/Lazy;", "infoHtml", "getInfoHtml", "setInfoHtml", "tocHtml", "getTocHtml", "setTocHtml", "getRealAuthor", "getUnreadChapterNum", "getDisplayCover", "getDisplayIntro", "fileCharset", "Ljava/nio/charset/Charset;", "config", "setDelTag", "", "tag", "getDelTag", "getFolderName", "getLocalFile", "Ljava/io/File;", "rootDir", "setRootDir", "root", "_userNameSpace", "setUserNameSpace", "nameSpace", "getUserNameSpace", "getBookDir", "getSplitLongChapter", "toSearchBook", "Lbook/model/SearchBook;", "getEpubRootDir", "updateFromLocal", "onlyCover", "workRoot", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component20", "component21", "component22", "component23", "component24", "component25", "component26", "component27", "component28", "component29", "component30", "component31", "component32", "copy", "Companion", "ReadConfig", "Converters", "book"})
@SourceDebugExtension(value={"SMAP\nBook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Book.kt\nbook/model/Book\n+ 2 GSON.kt\nbook/util/GSONKt\n*L\n1#1,302:1\n33#2,2:303\n30#2:305\n*S KotlinDebug\n*F\n+ 1 Book.kt\nbook/model/Book\n*L\n122#1:303,2\n122#1:305\n*E\n"})
public final class Book
implements BaseBook {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String bookUrl;
    @NotNull
    private String tocUrl;
    @NotNull
    private String origin;
    @NotNull
    private String originName;
    @NotNull
    private String name;
    @NotNull
    private String author;
    @Nullable
    private String kind;
    @Nullable
    private String customTag;
    @Nullable
    private String coverUrl;
    @Nullable
    private String customCoverUrl;
    @Nullable
    private String intro;
    @Nullable
    private String customIntro;
    @Nullable
    private String charset;
    private int type;
    private int group;
    @Nullable
    private String latestChapterTitle;
    private long latestChapterTime;
    private long lastCheckTime;
    private int lastCheckCount;
    private int totalChapterNum;
    @Nullable
    private String durChapterTitle;
    private int durChapterIndex;
    private double durChapterPos;
    private long durChapterTime;
    @Nullable
    private String wordCount;
    private boolean canUpdate;
    private int order;
    private int originOrder;
    private boolean useReplaceRule;
    @Expose(serialize=false, deserialize=false)
    @Nullable
    private String variable;
    @Nullable
    private ReadConfig readConfig;
    @NotNull
    private String userid;
    @Nullable
    private List<String> downloadUrls;
    @Expose(serialize=false, deserialize=false)
    @NotNull
    private final Lazy variableMap$delegate;
    @Expose(serialize=false, deserialize=false)
    @Nullable
    private String infoHtml;
    @Expose(serialize=false, deserialize=false)
    @Nullable
    private String tocHtml;
    @Expose(serialize=false, deserialize=false)
    @NotNull
    private transient String rootDir;
    @Expose(serialize=false, deserialize=false)
    @NotNull
    private transient String _userNameSpace;
    public static final long hTag = 2L;
    public static final long rubyTag = 4L;
    public static final long imgTag = 8L;
    @NotNull
    public static final String imgStyleDefault = "DEFAULT";
    @NotNull
    public static final String imgStyleFull = "FULL";
    @NotNull
    public static final String imgStyleText = "TEXT";

    public Book(@NotNull String bookUrl, @NotNull String tocUrl, @NotNull String origin, @NotNull String originName, @NotNull String name, @NotNull String author, @Nullable String kind, @Nullable String customTag, @Nullable String coverUrl, @Nullable String customCoverUrl, @Nullable String intro, @Nullable String customIntro, @Nullable String charset, int type, int group, @Nullable String latestChapterTitle, long latestChapterTime, long lastCheckTime, int lastCheckCount, int totalChapterNum, @Nullable String durChapterTitle, int durChapterIndex, double durChapterPos, long durChapterTime, @Nullable String wordCount, boolean canUpdate, int order, int originOrder, boolean useReplaceRule, @Nullable String variable, @Nullable ReadConfig readConfig, @NotNull String userid) {
        Intrinsics.checkNotNullParameter((Object)bookUrl, (String)"bookUrl");
        Intrinsics.checkNotNullParameter((Object)tocUrl, (String)"tocUrl");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)originName, (String)"originName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)userid, (String)"userid");
        this.bookUrl = bookUrl;
        this.tocUrl = tocUrl;
        this.origin = origin;
        this.originName = originName;
        this.name = name;
        this.author = author;
        this.kind = kind;
        this.customTag = customTag;
        this.coverUrl = coverUrl;
        this.customCoverUrl = customCoverUrl;
        this.intro = intro;
        this.customIntro = customIntro;
        this.charset = charset;
        this.type = type;
        this.group = group;
        this.latestChapterTitle = latestChapterTitle;
        this.latestChapterTime = latestChapterTime;
        this.lastCheckTime = lastCheckTime;
        this.lastCheckCount = lastCheckCount;
        this.totalChapterNum = totalChapterNum;
        this.durChapterTitle = durChapterTitle;
        this.durChapterIndex = durChapterIndex;
        this.durChapterPos = durChapterPos;
        this.durChapterTime = durChapterTime;
        this.wordCount = wordCount;
        this.canUpdate = canUpdate;
        this.order = order;
        this.originOrder = originOrder;
        this.useReplaceRule = useReplaceRule;
        this.variable = variable;
        this.readConfig = readConfig;
        this.userid = userid;
        this.variableMap$delegate = LazyKt.lazy(() -> Book.variableMap_delegate$lambda$0(this));
        this.rootDir = "";
        this._userNameSpace = "";
    }

    public /* synthetic */ Book(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, int n, int n2, String string14, long l, long l2, int n3, int n4, String string15, int n5, double d, long l3, String string16, boolean bl, int n6, int n7, boolean bl2, String string17, ReadConfig readConfig, String string18, int n8, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n8 & 1) != 0) {
            string = "";
        }
        if ((n8 & 2) != 0) {
            string2 = "";
        }
        if ((n8 & 4) != 0) {
            string3 = "loc_book";
        }
        if ((n8 & 8) != 0) {
            string4 = "";
        }
        if ((n8 & 0x10) != 0) {
            string5 = "";
        }
        if ((n8 & 0x20) != 0) {
            string6 = "";
        }
        if ((n8 & 0x40) != 0) {
            string7 = null;
        }
        if ((n8 & 0x80) != 0) {
            string8 = null;
        }
        if ((n8 & 0x100) != 0) {
            string9 = null;
        }
        if ((n8 & 0x200) != 0) {
            string10 = null;
        }
        if ((n8 & 0x400) != 0) {
            string11 = null;
        }
        if ((n8 & 0x800) != 0) {
            string12 = null;
        }
        if ((n8 & 0x1000) != 0) {
            string13 = null;
        }
        if ((n8 & 0x2000) != 0) {
            n = 0;
        }
        if ((n8 & 0x4000) != 0) {
            n2 = 0;
        }
        if ((n8 & 0x8000) != 0) {
            string14 = null;
        }
        if ((n8 & 0x10000) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n8 & 0x20000) != 0) {
            l2 = System.currentTimeMillis();
        }
        if ((n8 & 0x40000) != 0) {
            n3 = 0;
        }
        if ((n8 & 0x80000) != 0) {
            n4 = 0;
        }
        if ((n8 & 0x100000) != 0) {
            string15 = null;
        }
        if ((n8 & 0x200000) != 0) {
            n5 = 0;
        }
        if ((n8 & 0x400000) != 0) {
            d = 0.0;
        }
        if ((n8 & 0x800000) != 0) {
            l3 = System.currentTimeMillis();
        }
        if ((n8 & 0x1000000) != 0) {
            string16 = null;
        }
        if ((n8 & 0x2000000) != 0) {
            bl = true;
        }
        if ((n8 & 0x4000000) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x8000000) != 0) {
            n7 = 0;
        }
        if ((n8 & 0x10000000) != 0) {
            bl2 = true;
        }
        if ((n8 & 0x20000000) != 0) {
            string17 = null;
        }
        if ((n8 & 0x40000000) != 0) {
            readConfig = null;
        }
        if ((n8 & Integer.MIN_VALUE) != 0) {
            string18 = "";
        }
        this(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, n, n2, string14, l, l2, n3, n4, string15, n5, d, l3, string16, bl, n6, n7, bl2, string17, readConfig, string18);
    }

    @Override
    @NotNull
    public String getBookUrl() {
        return this.bookUrl;
    }

    @Override
    public void setBookUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.bookUrl = string;
    }

    @NotNull
    public final String getTocUrl() {
        return this.tocUrl;
    }

    public final void setTocUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.tocUrl = string;
    }

    @NotNull
    public final String getOrigin() {
        return this.origin;
    }

    public final void setOrigin(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.origin = string;
    }

    @NotNull
    public final String getOriginName() {
        return this.originName;
    }

    public final void setOriginName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.originName = string;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    @NotNull
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.author = string;
    }

    @Override
    @Nullable
    public String getKind() {
        return this.kind;
    }

    @Override
    public void setKind(@Nullable String string) {
        this.kind = string;
    }

    @Nullable
    public final String getCustomTag() {
        return this.customTag;
    }

    public final void setCustomTag(@Nullable String string) {
        this.customTag = string;
    }

    @Nullable
    public final String getCoverUrl() {
        return this.coverUrl;
    }

    public final void setCoverUrl(@Nullable String string) {
        this.coverUrl = string;
    }

    @Nullable
    public final String getCustomCoverUrl() {
        return this.customCoverUrl;
    }

    public final void setCustomCoverUrl(@Nullable String string) {
        this.customCoverUrl = string;
    }

    @Nullable
    public final String getIntro() {
        return this.intro;
    }

    public final void setIntro(@Nullable String string) {
        this.intro = string;
    }

    @Nullable
    public final String getCustomIntro() {
        return this.customIntro;
    }

    public final void setCustomIntro(@Nullable String string) {
        this.customIntro = string;
    }

    @Nullable
    public final String getCharset() {
        return this.charset;
    }

    public final void setCharset(@Nullable String string) {
        this.charset = string;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public final int getGroup() {
        return this.group;
    }

    public final void setGroup(int n) {
        this.group = n;
    }

    @Nullable
    public final String getLatestChapterTitle() {
        return this.latestChapterTitle;
    }

    public final void setLatestChapterTitle(@Nullable String string) {
        this.latestChapterTitle = string;
    }

    public final long getLatestChapterTime() {
        return this.latestChapterTime;
    }

    public final void setLatestChapterTime(long l) {
        this.latestChapterTime = l;
    }

    public final long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public final void setLastCheckTime(long l) {
        this.lastCheckTime = l;
    }

    public final int getLastCheckCount() {
        return this.lastCheckCount;
    }

    public final void setLastCheckCount(int n) {
        this.lastCheckCount = n;
    }

    public final int getTotalChapterNum() {
        return this.totalChapterNum;
    }

    public final void setTotalChapterNum(int n) {
        this.totalChapterNum = n;
    }

    @Nullable
    public final String getDurChapterTitle() {
        return this.durChapterTitle;
    }

    public final void setDurChapterTitle(@Nullable String string) {
        this.durChapterTitle = string;
    }

    public final int getDurChapterIndex() {
        return this.durChapterIndex;
    }

    public final void setDurChapterIndex(int n) {
        this.durChapterIndex = n;
    }

    public final double getDurChapterPos() {
        return this.durChapterPos;
    }

    public final void setDurChapterPos(double d) {
        this.durChapterPos = d;
    }

    public final long getDurChapterTime() {
        return this.durChapterTime;
    }

    public final void setDurChapterTime(long l) {
        this.durChapterTime = l;
    }

    @Override
    @Nullable
    public String getWordCount() {
        return this.wordCount;
    }

    @Override
    public void setWordCount(@Nullable String string) {
        this.wordCount = string;
    }

    public final boolean getCanUpdate() {
        return this.canUpdate;
    }

    public final void setCanUpdate(boolean bl) {
        this.canUpdate = bl;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int n) {
        this.order = n;
    }

    public final int getOriginOrder() {
        return this.originOrder;
    }

    public final void setOriginOrder(int n) {
        this.originOrder = n;
    }

    public final boolean getUseReplaceRule() {
        return this.useReplaceRule;
    }

    public final void setUseReplaceRule(boolean bl) {
        this.useReplaceRule = bl;
    }

    @Override
    @Nullable
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(@Nullable String string) {
        this.variable = string;
    }

    @Nullable
    public final ReadConfig getReadConfig() {
        return this.readConfig;
    }

    public final void setReadConfig(@Nullable ReadConfig readConfig) {
        this.readConfig = readConfig;
    }

    @Override
    @NotNull
    public String getUserid() {
        return this.userid;
    }

    @Override
    public void setUserid(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.userid = string;
    }

    @Nullable
    public final List<String> getDownloadUrls() {
        return this.downloadUrls;
    }

    public final void setDownloadUrls(@Nullable List<String> list) {
        this.downloadUrls = list;
    }

    @NotNull
    public String toString() {
        int hashCode = this.hashCode();
        String hexHash = Integer.toHexString(hashCode);
        String s = "io.legado.app.data.entities.Book@" + hexHash;
        return s;
    }

    public final boolean isLocalBook() {
        return Intrinsics.areEqual((Object)this.origin, (Object)"loc_book");
    }

    public final boolean isLocalTxt() {
        return this.isLocalBook() && StringsKt.endsWith((String)this.originName, (String)".txt", (boolean)true);
    }

    public final boolean isLocalEpub() {
        return this.isLocalBook() && StringsKt.endsWith((String)this.originName, (String)".epub", (boolean)true);
    }

    public final boolean isEpub() {
        return StringsKt.endsWith((String)this.originName, (String)".epub", (boolean)true);
    }

    public final boolean isCbz() {
        return StringsKt.endsWith((String)this.originName, (String)".cbz", (boolean)true);
    }

    public final boolean isUmd() {
        return StringsKt.endsWith((String)this.originName, (String)".umd", (boolean)true);
    }

    public final boolean isOnLineTxt() {
        return !this.isLocalBook() && this.type == 0;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof Book) {
            return Intrinsics.areEqual((Object)((Book)other).getBookUrl(), (Object)this.getBookUrl());
        }
        return false;
    }

    public int hashCode() {
        return this.getBookUrl().hashCode();
    }

    @Override
    @NotNull
    public HashMap<String, String> getVariableMap() {
        Lazy lazy = this.variableMap$delegate;
        return (HashMap)lazy.getValue();
    }

    @Override
    @Nullable
    public String getInfoHtml() {
        return this.infoHtml;
    }

    @Override
    public void setInfoHtml(@Nullable String string) {
        this.infoHtml = string;
    }

    @Override
    @Nullable
    public String getTocHtml() {
        return this.tocHtml;
    }

    @Override
    public void setTocHtml(@Nullable String string) {
        this.tocHtml = string;
    }

    @NotNull
    public final String getRealAuthor() {
        CharSequence charSequence = this.getAuthor();
        Regex regex = AppPattern.INSTANCE.getAuthorRegex();
        String string = "";
        return regex.replace(charSequence, string);
    }

    public final int getUnreadChapterNum() {
        return Math.max(this.totalChapterNum - this.durChapterIndex - 1, 0);
    }

    @Nullable
    public final String getDisplayCover() {
        CharSequence charSequence = this.customCoverUrl;
        return charSequence == null || charSequence.length() == 0 ? this.coverUrl : this.customCoverUrl;
    }

    @Nullable
    public final String getDisplayIntro() {
        CharSequence charSequence = this.customIntro;
        return charSequence == null || charSequence.length() == 0 ? this.intro : this.customIntro;
    }

    @NotNull
    public final Charset fileCharset() {
        String string = this.charset;
        if (string == null) {
            string = "UTF-8";
        }
        Charset charset = Charset.forName(string);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        return charset;
    }

    private final ReadConfig config() {
        if (this.readConfig == null) {
            this.readConfig = new ReadConfig(false, 0, false, null, false, 0L, 63, null);
        }
        ReadConfig readConfig = this.readConfig;
        Intrinsics.checkNotNull((Object)readConfig);
        return readConfig;
    }

    public final void setDelTag(long tag) {
        this.config().setDelTag((this.config().getDelTag() & tag) == tag ? this.config().getDelTag() & (tag ^ 0xFFFFFFFFFFFFFFFFL) : this.config().getDelTag() | tag);
    }

    public final boolean getDelTag(long tag) {
        return (this.config().getDelTag() & tag) == tag;
    }

    @NotNull
    public final String getFolderName() {
        CharSequence charSequence = this.getName();
        Regex regex = AppPattern.INSTANCE.getFileNameRegex();
        String string = "";
        String folderName = regex.replace(charSequence, string);
        String string2 = folderName.substring(0, Math.min(9, folderName.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        folderName = string2;
        return folderName + MD5Utils.INSTANCE.md5Encode16(this.getBookUrl());
    }

    @NotNull
    public final File getLocalFile() {
        return new File(this.originName);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void setRootDir(@NotNull String root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (((CharSequence)root).length() > 0) {
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            if (!StringsKt.endsWith$default((String)root, (String)string, (boolean)false, (int)2, null)) {
                this.rootDir = root + File.separator;
                return;
            }
        }
        this.rootDir = root;
    }

    public final void setUserNameSpace(@NotNull String nameSpace) {
        Intrinsics.checkNotNullParameter((Object)nameSpace, (String)"nameSpace");
        this._userNameSpace = nameSpace;
    }

    @NotNull
    public final String getUserNameSpace() {
        return this._userNameSpace;
    }

    @NotNull
    public final String getBookDir() {
        String[] stringArray = new String[]{"storage", "data", this._userNameSpace, this.getName() + "_" + this.getAuthor()};
        return FileUtils.INSTANCE.getPath(new File(this.rootDir), stringArray);
    }

    public final boolean getSplitLongChapter() {
        return false;
    }

    @NotNull
    public final SearchBook toSearchBook() {
        Object object = this.getName();
        String string = this.getAuthor();
        String string2 = this.getKind();
        String string3 = this.getBookUrl();
        String string4 = this.origin;
        String string5 = this.originName;
        int n = this.type;
        String string6 = this.getWordCount();
        String string7 = this.latestChapterTitle;
        String string8 = this.coverUrl;
        String string9 = this.intro;
        String string10 = this.tocUrl;
        Object $this$toSearchBook_u24lambda_u241 = object = new SearchBook(string3, string4, string5, n, (String)object, string, string2, string8, string9, string6, string7, string10, 0L, null, 0, null, 61440, null);
        boolean bl = false;
        ((SearchBook)$this$toSearchBook_u24lambda_u241).setUserid(((SearchBook)$this$toSearchBook_u24lambda_u241).getUserid());
        ((SearchBook)$this$toSearchBook_u24lambda_u241).setVariable(((SearchBook)$this$toSearchBook_u24lambda_u241).getVariable());
        ((SearchBook)$this$toSearchBook_u24lambda_u241).setInfoHtml(this.getInfoHtml());
        ((SearchBook)$this$toSearchBook_u24lambda_u241).setTocHtml(this.getTocHtml());
        return object;
    }

    @NotNull
    public final String getEpubRootDir() {
        String defaultPath;
        block4: {
            defaultPath = "OEBPS";
            File containerRes = new File(this.getBookUrl() + File.separator + "index" + File.separator + "META-INF" + File.separator + "container.xml");
            if (!containerRes.exists()) break block4;
            try {
                Object object;
                block6: {
                    block5: {
                        Document document = Jsoup.parse((String)FilesKt.readText$default((File)containerRes, null, (int)1, null));
                        Element rootFileElement = (Element)((Element)document.getElementsByTag("rootfiles").get(0)).getElementsByTag("rootfile").get(0);
                        String result = rootFileElement.attr("full-path");
                        if (result == null || !(((CharSequence)result).length() > 0)) break block4;
                        object = new File(result).getParentFile();
                        if (object == null) break block5;
                        File it = object;
                        boolean bl = false;
                        String string = it.toString();
                        object = string;
                        if (string != null) break block6;
                    }
                    object = "";
                }
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return defaultPath;
    }

    public final void updateFromLocal(boolean onlyCover) {
        try {
            if (this.isEpub()) {
                EpubFile.Companion.upBookInfo(this, onlyCover);
            } else if (this.isUmd()) {
                UmdFile.Companion.upBookInfo(this, onlyCover);
            } else if (this.isCbz()) {
                CbzFile.Companion.upBookInfo(this, onlyCover);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static /* synthetic */ void updateFromLocal$default(Book book, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        book.updateFromLocal(bl);
    }

    @NotNull
    public final String workRoot() {
        return this.rootDir;
    }

    @NotNull
    public final String component1() {
        return this.bookUrl;
    }

    @NotNull
    public final String component2() {
        return this.tocUrl;
    }

    @NotNull
    public final String component3() {
        return this.origin;
    }

    @NotNull
    public final String component4() {
        return this.originName;
    }

    @NotNull
    public final String component5() {
        return this.name;
    }

    @NotNull
    public final String component6() {
        return this.author;
    }

    @Nullable
    public final String component7() {
        return this.kind;
    }

    @Nullable
    public final String component8() {
        return this.customTag;
    }

    @Nullable
    public final String component9() {
        return this.coverUrl;
    }

    @Nullable
    public final String component10() {
        return this.customCoverUrl;
    }

    @Nullable
    public final String component11() {
        return this.intro;
    }

    @Nullable
    public final String component12() {
        return this.customIntro;
    }

    @Nullable
    public final String component13() {
        return this.charset;
    }

    public final int component14() {
        return this.type;
    }

    public final int component15() {
        return this.group;
    }

    @Nullable
    public final String component16() {
        return this.latestChapterTitle;
    }

    public final long component17() {
        return this.latestChapterTime;
    }

    public final long component18() {
        return this.lastCheckTime;
    }

    public final int component19() {
        return this.lastCheckCount;
    }

    public final int component20() {
        return this.totalChapterNum;
    }

    @Nullable
    public final String component21() {
        return this.durChapterTitle;
    }

    public final int component22() {
        return this.durChapterIndex;
    }

    public final double component23() {
        return this.durChapterPos;
    }

    public final long component24() {
        return this.durChapterTime;
    }

    @Nullable
    public final String component25() {
        return this.wordCount;
    }

    public final boolean component26() {
        return this.canUpdate;
    }

    public final int component27() {
        return this.order;
    }

    public final int component28() {
        return this.originOrder;
    }

    public final boolean component29() {
        return this.useReplaceRule;
    }

    @Nullable
    public final String component30() {
        return this.variable;
    }

    @Nullable
    public final ReadConfig component31() {
        return this.readConfig;
    }

    @NotNull
    public final String component32() {
        return this.userid;
    }

    @NotNull
    public final Book copy(@NotNull String bookUrl, @NotNull String tocUrl, @NotNull String origin, @NotNull String originName, @NotNull String name, @NotNull String author, @Nullable String kind, @Nullable String customTag, @Nullable String coverUrl, @Nullable String customCoverUrl, @Nullable String intro, @Nullable String customIntro, @Nullable String charset, int type, int group, @Nullable String latestChapterTitle, long latestChapterTime, long lastCheckTime, int lastCheckCount, int totalChapterNum, @Nullable String durChapterTitle, int durChapterIndex, double durChapterPos, long durChapterTime, @Nullable String wordCount, boolean canUpdate, int order, int originOrder, boolean useReplaceRule, @Nullable String variable, @Nullable ReadConfig readConfig, @NotNull String userid) {
        Intrinsics.checkNotNullParameter((Object)bookUrl, (String)"bookUrl");
        Intrinsics.checkNotNullParameter((Object)tocUrl, (String)"tocUrl");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)originName, (String)"originName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)userid, (String)"userid");
        return new Book(bookUrl, tocUrl, origin, originName, name, author, kind, customTag, coverUrl, customCoverUrl, intro, customIntro, charset, type, group, latestChapterTitle, latestChapterTime, lastCheckTime, lastCheckCount, totalChapterNum, durChapterTitle, durChapterIndex, durChapterPos, durChapterTime, wordCount, canUpdate, order, originOrder, useReplaceRule, variable, readConfig, userid);
    }

    public static /* synthetic */ Book copy$default(Book book, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, int n, int n2, String string14, long l, long l2, int n3, int n4, String string15, int n5, double d, long l3, String string16, boolean bl, int n6, int n7, boolean bl2, String string17, ReadConfig readConfig, String string18, int n8, Object object) {
        if ((n8 & 1) != 0) {
            string = book.bookUrl;
        }
        if ((n8 & 2) != 0) {
            string2 = book.tocUrl;
        }
        if ((n8 & 4) != 0) {
            string3 = book.origin;
        }
        if ((n8 & 8) != 0) {
            string4 = book.originName;
        }
        if ((n8 & 0x10) != 0) {
            string5 = book.name;
        }
        if ((n8 & 0x20) != 0) {
            string6 = book.author;
        }
        if ((n8 & 0x40) != 0) {
            string7 = book.kind;
        }
        if ((n8 & 0x80) != 0) {
            string8 = book.customTag;
        }
        if ((n8 & 0x100) != 0) {
            string9 = book.coverUrl;
        }
        if ((n8 & 0x200) != 0) {
            string10 = book.customCoverUrl;
        }
        if ((n8 & 0x400) != 0) {
            string11 = book.intro;
        }
        if ((n8 & 0x800) != 0) {
            string12 = book.customIntro;
        }
        if ((n8 & 0x1000) != 0) {
            string13 = book.charset;
        }
        if ((n8 & 0x2000) != 0) {
            n = book.type;
        }
        if ((n8 & 0x4000) != 0) {
            n2 = book.group;
        }
        if ((n8 & 0x8000) != 0) {
            string14 = book.latestChapterTitle;
        }
        if ((n8 & 0x10000) != 0) {
            l = book.latestChapterTime;
        }
        if ((n8 & 0x20000) != 0) {
            l2 = book.lastCheckTime;
        }
        if ((n8 & 0x40000) != 0) {
            n3 = book.lastCheckCount;
        }
        if ((n8 & 0x80000) != 0) {
            n4 = book.totalChapterNum;
        }
        if ((n8 & 0x100000) != 0) {
            string15 = book.durChapterTitle;
        }
        if ((n8 & 0x200000) != 0) {
            n5 = book.durChapterIndex;
        }
        if ((n8 & 0x400000) != 0) {
            d = book.durChapterPos;
        }
        if ((n8 & 0x800000) != 0) {
            l3 = book.durChapterTime;
        }
        if ((n8 & 0x1000000) != 0) {
            string16 = book.wordCount;
        }
        if ((n8 & 0x2000000) != 0) {
            bl = book.canUpdate;
        }
        if ((n8 & 0x4000000) != 0) {
            n6 = book.order;
        }
        if ((n8 & 0x8000000) != 0) {
            n7 = book.originOrder;
        }
        if ((n8 & 0x10000000) != 0) {
            bl2 = book.useReplaceRule;
        }
        if ((n8 & 0x20000000) != 0) {
            string17 = book.variable;
        }
        if ((n8 & 0x40000000) != 0) {
            readConfig = book.readConfig;
        }
        if ((n8 & Integer.MIN_VALUE) != 0) {
            string18 = book.userid;
        }
        return book.copy(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, n, n2, string14, l, l2, n3, n4, string15, n5, d, l3, string16, bl, n6, n7, bl2, string17, readConfig, string18);
    }

    @Override
    public boolean putVariable(@NotNull String key, @Nullable String value) {
        return BaseBook.DefaultImpls.putVariable(this, key, value);
    }

    @Override
    public void putCustomVariable(@Nullable String value) {
        BaseBook.DefaultImpls.putCustomVariable(this, value);
    }

    @Override
    @NotNull
    public String getCustomVariable() {
        return BaseBook.DefaultImpls.getCustomVariable(this);
    }

    @Override
    public void putBigVariable(@NotNull String key, @Nullable String value) {
        BaseBook.DefaultImpls.putBigVariable(this, key, value);
    }

    @Override
    @Nullable
    public String getBigVariable(@NotNull String key) {
        return BaseBook.DefaultImpls.getBigVariable(this, key);
    }

    @Override
    @NotNull
    public String getVariable(@NotNull String key) {
        return BaseBook.DefaultImpls.getVariable(this, key);
    }

    /*
     * WARNING - void declaration
     */
    private static final HashMap variableMap_delegate$lambda$0(Book this$0) {
        Object object;
        Object object2 = GSONKt.getGSON();
        String json$iv = this$0.getVariable();
        boolean $i$f$fromJsonObject = false;
        try {
            void $this$fromJsonObject$iv;
            boolean bl = false;
            boolean $i$f$genericType = false;
            Type type = new TypeToken<HashMap<String, String>>(){}.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            Object object3 = $this$fromJsonObject$iv.fromJson(json$iv, type);
            if (!(object3 instanceof HashMap)) {
                object3 = null;
            }
            object = Result.constructor-impl((Object)((HashMap)object3));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        HashMap hashMap = (HashMap)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        return hashMap;
    }

    public Book() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 0, null, 0L, 0L, 0, 0, null, 0, 0.0, 0L, null, false, 0, 0, false, null, null, null, -1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lbook/model/Book$Companion;", "", "<init>", "()V", "hTag", "", "rubyTag", "imgTag", "imgStyleDefault", "", "imgStyleFull", "imgStyleText", "initLocalBook", "Lbook/model/Book;", "bookUrl", "localPath", "rootDir", "book"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Book initLocalBook(@NotNull String bookUrl, @NotNull String localPath, @NotNull String rootDir) {
            Book book;
            Intrinsics.checkNotNullParameter((Object)bookUrl, (String)"bookUrl");
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
            String fileName = new File(localPath).getName();
            Intrinsics.checkNotNull((Object)fileName);
            Pair<String, String> nameAuthor = LocalBook.INSTANCE.analyzeNameAuthor(fileName);
            Book it = book = new Book(bookUrl, "", "loc_book", localPath, (String)nameAuthor.getFirst(), (String)nameAuthor.getSecond(), null, null, null, null, null, null, null, 0, 0, null, 0L, 0L, 0, 0, null, 0, 0.0, 0L, null, false, 0, 0, false, null, null, null, -64, null);
            boolean bl = false;
            it.setCanUpdate(false);
            Book book2 = book;
            book2.setRootDir(rootDir);
            Book.updateFromLocal$default(book2, false, 1, null);
            return book2;
        }

        public static /* synthetic */ Book initLocalBook$default(Companion companion, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string3 = "";
            }
            return companion.initLocalBook(string, string2, string3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001f\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lbook/model/Book$Converters;", "", "<init>", "()V", "readConfigToString", "", "config", "Lbook/model/Book$ReadConfig;", "stringToReadConfig", "Lkotlin/Result;", "json", "stringToReadConfig-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "book"})
    @SourceDebugExtension(value={"SMAP\nBook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Book.kt\nbook/model/Book$Converters\n+ 2 GSON.kt\nbook/util/GSONKt\n*L\n1#1,302:1\n33#2,2:303\n30#2:305\n*S KotlinDebug\n*F\n+ 1 Book.kt\nbook/model/Book$Converters\n*L\n299#1:303,2\n299#1:305\n*E\n"})
    public static final class Converters {
        @NotNull
        public final String readConfigToString(@Nullable ReadConfig config) {
            String string = GSONKt.getGSON().toJson((Object)config);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }

        @NotNull
        public final Object stringToReadConfig-IoAF18A(@Nullable String json) {
            Object object;
            Gson $this$fromJsonObject$iv = GSONKt.getGSON();
            boolean $i$f$fromJsonObject = false;
            try {
                boolean bl = false;
                boolean $i$f$genericType = false;
                Type type = new TypeToken<ReadConfig>(){}.getType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
                Object object2 = $this$fromJsonObject$iv.fromJson(json, type);
                if (!(object2 instanceof ReadConfig)) {
                    object2 = null;
                }
                object = Result.constructor-impl((Object)((ReadConfig)object2));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            return object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\"\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u000bH\u00c6\u0003JG\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\t\u0010,\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lbook/model/Book$ReadConfig;", "", "reverseToc", "", "pageAnim", "", "reSegment", "imageStyle", "", "useReplaceRule", "delTag", "", "<init>", "(ZIZLjava/lang/String;ZJ)V", "getReverseToc", "()Z", "setReverseToc", "(Z)V", "getPageAnim", "()I", "setPageAnim", "(I)V", "getReSegment", "setReSegment", "getImageStyle", "()Ljava/lang/String;", "setImageStyle", "(Ljava/lang/String;)V", "getUseReplaceRule", "setUseReplaceRule", "getDelTag", "()J", "setDelTag", "(J)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "book"})
    public static final class ReadConfig {
        private boolean reverseToc;
        private int pageAnim;
        private boolean reSegment;
        @Nullable
        private String imageStyle;
        private boolean useReplaceRule;
        private long delTag;

        public ReadConfig(boolean reverseToc, int pageAnim, boolean reSegment, @Nullable String imageStyle, boolean useReplaceRule, long delTag) {
            this.reverseToc = reverseToc;
            this.pageAnim = pageAnim;
            this.reSegment = reSegment;
            this.imageStyle = imageStyle;
            this.useReplaceRule = useReplaceRule;
            this.delTag = delTag;
        }

        public /* synthetic */ ReadConfig(boolean bl, int n, boolean bl2, String string, boolean bl3, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                n = -1;
            }
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            if ((n2 & 8) != 0) {
                string = null;
            }
            if ((n2 & 0x10) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x20) != 0) {
                l = 0L;
            }
            this(bl, n, bl2, string, bl3, l);
        }

        public final boolean getReverseToc() {
            return this.reverseToc;
        }

        public final void setReverseToc(boolean bl) {
            this.reverseToc = bl;
        }

        public final int getPageAnim() {
            return this.pageAnim;
        }

        public final void setPageAnim(int n) {
            this.pageAnim = n;
        }

        public final boolean getReSegment() {
            return this.reSegment;
        }

        public final void setReSegment(boolean bl) {
            this.reSegment = bl;
        }

        @Nullable
        public final String getImageStyle() {
            return this.imageStyle;
        }

        public final void setImageStyle(@Nullable String string) {
            this.imageStyle = string;
        }

        public final boolean getUseReplaceRule() {
            return this.useReplaceRule;
        }

        public final void setUseReplaceRule(boolean bl) {
            this.useReplaceRule = bl;
        }

        public final long getDelTag() {
            return this.delTag;
        }

        public final void setDelTag(long l) {
            this.delTag = l;
        }

        public final boolean component1() {
            return this.reverseToc;
        }

        public final int component2() {
            return this.pageAnim;
        }

        public final boolean component3() {
            return this.reSegment;
        }

        @Nullable
        public final String component4() {
            return this.imageStyle;
        }

        public final boolean component5() {
            return this.useReplaceRule;
        }

        public final long component6() {
            return this.delTag;
        }

        @NotNull
        public final ReadConfig copy(boolean reverseToc, int pageAnim, boolean reSegment, @Nullable String imageStyle, boolean useReplaceRule, long delTag) {
            return new ReadConfig(reverseToc, pageAnim, reSegment, imageStyle, useReplaceRule, delTag);
        }

        public static /* synthetic */ ReadConfig copy$default(ReadConfig readConfig, boolean bl, int n, boolean bl2, String string, boolean bl3, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = readConfig.reverseToc;
            }
            if ((n2 & 2) != 0) {
                n = readConfig.pageAnim;
            }
            if ((n2 & 4) != 0) {
                bl2 = readConfig.reSegment;
            }
            if ((n2 & 8) != 0) {
                string = readConfig.imageStyle;
            }
            if ((n2 & 0x10) != 0) {
                bl3 = readConfig.useReplaceRule;
            }
            if ((n2 & 0x20) != 0) {
                l = readConfig.delTag;
            }
            return readConfig.copy(bl, n, bl2, string, bl3, l);
        }

        @NotNull
        public String toString() {
            return "ReadConfig(reverseToc=" + this.reverseToc + ", pageAnim=" + this.pageAnim + ", reSegment=" + this.reSegment + ", imageStyle=" + this.imageStyle + ", useReplaceRule=" + this.useReplaceRule + ", delTag=" + this.delTag + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.reverseToc);
            result = result * 31 + Integer.hashCode(this.pageAnim);
            result = result * 31 + Boolean.hashCode(this.reSegment);
            result = result * 31 + (this.imageStyle == null ? 0 : this.imageStyle.hashCode());
            result = result * 31 + Boolean.hashCode(this.useReplaceRule);
            result = result * 31 + Long.hashCode(this.delTag);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReadConfig)) {
                return false;
            }
            ReadConfig readConfig = (ReadConfig)other;
            if (this.reverseToc != readConfig.reverseToc) {
                return false;
            }
            if (this.pageAnim != readConfig.pageAnim) {
                return false;
            }
            if (this.reSegment != readConfig.reSegment) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.imageStyle, (Object)readConfig.imageStyle)) {
                return false;
            }
            if (this.useReplaceRule != readConfig.useReplaceRule) {
                return false;
            }
            return this.delTag == readConfig.delTag;
        }

        public ReadConfig() {
            this(false, 0, false, null, false, 0L, 63, null);
        }
    }
}

