/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u001c\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0007J-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0013\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010H\u0007\u00a8\u0006\u001a"}, d2={"Landroid/text/TextUtils;", "", "<init>", "()V", "isEmpty", "", "str", "", "isDigitsOnly", "equals", "a", "b", "getTrimmedLength", "", "s", "join", "", "delimiter", "tokens", "", "(Ljava/lang/CharSequence;[Ljava/lang/Object;)Ljava/lang/String;", "split", "text", "expression", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "htmlEncode", "book"})
@SourceDebugExtension(value={"SMAP\nTextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextUtils.kt\nandroid/text/TextUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n1179#2,2:75\n1179#2,2:90\n739#3,9:77\n37#4:86\n36#4,3:87\n*S KotlinDebug\n*F\n+ 1 TextUtils.kt\nandroid/text/TextUtils\n*L\n14#1:75,2\n61#1:90,2\n55#1:77,9\n55#1:86\n55#1:87,3\n*E\n"})
public final class TextUtils {
    @NotNull
    public static final TextUtils INSTANCE = new TextUtils();

    private TextUtils() {
    }

    @JvmStatic
    public static final boolean isEmpty(@Nullable CharSequence str) {
        return str == null || str.length() == 0;
    }

    @JvmStatic
    public static final boolean isDigitsOnly(@Nullable CharSequence str) {
        if (TextUtils.isEmpty(str)) {
            return false;
        }
        CharSequence charSequence = str;
        Intrinsics.checkNotNull((Object)charSequence);
        CharSequence $this$forEach$iv = charSequence;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (Character.isDigit(it)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final boolean equals(@Nullable CharSequence a, @Nullable CharSequence b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Object)a).toString(), (Object)((Object)b).toString());
    }

    @JvmStatic
    public static final int getTrimmedLength(@Nullable CharSequence s) {
        int i;
        if (s == null) {
            return 0;
        }
        int len = s.length();
        for (i = 0; i < len && Intrinsics.compare((int)s.charAt(i), (int)32) <= 0; ++i) {
        }
        while (i < len && Intrinsics.compare((int)s.charAt(len - 1), (int)32) <= 0) {
            --len;
        }
        return len - i;
    }

    @JvmStatic
    @NotNull
    public static final String join(@NotNull CharSequence delimiter, Object ... tokens) {
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        if (tokens.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String[] split(@NotNull String text, @NotNull String expression) {
        List list;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        CharSequence charSequence = text;
        Regex regex = new Regex(expression);
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @JvmStatic
    @NotNull
    public static final String htmlEncode(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        StringBuilder sb = new StringBuilder();
        CharSequence $this$forEach$iv = s;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            switch (it) {
                case '\"': {
                    StringBuilder stringBuilder = sb.append("&quot;");
                    break;
                }
                case '\'': {
                    StringBuilder stringBuilder = sb.append("&apos;");
                    break;
                }
                case '&': {
                    StringBuilder stringBuilder = sb.append("&amp;");
                    break;
                }
                case '<': {
                    StringBuilder stringBuilder = sb.append("&lt;");
                    break;
                }
                case '>': {
                    StringBuilder stringBuilder = sb.append("&gt;");
                    break;
                }
                default: {
                    StringBuilder stringBuilder = sb.append(it);
                }
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

