/*
 * Decompiled with CFR 0.152.
 */
package web.util.hash;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0016\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"hash", "", "algorithm", "srcStr", "", "bytes", "solon-read"})
public final class HashKt {
    @NotNull
    public static final String hash(@NotNull String algorithm, @NotNull String srcStr) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)srcStr, (String)"srcStr");
        try {
            StringBuilder result = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            Charset charset = Charset.forName("utf-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = srcStr.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            for (byte b : md.digest(byArray)) {
                String hex = Integer.toHexString(b & 0xFF);
                if (hex.length() == 1) {
                    result.append("0");
                }
                result.append(hex);
            }
            String string = result.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static final byte[] hash(@NotNull String algorithm, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(bytes);
            byte[] byArray = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

