/*
 * Decompiled with CFR 0.152.
 */
package web.controller.api;

import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.web.cors.annotation.CrossOrigin;
import web.controller.api.BaseController;
import web.mapper.BooklistMapper;
import web.mapper.BookmarkMapper;
import web.model.Booklist;
import web.model.Bookmark;
import web.model.Users;
import web.response.JsonResponse;
import web.response.StaticKt;

@Controller
@Mapping(value="/api/{v}")
@CrossOrigin(origins="*")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u001a\u0010\u001a\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u001a\u0010\u001b\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0007R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lweb/controller/api/BookMarkController;", "Lweb/controller/api/BaseController;", "<init>", "()V", "bookmarkMapper", "Lweb/mapper/BookmarkMapper;", "getBookmarkMapper", "()Lweb/mapper/BookmarkMapper;", "setBookmarkMapper", "(Lweb/mapper/BookmarkMapper;)V", "booklistMapper", "Lweb/mapper/BooklistMapper;", "getBooklistMapper", "()Lweb/mapper/BooklistMapper;", "setBooklistMapper", "(Lweb/mapper/BooklistMapper;)V", "addbookmark", "Lweb/response/JsonResponse;", "accessToken", "", "url", "name", "index", "", "pos", "", "getbookmark", "delbookmark", "id", "solon-read"})
public class BookMarkController
extends BaseController {
    @Inject
    public BookmarkMapper bookmarkMapper;
    @Inject
    public BooklistMapper booklistMapper;

    @NotNull
    public final BookmarkMapper getBookmarkMapper() {
        BookmarkMapper bookmarkMapper = this.bookmarkMapper;
        if (bookmarkMapper != null) {
            return bookmarkMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bookmarkMapper");
        return null;
    }

    public final void setBookmarkMapper(@NotNull BookmarkMapper bookmarkMapper) {
        Intrinsics.checkNotNullParameter((Object)bookmarkMapper, (String)"<set-?>");
        this.bookmarkMapper = bookmarkMapper;
    }

    @NotNull
    public final BooklistMapper getBooklistMapper() {
        BooklistMapper booklistMapper = this.booklistMapper;
        if (booklistMapper != null) {
            return booklistMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"booklistMapper");
        return null;
    }

    public final void setBooklistMapper(@NotNull BooklistMapper booklistMapper) {
        Intrinsics.checkNotNullParameter((Object)booklistMapper, (String)"<set-?>");
        this.booklistMapper = booklistMapper;
    }

    @Mapping(value="/addbookmark")
    @NotNull
    public final JsonResponse addbookmark(@Nullable String accessToken, @NotNull String url, @NotNull String name, int index, double pos) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BookMarkController $this$addbookmark_u24lambda_u241 = this;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)url)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        Users user = $this$addbookmark_u24lambda_u241.getuserbytocken(accessToken);
        BooklistMapper booklistMapper = $this$addbookmark_u24lambda_u241.getBooklistMapper();
        String string = user.getId();
        Intrinsics.checkNotNull((Object)string);
        Booklist booklist = booklistMapper.getbook(string, url);
        if (booklist == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNO_BOOK()));
        }
        Booklist book = booklist;
        BookmarkMapper bookmarkMapper = $this$addbookmark_u24lambda_u241.getBookmarkMapper();
        String string2 = user.getId();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = book.getBookUrl();
        Intrinsics.checkNotNull((Object)string3);
        List<Bookmark> marks = bookmarkMapper.getbybook(string2, string3);
        for (Bookmark mark : marks) {
            Integer n = mark.getCindex();
            int n2 = index;
            if (n == null || n != n2 || !Intrinsics.areEqual((Double)mark.getCpos(), (double)pos)) continue;
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getMARK_IS()));
        }
        Bookmark bookmark2 = new Bookmark();
        String string4 = user.getId();
        Intrinsics.checkNotNull((Object)string4);
        Bookmark $this$addbookmark_u24lambda_u241_u24lambda_u240 = bookmark = bookmark2.create(string4, book);
        boolean bl2 = false;
        $this$addbookmark_u24lambda_u241_u24lambda_u240.setCindex(index);
        $this$addbookmark_u24lambda_u241_u24lambda_u240.setCpos(pos);
        $this$addbookmark_u24lambda_u241_u24lambda_u240.setCname(name);
        Bookmark bookmark3 = bookmark;
        $this$addbookmark_u24lambda_u241.getBookmarkMapper().insert(bookmark3);
        return new JsonResponse(true);
    }

    @Mapping(value="/getbookmark")
    @NotNull
    public final JsonResponse getbookmark(@Nullable String accessToken, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        BookMarkController $this$getbookmark_u24lambda_u242 = this;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)url)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        Users user = $this$getbookmark_u24lambda_u242.getuserbytocken(accessToken);
        BooklistMapper booklistMapper = $this$getbookmark_u24lambda_u242.getBooklistMapper();
        String string = user.getId();
        Intrinsics.checkNotNull((Object)string);
        Booklist booklist = booklistMapper.getbook(string, url);
        if (booklist == null) {
            throw new DataThrowable().data((Object)new JsonResponse(true).Data(CollectionsKt.emptyList()));
        }
        Booklist book = booklist;
        BookmarkMapper bookmarkMapper = $this$getbookmark_u24lambda_u242.getBookmarkMapper();
        String string2 = user.getId();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = book.getBookUrl();
        Intrinsics.checkNotNull((Object)string3);
        List<Bookmark> marks = bookmarkMapper.getbybook(string2, string3);
        return new JsonResponse(true).Data(marks);
    }

    @Mapping(value="/delbookmark")
    @NotNull
    public final JsonResponse delbookmark(@Nullable String accessToken, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        BookMarkController $this$delbookmark_u24lambda_u243 = this;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)id)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        Users user = $this$delbookmark_u24lambda_u243.getuserbytocken(accessToken);
        Bookmark mark = (Bookmark)$this$delbookmark_u24lambda_u243.getBookmarkMapper().selectById((Serializable)((Object)id));
        if (mark == null || !Intrinsics.areEqual((Object)mark.getUserid(), (Object)user.getId())) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_IS()));
        }
        $this$delbookmark_u24lambda_u243.getBookmarkMapper().deleteById((Serializable)((Object)id));
        return new JsonResponse(true);
    }
}

