/*
 * Decompiled with CFR 0.152.
 */
package web.controller.api;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.util.DataThrowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import web.mapper.BookSourceMapper;
import web.mapper.UserBookSourceMapper;
import web.mapper.UsersMapper;
import web.mapper.UsertockenMapper;
import web.model.BaseSource;
import web.model.BookSource;
import web.model.UserBookSource;
import web.model.Users;
import web.model.Usertocken;
import web.response.JsonResponse;
import web.response.StaticKt;

@Controller
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010%J&\u0010-\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020/0.2\b\u0010,\u001a\u0004\u0018\u00010%2\b\u00100\u001a\u0004\u0018\u00010%J\u001a\u00101\u001a\u00020/2\b\u0010,\u001a\u0004\u0018\u00010%2\b\u00100\u001a\u0004\u0018\u00010%J\u0018\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020+2\b\u00100\u001a\u0004\u0018\u00010%J\u0018\u00101\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020%2\u0006\u00102\u001a\u00020+J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020/042\u0006\u00102\u001a\u00020+J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020/042\u0006\u00106\u001a\u0002072\u0006\u00102\u001a\u00020+J\u0010\u0010-\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u001b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020!X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010#\u00a8\u00068"}, d2={"Lweb/controller/api/BaseController;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "usersMapper", "Lweb/mapper/UsersMapper;", "getUsersMapper", "()Lweb/mapper/UsersMapper;", "setUsersMapper", "(Lweb/mapper/UsersMapper;)V", "usertockenMapper", "Lweb/mapper/UsertockenMapper;", "getUsertockenMapper", "()Lweb/mapper/UsertockenMapper;", "setUsertockenMapper", "(Lweb/mapper/UsertockenMapper;)V", "bookSourceMapper", "Lweb/mapper/BookSourceMapper;", "getBookSourceMapper", "()Lweb/mapper/BookSourceMapper;", "setBookSourceMapper", "(Lweb/mapper/BookSourceMapper;)V", "userBookSourceMapper", "Lweb/mapper/UserBookSourceMapper;", "getUserBookSourceMapper", "()Lweb/mapper/UserBookSourceMapper;", "setUserBookSourceMapper", "(Lweb/mapper/UserBookSourceMapper;)V", "apiversion", "", "getApiversion", "()I", "appversion", "", "getAppversion", "()Ljava/lang/String;", "cachetime", "getCachetime", "getuserbytocken", "Lweb/model/Users;", "accessToken", "getsourceuser", "Lkotlin/Pair;", "Lweb/model/BaseSource;", "bookSourceUrl", "getsource", "user", "getallBookSourcelist", "", "getBookSourcelist", "enabled", "", "solon-read"})
@SourceDebugExtension(value={"SMAP\nBaseController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseController.kt\nweb/controller/api/BaseController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1#2:131\n1863#3,2:132\n1863#3,2:134\n1863#3,2:136\n1863#3,2:138\n*S KotlinDebug\n*F\n+ 1 BaseController.kt\nweb/controller/api/BaseController\n*L\n94#1:132,2\n98#1:134,2\n109#1:136,2\n113#1:138,2\n*E\n"})
public class BaseController {
    @NotNull
    private final Logger logger;
    @Inject
    public UsersMapper usersMapper;
    @Inject
    public UsertockenMapper usertockenMapper;
    @Inject
    public BookSourceMapper bookSourceMapper;
    @Inject
    public UserBookSourceMapper userBookSourceMapper;
    private final int apiversion;
    @NotNull
    private final String appversion;
    private final int cachetime;

    public BaseController() {
        Logger logger = LoggerFactory.getLogger(BaseController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.apiversion = 5;
        this.appversion = "3.1.0";
        this.cachetime = 60;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final UsersMapper getUsersMapper() {
        UsersMapper usersMapper = this.usersMapper;
        if (usersMapper != null) {
            return usersMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"usersMapper");
        return null;
    }

    public final void setUsersMapper(@NotNull UsersMapper usersMapper) {
        Intrinsics.checkNotNullParameter((Object)usersMapper, (String)"<set-?>");
        this.usersMapper = usersMapper;
    }

    @NotNull
    public final UsertockenMapper getUsertockenMapper() {
        UsertockenMapper usertockenMapper = this.usertockenMapper;
        if (usertockenMapper != null) {
            return usertockenMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"usertockenMapper");
        return null;
    }

    public final void setUsertockenMapper(@NotNull UsertockenMapper usertockenMapper) {
        Intrinsics.checkNotNullParameter((Object)usertockenMapper, (String)"<set-?>");
        this.usertockenMapper = usertockenMapper;
    }

    @NotNull
    public final BookSourceMapper getBookSourceMapper() {
        BookSourceMapper bookSourceMapper = this.bookSourceMapper;
        if (bookSourceMapper != null) {
            return bookSourceMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bookSourceMapper");
        return null;
    }

    public final void setBookSourceMapper(@NotNull BookSourceMapper bookSourceMapper) {
        Intrinsics.checkNotNullParameter((Object)bookSourceMapper, (String)"<set-?>");
        this.bookSourceMapper = bookSourceMapper;
    }

    @NotNull
    public final UserBookSourceMapper getUserBookSourceMapper() {
        UserBookSourceMapper userBookSourceMapper = this.userBookSourceMapper;
        if (userBookSourceMapper != null) {
            return userBookSourceMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"userBookSourceMapper");
        return null;
    }

    public final void setUserBookSourceMapper(@NotNull UserBookSourceMapper userBookSourceMapper) {
        Intrinsics.checkNotNullParameter((Object)userBookSourceMapper, (String)"<set-?>");
        this.userBookSourceMapper = userBookSourceMapper;
    }

    public final int getApiversion() {
        return this.apiversion;
    }

    @NotNull
    public final String getAppversion() {
        return this.appversion;
    }

    public final int getCachetime() {
        return this.cachetime;
    }

    @NotNull
    public final Users getuserbytocken(@Nullable String accessToken) {
        Object object;
        block6: {
            block5: {
                CharSequence charSequence = accessToken;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNEED_LOGIN()));
                }
                Usertocken usertocken = this.getUsertockenMapper().getUsertocken(accessToken);
                if (usertocken == null) {
                    throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNEED_LOGIN()));
                }
                Usertocken tocken = usertocken;
                object = tocken.getUserid();
                if (object == null) break block5;
                String it = object;
                boolean bl = false;
                Users users = this.getUsersMapper().getUser(it);
                object = users;
                if (users != null) break block6;
            }
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNEED_LOGIN()));
        }
        Object user = object;
        return user;
    }

    @NotNull
    public final Pair<Users, BaseSource> getsourceuser(@Nullable String accessToken, @Nullable String bookSourceUrl) {
        BaseSource baseSource;
        Users user = this.getuserbytocken(accessToken);
        if (bookSourceUrl == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        if (user.getSource() == 2) {
            UserBookSourceMapper userBookSourceMapper = this.getUserBookSourceMapper();
            String string = user.getId();
            Intrinsics.checkNotNull((Object)string);
            UserBookSource userBookSource = userBookSourceMapper.getBookSource(bookSourceUrl, string);
            baseSource = userBookSource != null ? userBookSource.toBaseSource() : null;
        } else {
            BookSource bookSource = this.getBookSourceMapper().getBookSource(bookSourceUrl);
            baseSource = bookSource != null ? bookSource.toBaseSource() : null;
        }
        if (baseSource == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_SOURCE()));
        }
        BaseSource source = baseSource;
        return new Pair((Object)user, (Object)source);
    }

    @NotNull
    public final BaseSource getsource(@Nullable String accessToken, @Nullable String bookSourceUrl) {
        return (BaseSource)this.getsourceuser(accessToken, bookSourceUrl).getSecond();
    }

    @NotNull
    public final BaseSource getsource(@NotNull Users user, @Nullable String bookSourceUrl) {
        BaseSource baseSource;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (bookSourceUrl == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_BANK()));
        }
        if (user.getSource() == 2) {
            UserBookSourceMapper userBookSourceMapper = this.getUserBookSourceMapper();
            String string = user.getId();
            Intrinsics.checkNotNull((Object)string);
            UserBookSource userBookSource = userBookSourceMapper.getBookSource(bookSourceUrl, string);
            baseSource = userBookSource != null ? userBookSource.toBaseSource() : null;
        } else {
            BookSource bookSource = this.getBookSourceMapper().getBookSource(bookSourceUrl);
            baseSource = bookSource != null ? bookSource.toBaseSource() : null;
        }
        if (baseSource == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getNOT_SOURCE()));
        }
        BaseSource source = baseSource;
        return source;
    }

    @Nullable
    public final BaseSource getsource(@NotNull String bookSourceUrl, @NotNull Users user) {
        BaseSource baseSource;
        Intrinsics.checkNotNullParameter((Object)bookSourceUrl, (String)"bookSourceUrl");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (user.getSource() == 2) {
            UserBookSourceMapper userBookSourceMapper = this.getUserBookSourceMapper();
            String string = user.getId();
            Intrinsics.checkNotNull((Object)string);
            UserBookSource userBookSource = userBookSourceMapper.getBookSource(bookSourceUrl, string);
            baseSource = userBookSource != null ? userBookSource.toBaseSource() : null;
        } else {
            BookSource bookSource = this.getBookSourceMapper().getBookSource(bookSourceUrl);
            baseSource = bookSource != null ? bookSource.toBaseSource() : null;
        }
        BaseSource source = baseSource;
        return source;
    }

    @NotNull
    public final List<BaseSource> getallBookSourcelist(@NotNull Users user) {
        List list;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                list = new ArrayList();
                if (user.getSource() != 2) break block3;
                UserBookSourceMapper userBookSourceMapper = this.getUserBookSourceMapper();
                String string = user.getId();
                Intrinsics.checkNotNull((Object)string);
                List<UserBookSource> list2 = userBookSourceMapper.getallBookSourcelist(string);
                if (list2 == null) break block4;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UserBookSource it = (UserBookSource)element$iv;
                    boolean bl = false;
                    list.add(it.toBaseSource());
                }
                break block4;
            }
            List<BookSource> list3 = this.getBookSourceMapper().getallBookSourcelist();
            if (list3 != null) {
                Iterable $this$forEach$iv = list3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BookSource it = (BookSource)element$iv;
                    boolean bl = false;
                    list.add(it.toBaseSource());
                }
            }
        }
        return list;
    }

    @NotNull
    public final List<BaseSource> getBookSourcelist(boolean enabled, @NotNull Users user) {
        List list;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                list = new ArrayList();
                if (user.getSource() != 2) break block3;
                UserBookSourceMapper userBookSourceMapper = this.getUserBookSourceMapper();
                String string = user.getId();
                Intrinsics.checkNotNull((Object)string);
                List<UserBookSource> list2 = userBookSourceMapper.getBookSourcelist(enabled, string);
                if (list2 == null) break block4;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UserBookSource it = (UserBookSource)element$iv;
                    boolean bl = false;
                    list.add(it.toBaseSource());
                }
                break block4;
            }
            List<BookSource> list3 = this.getBookSourceMapper().getBookSourcelist(enabled);
            if (list3 != null) {
                Iterable $this$forEach$iv = list3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BookSource it = (BookSource)element$iv;
                    boolean bl = false;
                    list.add(it.toBaseSource());
                }
            }
        }
        return list;
    }

    @NotNull
    public final Users getsourceuser(@Nullable String accessToken) {
        Users user = this.getuserbytocken(accessToken);
        if (user.getSource() == 0) {
            throw new DataThrowable().data((Object)new JsonResponse(false, StaticKt.getCAN_NOT()));
        }
        return user;
    }
}

