/*
 * Decompiled with CFR 0.152.
 */
package web.controller;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Get;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Post;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.web.cors.annotation.CrossOrigin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import web.mapper.CodeMapper;
import web.mapper.UsersMapper;
import web.model.Code;
import web.model.Users;
import web.response.JsonResponse;
import web.util.admin.StaticKt;
import web.util.mail.Mail;

@CrossOrigin(origins="*")
@Controller
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 E2\u00020\u0001:\u0001EB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u00103\u001a\u00020\tH\u0007J\b\u00104\u001a\u00020\tH\u0007J\b\u00105\u001a\u00020\tH\u0007J:\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u0001092\b\u0010:\u001a\u0004\u0018\u0001092\b\u0010;\u001a\u0004\u0018\u0001092\b\u0010<\u001a\u0004\u0018\u0001092\b\u0010=\u001a\u0004\u0018\u000109H\u0007J\b\u0010>\u001a\u000207H\u0007J\u0012\u0010?\u001a\u0002072\b\u0010<\u001a\u0004\u0018\u000109H\u0007J&\u0010@\u001a\u0002072\b\u0010:\u001a\u0004\u0018\u0001092\b\u0010=\u001a\u0004\u0018\u0001092\b\u0010<\u001a\u0004\u0018\u000109H\u0007J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00198\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u001e\u0010'\u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010!\"\u0004\b)\u0010#R\u001e\u0010*\u001a\u00020+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001e\u00100\u001a\u00020+8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/\u00a8\u0006F"}, d2={"Lweb/controller/HomeController;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "reghtml", "Lorg/noear/solon/core/handle/ModelAndView;", "getReghtml", "()Lorg/noear/solon/core/handle/ModelAndView;", "usersMapper", "Lweb/mapper/UsersMapper;", "getUsersMapper", "()Lweb/mapper/UsersMapper;", "setUsersMapper", "(Lweb/mapper/UsersMapper;)V", "codeMapper", "Lweb/mapper/CodeMapper;", "getCodeMapper", "()Lweb/mapper/CodeMapper;", "setCodeMapper", "(Lweb/mapper/CodeMapper;)V", "cacheService", "Lorg/noear/solon/data/cache/CacheService;", "getCacheService", "()Lorg/noear/solon/data/cache/CacheService;", "setCacheService", "(Lorg/noear/solon/data/cache/CacheService;)V", "allowuptxt", "", "getAllowuptxt", "()Z", "setAllowuptxt", "(Z)V", "allowcache", "getAllowcache", "setAllowcache", "allowimg", "getAllowimg", "setAllowimg", "source", "", "getSource", "()I", "setSource", "(I)V", "index", "getIndex", "setIndex", "home", "forget", "reg", "regester", "Lweb/response/JsonResponse;", "username", "", "password", "phone", "email", "code", "needcode", "sendResetCode", "resetPassword", "ua", "", "ctx", "Lorg/noear/solon/core/handle/Context;", "Companion", "solon-read"})
public class HomeController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LoggerFactory.getLogger(HomeController.class);
    @NotNull
    private final ModelAndView reghtml = new ModelAndView("regester.html");
    @Inject
    public UsersMapper usersMapper;
    @Inject
    public CodeMapper codeMapper;
    @Inject
    public CacheService cacheService;
    @Inject(value="${user.allowuptxt:false}", autoRefreshed=true)
    private boolean allowuptxt;
    @Inject(value="${user.allowcache:false}", autoRefreshed=true)
    private boolean allowcache;
    @Inject(value="${user.allowimg:false}", autoRefreshed=true)
    private boolean allowimg;
    @Inject(value="${user.source:0}", autoRefreshed=true)
    private int source;
    @Inject(value="${user.index:0}", autoRefreshed=true)
    private int index;
    private static boolean needcode = true;

    @Get
    @Mapping(value="/regester")
    @NotNull
    public final ModelAndView getReghtml() {
        return this.reghtml;
    }

    @NotNull
    public final UsersMapper getUsersMapper() {
        UsersMapper usersMapper = this.usersMapper;
        if (usersMapper != null) {
            return usersMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"usersMapper");
        return null;
    }

    public final void setUsersMapper(@NotNull UsersMapper usersMapper) {
        Intrinsics.checkNotNullParameter((Object)usersMapper, (String)"<set-?>");
        this.usersMapper = usersMapper;
    }

    @NotNull
    public final CodeMapper getCodeMapper() {
        CodeMapper codeMapper = this.codeMapper;
        if (codeMapper != null) {
            return codeMapper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"codeMapper");
        return null;
    }

    public final void setCodeMapper(@NotNull CodeMapper codeMapper) {
        Intrinsics.checkNotNullParameter((Object)codeMapper, (String)"<set-?>");
        this.codeMapper = codeMapper;
    }

    @NotNull
    public final CacheService getCacheService() {
        CacheService cacheService = this.cacheService;
        if (cacheService != null) {
            return cacheService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cacheService");
        return null;
    }

    public final void setCacheService(@NotNull CacheService cacheService) {
        Intrinsics.checkNotNullParameter((Object)cacheService, (String)"<set-?>");
        this.cacheService = cacheService;
    }

    public final boolean getAllowuptxt() {
        return this.allowuptxt;
    }

    public final void setAllowuptxt(boolean bl) {
        this.allowuptxt = bl;
    }

    public final boolean getAllowcache() {
        return this.allowcache;
    }

    public final void setAllowcache(boolean bl) {
        this.allowcache = bl;
    }

    public final boolean getAllowimg() {
        return this.allowimg;
    }

    public final void setAllowimg(boolean bl) {
        this.allowimg = bl;
    }

    public final int getSource() {
        return this.source;
    }

    public final void setSource(int n) {
        this.source = n;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Mapping(value="/")
    @NotNull
    public final ModelAndView home() {
        HomeController $this$home_u24lambda_u240 = this;
        boolean bl = false;
        return $this$home_u24lambda_u240.index == 0 ? new ModelAndView("qread/index.html") : ($this$home_u24lambda_u240.index == 1 ? new ModelAndView("qread/index2.html") : new ModelAndView("errors/404.html"));
    }

    @Mapping(value="/forget")
    @NotNull
    public final ModelAndView forget() {
        HomeController $this$forget_u24lambda_u241 = this;
        boolean bl = false;
        return new ModelAndView("qread/forget.html");
    }

    @Mapping(value="/reg")
    @NotNull
    public final ModelAndView reg() {
        HomeController $this$reg_u24lambda_u242 = this;
        boolean bl = false;
        return needcode ? new ModelAndView("qread/reg2.html") : new ModelAndView("qread/reg.html");
    }

    @Tran
    @Post
    @Mapping(value="/regester")
    @NotNull
    public final JsonResponse regester(@Nullable String username, @Nullable String password, @Nullable String phone, @Nullable String email, @Nullable String code) {
        Pair<Boolean, String> pair;
        HomeController $this$regester_u24lambda_u245 = this;
        boolean bl = false;
        CharSequence charSequence = username;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)password) == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)email) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getNOT_BANK()));
        }
        if (needcode && ((charSequence = (CharSequence)code) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getNOT_BANK()));
        }
        Pair<Boolean, String> $this$regester_u24lambda_u245_u24lambda_u243 = pair = new Pair<Boolean, String>();
        boolean bl2 = false;
        $this$regester_u24lambda_u245_u24lambda_u243.setUsername(username);
        $this$regester_u24lambda_u245_u24lambda_u243.setPassword(password);
        $this$regester_u24lambda_u245_u24lambda_u243.setCode(code);
        $this$regester_u24lambda_u245_u24lambda_u243.setPhone(phone);
        $this$regester_u24lambda_u245_u24lambda_u243.setEmail(email);
        Pair<Boolean, String> user = pair;
        pair = user.Check();
        boolean checkok = (Boolean)pair.component1();
        String msg = (String)pair.component2();
        if (!checkok) {
            throw new DataThrowable().data((Object)new JsonResponse(false, msg));
        }
        String c = "";
        if (needcode) {
            c = (String)$this$regester_u24lambda_u245.getCacheService().get(code, String.class);
            if (!Intrinsics.areEqual((Object)c, (Object)code)) {
                Code code2;
                CodeMapper codeMapper = $this$regester_u24lambda_u245.getCodeMapper();
                String string = code;
                Intrinsics.checkNotNull((Object)string);
                Code it = code2 = codeMapper.getCode(string);
                boolean bl3 = false;
                if (it == null) {
                    throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getCODE_ERROR()));
                }
            }
        } else {
            String c2 = (String)$this$regester_u24lambda_u245.getCacheService().get("code_" + email, String.class);
            if (!Intrinsics.areEqual((Object)c2, (Object)code)) {
                throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getCODE_CHECK_ERROR()));
            }
        }
        UsersMapper usersMapper = $this$regester_u24lambda_u245.getUsersMapper();
        String string = user.getUsername();
        if (string == null) {
            string = "";
        }
        if (usersMapper.getUserByusername(string) != null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getUSER_IS()));
        }
        if (!((Collection)$this$regester_u24lambda_u245.getUsersMapper().getUserByemail(email)).isEmpty()) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getEMAIL_IS()));
        }
        if (needcode && Intrinsics.areEqual((Object)c, (Object)code)) {
            user.setCode("\u5f00\u653e\u6ce8\u518c");
        }
        user.setSource($this$regester_u24lambda_u245.source);
        user.setAllowCache(Boolean.valueOf($this$regester_u24lambda_u245.allowcache));
        user.setAllowUpTxt(Boolean.valueOf($this$regester_u24lambda_u245.allowuptxt));
        user.setAllowImg(Boolean.valueOf($this$regester_u24lambda_u245.allowimg));
        if (user.getSource() != 0 && user.getSource() != 1 && user.getSource() != 2) {
            user.setSource(0);
        }
        if ($this$regester_u24lambda_u245.getUsersMapper().insert(user.create()) == 0) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getADD_ERROR()));
        }
        if (needcode && !Intrinsics.areEqual((Object)c, (Object)code) && $this$regester_u24lambda_u245.getCodeMapper().deleteById((Serializable)((Object)code)) == 0) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getADD_ERROR()));
        }
        return new JsonResponse(true);
    }

    @Mapping(value="/needcode")
    @NotNull
    public final JsonResponse needcode() {
        HomeController $this$needcode_u24lambda_u246 = this;
        boolean bl = false;
        return new JsonResponse(needcode);
    }

    @Mapping(value="/sendResetCode")
    @NotNull
    public final JsonResponse sendResetCode(@Nullable String email) {
        Object object;
        Object object2;
        HomeController $this$sendResetCode_u24lambda_u2410 = this;
        boolean bl = false;
        CharSequence charSequence = email;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getEMAIL_ERROR()));
        }
        int ct = 0;
        ct = 1;
        HomeController homeController = $this$sendResetCode_u24lambda_u2410;
        try {
            HomeController $this$sendResetCode_u24lambda_u2410_u24lambda_u247 = homeController;
            boolean bl2 = false;
            ct = ((Number)$this$sendResetCode_u24lambda_u2410_u24lambda_u247.getCacheService().get("codetime_" + email, Integer.TYPE)).intValue();
            object2 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl2) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        if (ct > 3) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getEMAIL_CONT_ERROR()));
        }
        String c = StaticKt.getMailCode();
        $this$sendResetCode_u24lambda_u2410.getCacheService().store("code_" + email, (Object)c, 600);
        $this$sendResetCode_u24lambda_u2410.logger.info(email + " has been sent to " + c);
        object2 = $this$sendResetCode_u24lambda_u2410;
        try {
            Object $this$sendResetCode_u24lambda_u2410_u24lambda_u248 = object2;
            boolean bl3 = false;
            Mail.INSTANCE.sendCode(c, email);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl3) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl4 = false;
            DataThrowable dataThrowable = new DataThrowable();
            String string = ((Throwable)it).getMessage();
            if (string == null) {
                string = "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25";
            }
            throw dataThrowable.data((Object)new JsonResponse(false, string));
        }
        $this$sendResetCode_u24lambda_u2410.getCacheService().store("codetime_" + email, (Object)(ct + 1), 86400);
        return new JsonResponse(true);
    }

    @Mapping(value="/resetPassword")
    @NotNull
    public final JsonResponse resetPassword(@Nullable String password, @Nullable String code, @Nullable String email) {
        HomeController $this$resetPassword_u24lambda_u2411 = this;
        boolean bl = false;
        CharSequence charSequence = password;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)email) == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)code) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getNOT_BANK()));
        }
        if (password.length() < 6 || password.length() > 15) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getPASS_VAIL_ERROR()));
        }
        List<Users> users = $this$resetPassword_u24lambda_u2411.getUsersMapper().getUserByemail(email);
        if (users.size() > 1) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getEMAIL_BIND_MAX()));
        }
        Users users2 = !((Collection)users).isEmpty() ? users.get(0) : null;
        if (users2 == null) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getUSER_NOT()));
        }
        Users user = users2;
        if (!Intrinsics.areEqual((Object)user.getEmail(), (Object)email)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getEMAIL_CHECK_ERROR()));
        }
        String c = (String)$this$resetPassword_u24lambda_u2411.getCacheService().get("code_" + email, String.class);
        if (!Intrinsics.areEqual((Object)c, (Object)code)) {
            throw new DataThrowable().data((Object)new JsonResponse(false, web.response.StaticKt.getCODE_CHECK_ERROR()));
        }
        $this$resetPassword_u24lambda_u2411.getCacheService().remove("code_" + email);
        UsersMapper usersMapper = $this$resetPassword_u24lambda_u2411.getUsersMapper();
        String string = user.getId();
        Intrinsics.checkNotNull((Object)string);
        usersMapper.changepass(string, StaticKt.passsign(password));
        return new JsonResponse(true);
    }

    @Mapping(value="/ua")
    public final void ua(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        HomeController $this$ua_u24lambda_u2412 = this;
        boolean bl = false;
        ctx.outputAsHtml(ctx.userAgent());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lweb/controller/HomeController$Companion;", "", "<init>", "()V", "needcode", "", "getNeedcode", "()Z", "setNeedcode", "(Z)V", "solon-read"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getNeedcode() {
            return needcode;
        }

        public final void setNeedcode(boolean bl) {
            needcode = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

