// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using MQTTnet.Packets;
using MQTTnet.Protocol;

namespace MQTTnet.Formatter;

public static class MqttDisconnectPacketFactory
{
    static readonly MqttDisconnectPacket DefaultNormalDisconnection = new()
    {
        ReasonCode = MqttDisconnectReasonCode.NormalDisconnection,
        UserProperties = null,
        ReasonString = null,
        ServerReference = null,
        SessionExpiryInterval = 0
    };

    public static MqttDisconnectPacket Create(MqttClientDisconnectOptions clientDisconnectOptions)
    {
        if (clientDisconnectOptions == null)
        {
            return DefaultNormalDisconnection;
        }

        return new MqttDisconnectPacket
        {
            ReasonCode = (MqttDisconnectReasonCode)clientDisconnectOptions.Reason,
            UserProperties = clientDisconnectOptions.UserProperties,
            SessionExpiryInterval = clientDisconnectOptions.SessionExpiryInterval
        };
    }
}