/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui.item;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nicelee.bilibili.enums.AudioQualityEnum;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.util.Logger;
import nicelee.bilibili.util.ResourcesUtil;
import nicelee.bilibili.util.custom.System;
import nicelee.ui.Global;
import nicelee.ui.TabVideo;
import nicelee.ui.item.MJButton;
import nicelee.ui.thread.DownloadRunnable;

public class ClipInfoPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = -752743062676819403L;
    String avTitle;
    VideoInfo video;
    ClipInfo clip;
    private JLabel labelTitle;
    private long lastMousePressed;
    Dimension btnSize = new Dimension(100, 26);

    public ClipInfoPanel(VideoInfo videoInfo, ClipInfo clipInfo) {
        this.video = videoInfo;
        this.clip = clipInfo;
        this.avTitle = clipInfo.getAvTitle();
        this.initUI();
    }

    void initUI() {
        Object object;
        this.setBorder(BorderFactory.createLineBorder(Color.red));
        this.setPreferredSize(new Dimension(340, 170));
        boolean bl = ResourcesUtil.isPicture(this.clip);
        this.labelTitle = this.clip.getListName() != null || bl ? new JLabel(this.clip.getRemark() + " - " + this.clip.getAvTitle() + " " + this.clip.getTitle(), 0) : new JLabel(this.clip.getRemark() + " - " + this.clip.getTitle(), 0);
        this.labelTitle.addMouseListener(this);
        this.labelTitle.setToolTipText(this.clip.getAvTitle() + this.clip.getTitle());
        this.labelTitle.setPreferredSize(new Dimension(250, 30));
        this.setOpaque(false);
        this.add(this.labelTitle);
        if (!bl) {
            object = new MJButton("\u5f39\u5e55");
            Dimension dimension = new Dimension(60, 26);
            ((JComponent)object).setPreferredSize(dimension);
            ((AbstractButton)object).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DownloadRunnable downloadRunnable = new DownloadRunnable(ClipInfoPanel.this.video, ClipInfoPanel.this.clip, 801);
                    Global.queryThreadPool.execute(downloadRunnable);
                }
            });
            this.add((Component)object);
        }
        object = this.clip.getLinks().keySet().iterator();
        while (object.hasNext()) {
            int n = (Integer)object.next();
            if (n >= 800) continue;
            String string = VideoQualityEnum.getQualityDescript(n);
            if (string == null) {
                string = AudioQualityEnum.getQualityDescript(n);
            }
            MJButton mJButton = null;
            mJButton = string != null && !bl ? new MJButton(string) : new MJButton("\u6e05\u6670\u5ea6: " + n);
            this.initQnBtn(n, mJButton);
        }
        if (!bl) {
            object = new MJButton("\u5b57\u5e55");
            this.initQnBtn(800, (JButton)object);
        }
    }

    private void initQnBtn(final int n, JButton jButton) {
        jButton.setPreferredSize(this.btnSize);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DownloadRunnable downloadRunnable = new DownloadRunnable(ClipInfoPanel.this.video, ClipInfoPanel.this.clip, n);
                Global.queryThreadPool.execute(downloadRunnable);
            }
        });
        this.add(jButton);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        String string = null;
        if (mouseEvent.getClickCount() != 1) {
            string = this.clip.getAvTitle() + this.clip.getTitle() + " " + this.clip.getAvId();
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, null);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.lastMousePressed = System.currentTimeMillis();
        this.labelTitle.setBorder(BorderFactory.createLineBorder(Color.red));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.labelTitle.setBorder(null);
        long l = System.currentTimeMillis() - this.lastMousePressed;
        Logger.println("\u957f\u6309\u4e86" + l + "ms");
        if (l >= 500L) {
            try {
                TabVideo tabVideo = (TabVideo)this.getParent().getParent().getParent().getParent();
                String string = this.clip.getPicPreview();
                if (string != null && !string.equals(tabVideo.getCurrentDisplayPic())) {
                    URL uRL = new URL(string);
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(700, 460, 4));
                    tabVideo.getLbAvPrivew().setText("");
                    tabVideo.getLbAvPrivew().setIcon(imageIcon);
                    tabVideo.setCurrentDisplayPic(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

