/*
 * Decompiled with CFR 0.152.
 */
package nicelee.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import nicelee.bilibili.annotations.Config;
import nicelee.bilibili.util.ConfigUtil;
import nicelee.ui.Global;
import nicelee.ui.item.JOptionPane;
import nicelee.ui.item.MJButton;

public class TabSettings
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 302743425054589939L;
    final ImageIcon backgroundIcon = Global.backgroundImg;
    static final int LINE_HEIGHT = 32;
    static final int H_GAP = 5;
    static final int V_GAP = 5;
    JPanel jpContent;
    String searchContent = "";
    JTextField searchFiled;
    JButton btnSearch;
    JButton btnClear;

    private TabSettings() {
        this.initUI();
    }

    public static void openSettingTab() {
        JLabel jLabel = new JLabel("\u8bbe\u7f6e\u9875");
        final TabSettings tabSettings = new TabSettings();
        Global.tabs.addTab("\u8bbe\u7f6e\u9875", tabSettings);
        Global.tabs.setTabComponentAt(Global.tabs.indexOfComponent(tabSettings), jLabel);
        Global.tabs.setSelectedComponent(tabSettings);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    Global.tabs.remove(tabSettings);
                } else {
                    Global.tabs.setSelectedComponent(tabSettings);
                }
            }
        });
    }

    private JLabel createTextLabel(String string, int n, int n2) {
        JLabel jLabel = new JLabel();
        if (string != null) {
            string = " " + string;
            jLabel.setBorder(BorderFactory.createLineBorder(Color.RED));
        }
        jLabel.setOpaque(true);
        jLabel.setText(string);
        jLabel.setPreferredSize(new Dimension(n, n2));
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        return jLabel;
    }

    public void initUI() {
        JLabel jLabel = new JLabel("\u8be5\u9762\u677f\u4ec5\u7528\u4e8e\u8f85\u52a9\u751f\u6210\u914d\u7f6e\u6587\u4ef6\uff0c\u914d\u7f6e\u5728\u91cd\u542f\u540e\u65b9\u80fd\u751f\u6548\uff01\uff01");
        jLabel.setFont(this.getFont().deriveFont(30.0f));
        this.setLayout(new FlowLayout(1, 5, 5));
        this.add(jLabel);
        this.add(this.createTextLabel(null, 450, 32));
        this.initSaveButton();
        this.initResetButton();
        this.initCloseButton(this);
        this.add(this.createTextLabel(null, 470, 32));
        this.initSearchItems();
        this.jpContent = new JPanel();
        this.jpContent.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(this.jpContent);
        jScrollPane.setPreferredSize(new Dimension(1150, 540));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add(jScrollPane);
        this.updateSettingsUI();
    }

    private void initSearchItems() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        jPanel.setPreferredSize(new Dimension(1150, 34));
        this.searchFiled = new JTextField();
        this.searchFiled.setPreferredSize(new Dimension(500, 32));
        jPanel.add(this.searchFiled);
        this.searchFiled.addActionListener(this);
        this.btnSearch = new MJButton("\u7b5b\u9009");
        Dimension dimension = new Dimension(60, 32);
        this.btnSearch.setPreferredSize(dimension);
        this.btnSearch.addActionListener(this);
        jPanel.add(this.btnSearch);
        this.btnClear = new MJButton("\u6e05\u7a7a");
        this.btnClear.setPreferredSize(dimension);
        this.btnClear.addActionListener(this);
        jPanel.add(this.btnClear);
        jPanel.add(this.createTextLabel(null, 20, 32));
        jPanel.add(new JLabel("<-- \u7b5b\u9009/\u6e05\u7a7a\u4f1a\u6062\u590d\u914d\u7f6e\u503c\uff0c\u5982\u6709\u6539\u52a8\uff0c\u8bf7\u5148\u4fdd\u5b58\u4fee\u6539\u518d\u70b9\u51fb"));
        this.add(jPanel);
    }

    private void initSaveButton() {
        MJButton mJButton = new MJButton("\u4fdd\u5b58");
        Dimension dimension = new Dimension(60, 32);
        mJButton.setPreferredSize(dimension);
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component[] componentArray = TabSettings.this.jpContent.getComponents();
                for (int i = 0; i < componentArray.length - 2; i += 3) {
                    String string;
                    JComponent jComponent;
                    String string2 = ((JLabel)componentArray[i]).getToolTipText();
                    if (componentArray[i + 1] instanceof JComboBox) {
                        jComponent = (JComboBox)componentArray[i + 1];
                        string = ((JComboBox)jComponent).getSelectedItem().toString();
                    } else {
                        jComponent = (JTextField)componentArray[i + 1];
                        string = ((JTextComponent)jComponent).getText().trim();
                    }
                    Global.settings.put(string2, string);
                }
                if (ConfigUtil.saveConfig()) {
                    JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u6210\u529f", "OK", 1);
                    TabSettings.this.resetJPanel();
                } else {
                    JOptionPane.showMessageDialog(null, "\u4fdd\u5b58\u5931\u8d25", "!", 0);
                }
            }
        });
        this.add(mJButton);
    }

    private void initResetButton() {
        MJButton mJButton = new MJButton("\u91cd\u7f6e");
        mJButton.setPreferredSize(new Dimension(60, 32));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TabSettings.this.resetJPanel();
            }
        });
        this.add(mJButton);
    }

    private void resetJPanel() {
        this.jpContent.removeAll();
        this.updateSettingsUI();
        this.jpContent.updateUI();
        this.jpContent.repaint();
    }

    private void initCloseButton(final JPanel jPanel) {
        MJButton mJButton = new MJButton("\u5173\u95ed");
        mJButton.setPreferredSize(new Dimension(60, 32));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Global.tabs.remove(jPanel);
            }
        });
        this.add(mJButton);
    }

    private void onContentChanged(JLabel jLabel, String string, String string2) {
        if (string.equals(string2) || string.isEmpty() && string2 == null) {
            jLabel.setBackground(null);
        } else {
            jLabel.setBackground(Color.PINK);
        }
    }

    private void updateSettingsUI() {
        int n = 0;
        Dimension dimension = new Dimension(80, 32);
        Dimension dimension2 = new Dimension(340, 32);
        Dimension dimension3 = new Dimension(320, 32);
        Dimension dimension4 = new Dimension(20, 32);
        for (Field field : Global.class.getDeclaredFields()) {
            JComponent jComponent;
            boolean bl;
            String string;
            Config config = field.getAnnotation(Config.class);
            if (config == null || (string = config.note()).isEmpty()) continue;
            String string2 = config.key();
            String[] stringArray = config.valids();
            final String string3 = Global.settings.get(string2);
            final JLabel jLabel = this.createTextLabel(string, 380, 32);
            jLabel.setToolTipText(string2);
            boolean bl2 = bl = string.contains(this.searchContent) || string2.toLowerCase().contains(this.searchContent) || string3 != null && string3.toLowerCase().contains(this.searchContent);
            if (stringArray.length > 0) {
                JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
                jComboBox.setSelectedItem(string3);
                jComboBox.setPreferredSize(dimension);
                jComboBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            TabSettings.this.onContentChanged(jLabel, itemEvent.getItem().toString(), string3);
                        }
                    }
                });
                jComponent = this.createTextLabel(null, 620, 32);
                jLabel.setVisible(bl);
                jComboBox.setVisible(bl);
                jComponent.setVisible(bl);
                this.jpContent.add(jLabel);
                this.jpContent.add(jComboBox);
                this.jpContent.add(jComponent);
            } else {
                boolean bl3 = !config.pathType().isEmpty();
                jComponent = new JTextField(string3);
                jComponent.setPreferredSize(bl3 ? dimension3 : dimension2);
                jComponent.addFocusListener(new FocusAdapter((JTextField)jComponent, string3){
                    final /* synthetic */ JTextField val$value;
                    final /* synthetic */ String val$selected;
                    {
                        this.val$value = jTextField;
                        this.val$selected = string;
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        TabSettings.this.onContentChanged(jLabel, this.val$value.getText(), this.val$selected);
                    }
                });
                jLabel.setVisible(bl);
                jComponent.setVisible(bl);
                this.jpContent.add(jLabel);
                this.jpContent.add(jComponent);
                int n2 = 360;
                JLabel jLabel2 = this.createTextLabel(null, n2, 32);
                jLabel2.setVisible(bl);
                if (bl3) {
                    boolean bl4 = !config.pathType().startsWith("dir");
                    JButton jButton = new JButton("...");
                    jButton.setPreferredSize(dimension4);
                    jButton.addActionListener(arg_0 -> TabSettings.lambda$updateSettingsUI$0((JTextField)jComponent, bl4, arg_0));
                    jButton.setVisible(bl);
                    JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
                    jPanel.add(jButton);
                    jPanel.add(jLabel2);
                    jPanel.setVisible(bl);
                    this.jpContent.add(jPanel);
                } else {
                    this.jpContent.add(jLabel2);
                }
            }
            if (!bl) continue;
            ++n;
        }
        this.jpContent.setPreferredSize(new Dimension(1100, 37 * n + 10));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnClear) {
            this.searchFiled.setText("");
        }
        this.searchContent = this.searchFiled.getText().toLowerCase();
        this.resetJPanel();
    }

    private static /* synthetic */ void lambda$updateSettingsUI$0(JTextField jTextField, boolean bl, ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(jTextField.getText());
        jFileChooser.setFileSelectionMode(bl ? 0 : 1);
        jFileChooser.setDialogTitle(bl ? "\u8bf7\u9009\u62e9\u6587\u4ef6" : "\u8bf7\u9009\u62e9\u6587\u4ef6\u5939");
        jFileChooser.setApproveButtonText("\u786e\u5b9a");
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            jTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }
}

