/*
 * Decompiled with CFR 0.152.
 */
package nicelee.server.core;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import nicelee.server.core.SocketDealer;

public class SocketServer {
    int portServerListening;
    boolean isRun = true;
    public static ExecutorService httpThreadPool;
    ServerSocket serverSocket;

    public static void main(String[] stringArray) {
        SocketServer socketServer = new SocketServer(8081);
        socketServer.startServer();
    }

    public SocketServer(int n) {
        this.portServerListening = n;
        httpThreadPool = Executors.newFixedThreadPool(20);
    }

    public SocketServer(int n, int n2) {
        this.portServerListening = n;
        httpThreadPool = Executors.newFixedThreadPool(n2);
    }

    public void stopServer() {
        try {
            this.isRun = false;
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("\u6b63\u5728\u5173\u95ed SocketServer: \u670d\u52a1\u5668... ");
    }

    public void startServer() {
        Socket socket = null;
        System.out.println("SocketServer: \u670d\u52a1\u5668\u76d1\u542c\u5f00\u59cb... ");
        try {
            this.serverSocket = new ServerSocket(this.portServerListening, 30, Inet4Address.getLoopbackAddress());
            while (this.isRun) {
                try {
                    socket = this.serverSocket.accept();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    continue;
                }
                catch (SocketException socketException) {
                    break;
                }
                SocketDealer socketDealer = new SocketDealer(socket);
                httpThreadPool.execute(socketDealer);
            }
            httpThreadPool.shutdownNow();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.out.println("SocketServer: \u670d\u52a1\u5668\u5df2\u7ecf\u5173\u95ed... ");
    }
}

