/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractBaseParser;
import nicelee.bilibili.util.Logger;
import nicelee.ui.Global;

@Bilibili(name="Version", note="\u7528\u4e8e\u6700\u65b0\u7684\u7248\u672c\u4e0b\u8f7d")
public class VersionParser
extends AbstractBaseParser {
    private static final Pattern pattern = Pattern.compile("BilibiliDown\\.v([0-9]+\\.[0-9]+).*\\.zip");
    private static final String PRE_RELEASE_FLAG = "BilibiliDown.PreRelease";
    String downName;
    String downUrl;

    public VersionParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        if (PRE_RELEASE_FLAG.equals(string)) {
            this.downUrl = PRE_RELEASE_FLAG;
            this.downName = PRE_RELEASE_FLAG;
            return true;
        }
        this.matcher = pattern.matcher(string);
        boolean bl = this.matcher.find();
        if (bl) {
            this.downName = this.matcher.group();
            String string2 = this.matcher.group(1);
            this.downUrl = this.getDownUrl(string2, this.downName);
            System.out.println("\u5339\u914dVersionParser: " + string2);
        }
        return bl;
    }

    private String getDownUrl(String string, String string2) {
        Logger.println("\u5f53\u524d\u4f7f\u7528\u7684\u66f4\u65b0\u6e90\u4e3a\uff1a " + Global.updateSourceActive);
        String string3 = "bilibili.download.update.patterns." + Global.updateSourceActive;
        String string4 = Global.settings.getOrDefault(string3, "https://github.com/nICEnnnnnnnLee/BilibiliDown/releases/download/V{version}/{file}");
        return string4.replace("{version}", string).replace("{file}", string2);
    }

    @Override
    public String validStr(String string) {
        return this.downName;
    }

    @Override
    public String getVideoLink(String string, String string2, int n, int n2) {
        this.paramSetter.setRealQN(1001);
        Logger.println(this.downUrl);
        return this.downUrl;
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        VideoInfo videoInfo = new VideoInfo();
        videoInfo.setAuthor("nICEnnnnnnnLee");
        videoInfo.setAuthorId("nICEnnnnnnnLee");
        videoInfo.setBrief("\u6700\u65b0\u7684\u7a0b\u5e8f\u7248\u672c");
        videoInfo.setVideoId(this.downName);
        videoInfo.setVideoName(this.downName);
        videoInfo.setVideoPreview("http://i2.hdslb.com/bfs/archive/0975f9fe3ec5a65b983f43bc437b8f5698e4ea8a.jpg");
        LinkedHashMap<Long, ClipInfo> linkedHashMap = new LinkedHashMap<Long, ClipInfo>();
        ClipInfo clipInfo = new ClipInfo();
        clipInfo.setAvId(this.downName);
        clipInfo.setcId(1234L);
        clipInfo.setAvTitle(this.downName);
        clipInfo.setTitle(this.downName);
        clipInfo.setPage(1);
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(1001, "");
        clipInfo.setUpId("nICEnnnnnnnLee");
        clipInfo.setUpName("nICEnnnnnnnLee");
        clipInfo.setLinks(hashMap);
        linkedHashMap.put(1234L, clipInfo);
        videoInfo.setClips(linkedHashMap);
        return videoInfo;
    }
}

