/*
 * Decompiled with CFR 0.152.
 */
package nicelee.bilibili.parsers.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nicelee.bilibili.API;
import nicelee.bilibili.annotations.Bilibili;
import nicelee.bilibili.enums.VideoQualityEnum;
import nicelee.bilibili.model.ClipInfo;
import nicelee.bilibili.model.VideoInfo;
import nicelee.bilibili.parsers.impl.AbstractPageQueryParser;
import nicelee.bilibili.util.HttpCookies;
import nicelee.bilibili.util.HttpHeaders;
import nicelee.bilibili.util.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

@Bilibili(name="URL4UPAllMedialistParser", weight=70, ifLoad="listAll", note="\u4e2a\u4eba\u4e0a\u4f20\u7684\u89c6\u9891\u5217\u8868(Medialist\u89e3\u6790\u65b9\u5f0f)")
public class URL4UPAllMedialistParser
extends AbstractPageQueryParser<VideoInfo> {
    private static final Pattern pattern = Pattern.compile("www\\.bilibili\\.com/medialist/play/([0-9]+)\\?.*&business=space&");
    private static final Pattern patternParams = Pattern.compile("(tid|sort_field)=([^=&]+)");
    private static final Pattern pattern2 = Pattern.compile("space\\.bilibili\\.com/([0-9]+)(/upload/video|/video|/search/video\\?|/? *$|/?\\?)");
    public static final Pattern patternKeyNotEmpty = Pattern.compile("keyword=[^=&]+");
    private static final Pattern patternParams2 = Pattern.compile("(tid|order)=([^=&]+)");
    private static final String[][] paramDicts = new String[][]{{"pubtime", "pubdate"}, {"play", "click"}, {"fav", "stow"}};
    private String spaceID;
    private String listName;
    private HashMap<String, String> params;

    public URL4UPAllMedialistParser(Object ... objectArray) {
        super(objectArray);
    }

    @Override
    public boolean matches(String string) {
        this.matcher = pattern.matcher(string);
        if (this.matcher.find()) {
            System.out.println("\u5339\u914dUP\u4e3b\u4e3b\u9875\u5168\u90e8\u89c6\u9891(Medialist\u89e3\u6790\u65b9\u5f0f) ...");
            this.spaceID = this.matcher.group(1);
            this.params = new HashMap();
            this.params.put("tid", "0");
            this.params.put("sort_field", "pubtime");
            Matcher matcher = patternParams.matcher(string);
            while (matcher.find()) {
                this.params.put(matcher.group(1), matcher.group(2).trim());
            }
            return true;
        }
        this.matcher = pattern2.matcher(string);
        if (this.matcher.find()) {
            if (patternKeyNotEmpty.matcher(string).find()) {
                return false;
            }
            System.out.println("\u5339\u914dUP\u4e3b\u4e3b\u9875\u5168\u90e8\u89c6\u9891(Medialist\u89e3\u6790\u65b9\u5f0f2) ...");
            this.spaceID = this.matcher.group(1);
            this.params = new HashMap();
            this.params.put("tid", "0");
            this.params.put("sort_field", "pubtime");
            Matcher matcher = patternParams2.matcher(string);
            while (matcher.find()) {
                switch (matcher.group(1)) {
                    case "tid": {
                        this.params.put("tid", matcher.group(2).trim());
                        break;
                    }
                    case "order": {
                        String string2 = paramDicts[0][0];
                        String string3 = matcher.group(2).trim();
                        for (int i = 0; i < paramDicts.length; ++i) {
                            if (!paramDicts[i][1].equals(string3)) continue;
                            string2 = paramDicts[i][0];
                            break;
                        }
                        this.params.put("sort_field", string2);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String validStr(String string) {
        return string.trim() + "p=" + this.paramSetter.getPage();
    }

    @Override
    public VideoInfo result(String string, int n, boolean bl) {
        return this.result(this.pageSize, this.paramSetter.getPage(), n, bl);
    }

    @Override
    public void initPageQueryParam() {
        this.API_PMAX = 20;
        this.pageQueryResult = new VideoInfo();
        ((VideoInfo)this.pageQueryResult).setClips(new LinkedHashMap<Long, ClipInfo>());
    }

    @Override
    public VideoInfo result(int n, int n2, Object ... objectArray) {
        this.initPageQueryParam();
        Logger.printf("pageSize: %d, page: %d", n, n2);
        int n3 = (Integer)objectArray[0];
        boolean bl = (Boolean)objectArray[1];
        String string = this.params.get("sort_field");
        try {
            int n4;
            String string2;
            Object object;
            String string3;
            HashMap<String, String> hashMap = new HttpHeaders().getCommonHeaders("api.bilibili.com");
            HashMap<String, String> hashMap2 = new HashMap<String, String>(hashMap);
            hashMap2.put("Referer", "https://space.bilibili.com/");
            hashMap2.put("Origin", "https://space.bilibili.com/");
            if (((VideoInfo)this.pageQueryResult).getVideoName() == null) {
                string3 = "https://api.bilibili.com/x/v1/medialist/info?type=1&tid=0&biz_id=" + this.spaceID;
                Logger.println(string3);
                String string4 = this.util.getContent(string3, hashMap);
                object = new JSONObject(string4).getJSONObject("data");
                this.listName = ((JSONObject)object).getString("title") + "\u7684\u89c6\u9891\u5217\u8868";
                ((VideoInfo)this.pageQueryResult).setVideoId("space" + this.spaceID);
                ((VideoInfo)this.pageQueryResult).setVideoName(this.listName + this.paramSetter.getPage());
                ((VideoInfo)this.pageQueryResult).setBrief(((JSONObject)object).getString("intro"));
                ((VideoInfo)this.pageQueryResult).setAuthorId(this.spaceID);
                ((VideoInfo)this.pageQueryResult).setAuthor(((JSONObject)object).getJSONObject("upper").getString("name"));
            }
            string3 = paramDicts[0][1];
            for (int i = 0; i < paramDicts.length; ++i) {
                if (!paramDicts[i][0].equals(string)) continue;
                string3 = paramDicts[i][1];
                break;
            }
            if ((string2 = this.position2Oid((n2 - 1) * n + 1, hashMap2, string3)).equals("end")) {
                return (VideoInfo)this.pageQueryResult;
            }
            object = this.position2Oid(n2 * n + 1, hashMap2, string3);
            String string5 = "https://api.bilibili.com/x/v2/medialist/resource/list?type=1&oid=%s&otype=2&biz_id=%s&bvid=&with_current=%s&mobi_app=web&ps=%d&direction=false&sort_field=%d&tid=%s&desc=true";
            boolean bl2 = true;
            int n5 = 1;
            for (n4 = 0; n4 < paramDicts.length; ++n4) {
                if (!paramDicts[n4][0].equals(string)) continue;
                n5 = n4 + 1;
                break;
            }
            n4 = 0;
            String string6 = string2;
            int n6 = (n2 - 1) * n;
            block6: while (n4 == 0) {
                String string7 = String.format(string5, string6, this.spaceID, bl2, this.API_PMAX, n5, this.params.get("tid"));
                Logger.println(string7);
                bl2 = false;
                String string8 = this.util.getContent(string7, hashMap);
                JSONObject jSONObject = new JSONObject(string8);
                JSONArray jSONArray = jSONObject.getJSONObject("data").getJSONArray("media_list");
                if (((VideoInfo)this.pageQueryResult).getVideoPreview() == null) {
                    ((VideoInfo)this.pageQueryResult).setVideoPreview(jSONArray.getJSONObject(0).getString("cover"));
                }
                LinkedHashMap<Long, ClipInfo> linkedHashMap = ((VideoInfo)this.pageQueryResult).getClips();
                for (int i = 0; i < jSONArray.length(); ++i) {
                    ++n6;
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    String string9 = jSONObject2.optString("id");
                    if (string9.equals(object)) {
                        n4 = 1;
                        continue block6;
                    }
                    string6 = string9;
                    String string10 = jSONObject2.getString("bv_id");
                    String string11 = jSONObject2.getString("title");
                    String string12 = jSONObject2.getJSONObject("upper").getString("name");
                    String string13 = jSONObject2.getJSONObject("upper").optString("mid");
                    long l = jSONObject2.optLong("pubtime") * 1000L;
                    JSONArray jSONArray2 = jSONObject2.optJSONArray("pages");
                    if (jSONArray2 == null) continue;
                    for (int j = 0; j < jSONArray2.length(); ++j) {
                        JSONObject jSONObject3 = jSONArray2.getJSONObject(j);
                        ClipInfo clipInfo = new ClipInfo();
                        clipInfo.setAvId(string10);
                        clipInfo.setcId(jSONObject3.getLong("id"));
                        clipInfo.setPage(jSONObject3.getInt("page"));
                        clipInfo.setRemark(n6);
                        clipInfo.setPicPreview(jSONObject2.getString("cover"));
                        clipInfo.setListName(this.listName.replaceAll("[/\\\\]", "_"));
                        clipInfo.setListOwnerName(((VideoInfo)this.pageQueryResult).getAuthor().replaceAll("[/\\\\]", "_"));
                        clipInfo.setListOwnerId(((VideoInfo)this.pageQueryResult).getAuthorId());
                        clipInfo.setUpName(string12);
                        clipInfo.setUpId(string13);
                        clipInfo.setAvTitle(string11);
                        clipInfo.setTitle(jSONObject3.getString("title"));
                        clipInfo.setcTime(l);
                        LinkedHashMap<Integer, String> linkedHashMap2 = new LinkedHashMap<Integer, String>();
                        try {
                            for (VideoQualityEnum videoQualityEnum : VideoQualityEnum.values()) {
                                if (bl) {
                                    String string14 = this.getVideoLink(string10, String.valueOf(clipInfo.getcId()), videoQualityEnum.getQn(), n3);
                                    linkedHashMap2.put(videoQualityEnum.getQn(), string14);
                                    continue;
                                }
                                linkedHashMap2.put(videoQualityEnum.getQn(), "");
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        clipInfo.setLinks(linkedHashMap2);
                        linkedHashMap.put(clipInfo.getcId(), clipInfo);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (VideoInfo)this.pageQueryResult;
    }

    private String position2Oid(int n, HashMap<String, String> hashMap, String string) {
        if (n == 1) {
            return "";
        }
        int n2 = n / 40 + 1;
        int n3 = n - n2 * 40 + 40;
        Logger.printf("ps: 40, pn: %d, number: %s", n2, n3);
        String string2 = "https://api.bilibili.com/x/space/wbi/arc/search?mid=%s&ps=%d&tid=%s&special_type=&pn=%d&keyword=&order=%s&platform=web";
        String string3 = String.format(string2, this.spaceID, 40, this.params.get("tid"), n2, string);
        string3 = string3 + API.genDmImgParams();
        string3 = API.encWbi(string3);
        Logger.println(string3);
        String string4 = this.util.getContent(string3, hashMap, HttpCookies.globalCookiesWithFingerprint());
        Logger.println(string3);
        Logger.println(string4);
        JSONArray jSONArray = new JSONObject(string4).getJSONObject("data").getJSONObject("list").getJSONArray("vlist");
        if (jSONArray.length() < n3) {
            Logger.printf("position: %d, oid: search till end", n);
            return "end";
        }
        String string5 = jSONArray.getJSONObject(n3 - 1).optString("aid");
        Logger.printf("position: %d, oid: %s", n, string5);
        return string5;
    }

    @Override
    protected boolean query(int n, int n2, int n3, Object ... objectArray) {
        return false;
    }
}

